/* Error codes for the file-conversion utility.  Codes less than ERROR are 
 * warnings and those greater are actual errors.
 * 
 * Peter Webb, Summer 1990.
 */

#ifndef error_h
#define error_h

/* All messages with codes less than ERROR are only warnings */

#define ERROR 1000

/* Routine names */

typedef enum {
 Main, SetUpWithDB, InitializeWidgets, ParseCvt, ScanDirectory, FreeStringList,
 FreeStringArray, TiffToHDF, ReformatFile, AppendFileType, FullInputPathname,
 WhatType, LastPathElt, ReplaceDialogTxt, FileListCall, FullOutputPathname,
 GIF2RI8, Fits2HDF, GetConfirm, ReformatConvert, WriteHDFFile, XWD2HDF,
 FileTypeCall, ChangeInFiles, Sun2RI8, WriteFITSFile, WriteGIFFile,
 WriteTIFFFile, WriteXWDFile, TiffTheData, LoadPix, WriteSunRastFile,
 WriteRaw8File, Raw82RI8, NewDialogStr, GetWidth, GetHeight, Pixrect2HDF,
} FuncName;

/* Errors */

typedef enum {

/* No problem, dude */

  AllOk,

/* Warnings */

  NoDBGeom,           /* No geometry in resource file */
  NoGeomMin,          /* No minimum size specified in resource file */
  NoDBFile,           /* No resource file */
  BadFGColor,         /* Bad foreground color specification */
  BadBGColor,         /* Bad background color specification */
  BadBDColor,         /* Border color bad */
  CantAllocColor,     /* Couldn't allocate the requested color */
  BGEqualFG,          /* Background and foreground colors equal */
  NoFont,             /* No font in the defaults or command line */
  CannotOpenFile,     /* Can't open the specified file */
  BadFileData,        /* Data in file and spec. type don't match */
  BadInputVersion,    /* Wrong version of file format */
  NoOverWrite,        /* Won't overwrite existing file */
  FileSystemError,    /* Error returned from the file system */
  UnknownFileType,    /* File is of unknown type */
  NotSupported,       /* Action not yet supported */
  CorruptedInputFile, /* File fails internal consistiency check */
  BadInputFile,       /* NULL or nonesense file name */
  BadOutputFile,      /* NULL or nonesense file name */
  BadInputType,       /* Input type not specified */
  BadOutputType,      /* Output type not specified */
  NoPalette,          /* No palette in file */
  ConvertFailed,      /* Conversion operation failed */  
  InputOpenFailed,    /* Can't open input file */
  OutputOpenFailed,   /* Can't open output file */
  CorruptedOutputFile,/* Output file corrupted */
  BadOption,          /* Bad command line option */
  ImageTooComplex,    /* Image too compliciated.  Too many color planes */
  TooManyColors,      /* Too many colors */
  BadInputColor,      /* Illegal color specified */
  ZeroSizeImage,      /* Image has no dimensions */
  NoColorMap,         /* No colormap in the image */
  NotAnInteger,       /* The input was not an integer */

#define WARNINGS 33   /* How many warnings are there? */

/* Errors */

  NoMemory=ERROR,      /* No more dynamic memory available */
  NullPtr,             /* Null pointer unexpected */
  BadInput,            /* Input in incorrect format */
  InternalError,       /* Bogus internal error (should never happen) */
  BadHardware,         /* The machine is not powerful enough */
} ErrorCode;

#endif

