/* servers.c -- routines to secure and grok the Ph server list.
 *
 * Copyright (C) 1992, Bradley C. Spatz, bcs@ufl.edu
 * Last edited: Wed Apr 22 11:05:59 1992 by bcs (Bradley C. Spatz) on frenulum
 */

#include <stdio.h>
#include <string.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>

#include "resource.h"
extern xph_res_t xphres;
#include "global.h"
#include "replies.h"

/* Describe a structure to record the server list. */
#define MAX_SERVERS 100
typedef struct {
   char *site;
   char *server;
   char *domain;
} server_list_t;
server_list_t server_list[MAX_SERVERS] = NULL;
int num_servers = 0;

#define QUERY "query name=ns-servers type=serverlist return text\n"


int get_server_list()
{
   int code=0, has_domain=0;
   char *text, *token, *value;

   /* Send off the query.  The response will either be success or failure.
    * If failure, then eat the data.  Otherwise eat only the success line.
    */
   write_ns(QUERY);
   read_ns(buf);
   if (atoi(buf) < 0) {
      do {
	 read_ns(buf);
      } while (atoi(buf) < 0);
      return(1);
   }
   else {
      read_ns(buf);
      while (atoi(buf) != LR_OK) {
	 /* Parse the individual line and determine the token.  Then
	  * allocate storage for and record the value.  Make sure to
	  * increment the number of servers in our list.  Make a paranoid
	  * check when we increment to make sure our static array is
	  * big enough.
	  */
	 text = (char *) (word(buf, ':', 3) + 1);
	 token = strtok(text, ":");
	 value = strtok(NULL, ":");
	 if (strcmp(token, "site") == 0) {
	    num_servers++;
	    if (num_servers > MAX_SERVERS) {
	       fprintf(stderr, "get_server_list: server list not big enough!\n");
	       num_servers--;
	    }
	    server_list[num_servers - 1].domain = NULL;

	    server_list[num_servers - 1].site = (char *) malloc ((strlen(value) + 1) * sizeof(char));
	    strcpy(server_list[num_servers - 1].site, value);
	 }
	 else if (strcmp(token, "server") == 0) {
	    server_list[num_servers - 1].server = (char *) malloc ((strlen(value) + 1) * sizeof(char));
	    strcpy(server_list[num_servers - 1].server, value);
	 }
	 else if (strcmp(token, "domain") == 0) {
	    server_list[num_servers - 1].domain = (char *) malloc ((strlen(value) + 1) * sizeof(char));
	    strcpy(server_list[num_servers - 1].domain, value);
	    has_domain = 1;
	 }
	 else {
	    /* Whoops.  An error. */
	    fprintf(stderr, "get_server_list: unknown token: '%s'\n", token);
	 }

	 read_ns(buf);
      }
   }

#ifdef DEBUG
{
   int i;

   fprintf(stderr, "Got %d entries:\n", num_servers);
   for (i=0; i< num_servers; i++) {
      fprintf(stderr, "Site:   %s\n", server_list[i].site);
      fprintf(stderr, "Server: %s\n", server_list[i].server);
      fprintf(stderr, "Domain: %s\n\n", (server_list[i].domain == NULL) ? "(none)" : server_list[i].domain);
   }
}
#endif

return(0);
}


extern Widget help;

static void
change_server(widget, client_data, call_data)
Widget widget;
XtPointer client_data, call_data;
{
   Widget grandpa;
   int i;

   busy_cursor();
   i = (int) client_data;
   grandpa = XtParent(XtParent(widget));
   XtVaSetValues(grandpa, XtNlabel, server_list[i].site, NULL);

   /* Connect to a new server.  Make sure to reset all the state
    * we've established.  Test for now.
    */
   close_connection();
   connect_to_server(server_list[i].server, xphres.service);
   sprintf(buf, "Connected to new server (%s).\n\n", server_list[i].site);
   XawAsciiSaveTextPosition(text);
   XawAsciiAppend(text, buf);
   XawAsciiRestoreTextPosition(text);
   create_help_menu(help);
   check_status();
   unbusy_cursor();
}


/* This routine creates the list of servers known to our default server.
 * It maps the the menu items to a routine do manage such a selection.
 */
void create_server_menu(widget)
Widget widget;		
{
   Widget slmenu, slitem;
   String site_name;
   int i;
   
   /* Create a simple popup menu that lists the server site names known to
    * our current default server.
    */
   XtVaSetValues(widget, XtNmenuName, "slmenu", NULL);

   /* Make sure our server has a list. */
   if (get_server_list()) {
      /* No help is available. */
      slmenu = XtVaCreatePopupShell("slmenu", simpleMenuWidgetClass, widget,
				    XtNlabel, "No site list is available.",
				    NULL);
   }
   else {
      XtVaSetValues(widget, XtNlabel, server_list[0].site, NULL);
      slmenu = XtVaCreatePopupShell("slmenu", simpleMenuWidgetClass, widget,
				    XtNlabel, "Select a Ph server:", NULL);
      slitem = XtCreateManagedWidget("slline", smeLineObjectClass, slmenu,
				     NULL, ZERO);
      for (i=0; i<num_servers; i++) {
	 site_name = server_list[i].site;
	 slitem = XtCreateManagedWidget(site_name, smeBSBObjectClass, slmenu,
					NULL, ZERO);
	 XtAddCallback(slitem, XtNcallback, change_server, (XtPointer) i);
      }
   }
}

