/* 1503, Tue 11 May 93

   SNMPTVAR.C:  AU Traffic Monitor snmp agent
		Based on the CMU snmpd version, snmpd.c

   Copyright (C) 1992 by Nevil Brownlee,
   Computer Centre,  University of Auckland */

#include "ausnmp.h"

#include <ctype.h>
#include <sys/types.h>

#include "trsnap.h"
#include "trtree.h"

#ifdef AU_MSDOS

#include "tcp.h"

#else

#include <sys/time.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/proc.h>
#include <machine/pte.h>
#include <sys/vm.h>
#include <netinet/in.h>
#include <syslog.h>
#include <sys/ioctl.h>
#include <net/if.h>
#include <net/route.h>
#include <netinet/in_pcb.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/ip_var.h>
#include <netinet/tcp.h>
#include <netinet/tcp_timer.h>
#include <netinet/tcp_var.h>
#include <netinet/tcp_fsm.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/icmp_var.h>
#include <nlist.h>
#include <sys/protosw.h>

#endif  /* AU_MSDOS */

#ifndef NULL
#define NULL 0
#endif

#ifndef AU_MSDOS
#include "asn1.h"
#include "snmp.h"
#include "snmp_impl.h"
#include "mib.h"
#include "snmp_vars.h"

#else  /* AU_MSDOS */

#include "asn1.h"
#include "snmp.h"
#include "snmpimpl.h"
#include "mib.h"
#include "snmpvars.h"
#endif  /* AU_MSDOS */


long		long_return;
u_char		return_buf[256]; /* nee 64 */

void init_snmp()
{  }

#define INT_ACCT   1, 3, 6, 1, 3, 99
#define AUKUNI     1, 3, 6, 1, 4, 1, 411

struct variable     variables[] = {
    /* these must be lexicographly ordered by the name field */
    {{MIB, 1, 1, 0},		9, STRING,  VERSION_DESCR, RONLY, var_system},
    {{MIB, 1, 2, 0},		9, OBJID,   VERSION_ID, RONLY, var_system},
    {{MIB, 1, 3, 0},		9, TIMETICKS, UPTIME, RONLY, var_system},
    {{MIB, 2, 1, 0},		9, INTEGER, IFNUMBER, RONLY, var_system},

   {{AUKUNI, 1, 1, 0},           10, INTEGER, PTTYPES, RONLY, var_system},
   {{AUKUNI, 1, 2, 1, 1, 0xFF},  12, STRING, PTPACKETTYPE, RONLY, var_pt},
   {{AUKUNI, 1, 2, 1, 2, 0xFF},  12, COUNTER, PTPACKETCOUNT, RONLY, var_pt},
   {{AUKUNI, 1, 2, 1, 3, 0xFF},  12, COUNTER, PTBYTECOUNT, RONLY, var_pt},

   {{AUKUNI, 2, 1, 0},           10, INTEGER, PCNEARMEM, RONLY, var_system},
   {{AUKUNI, 2, 2, 0},           10, INTEGER, PCFARMEM, RONLY, var_system},
   {{AUKUNI, 2, 3, 0},           10, INTEGER, PCBADPKTS, RONLY, var_system},
   {{AUKUNI, 2, 4, 0},           10, INTEGER, PCNOBUFPKTS, RONLY, var_system},
   {{AUKUNI, 2, 5, 0},           10, INTEGER, PCLOSTPKTS, RONLY, var_system},
   {{AUKUNI, 2, 6, 0},           10, INTEGER, PCPKTBACKLOG, RONLY, var_system},
   {{AUKUNI, 2, 7, 0},           10, INTEGER, PCCHKSEARCHES, RONLY, var_system},
   {{AUKUNI, 2, 8, 0},           10, INTEGER, PCCHKCOMPARES, RONLY, var_system}
   };

long packet_types = 1;  /* Nbr of different packet types seen since startup */
			/* Starts at 1 for 802.3 packets */

/*
 * getStatPtr - return a pointer to the named variable, as well as it's
 * type, length, and access control list.
 *
 * If an exact match for the variable name exists, it is returned.  If not,
 * and exact is false, the next variable lexicographically after the
 * requested one is returned.
 *
 * If no appropriate variable can be found, NULL is returned.
 */
u_char	*
getStatPtr(name, namelen, type, len, acl, exact, access_method)
    oid		*name;	    /* IN - name of var, OUT - name matched */
    int		*namelen;   /* IN -number of sub-ids in name, OUT - subid-is in matched name */
    u_char	*type;	    /* OUT - type of matched variable */
    int		*len;	    /* OUT - length of matched variable */
    u_short	*acl;	    /* OUT - access control list */
    int		exact;	    /* IN - TRUE if exact match wanted */
    int		*access_method; /* OUT - 1 if function, 0 if char * */
{
    register struct variable	*vp;

    register int	x;
    register u_char	*access;
    int			result;
    register int	minlen;
    register oid	*name1, *name2;

    for(x = 0, vp = variables; x < sizeof(variables)/sizeof(struct variable); vp++, x++){
	if (*namelen < (int)vp->namelen)
	    minlen = *namelen;
	else
	    minlen = (int)vp->namelen;
	name1 = name; name2 = vp->name;
	result = 0;
	while(minlen-- > 0){
	    if (*name1 < *name2){
		result = -1;
		break;
	    }
	    if (*name2++ < *name1++){
		result = 1;
		break;
	    }
	}
	if (result == 0){
	    if (*namelen < (int)vp->namelen)
		result = -1;	/* name1 shorter so it is "less" */
	    else if ((int)vp->namelen < *namelen)
		result = 1;
	    else
		result = 0;
	}
/*	result = compare(name, *namelen, vp->name, (int)vp->namelen); */
	if ((result < 0) || (exact && (result == 0))){
	    access = (*(vp->findVar))(vp, name, namelen, exact, len, access_method);
	    if (access != NULL)
		break;
	}
    }
    if (x == sizeof(variables)/sizeof(struct variable))
	return NULL;

    /* vp now points to the approprate struct */
    *type = vp->type;
    *acl = vp->acl;
    return access;
}

int
compare(name1, len1, name2, len2)
    register oid	    *name1, *name2;
    register int	    len1, len2;
{
    register int    len;

    /* len = minimum of len1 and len2 */
    if (len1 < len2)
	len = len1;
    else
	len = len2;
    /* find first non-matching byte */
    while(len-- > 0){
	if (*name1 < *name2)
	    return -1;
	if (*name2++ < *name1++)
	    return 1;
    }
    /* bytes match up to length of shorter string */
    if (len1 < len2)
	return -1;  /* name1 shorter, so it is "less" */
    if (len2 < len1)
	return 1;
    return 0;	/* both strings are equal */
}

char version_descr[] = "AU PC Traffic Monitor V1.2";
oid version_id[] = {
     1,  3,  6,       1,      4,          1,   411,     1, 1};
/* iso.org.dod.internet.private.enterprises.aukuni.monitor.1 */

int checkpoint_value;

extern char snmp_peer[];  /* Declared in snmpd.c */
extern int pkt_backlog;

void show_peer()  /* Display time and peername in window */
{
   w_roll(0,7, 40,24, 1);
   printf("%02d%02d:%02d -- %s", tod_h,tod_m,tod_s, snmp_peer);
   }

void display_msg(msg)
char *msg;
{
   w_roll(0,7, 40,24, 1);
   printf(msg);
   }

u_char *
var_system(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   unsigned long dummy;
   extern int writeCheckPoint(), writeRuleCount(),
       writeAddress(), writeTreeNbr(), writeAddrType();

    if (exact && (compare(name, *length, vp->name, (int)vp->namelen) != 0))
	return NULL;
    bcopy((char *)vp->name, (char *)name, (int)vp->namelen * sizeof(oid));
    *length = vp->namelen;
    *write_method = 0;
    *var_len = sizeof(long);	/* default length */
    switch (vp->magic){
	case VERSION_DESCR:
	    *var_len = strlen(version_descr);
	    return (u_char *)version_descr;
	case VERSION_ID:
	    *var_len = sizeof(version_id);
	    return (u_char *)version_id;
	case UPTIME:
	    long_return = uptime();
	    return (u_char *) &long_return;
	case IFNUMBER:
	    long_return = 1;  /* 1 ethernet card to start with */
	    return (u_char *)&long_return;

   case PTTYPES:
      long_return = (long)packet_types;
      return (u_char *)&long_return;


   case PCNEARMEM:
      long_return = (long)coreleft();
      return (u_char *)&long_return;
   case PCFARMEM:
      long_return = (long)farcoreleft();
      return (u_char *)&long_return;
   case PCBADPKTS:
      return (u_char *)&badpackets;
   case PCNOBUFPKTS:
      return (u_char *)&nobufpackets;
   case PCLOSTPKTS:
      return (u_char *)&lostpackets;
   case PCPKTBACKLOG:
      long_return = (long)pkt_backlog;
      return (u_char *)&long_return;
   case PCCHKSEARCHES:
      tree_stats(&long_return, &dummy);
      return (u_char *)&long_return;
   case PCCHKCOMPARES:
      tree_stats(&dummy, &long_return);
      return (u_char *)&long_return;

   default:
      ERROR("");
      }
   return NULL;
   }

int string_OK(t)
int t;
{
   if (t != STRING){
      display_msg("not string");
      return FALSE;
      }
   return TRUE;
   }

int int_OK(t)
int t;
{
   if (t != INTEGER){
      display_msg("not integer");
      return FALSE;
      }
   return TRUE;
   }

#define NPKTTYPES   300
#define MAXPKTLEN  1526

struct pt_entry {
   u_char type[2];  /* snmp variables */
   u_long packets;
   u_long bytes;

   int pkt_type;    /* for searching the table */
   };
struct pt_entry pt_table[NPKTTYPES+1] = {
    {{0x00,0x00}, 0,0, 1 },  /* 0-th entry for 802.3 packets */
    {{0x00,0x00}, 0,0, 0 }
};

u_char *	/* Packet type table */
var_pt(vp, name, length, exact, var_len, write_method)
    register struct variable *vp;   /* IN - pointer to variable entry that points here */
    register oid	*name;	    /* IN/OUT - input name requested, output name found */
    register int	*length;    /* IN/OUT - length of input and output oid's */
    int			exact;	    /* IN - TRUE if an exact match was requested. */
    int			*var_len;   /* OUT - length of variable or 0 if function returned. */
    int			(**write_method)(); /* OUT - 1 if function, 0 if char pointer. */
{
   oid newname[MAX_NAME_LEN];
   register int	j;
   register struct pt_entry *ptep;
   int result;

   bcopy((char *)vp->name, (char *)newname, (int)vp->namelen * sizeof(oid));
   for(j = 1, ptep = pt_table;  ptep->pkt_type != 0;  ++j, ++ptep) {
      newname[11] = (oid)j;
      result = compare(name, *length, newname, (int)vp->namelen);
      if ((exact && (result == 0)) || (!exact && (result < 0))) break;
      }
   if (ptep->pkt_type == 0) return NULL;
   bcopy((char *)newname, (char *)name, (int)vp->namelen * sizeof(oid));
   *length = vp->namelen;

   *write_method = 0;
   *var_len = sizeof(long);
   switch (vp->magic) {
   case PTPACKETTYPE:
      *var_len = 2;
      return ptep->type;
      case PTPACKETCOUNT:
      return (u_char *)&ptep->packets;
   case PTBYTECOUNT:
      return (u_char *)&ptep->bytes;
   default:
      ERROR("");
      }
   return NULL;
   }

