/* 1650, Tue 23 Aug 94

   METER_PC.C:  The AU accounting meter mainline;
		   based on CMU's snmpd,
		   PCIP's packet monitoring
		   and Waterloo's TCP/IP.

   Copyright (C) 1992,1993 by Nevil Brownlee,
   Computer Centre,  The University of Auckland */

/*
 * snmpd.c - send snmp GET requests to a network entity.
 *
 */
/***********************************************************
	Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/

#include "ausnmp.h"
#define PKTSNAP
#include "pktsnap.h"
#include "flowhash.h"

extern char version_descr[];  /* In met_vars.c */
extern unsigned int SampleRate;
extern char *communities[];  /* In snmp/snmpagnt.c */

#include <dos.h>
#include <alloc.h>
#include <ctype.h>

#include <sys/types.h>
/* #include <netinet/in.h> AU */
#include <stdio.h>
/* #include <sys/socket.h>  AU */
#include "tcp.h"

#include <errno.h>

#include "snmp.h"
#include "asn1.h"
#include "snmpimpl.h"  /* AU */

extern int errno;
int snmp_dump_packet = 0;

udp_Socket udpsock;
static udp_Socket *s;
int status;  /* For socket */

void init_snmp();
void receive();
void snmp_read();

unsigned int sample_count = 1;

void pkt_rcv_call2(handle, len, buffp)
unsigned int handle, len;
unsigned char far *buffp;
{
   unsigned char *buff = buffp;  /* TCP's buffers are in our data segment! */
   struct pkt far *pp;

   if (buff[0] == 0xFF && buff[1] == 0xFF && buff[2] == 0xFF &&
	 buff[3] == 0xFF && buff[4] == 0xFF && buff[5] == 0xFF) {
      if (buff[12] == 0x08 &&
	    (buff[13] == 0x00 || buff[13] == 0x06 )) {  /* IP or ARP */
	 buff[-2] = 1;  /* Ready for tcp/ip */
	 }
      else buff[-2] = 0;  /* Not for us; free the buffer */
      }
   else if (buff[5] == eth_addr[5] && buff[4] == eth_addr[4] &&
	 buff[3] == eth_addr[3] && buff[2] == eth_addr[2] &&
	 buff[1] == eth_addr[1] && buff[0] == eth_addr[0]) {
      if (buff[12] == 0x08 &&
	    (buff[13] == 0x00 || buff[13] == 0x06 )) {  /* IP or ARP */
	 buff[-2] = 1;  /* Ready for tcp/ip */
	 }
      else buff[-2] = 0;  /* Not for us; free the buffer */
      }
   else buff[-2] = 0;  /* Not for us; free the buffer */

   if (--sample_count != 0) return;  /* Process only 1 pkt per SampleRate */
   sample_count = SampleRate;

   ++npackets;  nbytes += len;
   if(((pproc - prcv) & pktmask) == 1) {  /* No pkts free, ignore the data */
      ++lostpackets;
      }
   else {
      pp = &pkts[prcv];
      pp->PeerAddrType = AT_DUMMY;
      if (proto_reqd[AT_IP] && buff[12] == 0x08 && buff[13] == 0x00)
	 pkt_extract(pp, AT_IP, &buffp[14]);
      else if (buff[12] <= maxpkthi) {  /* 802.3 */
	 if (proto_reqd[AT_NOVELL] && buff[14] == 0xFF && buff[15] == 0xFF)
	    pkt_extract(pp, AT_NOVELL, &buffp[14]);
	 else if (buff[14] == 0xAA && buff[15] == 0xAA) {  /* SNAP */
	    if (proto_reqd[AT_ETHERTALK] &&
		  buff[20] == 0x80 && buff[21] == 0x9B)
	       pkt_extract(pp, AT_ETHERTALK, &buffp[22]);
	    else if (proto_reqd[AT_NOVELL] &&
	          buff[20] == 0x81 && buff[21] == 0x37)
	       pkt_extract(pp, AT_NOVELL, &buffp[22]);
	    else if (proto_reqd[AT_OTHER])
	       pkt_extract(pp, AT_OTHER, buffp);
	    }
#ifdef CLNS
	 else if (buff[14] == 0xFE && buff[15] == 0xFE) {  /* CLNS */
	    if (proto_reqd[AT_CLNS])
	       pkt_extract(pp, AT_CLNS, &buffp[16]);  /* 1-org ! */
	    else if (proto_reqd[AT_OTHER])
	       pkt_extract(pp, AT_OTHER, buffp);
	    }
#endif
	 else if (proto_reqd[AT_NOVELL] &&  /* Novell 802.2 */
	       buff[14] == 0xE0 && buff[15] == 0xE0)
	    pkt_extract(pp, AT_NOVELL, &buffp[18]);
                                /* F0F0 is LSAP for NetBIOS */
	 else if (proto_reqd[AT_OTHER])
	    pkt_extract(pp, AT_OTHER, buffp);
	 }
      else if (proto_reqd[AT_DECNET] && buff[12] == 0x60 && buff[13] == 0x03)
	 pkt_extract(pp, AT_DECNET, &buffp[14]);
      else if (proto_reqd[AT_NOVELL] && buff[12] == 0x81 && buff[13] == 0x37)
	 pkt_extract(pp, AT_NOVELL, &buffp[14]);
      else if (proto_reqd[AT_OTHER])
	 pkt_extract(pp, AT_OTHER, buffp);
      if (pp->PeerAddrType != AT_DUMMY) {  /* Need to look at this packet */
	 if (adj_reqd) {
	    addrcpy(pp->Low.AdjAddress,&buff[6],MAC_ADDR_LEN);  /* Ethernet source */
	    addrcpy(pp->High.AdjAddress,&buff[0],MAC_ADDR_LEN);  /* Ethernet dest */
	    }
	 pp->p_len = len;
	 prcv = (prcv+1) & pktmask;
	 }
      }
   }

void au_send_mon(int length, unsigned char far *buffer)
{  /* Invoked by pkt_send in src/pcpkt.c */
   unsigned char au_save;
   au_save = buffer[-2];  /* rcv_call will overwrite this! */
   asm cli;  /* Disable interrupts */
   pkt_rcv_call2(2, length, buffer);
   asm sti;  /* Enable interrupts */
   buffer[-2] = au_save;
   }

void main(argc, argv)
    int	    argc;
    char    *argv[];
{
    int	arg, c;
    char cbuf[20], *ap;

   sclear();
   scpos(0,0);  printf(version_descr);
   scpos(0,1);

   maxpkt = 1024;
   display_enabled = kb_enabled = 1;  /* Enabled by default */
   mxflowsp1 = DFMXFLOWS+1;
   /* Default (CMU) communities are:  0 = "public", 1 = "proxy",
	 2 = "private", 3 = "regional", 4 = "core"
      We only allow "public" and "private" by default */
   communities[1] = communities[3] = communities[4] = "";
   for (c = 0, arg = 1; arg < argc; ++arg) {
      if (argv[arg][0] == '-') {
	 switch (argv[arg][1]) {
	 case 'd':
	    snmp_dump_packet++;
	    break;
	 case 'f':
	    ap = argv[arg]+2;
	    if (*ap == NULL) ap = argv[++arg];
	    mxflowsp1 = atoi(ap)+1;
	    break;
	 case 'k':
	    kb_enabled = 0;  /* -k to disable keyboard */
	    break;
	 case 'n':
	    ap = argv[arg]+2;
	    if (*ap == NULL) ap = argv[++arg];
	    SampleRate = atoi(ap);
	    if (SampleRate < 1) SampleRate = 1;
	    break;
	 case 'p':
	    ap = argv[arg]+2;
	    if (*ap == NULL) ap = argv[++arg];
	    maxpkt = atoi(ap);
	    break;
	 case 'r':
	    for (;;) {
	       if (c == 5) {
                  printf("Max of 4 read communities allowed\n");
                  exit(0);
                  }
	       communities[c++] = argv[++arg];
	       if (c == 2) ++c;  /* 2 -> "private" */
	       if (arg == argc-1 || argv[arg+1][0] == '-') break;
               }
	    break;
	 case 's':
	    display_enabled = 0;  /* -s to disable screen */
	    break;
	 case 'w':
	    communities[2] = argv[++arg];  /* -w to set write community */
	    break;
	 default:
	    printf("Invalid option: -%c\n", argv[arg][1]);
	    exit(0);
	    }
	 }
      }
   pktmask = maxpkt-1;  maxpkthi = maxpkt/256;
   pkts = (struct pkt far *)farmalloc((maxpkt+1) * sizeof(struct pkt));
   pproc = prcv = 0;
   au_monitor = 1;

   sock_init();
   printf("Running on %s",inet_ntoa(cbuf,gethostid()));

   s = &udpsock;  /* myport        hisadr hisport */
   if (!udp_open( s, SNMP_PORT,  0, 0,        0 )) {
      puts("udp_open failed!\n");
      exit(1);
      }

   init_snmp();
   init_monitor();
   receive();
   }

void show_meter_time()
{
   char msg[60];
   sprintf(msg,"%lu seconds since %02d%02d:%02d",
      elapsed_sec, s_tod_h,s_tod_m,s_tod_s);
   display_msg(0,msg);
   }

unsigned int mxmonpkts = 400;  /* Max nbr of packets per pkt_monitor call */
unsigned int bkgi;  /* Seconds before next run of backgound process */
#define BKG_INTERVAL  30  /* 30 seconds */

void zero_pkt_stats()
{
   npackets = nbytes = badpackets = nobufpackets = lostpackets =
      stats_time = t_backlog = spackets = sbytes =
      kilodummypackets = dummypacketrate = 0L;
   mindummyrate = 100000000L;
   pkt_backlog = max_pkt_backlog = max_pkt_rate =
      dummypackets = mdpacketrate = 0;
   clear_pkt_stats = 0;
   }

void receive()
{
   unsigned char startup, ch, gci, p;
   unsigned int k, n, x, sumx, minx, maxx, samples, ax;
   char l_tod_s;  /* Last tod_s displayed on chart */
   unsigned long pd, bd;
   long tot = set_timeout(1);
   char far *cp;
   unsigned char half_scale = 0;

   startup = 1;
   pproc = prcv;  /* Discard packets collected during initialisation */
   for (;;) {
      sock_tick(s, &status);
      if ((n = sock_dataready(s)) != 0) {
         snmp_read(n);
         sock_close(s);
         if (!udp_open( s, SNMP_PORT,  0, 0,        0 )) {
            puts("udp_open failed!\n");
            exit(1);
            }
	 }

      k = (prcv-pproc) & pktmask;
      if (k == 0) {  /* Build a dummy packet */
	 cp = (char far *)&pkts[maxpkt];
	 for (k = 0; k != sizeof(struct pkt); ++k) cp[k] = 0;
	 pkts[maxpkt].PeerAddrType = AT_DUMMY;
	 pkt_monitor(&pkts[maxpkt]);
	 }
      else {
	 if (k > pkt_backlog) pkt_backlog = k;
	 for (k = mxmonpkts; pproc != prcv && k != 0; --k) {
	    pkt_monitor(&pkts[pproc]);
	    pproc = (pproc+1) & pktmask;
	    }
	 }

      if (chk_timeout(tot)) {
	 tot = set_timeout(1);  /* 1 second */
	 ++elapsed_sec;  set_tod();
	 s_uptime = uptime();  /* Don't do this too often! */

	 if (startup) {  /* Running now, initialise counters etc. */
	    clear_pkt_stats = 1;
	    minx = 100;  sumx = samples = maxx = 0;
	    l_tod_s = -1;
	    gci = gc_interval;  /* Garbage collect interval */
	    bkgi = BKG_INTERVAL;  /* Background interval */
	    gc_f = (mxflowsp1-1)/100;  /* Flow indexes to check */
	    if (gc_f < 4) gc_f = 4;
	    startup = 0;
	    }
	 else {
            if (--gci == 0) {
	       garbage_collect(1);  /* Routine incremental collection */
               gci = gc_interval;
               }
	    if (--bkgi == 0) {
	       p = (unsigned long)active_flows()*100/(mxflowsp1-1);
	       if (display_enabled) {
		  scpos(12,3);
		  printf("a=%3lu",p);
		  }
	       if (p > FloodMark) {  /* % flows active */
		  display_msg(1,"Flows > FloodMark !!!!!");
		  }
	       else if (p > HighWaterMark) {
		  display_msg(1,"Flows > HighWaterMark !!!");
		  more_garbage();
		  }
	       bkgi = BKG_INTERVAL;
	       }
	    pd = (npackets-spackets)*SampleRate;
	    bd = (nbytes-sbytes)*SampleRate;
	    if (display_enabled) {
   	       scpos(0,3);
	       printf("q=%4d",pkt_backlog);
	       scpos(23,3);
	       printf("%02d%02d:%02d", tod_h,tod_m,tod_s);
	       scpos(0,5);
	       x = util_pc(pd,bd);  /* % utilisation */
	       printf("p=%6lu, b=%10lu, u=%4d", pd,bd, x);
	       sumx += x;  ++samples;
	       if (x < minx) minx = x;
	       if (x > maxx) maxx = x;
	       if (tod_s != l_tod_s && tod_s%10 == 0) {
	          if (samples) {  /* 30% in col 79 */
                     ax = (sumx+(samples>>1))/samples;
                     if (half_scale) 
                        chart(41,0, 79,24, minx>>1,ax>>1,maxx>>1);
		     else chart(41,0, 79,24, minx,ax,maxx);
		     l_tod_s = tod_s;
		     }
	          minx = 100;  sumx = samples = maxx = 0;
	          }
               }
	    }
	 if (clear_pkt_stats) zero_pkt_stats();
	 else {
            ++stats_time;
            if (pd > max_pkt_rate) max_pkt_rate = pd;
            t_backlog += (unsigned long)pkt_backlog;
	    if (pkt_backlog > max_pkt_backlog)
	       max_pkt_backlog = pkt_backlog;
	    if (dummypacketrate < mindummyrate) {
	       mindummyrate = dummypacketrate;  mdpacketrate = pd;
	       }
	    }

	 pkt_backlog = 0;  dummypacketrate = 0;
	 spackets = npackets;  sbytes = nbytes;

	 if (kb_enabled && kbhit()) {
	    if ((ch = getch()) == 27) {  /* ESC */
	       scpos(0,24);
	       printf("\nShutting down\n");
               exit(0);
               }
	    w_clear(0,24, 40,24);  scpos(0,24);
	    switch (tolower(ch)) {
	    case 'b':
	       printf("bad=%lu, nobuf=%lu, lost=%lu",
		  badpackets,nobufpackets,lostpackets);
	       break;
	    case 'h':
	       half_scale = !half_scale;
	       printf("Chart scale 0..%d \%",
		  half_scale ? 60 : 30);
	       break;
	    case 'm':
	       printf("%u near, %lu far bytes free",
		  coreleft(),farcoreleft());
	       break;
	    case 'v':
	       printf(version_descr);
	       break;
	    default:
	       handle_kb(ch);
	       break;
	       }
            }
         }
      }

sock_err:
   switch (status) {
   case 1 : /* foreign host closed */
      exit(0);
   case -1: /* timeout */
      printf("\nConnection timed out!");
      exit(1);
   default: printf("Aborting");
      exit(1);
      }
}

unsigned long snmp_peer_addr;

void snmp_read(length)
int length;
{
   int out_length;
   u_char  packet[1500], outpacket[1500];
   int count;
   struct sockaddr from;
   int fromlen = sizeof(struct sockaddr);
   char snmp_peer_name[30];  /* name of host which sent the snmp request */
   getpeername(s, &from,&fromlen);
   snmp_peer_addr = from.s_ip;

   sock_read(s, packet,length);

   if (snmp_dump_packet) {
      inet_ntoa(snmp_peer_name,from.s_ip);
      printf("received %d bytes from %s:\n", length, snmp_peer_name);
      for (count = 0; count < length; count++) {
	 printf("%02X ", packet[count]);
	 if ((count % 16) == 15) printf("\n");
	 }
      printf("\n\n");
      }
   out_length = 1500;
   if (snmp_agent_parse(packet, length, outpacket, &out_length, from.s_ip)) {
      if (snmp_dump_packet) {
	 printf("sent %d bytes to %s:\n", out_length, snmp_peer_name);
	 for (count = 0; count < out_length; count++) {
	    printf("%02X ", outpacket[count]);
	    if ((count % 16) == 15) printf("\n");
	    }
         printf("\n\n");
	 }
      sock_write( s, (char *)outpacket, out_length);
      }
   }
