typedef    long    time_t;

#include <stdio.h>
#include <types.h>
#include <task.h>
#include <q.h>
#include <netq.h>
#include <net.h>
#include <custom.h>
#include <netbuf.h>
#include <icmp.h>
#include <ip.h>
#include <timer.h>
#include <ntcp.h>
#include <ntcpblk.h>

/* This routine is upcalled by internet when a TCP packet arrives.
 * it processes the packet according to the  algorithm in the
 * "TCP functional specification", pp66-77.  Because of the proliferation
 * of 3 terminating cases in many places, and the need to have a compact
 * binaries, goto's are used (much like a structured break) to get to the
 * correct return point, and improve the code.
 */

tcp_rcv(inpkt, len, fhost)
PACKET  inpkt;	/* the packet itself */
int    len;	/* length of packet */
in_name fhost;	/* source of packet */
{
    register TcpCon con;/* connection receiving a packet */
    struct tcp *itp;	/* input  pkt tcp hdr */
    struct tcp *otp;	/* output pkt tcp hdr for pkt's connection */
    char *idp;		/* input pkt data ptr */
    int prev_rcvd;	/* (data + fin bit) in current packet*/
    int idlen;		/* len of input pkt in bytes */
    int i,j,k;		/* loops vars for buffer input bytes */
    long needed_acking;	/* length we need to be content (incl FINs) */
    long data_acked;	/* # data bytes acked */
    long acked;		/* number of octets ACKED (incl FINs) */
    char *m;    
    int  limit;
    unsigned tempsum;	/* temp variable for a checksum */
    int start_offset;	/* packet begin=ack + start_offset */
    int end_offset;	/* packet end=ack + end_offset */
    int numchunks;	/* temps for circbuf array addresses */

    long unsigned inseq,outack,mywin,winend,reject,inend;

    itp = (struct tcp *)in_data(in_head(inpkt));
    idp = (char *)itp + (itp->tc_thl << 2);

    /* get incoming data length */
    idlen = len - (itp->tc_thl << 2);
    tcpprcv++;	/* another packet received */

    /* zero 2nd half of last word in case #bytes is odd */
    if(idlen >= 0) *(idp +idlen)= 0; 

    /* compute incoming tcp checksum here... */
    iphp.tp_len = len;
    iphp.tp_len = swab(iphp.tp_len);
    iphp.tp_dst = in_mymach(fhost);
    iphp.tp_src = fhost;
    tempsum = itp->tc_cksum;
    itp->tc_cksum = cksum(&iphp, sizeof(struct tcpph) >> 1, 0);
    itp->tc_cksum = ~cksum(itp, ((idlen + 1) >> 1) + (itp->tc_thl << 1),0);

    if(itp->tc_cksum != tempsum) {
#ifdef DEBUG
	if(NDEBUG & (INFOMSG|NETERR|PROTERR))
	    printf("TCP: Bad xsum: %4x should have been %4x.\n",tempsum,
	    itp->tc_cksum);
#endif
	bd_chk ++;
	goto Return;
    }

    tcp_swab(itp);    /* reverses bytes to 8088-readable format */

    /* the packet demuxes if its for one of our ports.  Also, */
    /* make sure we expect the packet from whomever sent it. */
    if (!(con = tcp_resolve_con(itp->tc_dstp,itp->tc_srcp,fhost))) {
#ifdef DEBUG
	if(NDEBUG & (PROTERR|NETERR|INFOMSG))
	    printf("TCP: pkt for port %u from %a\n",itp->tc_dstp, fhost);
#endif
	tcpsock++;
	goto Reset;
    }
    /* drop SYN packets for 1/2 opened listen sockets - see tcp_resolve_con() */
    if (con == (TcpCon) 1) goto Return;    

#ifdef DEBUG
    if (TCDBG) {
	printf("RCV(%u):\t",itp->tc_dstp);
	tcp_prpacket(itp,idp,idlen);
    }
#endif

    otp = con->otp;

    /* This comes straight from the TCP implementation manual */
    /* FIRST DO STATE PROCESSING FOR OPENING CONNECTIONS */

    switch(con->conn_state) {
    case LISTEN:    
	tcp_popen(con,itp,fhost,inpkt);    /* I don't handle data here */
	goto Return;

    case SYNSENT:    

	/* Ack must be for our initial sequence number, 1 */
	if(itp->tc_ack != 1 || itp->tc_fack == 0) {
	    /* if it's a reset for the wrong ack number, drop it.  When  */
	    /* our SYN is resent, hopefully the connection will open */
	    if (itp->tc_rst) goto Return;
	    goto Reset;    /* reset the other guy (cheat)*/
	}

	if (itp->tc_rst) {
#ifdef    DEBUG
	    if (TCDBG) printf("TCP: active open reset\n");
#endif
	    tcp_clean(con,FALSE);
	    goto Return;
	}    

	if(!itp->tc_syn) {    /* There must be a SYN to open */
	    /* HERE IS A DEPARTURE FROM TCP SPECIFICATIONS */
	    /* this TCP can't handle simultaneous opens, so I reset the */
	    /* other TCP.  boo hiss */
	    tcp_newdata(con);    /* start from scratch */
	    goto Reset;	/* reset the other guy */
	}

	/* Connection opened.  Call the user to tell him. */
	otp->tc_syn = 0;    /* stuff static values into */
	otp->tc_fack= /*  1; */    /* the output packet header */  
	otp->tc_psh = /*  1; */
	otp->tc_seq = 1;
	itp->tc_seq++;	/* (for "Sixth" step */
	otp->tc_ack = itp->tc_seq;
	tcpbrcv ++;
	con->frn_win = itp->tc_win;
	con->conn_state = ESTAB;
	con->retry_time = CONNRT;
	con->blk_inpt    = UNBLOCKED;    /* let him send data*/
	wind_recomp(con);
	tcp_hush(con);	/* turn off retransmissions */
	tcp_sendack(con);    /* send the singular ACK */
	(*(con->tc_open))(con);    /* tell user it's open */
	if (idlen > 0) goto Sixth;    /* yick. icky part of the spec */
	goto Return;
    default: 
	break;	    /* default: do nothing */

    }


    /* NOW DO 8 TESTS FOR THE REMAINING STATES */


    /* FIRST PROCESS A RESET IF PRESENT */

    if(itp->tc_rst) {	/* other guy's resetting me */
	switch (con->conn_state) {    /* as per TCP spec */
	case SYNRCVD:
	    otp->tc_syn = 1;    /* fix output packet */
	    con->conn_state = LISTEN;
	    tcp_hush(con);    /* stop transmissions */
	    tk_sleep(con->TCPsend);    /* sleep the send process */
#ifdef DEBUG
	    if (TCDBG) printf("TCP: foreign reset on passive connection\n");
#endif
	    goto Return;
	default:
#ifdef DEBUG
	    if (TCDBG) {
		printf("TCP: foreign reset on active connection. Done by:\n");
		tcp_prpacket(itp,idp,idlen);
		printf("Currently sending\n");
		tcp_prpacket(con->otp,con->odp,con->bptr - con->odp);
	    }
#endif
	    /* reset while we wait for his close is his problem, not ours*/
	    if (con->conn_state == SIMUL | con->conn_state == TIMEWAIT |
		con->conn_state == R_AND_S) {
		tcp_clean(con,TRUE);
		goto Return;
	    }
	    goto Abort;
	}
    }

    /* SECOND TEST IF THE PACKET IS OUT OF SEQUENCE */
    /* this follows TCP spec closely except for the variable names: */
    /* inseq  = seg.seq */
    /* outack = rcv.nxt */
    /* mywin  = rcv.win */

    /* this TCP does not take responsibility for data until the user sees   */
    /* it.  Thus, we shouldn't send ack/update packets if the packet is in  */
    /* the tcp storage range:  0---old data---1---tcp storage---2---new---3 */
    /* because doing so would frustrate the foreign TCP (the ack value is   */
    /* 1).  The next few lines consider the storage window as old data, and */
    /* avoid sending extra ACKs at the last minute (read below)    */
    inseq  = itp->tc_seq;
    outack = otp->tc_ack + con->avail + 1;     /* compute storage window (2)*/
    mywin  = otp->tc_win;
    reject = FALSE;
    winend = mywin + outack;
    if (idlen + itp->tc_fin == 0) {    /* text-less packet */
	if(mywin > 0) {
	    if (inseq < outack || inseq >= winend) reject = 1;
	}
	else {
	    if (inseq != outack) reject = 2;
	}
    }
    else {    /* packet has a text */
	/* compute byte no of last byte */
	inend = inseq - 1L + (long) idlen + (long) itp->tc_fin; 
	if (mywin > 0) {
	    if (inend < outack || inseq >= winend) { /* all out of window? */
		reject = 3;
	    }
	}
	else reject = 4;
    }
    /* if there's nothing interesting in this packet, punt it. */
    /* 1: we aren't in TIMEWAIT    (otherwise steps 5,8 want to see it) */
    /* 2: all the text is old.    (otherwise steps 3-8) */
    /* 3: it ACKS nothing.    (otherwise step 5 wants to see it) */
    if (con->conn_state == TIMEWAIT) {    /* excessive TIMEWAIT FIN packets ? */
	if ((con->tw_to_live++) >= TW_PKTS) {
	    tcp_timewait(con);    /* restart timewait timers */
	}
	else {
	    tcp_sendack(con);    /* resend that final packet */
	}
	goto Return;
    }

    if (reject && itp->tc_ack <= otp->tc_seq) {
	/* drop pkt if we've sent alot of acks from timewait */
	/* here's where extra ACKS are avoided: update pkts aren't */
	/* sent until we've emptied our local window. */
	if (!itp->tc_rst & con->avail == -1) {
	    tcp_sendack(con); /* bring client up to date */
	}

#ifdef DEBUG
	if (TCDBG) printf("Packet rejected for reason %d\n",reject);
#endif
	goto Return;
    }

    /* THIRD CHECK SECURITY AND PRECEDENCE (unhandled) */

    /* FOURTH CHECK the SYN BIT */
    if (itp->tc_syn) {
#ifdef DEBUG
	if (TCDBG) printf("TCP: closed: SYN in packet\n");
#endif
	goto Abort;
    }

    /* FIFTH PROCESS AN ACK OF OUR DATA IF PRESENT */
    if (!itp->tc_fack) goto Return;
    acked = (int)(itp->tc_ack - otp->tc_seq);    /* number of bytes he acked */
    con->odlen = con->bptr - con->odp;
    needed_acking = con->odlen + (int)otp->tc_fin;/* number we were sending */

    /* data_acked = number of bytes acked not including FINS */
    data_acked = ((acked == needed_acking) ?(acked - (int)otp->tc_fin) : acked);

    /* Ack for unsent data prompts us to reset. */
    if(con->conn_state == SYNRCVD) {
	if (itp->tc_ack == 1) {    /* passive open */
	    con->conn_state    = ESTAB;
	    con->blk_inpt    = UNBLOCKED;
	    con->frn_win    = itp->tc_win;
	    wind_recomp(con);
	    otp->tc_seq	= 1;
	    otp->tc_syn	= 0;
	    con->retry_time    = CONNRT;
	    tcp_hush(con);    /* quiet any rexmitting in progress */
	    (*(con->tc_open))(con);
	}
	else {
#ifdef DEBUG
	    if (TCDBG) printf("TCP: bad ack on passive open: reset\n");
#endif
	    goto Abort;
	}
    }
    else {
	if(acked > needed_acking) {
#ifdef DEBUG
	    if (TCDBG) printf("TCP: ack of unsent data: reset\n");
#endif
	    goto Abort;
	}

	/* If all our outgoing data is now acked stop resending */
	if(acked == needed_acking) {
	    tcp_hush(con);    /* stop retransmitting new data */
	    /* but still send any piggybacked acks */    
	    if (con->piggied) tcp_sendack(con);
	    if (otp->tc_fin) {    /* has he acked our fin? */
		otp->tc_fin = 0;    /* no need to send fin any more */
		switch(con->conn_state) {
		case FINSENT:
		    con->conn_state = FINACKED;
		    break;
		case SIMUL:
		    con->conn_state = TIMEWAIT;
		    tcp_timewait(con);
		case R_AND_S:
		    tcp_clean(con,TRUE);    /* closes normally, zap it */
		    goto Return;
		}
	    }
	}

	if(otp->tc_furg) {    /* he acked our urgent data ? */
	    otp->tc_urg = otp->tc_urg - acked;
	    if((int) otp->tc_urg  <= 0) {
		otp->tc_urg = 0;
		otp->tc_furg = 0;
	    }
	}
	if (acked > 0) {
	    /* Otherwise, shift the output data in the packet to account */
	    /* ack, and update the sequence number */
	    con->odlen -= (int) data_acked;
	    con->bptr -= (int) data_acked;
	    shift((con->odp)+data_acked, (con->odp), con->odlen);
	    otp->tc_seq += acked;
	    if (con->conn_state == TIMEWAIT) goto Return;
	}
	con->frn_win = itp->tc_win; /* save his input window */
	/* decide if some buffer space is available.*/
	i = con->blth;	    /* remember if buffer was full */
	wind_recomp(con);	/* compute new buffer size */
	/*    printf("W=%d/%d/%d ",con->blth,con->blk_inpt,itp->tc_win); */
	/* if we were blocked, and if there is space */
	if (i <= 0 && con->blth > 0)
	    (*(con->tc_buff))(con);    /* upcall client -> space avail */
    }


Sixth:    /* SIXTH PROCESS URG INFORMATION (unhandled)*/


    /* SEVENTH PROCESS THE SEGMENT TEXT */
    if (idlen > 0) {
	/* Find data's home relative to the beginning of our buffer */
	start_offset = -(prev_rcvd = otp->tc_ack - itp->tc_seq);
	end_offset = start_offset + idlen - 1;

	/* overflows our window?  chop it off. */
	if(end_offset >= con->otp->tc_win)
	    end_offset = con->otp->tc_win - 1;

	m = con->circbuf;	/* base of circular buffer */
	k = max(0,prev_rcvd);	/* # bytes not to copy */
	i = con->taken + 1 + start_offset + k;    /* where to begin copying */
	j = i + (idlen-k);	/* where to end */
	idp += k;    /* first place to copy to */

	while (i  < j) m[i++ & BUFMASK]=(*idp++);

	/* if there are no fragments */
	if((numchunks=con->numchunks) == 0) {

	    /* and this packet touches or overlaps our byte stream */
	    if(start_offset  < con->avail + 2) {

		con->avail = end_offset;    /* then the stream simply got longer */
	    }
	    else {
		/* otherwise we got our first stream-fragment */
		*(con->first) = start_offset;
		*(con->last)  = end_offset;
		*(con->free)  = FALSE;
		con->numchunks = 1;
		con->maxchunks = 0;
		con->lastchunk = 0;
	    }
	}
	else {
	    /* optimization: if the bytes received go at the end of the */
	    /* last fragment, just tack them on */
	    if((con->lastchunk > -1) &&
		(con->last[con->lastchunk] + 1 == start_offset))
		con->last[con->lastchunk] = end_offset;
	    else {
		for(i = 0; i  <= con->maxchunks; i++) {
		    if(con->free[i]) continue;
		    if(con->last[i]+1  < start_offset) continue;
		    if(con->first[i] > end_offset + 1) continue;
		    end_offset = max(end_offset, con->last[i]);
		    start_offset = min(start_offset,con->first[i]);
		    con->free[i] = TRUE;
		    numchunks--;
		    if(numchunks == 0) {
			con->maxchunks = -1;
			break;
		    }
		}

		if(con->free[con->lastchunk]) con->lastchunk = -1;
		if(start_offset  <= 0) con->avail = end_offset;
		else {
		    limit = min(con->maxchunks+1, TOTALCHUNKS-1);
		    for(i=0; i <=limit; i++) {
			if(!con->free[i]) continue;
			con->free [i] = FALSE;
			con->first[i] = start_offset;
			con->last [i] = end_offset;
			numchunks++;
			if(i == con->maxchunks + 1) con->maxchunks = i;

			if(con->lastchunk == -1)
			    con->lastchunk = i;
			break;
		    }
		}
		con->numchunks = numchunks;
	    }
	}
	/* Here we collect bytes, and our window shrinks */
	con->otp->tc_win = (unsigned) con->loc_win - con->avail - 1;
    }

    /* EIGHTH CHECK THE FIN BIT */

    if (itp->tc_fin) {
	tcp_flush(con);	/* flush all pending data */
	tm_clear(con->tmack);    /* hush the dally timer */
	switch(con->conn_state) {
	case ESTAB:
	case SYNRCVD:
	    tcp_sendack(con);    /* ack his fin */
	    con->conn_state = FINRCVD;
	    con->otp->tc_ack++;    /* acknowlege his fin */
	    tcpbrcv ++;	/* got one more byte */
	    (*(con->tc_fclose))(con);    /* tell user its closing */
	    break;
	case FINSENT:
	    tcp_sendack(con);
	    if (acked != needed_acking) {
		con->otp->tc_ack++;    /* acknowlege his fin */
		tcpbrcv ++;	/* got one more byte */
		(*(con->tc_fclose))(con);    /* tell user its closing */
		con->conn_state = SIMUL;
		break;
	    }
	    /* if we fall through it's because our FIN is acked and */
	    /* we should really be in the FINACKED state anyway */
	case FINACKED:
	    tcp_hush(con);
	    tcp_sendack(con);    /* send the final ACK */
	    con->otp->tc_ack++;    /* acknowlege his fin */
	    tcpbrcv ++;	/* got one more byte */
	    (*(con->tc_fclose))(con);    /* tell user its closing */
	    con->conn_state = TIMEWAIT;    
	case TIMEWAIT:    /* TIMEWAIT timer restarted in step 5 */
	    break;    /* so there's nothing to do here */
	case SIMUL:
	case R_AND_S:
	case FINRCVD:
	    tcp_sendack(con);    /* this is equivalent to a resend */
	}
    }

    /* if new data, process it */
    if (con->avail >= 0) tk_wake(con->TCPprocess);
    goto Return;

Abort:    /* blasts everything, unnatural death */
    tcp_clean(con,FALSE);
Reset:    /* just resets other host */
    tc_clrs(inpkt,fhost);
Return:    /* simply returns */
    in_free(inpkt);
    return;
}

tcp_popen(con,itp,fh,pkt)    /* replies to a connection request */
register TcpCon con;    /* on a listen socket */
struct tcp *itp;
in_name    fh;
PACKET pkt;
{
    struct tcp *otp;
    otp = con->otp;

    if (itp->tc_rst) return;    /* resets are ignored */
    else if (itp->tc_fack) {    /* can't ack if we've sent nothing */
#ifdef DEBUG    
	if (TCDBG)
	    printf("TCP: passive open: Attempting to reset foreign host\n");
#endif
    }
    else if (itp->tc_syn) {
	con->conn_state   = SYNRCVD;
	otp->tc_psh       = 1;
	otp->tc_ack       = itp->tc_seq + 1; /* ACK FIN if there */
	con->frn_win      = itp->tc_win;
	con->otp->tc_dstp =
	    con->dstport      = itp->tc_srcp;
	con->ophp.tp_dst  =
	    con->fhost    = fh;
	con->ophp.tp_src  = in_mymach(fh);
	/* we don't reduce the resend time here because we must avoid */
	/* replying with too many SYNs, causing the other host to reset us */
	tcp_newdata(con);
	return;
    }
#ifdef DEBUG
    /* in the incredibly unlikely case that there is neither SYN nor FACK: */
    else 
	if (TCDBG) printf("TCP: no SYN, FACK foreign error: listen socket: reset\n");
#endif
    tc_clrs(pkt,fh);
}
