<% /*
Copyright (c) Steve Schneider 2002-2003.
All rights reserved.
*/ %>


<% PageUtils.jspStart(request); %>
<% //PageUtils.forceNoCache(response); %>

<%@ page import="java.util.*" %>
<%@ page import="java.net.*" %>

<%@ page import="com.workroll.app.filesystem.*" %>
<%@ page import="com.workroll.app.entity.*" %>
<%@ page import="com.workroll.app.db.*" %>
<%@ page import="com.workroll.app.session.*" %>
<%@ page import="com.workroll.app.mail.*" %>
<%@ page import="com.workroll.app.WorkRollConstants" %>
 
<% PageUtils.setRequiredLoginStatus("none",request); %>
<% PageUtils.setPathToAppRoot("../",request); %>
<% PageUtils.setRequiredRequestMethod("POST",request); %>
<% PageUtils.setSection(WorkRollConstants.SECTION_ISSUES_POPUP,request); %>

<%@ include file="../global/topInclude.jsp" %>

<%!
static final int getDateFieldParam(Controller controller, String paramName)
{
	String paramValue=controller.getParam(paramName);
	if (paramValue.trim().length()==0)
	{
		return -1;
	}
	return controller.getParamAsInt(paramName);
}

static final Date dateFromParams(int earliestOpenDateDate, int earliestOpenDateMonth, int earliestOpenDateYear)
{
	Calendar cal=Calendar.getInstance();
	cal.set(cal.YEAR,earliestOpenDateYear);
	cal.set(cal.MONTH,earliestOpenDateMonth);
	cal.set(cal.DATE,earliestOpenDateDate);
	cal.set(cal.HOUR,0);
	cal.set(cal.MINUTE,0);
	cal.set(cal.SECOND,0);
	cal.set(cal.MILLISECOND,0);
	cal.set(cal.AM_PM,cal.AM);
	return cal.getTime();
}


%>

<%
boolean success;
try
{
	int status=controller.getParamAsInt("status");
	int priority=controller.getParamAsInt("priority");

	String projectViewMode=controller.getParam("projectType");
	String instanceViewMode=controller.getParam("instanceType");
	String assignedByViewMode=controller.getParam("assignedByType");
	String assignedToViewMode=controller.getParam("assignedToType");

	boolean noEarliestOpenDate=controller.getParamAsBoolean("earliestOpenDateAll");
	boolean noLatestOpenDate=controller.getParamAsBoolean("latestOpenDateAll");
	boolean noEarliestDueDate=controller.getParamAsBoolean("earliestDueDateAll");
	boolean noLatestDueDate=controller.getParamAsBoolean("latestDueDateAll");

	int[] suppressProjectIds=controller.getParamsAsIntArray("projectIds");
	int[] suppressInstanceIds=controller.getParamsAsIntArray("instanceIds");
	int[] suppressAssignedByUsers=controller.getParamsAsIntArray("assignedByUsers");
	int[] suppressAssignedToUsers=controller.getParamsAsIntArray("assignedToUsers");

	int earliestOpenDateMonth=-1;
	int earliestOpenDateDate=-1;
	int earliestOpenDateYear=-1;

	int latestOpenDateMonth=-1;
	int latestOpenDateDate=-1;
	int latestOpenDateYear=-1;

	int earliestDueDateMonth=-1;
	int earliestDueDateDate=-1;
	int earliestDueDateYear=-1;

	int latestDueDateMonth=-1;
	int latestDueDateDate=-1;
	int latestDueDateYear=-1;

	if (!noEarliestOpenDate)
	{
		earliestOpenDateDate=(getDateFieldParam(controller,"earliestOpenDateDate"));
		earliestOpenDateMonth=(getDateFieldParam(controller,"earliestOpenDateMonth"));
		earliestOpenDateYear=(getDateFieldParam(controller,"earliestOpenDateYear"));
	}
	if (!noLatestOpenDate)
	{
		latestOpenDateDate=(getDateFieldParam(controller,"latestOpenDateDate"));
		latestOpenDateMonth=(getDateFieldParam(controller,"latestOpenDateMonth"));
		latestOpenDateYear=(getDateFieldParam(controller,"latestOpenDateYear"));
	}
	if (!noEarliestDueDate)
	{
		earliestDueDateDate=(getDateFieldParam(controller,"earliestDueDateDate"));
		earliestDueDateMonth=(getDateFieldParam(controller,"earliestDueDateMonth"));
		earliestDueDateYear=(getDateFieldParam(controller,"earliestDueDateYear"));
	}
	if (!noLatestDueDate)
	{
		latestDueDateDate=(getDateFieldParam(controller,"latestDueDateDate"));
		latestDueDateMonth=(getDateFieldParam(controller,"latestDueDateMonth"));
		latestDueDateYear=(getDateFieldParam(controller,"latestDueDateYear"));
	}


	IssueFilter filter=new IssueFilter();
	
	int[] emptyArray={};
	
	// ASSIGNED-BY:
	if (assignedByViewMode.equals("self"))
	{
		filter.setShowOnlyAssignedBySelf(true);
		filter.setSuppressAssignedByUserIds(emptyArray);
	}
	else if (assignedByViewMode.equals("any"))
	{
		filter.setShowOnlyAssignedBySelf(false);
		filter.setSuppressAssignedByUserIds(emptyArray);
	}
	else if (assignedByViewMode.equals("suppress"))
	{
		filter.setShowOnlyAssignedBySelf(false);
		filter.setSuppressAssignedByUserIds(suppressAssignedByUsers);
	}

	
	// ASSIGNED-TO:
	if (assignedToViewMode.equals("self"))
	{
		filter.setShowOnlyAssignedToSelf(true);
		filter.setSuppressAssignedToUserIds(emptyArray);
	}
	else if (assignedToViewMode.equals("any"))
	{
		filter.setShowOnlyAssignedToSelf(false);
		filter.setSuppressAssignedToUserIds(emptyArray);
	}
	else if (assignedToViewMode.equals("suppress"))
	{
		filter.setShowOnlyAssignedToSelf(false);
		filter.setSuppressAssignedToUserIds(suppressAssignedToUsers);
	}


	// PROJECT:
	if (projectViewMode.equals("any"))
	{
		filter.setSuppressProjectIds(emptyArray);
	}
	else if (projectViewMode.equals("suppress"))
	{
		filter.setSuppressProjectIds(suppressProjectIds);
	}
	

	// INSTANCE:
	if (instanceViewMode.equals("any"))
	{
		filter.setSuppressInstanceIds(emptyArray);
	}
	else if (instanceViewMode.equals("suppress"))
	{
		filter.setSuppressInstanceIds(suppressInstanceIds);
	}
	
	// PRIORITY, STATUS:
	filter.setLowestPriority(priority);
	filter.setStatuses(status);
	
	// DATES:
	
	if (noEarliestOpenDate)
	{
		filter.setEarliestOpenDate(IssueFilter.NO_MINIMUM_DATE);
	}
	else
	{
		filter.setEarliestOpenDate(dateFromParams(earliestOpenDateDate,earliestOpenDateMonth,earliestOpenDateYear));
	}

	if (noEarliestDueDate)
	{
		filter.setEarliestDueDate(IssueFilter.NO_MINIMUM_DATE);
	}
	else
	{
		filter.setEarliestDueDate(dateFromParams(earliestDueDateDate,earliestDueDateMonth,earliestDueDateYear));
	}
	
	if (noLatestOpenDate)
	{
		filter.setLatestOpenDate(IssueFilter.NO_MAXIMUM_DATE);
	}
	else
	{
		filter.setLatestOpenDate(dateFromParams(latestOpenDateDate,latestOpenDateMonth,latestOpenDateYear));
	}

	if (noLatestDueDate)
	{
		filter.setLatestDueDate(IssueFilter.NO_MAXIMUM_DATE);
	}
	else
	{
		filter.setLatestDueDate(dateFromParams(latestDueDateDate,latestDueDateMonth,latestDueDateYear));
	}
	
	
	SessionInfo sessionInfo=controller.getSessionInfo();
	sessionInfo.setCurrentFilter(filter);
	controller.setSessionInfo(sessionInfo);
	success=true;
}
catch (Throwable t)
{
	success=false;
	Printer.pe("storing filter", t);
}
if (success)
{
	%>
	<html><head></head>
	<body onload="parent.frames[0].storeFilterSuccess(true)">
	</body>
	</html>
	<%
}
else
{
	%>
	<html><head></head>
	<body onload="parent.frames[0].storeFilterSuccess(false)">
	</body>
	</html>
	<%
}
%>


<%@ include file="../global/bottomInclude.jsp" %>


<%
if (pageException!=null)
{
	%>
	<%@ include file="../global/jspErrorDialogLaunch.jsp" %>
	<%
}
%>




<% PageUtils.jspEnd(request); %>
