<%@ page import="com.workroll.app.help.HelpManager" %>

<%=HelpManager.itemTitle("Issue")%>


Whether you use WorkRoll as a bug tracker or as a to-do list, an "issue" represents a task that must be kept track of: its <%=HelpManager.itemLink("status","status")%> (is it fixed yet, is it ready for review?), its <%=HelpManager.itemLink("priority","priority")%> (is it a very-low-priority task, an emergency, or something in between?), what <%=HelpManager.itemLink("project","project")%> (if any) it's associated with, to whom it's been assigned, when it's due to be fixed, who assigned it, etc.  WorkRoll exists for the purpose of keeping track of such tasks.<BR><BR>

WorkRoll organizes issues into two groups: <%=HelpManager.itemLink("active","activeIssue")%> issues and <%=HelpManager.itemLink("closed","closedIssue")%> issues.  Active issues are issues whose status is either "open" or "resolved"; closed issues are issues whose status is "closed."  Issues always start out as active issues, and the expectation is that they will eventually end up as closed issues.<BR><BR>

It is expected that users will spend little time reviewing or addressing closed issues; by their nature, these issues are not of much interest to members of a project team since they have been handled already (it is, however, possible to <%=HelpManager.itemLink("reopen","reopening")%> closed issues should the need arise).  It is likewise expected that users will spend a large amount of time reviewing and addressing active issues, since these issues are "in play."  Therefore, the <%=HelpManager.itemLink("active-issues list","activeIssuesList")%> is more fully featured than the <%=HelpManager.itemLink("closed-issues list","closedIssuesList")%>; for example, issues may not be added or edited from the closed-issues screen (however, active and closed issues may both be <%=HelpManager.itemLink("sorted","sort")%> and <%=HelpManager.itemLink("filtered","filter")%>.<BR><BR>

The following fields are associated with any active or closed issue:

<ul>
<li><%=HelpManager.itemLink("ID","id")%>, a number identifying the issue
<li><%=HelpManager.itemLink("Assigned-by user","assignedByUser")%>, the <%=HelpManager.itemLink("user","user")%> who assigned the ussue
<li><%=HelpManager.itemLink("Assigned-to user","assignedToUser")%>, the user to whom the issue is assigned
<li><%=HelpManager.itemLink("Status","status")%>, whether the issue is open, resolved, or closed
<li><%=HelpManager.itemLink("Priority","priority")%>, whether the issue is of very low priority, emergency priority, or somewhere in between
<li><%=HelpManager.itemLink("Project","project")%>, the project associated with the issue, or "All projects"
<li><%=HelpManager.itemLink("Instance","instance")%>, the instance associated with the issue, or "All instances"
<li><%=HelpManager.itemLink("Opened date","openedDate")%>, the date on which the issue was originally opened (not changeable)
<li><%=HelpManager.itemLink("Due date","dueDate")%>, the date and time when the issue is due to be resolved
<li><%=HelpManager.itemLink("Description","description")%>, the description of the issue
<li><%=HelpManager.itemLink("URL","url")%>, optionally, a URL associated with the issue
</ul>


<BR><BR>






