VERSION 5.00
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmVMFORS 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Browsing an ADO forward-only recordset in virtual mode"
   ClientHeight    =   5175
   ClientLeft      =   2940
   ClientTop       =   1830
   ClientWidth     =   6420
   Icon            =   "VMFORS.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5175
   ScaleWidth      =   6420
   Begin iGrid250_75B4A91C.iGrid grdVirtual 
      Height          =   4155
      Left            =   120
      TabIndex        =   2
      Top             =   900
      Width           =   6195
      _ExtentX        =   10927
      _ExtentY        =   7329
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin VB.Label Label1 
      Caption         =   "It also dinamically highlits non-USA customers with last year's sales greater than 25000."
      Height          =   255
      Index           =   1
      Left            =   120
      TabIndex        =   1
      Top             =   540
      Width           =   6240
   End
   Begin VB.Label Label1 
      Caption         =   $"VMFORS.frx":0442
      Height          =   435
      Index           =   0
      Left            =   120
      TabIndex        =   0
      Top             =   60
      Width           =   6240
   End
End
Attribute VB_Name = "frmVMFORS"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const BATCH_SIZE = 20

Private m_Cnn As ADODB.Connection
Private m_RS As ADODB.Recordset

Private Sub Form_Load()
   Dim i As Long

   Set m_Cnn = New ADODB.Connection
   m_Cnn.Open "Provider=Microsoft.Jet.OLEDB.4.0;Data Source=" & App.Path & "\Test.mdb"
   
   Set m_RS = New ADODB.Recordset
   m_RS.CacheSize = BATCH_SIZE   ' this settings specifies how many records are retrieved
                                 ' at one time into local memory
   m_RS.CursorLocation = adUseServer
   m_RS.CursorType = adOpenForwardOnly
   m_RS.Open "SELECT ID, Company, Country, [Last Year's Sales] FROM Customers ORDER BY ID", m_Cnn

   With grdVirtual
      .Redraw = False
      
      .RowMode = True
      .Editable = False
      
      .AddCol sHeader:="ID", lWidth:=32
      .AddCol sHeader:="Company", lWidth:=96
      .AddCol sHeader:="Country", lWidth:=96
      .AddCol sHeader:="Last Year's Sales", lWidth:=96
      .ColDefaultCell(4).eTextFlags = igTextRight
      .ColDefaultCell(4).sFmtString = "$#,##"
      
      .Virtual = True
      
      .Redraw = True
   End With
End Sub

' This event is fired every time when iGrid needs to know
' whether it will add a new row or not
Private Sub grdVirtual_RequestRow(ByVal lRow As Long, bNoMoreRows As Boolean)
   ' If you keep the default value of the bNoMoreRows parameter (False)
   ' iGrid raises the RequestRowData event just after this event.
   ' We move the record pointer in RequestRowData.
   If m_RS.EOF Then
      bNoMoreRows = True
   End If
End Sub

' We use this event to populate the currently added row
' and move the record pointer to the next record.
' This event is raised in series for each row (from the 1st row to the last one)
Private Sub grdVirtual_RequestRowData(ByVal lRow As Long)
   Dim i As Long
   
   With grdVirtual
      .Redraw = False
      
      ' populating the currently added row by field values of the current record
      For i = 1 To .ColCount
         .CellValue(lRow, i) = m_RS(i - 1).Value
      Next
      
      ' highlighting the record if required
      If m_RS("Country").Value <> "USA" And m_RS("Last Year's Sales").Value >= 25000 Then
         For i = 1 To .ColCount
            .CellBackColor(lRow, i) = RGB(240, 210, 220)
         Next
      End If
      
      .Redraw = True
   End With
   
   m_RS.MoveNext
End Sub
