VERSION 5.00
Object = "{C0A58BC3-1600-4C2C-8DDB-2DD7FDE5CA63}#1.0#0"; "vbalIml200_75B4A91C.ocx"
Object = "{23F895D7-45A6-4886-931B-89D88C2857ED}#1.0#0"; "iGrid250_75B4A91C.ocx"
Begin VB.Form frmMyCust 
   Caption         =   "My Customers Demo"
   ClientHeight    =   6360
   ClientLeft      =   360
   ClientTop       =   2550
   ClientWidth     =   11445
   Icon            =   "MyCust.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6360
   ScaleWidth      =   11445
   Begin VB.PictureBox picBackground 
      Height          =   495
      Left            =   4800
      Picture         =   "MyCust.frx":0442
      ScaleHeight     =   435
      ScaleWidth      =   1155
      TabIndex        =   1
      Top             =   3180
      Visible         =   0   'False
      Width           =   1215
   End
   Begin vbalIml200_75B4A91C.vbalImageList HdrImgList 
      Left            =   7380
      Top             =   1080
      _ExtentX        =   953
      _ExtentY        =   953
      IconSizeY       =   14
      ColourDepth     =   24
      Size            =   6072
      Images          =   "MyCust.frx":0E48
      Version         =   131072
      KeyCount        =   6
      Keys            =   ""
   End
   Begin iGrid250_75B4A91C.iGrid grdCust 
      Height          =   2415
      Left            =   840
      TabIndex        =   0
      Top             =   840
      Width           =   3555
      _ExtentX        =   6271
      _ExtentY        =   4260
      FocusRect       =   0   'False
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   204
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
   End
   Begin vbalIml200_75B4A91C.vbalImageList ImgList 
      Left            =   5880
      Top             =   840
      _ExtentX        =   953
      _ExtentY        =   953
      IconSizeX       =   24
      ColourDepth     =   8
      Size            =   19920
      Images          =   "MyCust.frx":2620
      Version         =   131072
      KeyCount        =   12
      Keys            =   "RUSPORCANSPAMEXITAGERFRAFINSWEprivcomp"
   End
   Begin VB.Menu mnuFile 
      Caption         =   "File"
      Begin VB.Menu mnuFileSave 
         Caption         =   "Save"
         Enabled         =   0   'False
      End
      Begin VB.Menu mnuFileReload 
         Caption         =   "Reload"
      End
      Begin VB.Menu mnuSep1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "Exit"
      End
   End
   Begin VB.Menu mnuView 
      Caption         =   "View"
      Begin VB.Menu mnuViewFilt 
         Caption         =   "Filter"
         Begin VB.Menu mnuFiltDebt 
            Caption         =   "My Debtors"
         End
         Begin VB.Menu mnuFiltFin 
            Caption         =   "Only Finland Customers"
         End
         Begin VB.Menu mnuSep4 
            Caption         =   "-"
         End
         Begin VB.Menu mnuFiltAll 
            Caption         =   "All Rows"
            Checked         =   -1  'True
         End
      End
      Begin VB.Menu mnuSep2 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewGrp 
         Caption         =   "Grouping"
         Begin VB.Menu mnuGrpTypes 
            Caption         =   "By Types"
         End
         Begin VB.Menu mnuGrpCountries 
            Caption         =   "By Countries"
         End
         Begin VB.Menu mnuSep5 
            Caption         =   "-"
         End
         Begin VB.Menu mnuGrpNo 
            Caption         =   "No Groups"
            Checked         =   -1  'True
         End
      End
      Begin VB.Menu mnuSep6 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewCols 
         Caption         =   "Columns"
         Begin VB.Menu mnuColsShort 
            Caption         =   "Short Mode"
         End
         Begin VB.Menu mnuSep7 
            Caption         =   "-"
         End
         Begin VB.Menu mnuColsAll 
            Caption         =   "All Columns"
            Checked         =   -1  'True
         End
      End
      Begin VB.Menu mnuSep8 
         Caption         =   "-"
      End
      Begin VB.Menu mnuViewTxt 
         Caption         =   "Text Size"
         Begin VB.Menu mnuViewTxt10 
            Caption         =   "10 pt"
            Checked         =   -1  'True
         End
         Begin VB.Menu mnuViewTxt8 
            Caption         =   "8 pt"
         End
      End
   End
   Begin VB.Menu mnuTls 
      Caption         =   "Tools"
      Begin VB.Menu mnuTlsFitH 
         Caption         =   "Fit Row Heights"
      End
      Begin VB.Menu mnuTlsFitW 
         Caption         =   "Fit Column Widths"
      End
      Begin VB.Menu mnuSep9 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSaveLayout 
         Caption         =   "Save Layout"
      End
      Begin VB.Menu mnuRestLayout 
         Caption         =   "Restore Layout"
      End
   End
   Begin VB.Menu mnuOpt 
      Caption         =   "Options"
      Begin VB.Menu mnuOptResColWHdr 
         Caption         =   "Resize Column with its Header"
      End
      Begin VB.Menu mnuOptRow 
         Caption         =   "Row Mode"
      End
      Begin VB.Menu mnuOptFocusRect 
         Caption         =   "Focus Rectangle"
      End
      Begin VB.Menu mnuOptBackgrPic 
         Caption         =   "Background Picture"
         Checked         =   -1  'True
      End
      Begin VB.Menu mnuSep10 
         Caption         =   "-"
      End
      Begin VB.Menu mnuOptKeyPrs 
         Caption         =   "On Key Press"
         Begin VB.Menu mnuKeyPrsEdit 
            Caption         =   "Edit Cell"
            Checked         =   -1  'True
         End
         Begin VB.Menu mnuKeyPrsSrch 
            Caption         =   "Customer Search"
         End
      End
   End
   Begin VB.Menu mnuPopup 
      Caption         =   "Popup"
      Visible         =   0   'False
      Begin VB.Menu mnuPopupGen 
         Caption         =   "Generate from the Customer Name"
      End
   End
End
Attribute VB_Name = "frmMyCust"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private mTT As CTooltip
Private mGroupFont As StdFont

Private Sub Form_Load()
   Dim i As Long
   
   ' Grid definition:
   With grdCust
      .GridLines = igGridLinesBoth
      .Header.Flat = True
      .Editable = True
      .DefaultRowHeight = 1 + 18 * 15 / Screen.TwipsPerPixelY  ' 18 pixels - for cell text & icon
                                                               ' 1 pixels for the horizontal gridline at the bottom of a cell
                                                               ' 15 / Screen.TwipsPerPixelY - to take into account the "Large Fonts" setting
      .GridLineColor = RGB(209, 209, 209)
      .HighlightSelIcons = False
      .FocusRect = False
      Set .BackgroundPicture = picBackground.Picture
      .BackColor = RGB(137, 196, 253)
      .ImageList = ImgList
      .Header.ImageList = HdrImgList
      .DrawRowText = False
      
      ' Grid font:
      .Font.Name = "MS Sans Serif"
      .Font.Size = 10
      ' Font for grouped cells
      Set mGroupFont = New StdFont
      mGroupFont.Name = .Font.Name
      mGroupFont.Size = .Font.Size
      mGroupFont.Bold = True
      
      ' Header font
      With .Header.Font
         .Name = "Arial Narrow"
         .Bold = True
         .Size = 8
      End With
      
      ' Definition of the customer type combo
      With .Combos.Add("type")
         .AddItem sItemText:="Private person", vItemValue:="priv", _
            iIconIndex:=ImgList.ItemIndex("priv")
         .AddItem sItemText:="Company", vItemValue:="comp", _
            iIconIndex:=ImgList.ItemIndex("comp")
         With .Font
            .Name = "Tahoma"
            .Size = 10
            .Bold = True
         End With
         .AutoAdjustWidth
      End With
      
      ' Definition of the country combo
      With .Combos.Add("country")
         .AddItem sItemText:="=== America ===", vItemValue:=0  ' means that you can't select this item
                                                               ' see the BeforeCommitEdit event procedure
         .AddItem sItemText:="Canada", vItemValue:="CAN", iIconIndex:=ImgList.ItemIndex("CAN")
         .AddItem sItemText:="Mexico", vItemValue:="MEX", iIconIndex:=ImgList.ItemIndex("MEX")
         .AddItem sItemText:="=== Europe  ===", vItemValue:=0
         .AddItem sItemText:="Finland", vItemValue:="FIN", iIconIndex:=ImgList.ItemIndex("FIN")
         .AddItem sItemText:="France", vItemValue:="FRA", iIconIndex:=ImgList.ItemIndex("FRA")
         .AddItem sItemText:="Germany", vItemValue:="GER", iIconIndex:=ImgList.ItemIndex("GER")
         .AddItem sItemText:="Italy", vItemValue:="ITA", iIconIndex:=ImgList.ItemIndex("ITA")
         .AddItem sItemText:="Portugal", vItemValue:="POR", iIconIndex:=ImgList.ItemIndex("POR")
         .AddItem sItemText:="Russia", vItemValue:="RUS", iIconIndex:=ImgList.ItemIndex("RUS")
         .AddItem sItemText:="Spain", vItemValue:="SPA", iIconIndex:=ImgList.ItemIndex("SPA")
         .AddItem sItemText:="Sweden", vItemValue:="SWE", iIconIndex:=ImgList.ItemIndex("SWE")
         With .Font
            .Name = "Courier New"
            .Size = 9
            .Bold = True
         End With
         .AutoAdjustWidth
      End With
   
      ' Cols of the grid:
      With .AddCol(sKey:="type", sHeader:="Type", lWidth:=32, lMinWidth:=24, eHdrTextFlags:=igTextLeft)
         .eType = igCellCombo
         .sCtrlKey = "type"
      End With
      
      .AddCol sKey:="id", sHeader:="CustID", iIconIndex:=0
      
      .AddCol sKey:="name", sHeader:="Name", lWidth:=120, iIconIndex:=1
      
      With .AddCol(sKey:="country", sHeader:="Country", lWidth:=105, lMinWidth:=30, iIconIndex:=2)
         .eType = igCellCombo
         .sCtrlKey = "country"
      End With
      
      .AddCol(sKey:="is_patron", sHeader:="Patron", lWidth:=42, _
         eHdrTextFlags:=igTextLeft).eType = igCellCheck

      With .AddCol(sKey:="total", sHeader:="Total", lWidth:=78, eHdrTextFlags:=igTextRight, iIconIndex:=3)
         .sFmtString = "$#,##0"
         .eTextFlags = igTextRight
         .iRightIndent = 2
      End With
      
      With .AddCol(sKey:="debt", sHeader:="Debt", lWidth:=60, eHdrTextFlags:=igTextRight, iIconIndex:=4)
         .sFmtString = "$#,##0;;"""""
         .eTextFlags = igTextRight
         .iRightIndent = 2
      End With
      
      With .AddCol(sKey:="info", sHeader:="Info", lWidth:=240, iIconIndex:=5)
         .eTextFlags = igTextEndEllipsis Or igTextModifyString Or _
            igTextWordBreak Or igTextEditControl
      End With
      
      .AddCol bRowTextCol:=True
   End With
   
   pPopulate
   
   Set mTT = New CTooltip
   mTT.Icon = TTIconInfo
   mTT.Style = TTBalloon
   mTT.DelayTime = 1000
   mTT.VisibleTime = 10000

   gpCheckShowTips Me
End Sub

Private Sub Form_Resize()
   On Error Resume Next
   grdCust.Move 0, 0, Me.ScaleWidth, Me.ScaleHeight
End Sub

Private Sub grdCust_AfterCommitEdit(ByVal lRow As Long, ByVal lCol As Long)
   If grdCust.ColKey(lCol) = "type" And mnuGrpTypes.Checked Then
      mnuGrpTypes_Click
   ElseIf grdCust.ColKey(lCol) = "country" And mnuGrpCountries.Checked Then
      mnuGrpCountries_Click
   End If
End Sub

Private Sub pPopulate()
   Dim fh As Integer, iRow As Long
   Dim cust_type As String, id As String, CustName As String, country As String
   Dim IsPatron As Byte, total As Currency, debt As Currency, info As String

   fh = FreeFile
   Open App.Path & "\CustList.txt" For Input As #fh

   With grdCust
      .Redraw = False
      .MemMngWantFreeRows = 20
      
      Do Until EOF(fh)
         Input #fh, cust_type, id, CustName, country, IsPatron, total, debt, info
         .AddRow
         iRow = .RowCount
         .CellValue(iRow, "type") = cust_type
         .CellValue(iRow, "id") = id
         .CellValue(iRow, "name") = CustName
         .CellValue(iRow, "country") = country
         .CellValue(iRow, "is_patron") = IsPatron
         .CellValue(iRow, "total") = total
         .CellValue(iRow, "debt") = debt
         .CellValue(iRow, "info") = info
      Loop
      
      .Redraw = True
   End With
   
   Close #fh
End Sub

Private Sub grdCust_BeforeCommitEdit(ByVal lRow As Long, ByVal lCol As Long, eResult As EEditResults, ByVal sNewText As String, vNewValue As Variant, ByVal lConvErr As Long)
   Select Case grdCust.ColKey(lCol)
   Case "id"
      If grdCust.CellValue(lRow, lCol) <> vNewValue Then
         Select Case MsgBox("Are you sure to change the CustId from '" & _
            grdCust.CellValue(lRow, lCol) & "' to '" & sNewText & "'?", vbQuestion + vbYesNoCancel)
         Case vbYes:
            eResult = igEditResCommit ' commit and finish the edit process (default)
         Case vbNo
            eResult = igEditResCancel ' abort changes in the cell
            Exit Sub
         Case vbCancel
            eResult = igEditResProceed ' return to the cell edit process
            Exit Sub
         End Select
      End If
   Case "country"
      If vNewValue = 0 Then
         ' The user must select a country
         eResult = igEditResCancel
         Exit Sub
      End If
   End Select
   
   If grdCust.CellValue(lRow, lCol) <> vNewValue Then
      mnuFileSave.Enabled = True
   End If
End Sub

Private Sub grdCust_ColHeaderClick(ByVal lCol As Long, bDoDefault As Boolean, ByVal Shift As Integer, ByVal X As Long, ByVal Y As Long)
   If Not mnuGrpNo.Checked Then
      If vbNo = MsgBox("Sorting by this column will remove your groupings." & vbCrLf & "Are you sure you want to do this?", vbYesNo Or vbQuestion) Then
         bDoDefault = False
      Else
         pRemoveGrouping
         mnuGrpTypes.Checked = False
         mnuGrpCountries.Checked = False
         mnuGrpNo.Checked = True
      End If
   End If
End Sub

Private Sub grdCust_ColHeaderMouseEnter(ByVal lCol As Long)
   If lCol > 0 Then
      mTT.Title = grdCust.ColHeaderText(lCol) & " column"
      Select Case grdCust.ColKey(lCol)
      Case "type"
         mTT.TipText = "This column allows you to select the kind of a customer -" & vbCrLf & "company or private person."
      Case "id"
         mTT.TipText = "In this column you can enter a unique identifier for each customer" & vbCrLf & "(up to 5 characters)."
      Case "name"
         mTT.TipText = "Contains the full name of a customer."
      Case "country"
         mTT.TipText = "Contains the country a customer is located in."
      Case "is_patron"
         mTT.TipText = "This column allows you to mark customers which" & vbCrLf & "buy your products often and often."
      Case "total"
         mTT.TipText = "The column contains the total sum of purchases" & vbCrLf & "a customer has made."
      Case "debt"
         mTT.TipText = "Contains customer debt."
      Case "info"
         mTT.TipText = "You can type in your comments" & vbCrLf & "concerning each customer here."
      End Select
      mTT.Create grdCust.Header.hWnd
   End If
End Sub

Private Sub grdCust_ColHeaderMouseLeave(ByVal lCol As Long)
   mTT.Destroy
End Sub

Private Sub grdCust_RequestEdit(ByVal lRow As Long, ByVal lCol As Long, ByVal iKeyAscii As Integer, bCancel As Boolean, sText As String, lMaxLength As Long, eTextEditOpt As iGrid250_75B4A91C.ETextEditFlags)
   ' We can not edit grouped cells
   If lCol = grdCust.ColCount Then
      bCancel = True
      Exit Sub
   End If

   Select Case grdCust.ColKey(lCol)
   Case "id"
      eTextEditOpt = igTextEditUpperCase
      lMaxLength = 5
      grdCust.TextEditCustomContextMenu = True
   Case "total", "debt":
      MsgBox "The value of this field is calculated based on additional data." & vbCrLf & _
         "You cannot edit this column.", vbOKOnly + vbCritical, Me.Caption
      bCancel = True
   Case Else
      grdCust.TextEditCustomContextMenu = False
   End Select
End Sub

Private Sub grdCust_TextEditCustomContextMenu(ByVal lRow As Long, ByVal lCol As Long)
   PopupMenu mnuPopup
End Sub

Private Sub mnuColsAll_Click()
   Dim i As Integer
   
   grdCust.Redraw = False
   For i = 1 To grdCust.ColCount
      grdCust.ColVisible(i) = True
   Next
   grdCust.Redraw = True
   
   mnuColsAll.Checked = True
   mnuColsShort.Checked = False
End Sub

Private Sub mnuColsShort_Click()
   Dim i As Integer
   Dim sKey As String
   
   grdCust.Redraw = False
   For i = 1 To grdCust.ColCount
      sKey = grdCust.ColKey(i)
      If (sKey = "type") Or (sKey = "id") Or (sKey = "debt") Or (sKey = "info") Then
         grdCust.ColVisible(i) = False
      Else
         grdCust.ColVisible(i) = True
      End If
   Next
   grdCust.Redraw = True
   
   mnuColsAll.Checked = False
   mnuColsShort.Checked = True
End Sub

Private Sub mnuFileExit_Click()
   Unload Me
End Sub

Private Sub mnuFileReload_Click()
   grdCust.Clear
   pPopulate
End Sub

Private Sub mnuFiltAll_Click()
   Dim lRow As Long
   
   mnuFiltDebt.Checked = False
   mnuFiltFin.Checked = False
   mnuFiltAll.Checked = True
   
   With grdCust
      .Redraw = False
      For lRow = 1 To .RowCount
         .RowVisible(lRow) = True
      Next
      .Redraw = True
   End With
End Sub

Private Sub mnuFiltDebt_Click()
   Dim lRow As Long
   
   mnuFiltDebt.Checked = True
   mnuFiltFin.Checked = False
   mnuFiltAll.Checked = False
   
   With grdCust
      .Redraw = False
      pRemoveGrouping
      For lRow = 1 To .RowCount
         .RowVisible(lRow) = (.CellValue(lRow, "debt") > 0)
      Next
      .Redraw = True
   End With
   
   If mnuGrpCountries.Checked Then
      pDoFilterGroup "country"
   ElseIf mnuGrpTypes.Checked Then
      pDoFilterGroup "type"
   End If
End Sub

Private Sub mnuFiltFin_Click()
   Dim lRow As Long
   
   mnuFiltDebt.Checked = False
   mnuFiltFin.Checked = True
   mnuFiltAll.Checked = False
   
   With grdCust
      .Redraw = False
      pRemoveGrouping
      For lRow = 1 To .RowCount
         .RowVisible(lRow) = (.CellValue(lRow, "country") = "FIN")
      Next
      .Redraw = True
   End With
   
   If mnuGrpCountries.Checked Then
      pDoFilterGroup "country"
   ElseIf mnuGrpTypes.Checked Then
      pDoFilterGroup "type"
   End If
End Sub

Private Sub mnuGrpCountries_Click()
   mnuGrpCountries.Checked = True
   mnuGrpTypes.Checked = False
   mnuGrpNo.Checked = False
   
   pDoGroup "country"
End Sub

Private Sub mnuGrpNo_Click()
   mnuGrpCountries.Checked = False
   mnuGrpTypes.Checked = False
   mnuGrpNo.Checked = True
   
   grdCust.Redraw = False
   pRemoveGrouping
   grdCust.Redraw = True
End Sub

Private Sub mnuGrpTypes_Click()
   mnuGrpCountries.Checked = False
   mnuGrpTypes.Checked = True
   mnuGrpNo.Checked = False
   
   pDoGroup "type"
End Sub

Private Sub pDoGroup(ByVal sGrpCol As String)
   Dim iRow As Long, iCol As Long
   Dim CurValue As Variant
   Dim GroupCellsFont As StdFont
   
   Set GroupCellsFont = New StdFont
   GroupCellsFont.Name = grdCust.Font.Name
   GroupCellsFont.Size = grdCust.Font.Size
   GroupCellsFont.Bold = True

   With grdCust
      .Redraw = False
      
      pRemoveGrouping
      
      iCol = .ColIndex(sGrpCol)

      .Sort iCol
      
      iRow = 1
      Do While iRow <= .RowCount
         If .RowVisible(iRow) Then
            If CurValue <> .CellValue(iRow, iCol) Then
               CurValue = .CellValue(iRow, iCol)
               .AddRow vRowBefore:=iRow, bGroupRow:=True, lHeight:=20
               .CellValue(iRow, .ColCount) = .CellText(iRow + 1, iCol)
               .CellTextFlags(iRow, .ColCount) = igTextSingleLine Or igTextVCenter Or igTextCenter
               .CellBackColor(iRow, .ColCount) = RGB(0, 176, 176)
               .CellForeColor(iRow, .ColCount) = RGB(255, 255, 255)
               .CellFont(iRow, .ColCount) = GroupCellsFont
               iRow = iRow + 1
            End If
         End If
         iRow = iRow + 1
      Loop
      
      .Redraw = True
   End With
End Sub

Private Sub pRemoveGrouping()
   Dim iRow As Long

   With grdCust
      iRow = .RowCount
      Do While iRow > 0
         If .RowIsGroup(iRow) Then
            .RemoveRow iRow
         End If
         iRow = iRow - 1
      Loop
   End With
End Sub

Private Sub mnuKeyPrsEdit_Click()
   mnuKeyPrsEdit.Checked = True
   mnuKeyPrsSrch.Checked = False
   grdCust.KeyPressBehaviour = igKeyPressEditReplace
End Sub

Private Sub mnuKeyPrsSrch_Click()
   mnuKeyPrsEdit.Checked = False
   mnuKeyPrsSrch.Checked = True
   grdCust.KeyPressBehaviour = igKeyPressSearchDefCol
   grdCust.KeySearchCol = grdCust.ColIndex("name")
End Sub

Private Sub mnuOptBackgrPic_Click()
   mnuOptBackgrPic.Checked = Not mnuOptBackgrPic.Checked
   If mnuOptBackgrPic.Checked Then
      Set grdCust.BackgroundPicture = picBackground.Picture
   Else
      Set grdCust.BackgroundPicture = Nothing
   End If
End Sub

Private Sub mnuOptResColWHdr_Click()
   Dim bNewState As Boolean
   
   bNewState = Not mnuOptResColWHdr.Checked
   
   If bNewState Then
      If Not grdCust.Supports(igSupFeatImmedColResizing) Then
         MsgBox "You need to have Windows 2000 or Windows XP in order to use this feature.", vbInformation
      Else
         mnuOptResColWHdr.Checked = True
         grdCust.ImmediateColumnResizing = True
      End If
   Else
      mnuOptResColWHdr.Checked = False
   End If
End Sub

Private Sub mnuOptRow_Click()
   mnuOptRow.Checked = Not mnuOptRow.Checked
   grdCust.RowMode = mnuOptRow.Checked
End Sub

Private Sub mnuPopupGen_Click()
   Dim sName As String
   Dim sID As String
   Dim pos As Long
   
   sName = grdCust.CellValue(grdCust.CurRow, "name")
   
   pos = InStr(sName, " ")
   
   If pos > 0 Then
      sID = UCase$(Left$(sName, 3) + Left$(Mid$(sName, pos + 1), 2))
   Else
      sID = UCase$(Left$(sName, 5))
   End If
   
   grdCust.TextEditText = sID
End Sub

Private Sub mnuRestLayout_Click()
   pRemoveGrouping
   grdCust.LayoutCol = GetSetting("iGrid_Demonstrator_Customers", "Layout", "Columns")
   grdCust.LayoutSort = GetSetting("iGrid_Demonstrator_Customers", "Layout", "Sort")
End Sub

Private Sub mnuSaveLayout_Click()
   SaveSetting "iGrid_Demonstrator_Customers", "Layout", "Columns", grdCust.LayoutCol
   SaveSetting "iGrid_Demonstrator_Customers", "Layout", "Sort", grdCust.LayoutSort
End Sub

Private Sub mnuTlsFitH_Click()
   Dim lRow As Long
   
   grdCust.Redraw = False
   For lRow = 1 To grdCust.RowCount
      grdCust.AutoHeightRow lRow
   Next
   grdCust.Redraw = True
End Sub

Private Sub mnuTlsFitW_Click()
   Dim lCol As Long
   
   grdCust.Redraw = False
   For lCol = 1 To grdCust.ColCount
      grdCust.AutoWidthCol lCol
   Next
   grdCust.Redraw = True
End Sub

Private Sub mnuOptFocusRect_Click()
   mnuOptFocusRect.Checked = Not mnuOptFocusRect.Checked
   grdCust.FocusRect = mnuOptFocusRect.Checked
End Sub

Private Sub pDoFilterGroup(ByVal sGrpCol As String)
   Dim iRow As Long, iCol As Long
   Dim CurValue As Variant

   With grdCust
      .Redraw = False
      
      iRow = 1
      iCol = .ColIndex(sGrpCol)
      Do While iRow <= .RowCount
         If .RowVisible(iRow) Then
            If CurValue <> .CellValue(iRow, iCol) Then
               CurValue = .CellValue(iRow, iCol)
               .AddRow vRowBefore:=iRow, bGroupRow:=True, lHeight:=20
               .CellValue(iRow, .ColCount) = .CellText(iRow + 1, iCol)
               .CellTextFlags(iRow, .ColCount) = igTextSingleLine Or igTextVCenter Or igTextCenter
               .CellBackColor(iRow, .ColCount) = RGB(0, 176, 176)
               .CellForeColor(iRow, .ColCount) = RGB(255, 255, 255)
               .CellFont(iRow, .ColCount) = mGroupFont
               iRow = iRow + 1
            End If
         End If
         iRow = iRow + 1
      Loop
      
      .Redraw = True
   End With
End Sub

Private Sub mnuViewTxt10_Click()
   Dim iRow As Long

   ' It's all that we need to do for normal cells and header:
   grdCust.Font.Size = 10
   
   mGroupFont.Size = 10
   
   ' If we have any grouping...
   If Not mnuGrpNo.Checked Then
      For iRow = 1 To grdCust.RowCount
         If grdCust.RowIsGroup(iRow) Then
            grdCust.CellFont(iRow, grdCust.ColCount) = mGroupFont
         End If
      Next
   End If
   
   mnuViewTxt10.Checked = True
   mnuViewTxt8.Checked = False
End Sub

Private Sub mnuViewTxt8_Click()
   Dim iRow As Long

   ' It's all that we need to do for normal cells and header:
   grdCust.Font.Size = 8
   
   mGroupFont.Size = 8
   
   ' If we have any grouping...
   If Not mnuGrpNo.Checked Then
      For iRow = 1 To grdCust.RowCount
         If grdCust.RowIsGroup(iRow) Then
            grdCust.CellFont(iRow, grdCust.ColCount) = mGroupFont
         End If
      Next
   End If
   
   mnuViewTxt10.Checked = False
   mnuViewTxt8.Checked = True
End Sub

Private Sub mnuFileSave_Click()
   Dim fh As Integer
   Dim iRow As Long
   
   fh = FreeFile
   Open App.Path & "\CustList.txt" For Output As #fh
   With grdCust
      For iRow = 1 To .RowCount
         If Not .RowIsGroup(iRow) Then
            Write #fh, .CellValue(iRow, "type"), .CellValue(iRow, "id"), _
               .CellValue(iRow, "name"), .CellValue(iRow, "country"), .CellValue(iRow, "is_patron"), _
               .CellValue(iRow, "total"), .CellValue(iRow, "debt"), .CellValue(iRow, "info")
         End If
      Next
   End With
   Close #fh
   
   mnuFileSave.Enabled = False
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
   If mnuFileSave.Enabled Then
      Select Case MsgBox("Do you want to save changes?", vbQuestion + vbYesNoCancel, Me.Caption)
      Case vbYes
         mnuFileSave_Click
      Case vbCancel
         Cancel = 1
      End Select
   End If
End Sub
