VERSION 5.00
Begin VB.UserControl StatusBar 
   Alignable       =   -1  'True
   CanGetFocus     =   0   'False
   ClientHeight    =   285
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   19
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   320
   ToolboxBitmap   =   "StatusBar.ctx":0000
End
Attribute VB_Name = "StatusBar"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Const WM_USER = &H400

Private Const SB_SETTEXT = WM_USER + 1

Private Const SBARS_SIZEGRIP = &H100
Private Const SBT_NOBORDERS = &H100

Private Const WM_SIZE = &H5

Private Const WS_CHILD = &H40000000
Private Const WS_VISIBLE = &H10000000

Private Type RECT
   Left As Long
   Top As Long
   Right As Long
   Bottom As Long
End Type

Private Declare Function CreateStatusWindow Lib "COMCTL32" Alias "CreateStatusWindowA" (ByVal Style As Long, ByVal lpszText As String, ByVal hWndParent As Long, ByVal wID As Long) As Long
Private Declare Function GetClientRect Lib "user32" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Sub InitCommonControls Lib "comctl32.dll" ()
Private Declare Function MoveWindow Lib "user32" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Private Declare Function SendMessageLong Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
Private Declare Function SendMessageString Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, ByVal lParam As String) As Long

Private m_hwnd As Long

Private Sub UserControl_Initialize()
   Dim lStyle As Long
   
   InitCommonControls
   
   lStyle = SBARS_SIZEGRIP Or WS_CHILD Or WS_VISIBLE
   
   m_hwnd = CreateStatusWindow(lStyle, vbNullString, UserControl.hwnd, 0&)
   
   MoveWindow m_hwnd, 0, 0, UserControl.ScaleWidth, UserControl.ScaleHeight, 1
End Sub

Private Sub UserControl_InitProperties()
   UserControl.Extender.Align = 2
End Sub

Private Sub UserControl_Resize()
   Dim tR As RECT
   Static bInHere As Boolean
   
   If Not (bInHere) Then
      bInHere = True
   
      ' Resize the status bar:
      SendMessageLong m_hwnd, WM_SIZE, 0, 0
      
      ' Is the UserControl has the correct height?
      GetClientRect m_hwnd, tR
      If (UserControl.Height <> (tR.Bottom - tR.Top) * Screen.TwipsPerPixelY) Then
         UserControl.Height = (tR.Bottom - tR.Top) * Screen.TwipsPerPixelY
      End If
      
      bInHere = False
   End If
End Sub

Public Sub SetText(Optional ByRef sText As String)
   SendMessageString m_hwnd, SB_SETTEXT, 0&, sText & vbNullChar
End Sub
