package demo;

import java.awt.*;
import java.awt.event.*;

import com.japisoft.formula.*;

/** Here a sample of Symbol resolver ans Function resolver. 
    We add a "sumi" function that computes the sum of the n integer and a PI symbol value.
    We use a "random" variable by the symbol table.
  */
public class Demo extends Frame implements SymbolResolver, FunctionResolver, ActionListener {

    private TextField cField;
    private Label cLabel;

    public Demo() {
	super();
	setTitle( "Demo" );
	initUI();
    }

    private void initUI() {
	setLayout( new BorderLayout() );

	Button mB = new Button( "Evaluate" );
	Button mB2 = new Button( "Clear" );
	mB.setActionCommand( "evaluate" );
	mB2.setActionCommand( "clear" );

	Panel mPanel = new Panel();
	mPanel.add( mB );
	mPanel.add( mB2 );

	add( cField = new TextField() );
	add( mPanel, BorderLayout.SOUTH );
	add( cLabel = new Label( "Result" ), BorderLayout.NORTH );

	mB.addActionListener( this );
	mB2.addActionListener( this );

	cField.addActionListener( this );
    }

    public void actionPerformed( ActionEvent e ) {
	String mCom = e.getActionCommand();
	if ( "clear".equals( mCom ) ) {
	    cField.setText( "" );
	} else 
	    if ( ( "evaluate".equals( mCom ) ) || ( e.getSource() == cField ) ) {
		if ( ( "".equals( cField.getText() ) ) || ( cField.getText() == null ) ) 
		    return;

		// Evaluate the expression
		FormulaFactory mFac = FormulaFactory.getInstance();
		Formula mForm = mFac.getFormula( cField.getText() );

		// We add a custom symbol
		mForm.setSymbolValue( "magic", new Variant( Math.random() ) );
		mForm.addFunctionResolver( this );
		mForm.addSymbolResolver( this );

		try {
		    cField.setForeground( Color.black );
		    cLabel.setText( "" + mForm.evaluate() );
		} catch( Throwable ex ) {
		    cLabel.setText( "Error : " + ex );
		    cField.setForeground( Color.red );
		    ex.printStackTrace();
		}
	    }
    }

    public static void main( String[] args ) {
	Demo mDemo = new Demo();
	mDemo.setSize( 400, 150 );
	mDemo.setVisible( true );
    }

    /////////////////////////////////////////////////////////////////////////

    /** Resolver for a symbol value */
    public Variant getValue( String symbol ) {
	if ( "PI2".equals( symbol ) ) 
	    return new Variant( Math.PI );
	else {
	    throw new SymbolResolverException( "Unknown " + symbol );
	}
    }

    /** Resolver for a "sumi function" */
    public Variant getValue( String function, ListOfArgument args ) {
	if ( "sumi".equals( function ) ) {
	    System.out.println( "Sumi resolver : Argument content " );
	    for ( int i = 0; i < args.getArgumentCount(); i++ ) {
		Variant mV = args.getArgumentAt( i );
		System.out.println( "Argument " + i + " = " + mV );
	    }

	    for ( int i = 0; i < args.getArgumentCount(); i++ ) {
		Variant mV = args.getArgumentAt( i );
		if ( mV.isDouble() ) {
		    int a = (int)mV.getDoubleValue();
		    return new Variant( (double)( ( a * ( a + 1 ) ) / 2 ) );
		}
	    }
	}
	throw new FunctionResolverException( "Unknown " + function );
    }

    public void setValue( String symb, Variant v ) {}
}
