// VaxVoIP.h: interface for the CVaxVoIP class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VAXVOIP_H__017BA040_906C_45E4_B6E6_F86A3960ADA4__INCLUDED_)
#define AFX_VAXVOIP_H__017BA040_906C_45E4_B6E6_F86A3960ADA4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "VaxSIPUserAgentLib/VaxSIPUserAgentLib.h"

class CVCSampleDlg;

class CVaxVoIP : public CVaxSIPUserAgentLib  
{
public:
	CVaxVoIP();
	~CVaxVoIP();

public:
	
	CVCSampleDlg* m_pVCSampleDlg;

	void ErrorMessage();

public:

	void OnFailToUnRegister();
	void OnSuccessToUnRegister();
	
	void OnFailToRegister();
	void OnSuccessToRegister();

	void OnFailToConnect();
	void OnSuccessToConnect(int nTxCodecNo);
	void OnConnecting();

	void OnIncomingCall(LPCTSTR sDisplayName, LPCTSTR sUserName, LPCTSTR sFromURI);
	void OnIncomingCallRingingStart();
	void OnIncomingCallRingingStop();

	void OnDisconnectCall();
	
	void OnProvisionalResponse(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnRedirectionResponse(int nStatusCode, LPCTSTR sReasonPhrase, LPCTSTR sContact);
	void OnRequestFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnServerFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase);
	void OnGeneralFailureResponse(int nStatusCode, LPCTSTR sReasonPhrase);

};

#endif // !defined(AFX_VAXVOIP_H__017BA040_906C_45E4_B6E6_F86A3960ADA4__INCLUDED_)
