

# ========================================================================
# Categories: Queries.
# SELECT , INSERT and UPDATE Queries for Categories
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_CategoriesBase]
{
SELECT * FROM [Categories] 
WHERE
[CategoryID]=?
}
int



[INSERT_CategoriesBase]
{
	
-- we will use a transaction in order for identity to be correctly read
begin transaction

INSERT INTO [Categories]
([CategoryName]
,[Description]
,[Picture]
) 
	VALUES(?,?,?)

	
SELECT @@IDENTITY
commit transaction

}
nvarchar(15)
ntext
image

[UPDATE_CategoriesBase]
{
UPDATE [Categories] 
SET [CategoryName]=?,[Description]=?,[Picture]=?
	WHERE [CategoryID]=?
}
nvarchar(15)
ntext
image
int

[DELETE_CategoriesBase]
{
DELETE FROM [Categories] 
WHERE
[CategoryID]=?
}
int

# SELECT for CategoriesBase.CategoryID
[SELECT_CategoriesBase_CategoryID]
{
	SELECT * FROM [Categories] WHERE [CategoryID]=?
}
int
# SELECT for CategoriesBase.CategoryName
[SELECT_CategoriesBase_CategoryName]
{
	SELECT * FROM [Categories] WHERE [CategoryName]=?
}
nvarchar(15)

# ========================================================================
# CustomerCustomerDemo: Queries.
# SELECT , INSERT and UPDATE Queries for CustomerCustomerDemo
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_CustomerCustomerDemoBase]
{
SELECT * FROM [CustomerCustomerDemo] 
WHERE
[CustomerID]=?
 AND [CustomerTypeID]=?
}
nchar(5)
nchar(10)



[INSERT_CustomerCustomerDemoBase]
{

INSERT INTO [CustomerCustomerDemo]
([CustomerID]
,[CustomerTypeID]
) 
	VALUES(?,?)


}
nchar(5)
nchar(10)

[UPDATEALL_CustomerCustomerDemoBase]
{
UPDATE [CustomerCustomerDemo] 
SET [CustomerID]=?,[CustomerTypeID]=?
	WHERE [CustomerID]=? AND [CustomerTypeID]=?
}
nchar(5)
nchar(10)
nchar(5)
nchar(10)

[DELETE_CustomerCustomerDemoBase]
{
DELETE FROM [CustomerCustomerDemo] 
WHERE
[CustomerID]=?
 AND [CustomerTypeID]=?
}
nchar(5)
nchar(10)

# SELECT for CustomerCustomerDemoBase.CustomerID
[SELECT_CustomerCustomerDemoBase_CustomerID]
{
	SELECT * FROM [CustomerCustomerDemo] WHERE [CustomerID]=?
}
nchar(5)
# SELECT for CustomerCustomerDemoBase.CustomerTypeID
[SELECT_CustomerCustomerDemoBase_CustomerTypeID]
{
	SELECT * FROM [CustomerCustomerDemo] WHERE [CustomerTypeID]=?
}
nchar(10)

# ========================================================================
# CustomerDemographics: Queries.
# SELECT , INSERT and UPDATE Queries for CustomerDemographics
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_CustomerDemographicsBase]
{
SELECT * FROM [CustomerDemographics] 
WHERE
[CustomerTypeID]=?
}
nchar(10)



[INSERT_CustomerDemographicsBase]
{

INSERT INTO [CustomerDemographics]
([CustomerTypeID]
,[CustomerDesc]
) 
	VALUES(?,?)


}
nchar(10)
ntext

[UPDATE_CustomerDemographicsBase]
{
UPDATE [CustomerDemographics] 
SET [CustomerDesc]=?
	WHERE [CustomerTypeID]=?
}
ntext
nchar(10)

[UPDATEALL_CustomerDemographicsBase]
{
UPDATE [CustomerDemographics] 
SET [CustomerTypeID]=?,[CustomerDesc]=?
	WHERE [CustomerTypeID]=?
}
nchar(10)
ntext
nchar(10)

[DELETE_CustomerDemographicsBase]
{
DELETE FROM [CustomerDemographics] 
WHERE
[CustomerTypeID]=?
}
nchar(10)

# SELECT for CustomerDemographicsBase.CustomerTypeID
[SELECT_CustomerDemographicsBase_CustomerTypeID]
{
	SELECT * FROM [CustomerDemographics] WHERE [CustomerTypeID]=?
}
nchar(10)

# ========================================================================
# Customers: Queries.
# SELECT , INSERT and UPDATE Queries for Customers
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_CustomersBase]
{
SELECT * FROM [Customers] 
WHERE
[CustomerID]=?
}
nchar(5)



[INSERT_CustomersBase]
{

INSERT INTO [Customers]
([CustomerID]
,[CompanyName]
,[ContactName]
,[ContactTitle]
,[Address]
,[City]
,[Region]
,[PostalCode]
,[Country]
,[Phone]
,[Fax]
) 
	VALUES(?,?,?,?,?,?,?,?,?,?,?)


}
nchar(5)
nvarchar(40)
nvarchar(30)
nvarchar(30)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(24)
nvarchar(24)

[UPDATE_CustomersBase]
{
UPDATE [Customers] 
SET [CompanyName]=?,[ContactName]=?,[ContactTitle]=?,[Address]=?,[City]=?,[Region]=?,[PostalCode]=?,[Country]=?,[Phone]=?,[Fax]=?
	WHERE [CustomerID]=?
}
nvarchar(40)
nvarchar(30)
nvarchar(30)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(24)
nvarchar(24)
nchar(5)

[UPDATEALL_CustomersBase]
{
UPDATE [Customers] 
SET [CustomerID]=?,[CompanyName]=?,[ContactName]=?,[ContactTitle]=?,[Address]=?,[City]=?,[Region]=?,[PostalCode]=?,[Country]=?,[Phone]=?,[Fax]=?
	WHERE [CustomerID]=?
}
nchar(5)
nvarchar(40)
nvarchar(30)
nvarchar(30)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(24)
nvarchar(24)
nchar(5)

[DELETE_CustomersBase]
{
DELETE FROM [Customers] 
WHERE
[CustomerID]=?
}
nchar(5)

# SELECT for CustomersBase.CustomerID
[SELECT_CustomersBase_CustomerID]
{
	SELECT * FROM [Customers] WHERE [CustomerID]=?
}
nchar(5)
# SELECT for CustomersBase.CompanyName
[SELECT_CustomersBase_CompanyName]
{
	SELECT * FROM [Customers] WHERE [CompanyName]=?
}
nvarchar(40)
# SELECT for CustomersBase.ContactName
[SELECT_CustomersBase_ContactName]
{
	SELECT * FROM [Customers] WHERE [ContactName]=?
}
nvarchar(30)
# SELECT for CustomersBase.ContactTitle
[SELECT_CustomersBase_ContactTitle]
{
	SELECT * FROM [Customers] WHERE [ContactTitle]=?
}
nvarchar(30)
# SELECT for CustomersBase.Address
[SELECT_CustomersBase_Address]
{
	SELECT * FROM [Customers] WHERE [Address]=?
}
nvarchar(60)
# SELECT for CustomersBase.City
[SELECT_CustomersBase_City]
{
	SELECT * FROM [Customers] WHERE [City]=?
}
nvarchar(15)
# SELECT for CustomersBase.Region
[SELECT_CustomersBase_Region]
{
	SELECT * FROM [Customers] WHERE [Region]=?
}
nvarchar(15)
# SELECT for CustomersBase.PostalCode
[SELECT_CustomersBase_PostalCode]
{
	SELECT * FROM [Customers] WHERE [PostalCode]=?
}
nvarchar(10)
# SELECT for CustomersBase.Country
[SELECT_CustomersBase_Country]
{
	SELECT * FROM [Customers] WHERE [Country]=?
}
nvarchar(15)
# SELECT for CustomersBase.Phone
[SELECT_CustomersBase_Phone]
{
	SELECT * FROM [Customers] WHERE [Phone]=?
}
nvarchar(24)
# SELECT for CustomersBase.Fax
[SELECT_CustomersBase_Fax]
{
	SELECT * FROM [Customers] WHERE [Fax]=?
}
nvarchar(24)

# ========================================================================
# EmployeeTerritories: Queries.
# SELECT , INSERT and UPDATE Queries for EmployeeTerritories
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_EmployeeTerritoriesBase]
{
SELECT * FROM [EmployeeTerritories] 
WHERE
[EmployeeID]=?
 AND [TerritoryID]=?
}
int
nvarchar(20)



[INSERT_EmployeeTerritoriesBase]
{

INSERT INTO [EmployeeTerritories]
([EmployeeID]
,[TerritoryID]
) 
	VALUES(?,?)


}
int
nvarchar(20)

[UPDATEALL_EmployeeTerritoriesBase]
{
UPDATE [EmployeeTerritories] 
SET [EmployeeID]=?,[TerritoryID]=?
	WHERE [EmployeeID]=? AND [TerritoryID]=?
}
int
nvarchar(20)
int
nvarchar(20)

[DELETE_EmployeeTerritoriesBase]
{
DELETE FROM [EmployeeTerritories] 
WHERE
[EmployeeID]=?
 AND [TerritoryID]=?
}
int
nvarchar(20)

# SELECT for EmployeeTerritoriesBase.EmployeeID
[SELECT_EmployeeTerritoriesBase_EmployeeID]
{
	SELECT * FROM [EmployeeTerritories] WHERE [EmployeeID]=?
}
int
# SELECT for EmployeeTerritoriesBase.TerritoryID
[SELECT_EmployeeTerritoriesBase_TerritoryID]
{
	SELECT * FROM [EmployeeTerritories] WHERE [TerritoryID]=?
}
nvarchar(20)

# ========================================================================
# Employees: Queries.
# SELECT , INSERT and UPDATE Queries for Employees
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_EmployeesBase]
{
SELECT * FROM [Employees] 
WHERE
[EmployeeID]=?
}
int



[INSERT_EmployeesBase]
{
	
-- we will use a transaction in order for identity to be correctly read
begin transaction

INSERT INTO [Employees]
([LastName]
,[FirstName]
,[Title]
,[TitleOfCourtesy]
,[BirthDate]
,[HireDate]
,[Address]
,[City]
,[Region]
,[PostalCode]
,[Country]
,[HomePhone]
,[Extension]
,[Photo]
,[Notes]
,[ReportsTo]
,[PhotoPath]
) 
	VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)

	
SELECT @@IDENTITY
commit transaction

}
nvarchar(20)
nvarchar(10)
nvarchar(30)
nvarchar(25)
datetime
datetime
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(24)
nvarchar(4)
image
ntext
int
nvarchar(255)

[UPDATE_EmployeesBase]
{
UPDATE [Employees] 
SET [LastName]=?,[FirstName]=?,[Title]=?,[TitleOfCourtesy]=?,[BirthDate]=?,[HireDate]=?,[Address]=?,[City]=?,[Region]=?,[PostalCode]=?,[Country]=?,[HomePhone]=?,[Extension]=?,[Photo]=?,[Notes]=?,[ReportsTo]=?,[PhotoPath]=?
	WHERE [EmployeeID]=?
}
nvarchar(20)
nvarchar(10)
nvarchar(30)
nvarchar(25)
datetime
datetime
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(24)
nvarchar(4)
image
ntext
int
nvarchar(255)
int

[DELETE_EmployeesBase]
{
DELETE FROM [Employees] 
WHERE
[EmployeeID]=?
}
int

# SELECT for EmployeesBase.EmployeeID
[SELECT_EmployeesBase_EmployeeID]
{
	SELECT * FROM [Employees] WHERE [EmployeeID]=?
}
int
# SELECT for EmployeesBase.LastName
[SELECT_EmployeesBase_LastName]
{
	SELECT * FROM [Employees] WHERE [LastName]=?
}
nvarchar(20)
# SELECT for EmployeesBase.FirstName
[SELECT_EmployeesBase_FirstName]
{
	SELECT * FROM [Employees] WHERE [FirstName]=?
}
nvarchar(10)
# SELECT for EmployeesBase.Title
[SELECT_EmployeesBase_Title]
{
	SELECT * FROM [Employees] WHERE [Title]=?
}
nvarchar(30)
# SELECT for EmployeesBase.TitleOfCourtesy
[SELECT_EmployeesBase_TitleOfCourtesy]
{
	SELECT * FROM [Employees] WHERE [TitleOfCourtesy]=?
}
nvarchar(25)
# SELECT for EmployeesBase.BirthDate
[SELECT_EmployeesBase_BirthDate]
{
	SELECT * FROM [Employees] WHERE [BirthDate]=?
}
datetime
# SELECT for EmployeesBase.HireDate
[SELECT_EmployeesBase_HireDate]
{
	SELECT * FROM [Employees] WHERE [HireDate]=?
}
datetime
# SELECT for EmployeesBase.Address
[SELECT_EmployeesBase_Address]
{
	SELECT * FROM [Employees] WHERE [Address]=?
}
nvarchar(60)
# SELECT for EmployeesBase.City
[SELECT_EmployeesBase_City]
{
	SELECT * FROM [Employees] WHERE [City]=?
}
nvarchar(15)
# SELECT for EmployeesBase.Region
[SELECT_EmployeesBase_Region]
{
	SELECT * FROM [Employees] WHERE [Region]=?
}
nvarchar(15)
# SELECT for EmployeesBase.PostalCode
[SELECT_EmployeesBase_PostalCode]
{
	SELECT * FROM [Employees] WHERE [PostalCode]=?
}
nvarchar(10)
# SELECT for EmployeesBase.Country
[SELECT_EmployeesBase_Country]
{
	SELECT * FROM [Employees] WHERE [Country]=?
}
nvarchar(15)
# SELECT for EmployeesBase.HomePhone
[SELECT_EmployeesBase_HomePhone]
{
	SELECT * FROM [Employees] WHERE [HomePhone]=?
}
nvarchar(24)
# SELECT for EmployeesBase.Extension
[SELECT_EmployeesBase_Extension]
{
	SELECT * FROM [Employees] WHERE [Extension]=?
}
nvarchar(4)
# SELECT for EmployeesBase.ReportsTo
[SELECT_EmployeesBase_ReportsTo]
{
	SELECT * FROM [Employees] WHERE [ReportsTo]=?
}
int
# SELECT for EmployeesBase.PhotoPath
[SELECT_EmployeesBase_PhotoPath]
{
	SELECT * FROM [Employees] WHERE [PhotoPath]=?
}
nvarchar(255)

# ========================================================================
# Order Details: Queries.
# SELECT , INSERT and UPDATE Queries for Order Details
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Order_DetailsBase]
{
SELECT * FROM [Order Details] 
WHERE
[OrderID]=?
 AND [ProductID]=?
}
int
int



[INSERT_Order_DetailsBase]
{

INSERT INTO [Order Details]
([OrderID]
,[ProductID]
,[UnitPrice]
,[Quantity]
,[Discount]
) 
	VALUES(?,?,?,?,?)


}
int
int
money
smallint
real

[UPDATE_Order_DetailsBase]
{
UPDATE [Order Details] 
SET [UnitPrice]=?,[Quantity]=?,[Discount]=?
	WHERE [OrderID]=? AND [ProductID]=?
}
money
smallint
real
int
int

[UPDATEALL_Order_DetailsBase]
{
UPDATE [Order Details] 
SET [OrderID]=?,[ProductID]=?,[UnitPrice]=?,[Quantity]=?,[Discount]=?
	WHERE [OrderID]=? AND [ProductID]=?
}
int
int
money
smallint
real
int
int

[DELETE_Order_DetailsBase]
{
DELETE FROM [Order Details] 
WHERE
[OrderID]=?
 AND [ProductID]=?
}
int
int

# SELECT for Order_DetailsBase.OrderID
[SELECT_Order_DetailsBase_OrderID]
{
	SELECT * FROM [Order Details] WHERE [OrderID]=?
}
int
# SELECT for Order_DetailsBase.ProductID
[SELECT_Order_DetailsBase_ProductID]
{
	SELECT * FROM [Order Details] WHERE [ProductID]=?
}
int
# SELECT for Order_DetailsBase.UnitPrice
[SELECT_Order_DetailsBase_UnitPrice]
{
	SELECT * FROM [Order Details] WHERE [UnitPrice]=?
}
money
# SELECT for Order_DetailsBase.Quantity
[SELECT_Order_DetailsBase_Quantity]
{
	SELECT * FROM [Order Details] WHERE [Quantity]=?
}
smallint
# SELECT for Order_DetailsBase.Discount
[SELECT_Order_DetailsBase_Discount]
{
	SELECT * FROM [Order Details] WHERE [Discount]=?
}
real

# ========================================================================
# Orders: Queries.
# SELECT , INSERT and UPDATE Queries for Orders
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_OrdersBase]
{
SELECT * FROM [Orders] 
WHERE
[OrderID]=?
}
int



[INSERT_OrdersBase]
{
	
-- we will use a transaction in order for identity to be correctly read
begin transaction

INSERT INTO [Orders]
([CustomerID]
,[EmployeeID]
,[OrderDate]
,[RequiredDate]
,[ShippedDate]
,[ShipVia]
,[Freight]
,[ShipName]
,[ShipAddress]
,[ShipCity]
,[ShipRegion]
,[ShipPostalCode]
,[ShipCountry]
) 
	VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?)

	
SELECT @@IDENTITY
commit transaction

}
nchar(5)
int
datetime
datetime
datetime
int
money
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)

[UPDATE_OrdersBase]
{
UPDATE [Orders] 
SET [CustomerID]=?,[EmployeeID]=?,[OrderDate]=?,[RequiredDate]=?,[ShippedDate]=?,[ShipVia]=?,[Freight]=?,[ShipName]=?,[ShipAddress]=?,[ShipCity]=?,[ShipRegion]=?,[ShipPostalCode]=?,[ShipCountry]=?
	WHERE [OrderID]=?
}
nchar(5)
int
datetime
datetime
datetime
int
money
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
int

[DELETE_OrdersBase]
{
DELETE FROM [Orders] 
WHERE
[OrderID]=?
}
int

# SELECT for OrdersBase.OrderID
[SELECT_OrdersBase_OrderID]
{
	SELECT * FROM [Orders] WHERE [OrderID]=?
}
int
# SELECT for OrdersBase.CustomerID
[SELECT_OrdersBase_CustomerID]
{
	SELECT * FROM [Orders] WHERE [CustomerID]=?
}
nchar(5)
# SELECT for OrdersBase.EmployeeID
[SELECT_OrdersBase_EmployeeID]
{
	SELECT * FROM [Orders] WHERE [EmployeeID]=?
}
int
# SELECT for OrdersBase.OrderDate
[SELECT_OrdersBase_OrderDate]
{
	SELECT * FROM [Orders] WHERE [OrderDate]=?
}
datetime
# SELECT for OrdersBase.RequiredDate
[SELECT_OrdersBase_RequiredDate]
{
	SELECT * FROM [Orders] WHERE [RequiredDate]=?
}
datetime
# SELECT for OrdersBase.ShippedDate
[SELECT_OrdersBase_ShippedDate]
{
	SELECT * FROM [Orders] WHERE [ShippedDate]=?
}
datetime
# SELECT for OrdersBase.ShipVia
[SELECT_OrdersBase_ShipVia]
{
	SELECT * FROM [Orders] WHERE [ShipVia]=?
}
int
# SELECT for OrdersBase.Freight
[SELECT_OrdersBase_Freight]
{
	SELECT * FROM [Orders] WHERE [Freight]=?
}
money
# SELECT for OrdersBase.ShipName
[SELECT_OrdersBase_ShipName]
{
	SELECT * FROM [Orders] WHERE [ShipName]=?
}
nvarchar(40)
# SELECT for OrdersBase.ShipAddress
[SELECT_OrdersBase_ShipAddress]
{
	SELECT * FROM [Orders] WHERE [ShipAddress]=?
}
nvarchar(60)
# SELECT for OrdersBase.ShipCity
[SELECT_OrdersBase_ShipCity]
{
	SELECT * FROM [Orders] WHERE [ShipCity]=?
}
nvarchar(15)
# SELECT for OrdersBase.ShipRegion
[SELECT_OrdersBase_ShipRegion]
{
	SELECT * FROM [Orders] WHERE [ShipRegion]=?
}
nvarchar(15)
# SELECT for OrdersBase.ShipPostalCode
[SELECT_OrdersBase_ShipPostalCode]
{
	SELECT * FROM [Orders] WHERE [ShipPostalCode]=?
}
nvarchar(10)
# SELECT for OrdersBase.ShipCountry
[SELECT_OrdersBase_ShipCountry]
{
	SELECT * FROM [Orders] WHERE [ShipCountry]=?
}
nvarchar(15)

# ========================================================================
# Products: Queries.
# SELECT , INSERT and UPDATE Queries for Products
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_ProductsBase]
{
SELECT * FROM [Products] 
WHERE
[ProductID]=?
}
int



[INSERT_ProductsBase]
{
	
-- we will use a transaction in order for identity to be correctly read
begin transaction

INSERT INTO [Products]
([ProductName]
,[SupplierID]
,[CategoryID]
,[QuantityPerUnit]
,[UnitPrice]
,[UnitsInStock]
,[UnitsOnOrder]
,[ReorderLevel]
,[Discontinued]
) 
	VALUES(?,?,?,?,?,?,?,?,?)

	
SELECT @@IDENTITY
commit transaction

}
nvarchar(40)
int
int
nvarchar(20)
money
smallint
smallint
smallint
bit

[UPDATE_ProductsBase]
{
UPDATE [Products] 
SET [ProductName]=?,[SupplierID]=?,[CategoryID]=?,[QuantityPerUnit]=?,[UnitPrice]=?,[UnitsInStock]=?,[UnitsOnOrder]=?,[ReorderLevel]=?,[Discontinued]=?
	WHERE [ProductID]=?
}
nvarchar(40)
int
int
nvarchar(20)
money
smallint
smallint
smallint
bit
int

[DELETE_ProductsBase]
{
DELETE FROM [Products] 
WHERE
[ProductID]=?
}
int

# SELECT for ProductsBase.ProductID
[SELECT_ProductsBase_ProductID]
{
	SELECT * FROM [Products] WHERE [ProductID]=?
}
int
# SELECT for ProductsBase.ProductName
[SELECT_ProductsBase_ProductName]
{
	SELECT * FROM [Products] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for ProductsBase.SupplierID
[SELECT_ProductsBase_SupplierID]
{
	SELECT * FROM [Products] WHERE [SupplierID]=?
}
int
# SELECT for ProductsBase.CategoryID
[SELECT_ProductsBase_CategoryID]
{
	SELECT * FROM [Products] WHERE [CategoryID]=?
}
int
# SELECT for ProductsBase.QuantityPerUnit
[SELECT_ProductsBase_QuantityPerUnit]
{
	SELECT * FROM [Products] WHERE [QuantityPerUnit]=?
}
nvarchar(20)
# SELECT for ProductsBase.UnitPrice
[SELECT_ProductsBase_UnitPrice]
{
	SELECT * FROM [Products] WHERE [UnitPrice]=?
}
money
# SELECT for ProductsBase.UnitsInStock
[SELECT_ProductsBase_UnitsInStock]
{
	SELECT * FROM [Products] WHERE [UnitsInStock]=?
}
smallint
# SELECT for ProductsBase.UnitsOnOrder
[SELECT_ProductsBase_UnitsOnOrder]
{
	SELECT * FROM [Products] WHERE [UnitsOnOrder]=?
}
smallint
# SELECT for ProductsBase.ReorderLevel
[SELECT_ProductsBase_ReorderLevel]
{
	SELECT * FROM [Products] WHERE [ReorderLevel]=?
}
smallint
# SELECT for ProductsBase.Discontinued
[SELECT_ProductsBase_Discontinued]
{
	SELECT * FROM [Products] WHERE [Discontinued]=?
}
bit

# ========================================================================
# Region: Queries.
# SELECT , INSERT and UPDATE Queries for Region
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_RegionBase]
{
SELECT * FROM [Region] 
WHERE
[RegionID]=?
}
int



[INSERT_RegionBase]
{

INSERT INTO [Region]
([RegionID]
,[RegionDescription]
) 
	VALUES(?,?)


}
int
nchar(50)

[UPDATE_RegionBase]
{
UPDATE [Region] 
SET [RegionDescription]=?
	WHERE [RegionID]=?
}
nchar(50)
int

[UPDATEALL_RegionBase]
{
UPDATE [Region] 
SET [RegionID]=?,[RegionDescription]=?
	WHERE [RegionID]=?
}
int
nchar(50)
int

[DELETE_RegionBase]
{
DELETE FROM [Region] 
WHERE
[RegionID]=?
}
int

# SELECT for RegionBase.RegionID
[SELECT_RegionBase_RegionID]
{
	SELECT * FROM [Region] WHERE [RegionID]=?
}
int
# SELECT for RegionBase.RegionDescription
[SELECT_RegionBase_RegionDescription]
{
	SELECT * FROM [Region] WHERE [RegionDescription]=?
}
nchar(50)

# ========================================================================
# Shippers: Queries.
# SELECT , INSERT and UPDATE Queries for Shippers
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_ShippersBase]
{
SELECT * FROM [Shippers] 
WHERE
[ShipperID]=?
}
int



[INSERT_ShippersBase]
{
	
-- we will use a transaction in order for identity to be correctly read
begin transaction

INSERT INTO [Shippers]
([CompanyName]
,[Phone]
) 
	VALUES(?,?)

	
SELECT @@IDENTITY
commit transaction

}
nvarchar(40)
nvarchar(24)

[UPDATE_ShippersBase]
{
UPDATE [Shippers] 
SET [CompanyName]=?,[Phone]=?
	WHERE [ShipperID]=?
}
nvarchar(40)
nvarchar(24)
int

[DELETE_ShippersBase]
{
DELETE FROM [Shippers] 
WHERE
[ShipperID]=?
}
int

# SELECT for ShippersBase.ShipperID
[SELECT_ShippersBase_ShipperID]
{
	SELECT * FROM [Shippers] WHERE [ShipperID]=?
}
int
# SELECT for ShippersBase.CompanyName
[SELECT_ShippersBase_CompanyName]
{
	SELECT * FROM [Shippers] WHERE [CompanyName]=?
}
nvarchar(40)
# SELECT for ShippersBase.Phone
[SELECT_ShippersBase_Phone]
{
	SELECT * FROM [Shippers] WHERE [Phone]=?
}
nvarchar(24)

# ========================================================================
# Suppliers: Queries.
# SELECT , INSERT and UPDATE Queries for Suppliers
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_SuppliersBase]
{
SELECT * FROM [Suppliers] 
WHERE
[SupplierID]=?
}
int



[INSERT_SuppliersBase]
{
	
-- we will use a transaction in order for identity to be correctly read
begin transaction

INSERT INTO [Suppliers]
([CompanyName]
,[ContactName]
,[ContactTitle]
,[Address]
,[City]
,[Region]
,[PostalCode]
,[Country]
,[Phone]
,[Fax]
,[HomePage]
) 
	VALUES(?,?,?,?,?,?,?,?,?,?,?)

	
SELECT @@IDENTITY
commit transaction

}
nvarchar(40)
nvarchar(30)
nvarchar(30)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(24)
nvarchar(24)
ntext

[UPDATE_SuppliersBase]
{
UPDATE [Suppliers] 
SET [CompanyName]=?,[ContactName]=?,[ContactTitle]=?,[Address]=?,[City]=?,[Region]=?,[PostalCode]=?,[Country]=?,[Phone]=?,[Fax]=?,[HomePage]=?
	WHERE [SupplierID]=?
}
nvarchar(40)
nvarchar(30)
nvarchar(30)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(24)
nvarchar(24)
ntext
int

[DELETE_SuppliersBase]
{
DELETE FROM [Suppliers] 
WHERE
[SupplierID]=?
}
int

# SELECT for SuppliersBase.SupplierID
[SELECT_SuppliersBase_SupplierID]
{
	SELECT * FROM [Suppliers] WHERE [SupplierID]=?
}
int
# SELECT for SuppliersBase.CompanyName
[SELECT_SuppliersBase_CompanyName]
{
	SELECT * FROM [Suppliers] WHERE [CompanyName]=?
}
nvarchar(40)
# SELECT for SuppliersBase.ContactName
[SELECT_SuppliersBase_ContactName]
{
	SELECT * FROM [Suppliers] WHERE [ContactName]=?
}
nvarchar(30)
# SELECT for SuppliersBase.ContactTitle
[SELECT_SuppliersBase_ContactTitle]
{
	SELECT * FROM [Suppliers] WHERE [ContactTitle]=?
}
nvarchar(30)
# SELECT for SuppliersBase.Address
[SELECT_SuppliersBase_Address]
{
	SELECT * FROM [Suppliers] WHERE [Address]=?
}
nvarchar(60)
# SELECT for SuppliersBase.City
[SELECT_SuppliersBase_City]
{
	SELECT * FROM [Suppliers] WHERE [City]=?
}
nvarchar(15)
# SELECT for SuppliersBase.Region
[SELECT_SuppliersBase_Region]
{
	SELECT * FROM [Suppliers] WHERE [Region]=?
}
nvarchar(15)
# SELECT for SuppliersBase.PostalCode
[SELECT_SuppliersBase_PostalCode]
{
	SELECT * FROM [Suppliers] WHERE [PostalCode]=?
}
nvarchar(10)
# SELECT for SuppliersBase.Country
[SELECT_SuppliersBase_Country]
{
	SELECT * FROM [Suppliers] WHERE [Country]=?
}
nvarchar(15)
# SELECT for SuppliersBase.Phone
[SELECT_SuppliersBase_Phone]
{
	SELECT * FROM [Suppliers] WHERE [Phone]=?
}
nvarchar(24)
# SELECT for SuppliersBase.Fax
[SELECT_SuppliersBase_Fax]
{
	SELECT * FROM [Suppliers] WHERE [Fax]=?
}
nvarchar(24)

# ========================================================================
# Territories: Queries.
# SELECT , INSERT and UPDATE Queries for Territories
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_TerritoriesBase]
{
SELECT * FROM [Territories] 
WHERE
[TerritoryID]=?
}
nvarchar(20)



[INSERT_TerritoriesBase]
{

INSERT INTO [Territories]
([TerritoryID]
,[TerritoryDescription]
,[RegionID]
) 
	VALUES(?,?,?)


}
nvarchar(20)
nchar(50)
int

[UPDATE_TerritoriesBase]
{
UPDATE [Territories] 
SET [TerritoryDescription]=?,[RegionID]=?
	WHERE [TerritoryID]=?
}
nchar(50)
int
nvarchar(20)

[UPDATEALL_TerritoriesBase]
{
UPDATE [Territories] 
SET [TerritoryID]=?,[TerritoryDescription]=?,[RegionID]=?
	WHERE [TerritoryID]=?
}
nvarchar(20)
nchar(50)
int
nvarchar(20)

[DELETE_TerritoriesBase]
{
DELETE FROM [Territories] 
WHERE
[TerritoryID]=?
}
nvarchar(20)

# SELECT for TerritoriesBase.TerritoryID
[SELECT_TerritoriesBase_TerritoryID]
{
	SELECT * FROM [Territories] WHERE [TerritoryID]=?
}
nvarchar(20)
# SELECT for TerritoriesBase.TerritoryDescription
[SELECT_TerritoriesBase_TerritoryDescription]
{
	SELECT * FROM [Territories] WHERE [TerritoryDescription]=?
}
nchar(50)
# SELECT for TerritoriesBase.RegionID
[SELECT_TerritoriesBase_RegionID]
{
	SELECT * FROM [Territories] WHERE [RegionID]=?
}
int

# ========================================================================
# Alphabetical list of products: Queries.
# SELECT , INSERT and UPDATE Queries for Alphabetical list of products
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Alphabetical_list_of_productsBase]
{
SELECT * FROM [Alphabetical list of products] 
}



[INSERT_Alphabetical_list_of_productsBase]
{

INSERT INTO [Alphabetical list of products]
([ProductID]
,[ProductName]
,[SupplierID]
,[CategoryID]
,[QuantityPerUnit]
,[UnitPrice]
,[UnitsInStock]
,[UnitsOnOrder]
,[ReorderLevel]
,[Discontinued]
,[CategoryName]
) 
	VALUES(?,?,?,?,?,?,?,?,?,?,?)


}
int
nvarchar(40)
int
int
nvarchar(20)
money
smallint
smallint
smallint
bit
nvarchar(15)

[UPDATE_Alphabetical_list_of_productsBase]
{
UPDATE [Alphabetical list of products] 
SET [ProductID]=?,[ProductName]=?,[SupplierID]=?,[CategoryID]=?,[QuantityPerUnit]=?,[UnitPrice]=?,[UnitsInStock]=?,[UnitsOnOrder]=?,[ReorderLevel]=?,[Discontinued]=?,[CategoryName]=?
}
int
nvarchar(40)
int
int
nvarchar(20)
money
smallint
smallint
smallint
bit
nvarchar(15)

# SELECT for Alphabetical_list_of_productsBase.ProductID
[SELECT_Alphabetical_list_of_productsBase_ProductID]
{
	SELECT * FROM [Alphabetical list of products] WHERE [ProductID]=?
}
int
# SELECT for Alphabetical_list_of_productsBase.ProductName
[SELECT_Alphabetical_list_of_productsBase_ProductName]
{
	SELECT * FROM [Alphabetical list of products] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for Alphabetical_list_of_productsBase.SupplierID
[SELECT_Alphabetical_list_of_productsBase_SupplierID]
{
	SELECT * FROM [Alphabetical list of products] WHERE [SupplierID]=?
}
int
# SELECT for Alphabetical_list_of_productsBase.CategoryID
[SELECT_Alphabetical_list_of_productsBase_CategoryID]
{
	SELECT * FROM [Alphabetical list of products] WHERE [CategoryID]=?
}
int
# SELECT for Alphabetical_list_of_productsBase.QuantityPerUnit
[SELECT_Alphabetical_list_of_productsBase_QuantityPerUnit]
{
	SELECT * FROM [Alphabetical list of products] WHERE [QuantityPerUnit]=?
}
nvarchar(20)
# SELECT for Alphabetical_list_of_productsBase.UnitPrice
[SELECT_Alphabetical_list_of_productsBase_UnitPrice]
{
	SELECT * FROM [Alphabetical list of products] WHERE [UnitPrice]=?
}
money
# SELECT for Alphabetical_list_of_productsBase.UnitsInStock
[SELECT_Alphabetical_list_of_productsBase_UnitsInStock]
{
	SELECT * FROM [Alphabetical list of products] WHERE [UnitsInStock]=?
}
smallint
# SELECT for Alphabetical_list_of_productsBase.UnitsOnOrder
[SELECT_Alphabetical_list_of_productsBase_UnitsOnOrder]
{
	SELECT * FROM [Alphabetical list of products] WHERE [UnitsOnOrder]=?
}
smallint
# SELECT for Alphabetical_list_of_productsBase.ReorderLevel
[SELECT_Alphabetical_list_of_productsBase_ReorderLevel]
{
	SELECT * FROM [Alphabetical list of products] WHERE [ReorderLevel]=?
}
smallint
# SELECT for Alphabetical_list_of_productsBase.Discontinued
[SELECT_Alphabetical_list_of_productsBase_Discontinued]
{
	SELECT * FROM [Alphabetical list of products] WHERE [Discontinued]=?
}
bit
# SELECT for Alphabetical_list_of_productsBase.CategoryName
[SELECT_Alphabetical_list_of_productsBase_CategoryName]
{
	SELECT * FROM [Alphabetical list of products] WHERE [CategoryName]=?
}
nvarchar(15)

# ========================================================================
# Category Sales for 1997: Queries.
# SELECT , INSERT and UPDATE Queries for Category Sales for 1997
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Category_Sales_for_1997Base]
{
SELECT * FROM [Category Sales for 1997] 
}



[INSERT_Category_Sales_for_1997Base]
{

INSERT INTO [Category Sales for 1997]
([CategoryName]
,[CategorySales]
) 
	VALUES(?,?)


}
nvarchar(15)
money

[UPDATE_Category_Sales_for_1997Base]
{
UPDATE [Category Sales for 1997] 
SET [CategoryName]=?,[CategorySales]=?
}
nvarchar(15)
money

# SELECT for Category_Sales_for_1997Base.CategoryName
[SELECT_Category_Sales_for_1997Base_CategoryName]
{
	SELECT * FROM [Category Sales for 1997] WHERE [CategoryName]=?
}
nvarchar(15)
# SELECT for Category_Sales_for_1997Base.CategorySales
[SELECT_Category_Sales_for_1997Base_CategorySales]
{
	SELECT * FROM [Category Sales for 1997] WHERE [CategorySales]=?
}
money

# ========================================================================
# Current Product List: Queries.
# SELECT , INSERT and UPDATE Queries for Current Product List
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Current_Product_ListBase]
{
SELECT * FROM [Current Product List] 
}



[INSERT_Current_Product_ListBase]
{
	
-- we will use a transaction in order for identity to be correctly read
begin transaction

INSERT INTO [Current Product List]
([ProductName]
) 
	VALUES(?)

	
SELECT @@IDENTITY
commit transaction

}
nvarchar(40)

[UPDATE_Current_Product_ListBase]
{
UPDATE [Current Product List] 
SET [ProductName]=?
}
nvarchar(40)

# SELECT for Current_Product_ListBase.ProductID
[SELECT_Current_Product_ListBase_ProductID]
{
	SELECT * FROM [Current Product List] WHERE [ProductID]=?
}
int
# SELECT for Current_Product_ListBase.ProductName
[SELECT_Current_Product_ListBase_ProductName]
{
	SELECT * FROM [Current Product List] WHERE [ProductName]=?
}
nvarchar(40)

# ========================================================================
# Customer and Suppliers by City: Queries.
# SELECT , INSERT and UPDATE Queries for Customer and Suppliers by City
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Customer_and_Suppliers_by_CityBase]
{
SELECT * FROM [Customer and Suppliers by City] 
}



[INSERT_Customer_and_Suppliers_by_CityBase]
{

INSERT INTO [Customer and Suppliers by City]
([City]
,[CompanyName]
,[ContactName]
,[Relationship]
) 
	VALUES(?,?,?,?)


}
nvarchar(15)
nvarchar(40)
nvarchar(30)
varchar(9)

[UPDATE_Customer_and_Suppliers_by_CityBase]
{
UPDATE [Customer and Suppliers by City] 
SET [City]=?,[CompanyName]=?,[ContactName]=?,[Relationship]=?
}
nvarchar(15)
nvarchar(40)
nvarchar(30)
varchar(9)

# SELECT for Customer_and_Suppliers_by_CityBase.City
[SELECT_Customer_and_Suppliers_by_CityBase_City]
{
	SELECT * FROM [Customer and Suppliers by City] WHERE [City]=?
}
nvarchar(15)
# SELECT for Customer_and_Suppliers_by_CityBase.CompanyName
[SELECT_Customer_and_Suppliers_by_CityBase_CompanyName]
{
	SELECT * FROM [Customer and Suppliers by City] WHERE [CompanyName]=?
}
nvarchar(40)
# SELECT for Customer_and_Suppliers_by_CityBase.ContactName
[SELECT_Customer_and_Suppliers_by_CityBase_ContactName]
{
	SELECT * FROM [Customer and Suppliers by City] WHERE [ContactName]=?
}
nvarchar(30)
# SELECT for Customer_and_Suppliers_by_CityBase.Relationship
[SELECT_Customer_and_Suppliers_by_CityBase_Relationship]
{
	SELECT * FROM [Customer and Suppliers by City] WHERE [Relationship]=?
}
varchar(9)

# ========================================================================
# Invoices: Queries.
# SELECT , INSERT and UPDATE Queries for Invoices
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_InvoicesBase]
{
SELECT * FROM [Invoices] 
}



[INSERT_InvoicesBase]
{

INSERT INTO [Invoices]
([ShipName]
,[ShipAddress]
,[ShipCity]
,[ShipRegion]
,[ShipPostalCode]
,[ShipCountry]
,[CustomerID]
,[CustomerName]
,[Address]
,[City]
,[Region]
,[PostalCode]
,[Country]
,[Salesperson]
,[OrderID]
,[OrderDate]
,[RequiredDate]
,[ShippedDate]
,[ShipperName]
,[ProductID]
,[ProductName]
,[UnitPrice]
,[Quantity]
,[Discount]
,[ExtendedPrice]
,[Freight]
) 
	VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)


}
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nchar(5)
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(31)
int
datetime
datetime
datetime
nvarchar(40)
int
nvarchar(40)
money
smallint
real
money
money

[UPDATE_InvoicesBase]
{
UPDATE [Invoices] 
SET [ShipName]=?,[ShipAddress]=?,[ShipCity]=?,[ShipRegion]=?,[ShipPostalCode]=?,[ShipCountry]=?,[CustomerID]=?,[CustomerName]=?,[Address]=?,[City]=?,[Region]=?,[PostalCode]=?,[Country]=?,[Salesperson]=?,[OrderID]=?,[OrderDate]=?,[RequiredDate]=?,[ShippedDate]=?,[ShipperName]=?,[ProductID]=?,[ProductName]=?,[UnitPrice]=?,[Quantity]=?,[Discount]=?,[ExtendedPrice]=?,[Freight]=?
}
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nchar(5)
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(31)
int
datetime
datetime
datetime
nvarchar(40)
int
nvarchar(40)
money
smallint
real
money
money

# SELECT for InvoicesBase.ShipName
[SELECT_InvoicesBase_ShipName]
{
	SELECT * FROM [Invoices] WHERE [ShipName]=?
}
nvarchar(40)
# SELECT for InvoicesBase.ShipAddress
[SELECT_InvoicesBase_ShipAddress]
{
	SELECT * FROM [Invoices] WHERE [ShipAddress]=?
}
nvarchar(60)
# SELECT for InvoicesBase.ShipCity
[SELECT_InvoicesBase_ShipCity]
{
	SELECT * FROM [Invoices] WHERE [ShipCity]=?
}
nvarchar(15)
# SELECT for InvoicesBase.ShipRegion
[SELECT_InvoicesBase_ShipRegion]
{
	SELECT * FROM [Invoices] WHERE [ShipRegion]=?
}
nvarchar(15)
# SELECT for InvoicesBase.ShipPostalCode
[SELECT_InvoicesBase_ShipPostalCode]
{
	SELECT * FROM [Invoices] WHERE [ShipPostalCode]=?
}
nvarchar(10)
# SELECT for InvoicesBase.ShipCountry
[SELECT_InvoicesBase_ShipCountry]
{
	SELECT * FROM [Invoices] WHERE [ShipCountry]=?
}
nvarchar(15)
# SELECT for InvoicesBase.CustomerID
[SELECT_InvoicesBase_CustomerID]
{
	SELECT * FROM [Invoices] WHERE [CustomerID]=?
}
nchar(5)
# SELECT for InvoicesBase.CustomerName
[SELECT_InvoicesBase_CustomerName]
{
	SELECT * FROM [Invoices] WHERE [CustomerName]=?
}
nvarchar(40)
# SELECT for InvoicesBase.Address
[SELECT_InvoicesBase_Address]
{
	SELECT * FROM [Invoices] WHERE [Address]=?
}
nvarchar(60)
# SELECT for InvoicesBase.City
[SELECT_InvoicesBase_City]
{
	SELECT * FROM [Invoices] WHERE [City]=?
}
nvarchar(15)
# SELECT for InvoicesBase.Region
[SELECT_InvoicesBase_Region]
{
	SELECT * FROM [Invoices] WHERE [Region]=?
}
nvarchar(15)
# SELECT for InvoicesBase.PostalCode
[SELECT_InvoicesBase_PostalCode]
{
	SELECT * FROM [Invoices] WHERE [PostalCode]=?
}
nvarchar(10)
# SELECT for InvoicesBase.Country
[SELECT_InvoicesBase_Country]
{
	SELECT * FROM [Invoices] WHERE [Country]=?
}
nvarchar(15)
# SELECT for InvoicesBase.Salesperson
[SELECT_InvoicesBase_Salesperson]
{
	SELECT * FROM [Invoices] WHERE [Salesperson]=?
}
nvarchar(31)
# SELECT for InvoicesBase.OrderID
[SELECT_InvoicesBase_OrderID]
{
	SELECT * FROM [Invoices] WHERE [OrderID]=?
}
int
# SELECT for InvoicesBase.OrderDate
[SELECT_InvoicesBase_OrderDate]
{
	SELECT * FROM [Invoices] WHERE [OrderDate]=?
}
datetime
# SELECT for InvoicesBase.RequiredDate
[SELECT_InvoicesBase_RequiredDate]
{
	SELECT * FROM [Invoices] WHERE [RequiredDate]=?
}
datetime
# SELECT for InvoicesBase.ShippedDate
[SELECT_InvoicesBase_ShippedDate]
{
	SELECT * FROM [Invoices] WHERE [ShippedDate]=?
}
datetime
# SELECT for InvoicesBase.ShipperName
[SELECT_InvoicesBase_ShipperName]
{
	SELECT * FROM [Invoices] WHERE [ShipperName]=?
}
nvarchar(40)
# SELECT for InvoicesBase.ProductID
[SELECT_InvoicesBase_ProductID]
{
	SELECT * FROM [Invoices] WHERE [ProductID]=?
}
int
# SELECT for InvoicesBase.ProductName
[SELECT_InvoicesBase_ProductName]
{
	SELECT * FROM [Invoices] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for InvoicesBase.UnitPrice
[SELECT_InvoicesBase_UnitPrice]
{
	SELECT * FROM [Invoices] WHERE [UnitPrice]=?
}
money
# SELECT for InvoicesBase.Quantity
[SELECT_InvoicesBase_Quantity]
{
	SELECT * FROM [Invoices] WHERE [Quantity]=?
}
smallint
# SELECT for InvoicesBase.Discount
[SELECT_InvoicesBase_Discount]
{
	SELECT * FROM [Invoices] WHERE [Discount]=?
}
real
# SELECT for InvoicesBase.ExtendedPrice
[SELECT_InvoicesBase_ExtendedPrice]
{
	SELECT * FROM [Invoices] WHERE [ExtendedPrice]=?
}
money
# SELECT for InvoicesBase.Freight
[SELECT_InvoicesBase_Freight]
{
	SELECT * FROM [Invoices] WHERE [Freight]=?
}
money

# ========================================================================
# Order Details Extended: Queries.
# SELECT , INSERT and UPDATE Queries for Order Details Extended
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Order_Details_ExtendedBase]
{
SELECT * FROM [Order Details Extended] 
}



[INSERT_Order_Details_ExtendedBase]
{

INSERT INTO [Order Details Extended]
([OrderID]
,[ProductID]
,[ProductName]
,[UnitPrice]
,[Quantity]
,[Discount]
,[ExtendedPrice]
) 
	VALUES(?,?,?,?,?,?,?)


}
int
int
nvarchar(40)
money
smallint
real
money

[UPDATE_Order_Details_ExtendedBase]
{
UPDATE [Order Details Extended] 
SET [OrderID]=?,[ProductID]=?,[ProductName]=?,[UnitPrice]=?,[Quantity]=?,[Discount]=?,[ExtendedPrice]=?
}
int
int
nvarchar(40)
money
smallint
real
money

# SELECT for Order_Details_ExtendedBase.OrderID
[SELECT_Order_Details_ExtendedBase_OrderID]
{
	SELECT * FROM [Order Details Extended] WHERE [OrderID]=?
}
int
# SELECT for Order_Details_ExtendedBase.ProductID
[SELECT_Order_Details_ExtendedBase_ProductID]
{
	SELECT * FROM [Order Details Extended] WHERE [ProductID]=?
}
int
# SELECT for Order_Details_ExtendedBase.ProductName
[SELECT_Order_Details_ExtendedBase_ProductName]
{
	SELECT * FROM [Order Details Extended] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for Order_Details_ExtendedBase.UnitPrice
[SELECT_Order_Details_ExtendedBase_UnitPrice]
{
	SELECT * FROM [Order Details Extended] WHERE [UnitPrice]=?
}
money
# SELECT for Order_Details_ExtendedBase.Quantity
[SELECT_Order_Details_ExtendedBase_Quantity]
{
	SELECT * FROM [Order Details Extended] WHERE [Quantity]=?
}
smallint
# SELECT for Order_Details_ExtendedBase.Discount
[SELECT_Order_Details_ExtendedBase_Discount]
{
	SELECT * FROM [Order Details Extended] WHERE [Discount]=?
}
real
# SELECT for Order_Details_ExtendedBase.ExtendedPrice
[SELECT_Order_Details_ExtendedBase_ExtendedPrice]
{
	SELECT * FROM [Order Details Extended] WHERE [ExtendedPrice]=?
}
money

# ========================================================================
# Order Subtotals: Queries.
# SELECT , INSERT and UPDATE Queries for Order Subtotals
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Order_SubtotalsBase]
{
SELECT * FROM [Order Subtotals] 
}



[INSERT_Order_SubtotalsBase]
{

INSERT INTO [Order Subtotals]
([OrderID]
,[Subtotal]
) 
	VALUES(?,?)


}
int
money

[UPDATE_Order_SubtotalsBase]
{
UPDATE [Order Subtotals] 
SET [OrderID]=?,[Subtotal]=?
}
int
money

# SELECT for Order_SubtotalsBase.OrderID
[SELECT_Order_SubtotalsBase_OrderID]
{
	SELECT * FROM [Order Subtotals] WHERE [OrderID]=?
}
int
# SELECT for Order_SubtotalsBase.Subtotal
[SELECT_Order_SubtotalsBase_Subtotal]
{
	SELECT * FROM [Order Subtotals] WHERE [Subtotal]=?
}
money

# ========================================================================
# Orders Qry: Queries.
# SELECT , INSERT and UPDATE Queries for Orders Qry
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Orders_QryBase]
{
SELECT * FROM [Orders Qry] 
}



[INSERT_Orders_QryBase]
{

INSERT INTO [Orders Qry]
([OrderID]
,[CustomerID]
,[EmployeeID]
,[OrderDate]
,[RequiredDate]
,[ShippedDate]
,[ShipVia]
,[Freight]
,[ShipName]
,[ShipAddress]
,[ShipCity]
,[ShipRegion]
,[ShipPostalCode]
,[ShipCountry]
,[CompanyName]
,[Address]
,[City]
,[Region]
,[PostalCode]
,[Country]
) 
	VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)


}
int
nchar(5)
int
datetime
datetime
datetime
int
money
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)

[UPDATE_Orders_QryBase]
{
UPDATE [Orders Qry] 
SET [OrderID]=?,[CustomerID]=?,[EmployeeID]=?,[OrderDate]=?,[RequiredDate]=?,[ShippedDate]=?,[ShipVia]=?,[Freight]=?,[ShipName]=?,[ShipAddress]=?,[ShipCity]=?,[ShipRegion]=?,[ShipPostalCode]=?,[ShipCountry]=?,[CompanyName]=?,[Address]=?,[City]=?,[Region]=?,[PostalCode]=?,[Country]=?
}
int
nchar(5)
int
datetime
datetime
datetime
int
money
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)
nvarchar(40)
nvarchar(60)
nvarchar(15)
nvarchar(15)
nvarchar(10)
nvarchar(15)

# SELECT for Orders_QryBase.OrderID
[SELECT_Orders_QryBase_OrderID]
{
	SELECT * FROM [Orders Qry] WHERE [OrderID]=?
}
int
# SELECT for Orders_QryBase.CustomerID
[SELECT_Orders_QryBase_CustomerID]
{
	SELECT * FROM [Orders Qry] WHERE [CustomerID]=?
}
nchar(5)
# SELECT for Orders_QryBase.EmployeeID
[SELECT_Orders_QryBase_EmployeeID]
{
	SELECT * FROM [Orders Qry] WHERE [EmployeeID]=?
}
int
# SELECT for Orders_QryBase.OrderDate
[SELECT_Orders_QryBase_OrderDate]
{
	SELECT * FROM [Orders Qry] WHERE [OrderDate]=?
}
datetime
# SELECT for Orders_QryBase.RequiredDate
[SELECT_Orders_QryBase_RequiredDate]
{
	SELECT * FROM [Orders Qry] WHERE [RequiredDate]=?
}
datetime
# SELECT for Orders_QryBase.ShippedDate
[SELECT_Orders_QryBase_ShippedDate]
{
	SELECT * FROM [Orders Qry] WHERE [ShippedDate]=?
}
datetime
# SELECT for Orders_QryBase.ShipVia
[SELECT_Orders_QryBase_ShipVia]
{
	SELECT * FROM [Orders Qry] WHERE [ShipVia]=?
}
int
# SELECT for Orders_QryBase.Freight
[SELECT_Orders_QryBase_Freight]
{
	SELECT * FROM [Orders Qry] WHERE [Freight]=?
}
money
# SELECT for Orders_QryBase.ShipName
[SELECT_Orders_QryBase_ShipName]
{
	SELECT * FROM [Orders Qry] WHERE [ShipName]=?
}
nvarchar(40)
# SELECT for Orders_QryBase.ShipAddress
[SELECT_Orders_QryBase_ShipAddress]
{
	SELECT * FROM [Orders Qry] WHERE [ShipAddress]=?
}
nvarchar(60)
# SELECT for Orders_QryBase.ShipCity
[SELECT_Orders_QryBase_ShipCity]
{
	SELECT * FROM [Orders Qry] WHERE [ShipCity]=?
}
nvarchar(15)
# SELECT for Orders_QryBase.ShipRegion
[SELECT_Orders_QryBase_ShipRegion]
{
	SELECT * FROM [Orders Qry] WHERE [ShipRegion]=?
}
nvarchar(15)
# SELECT for Orders_QryBase.ShipPostalCode
[SELECT_Orders_QryBase_ShipPostalCode]
{
	SELECT * FROM [Orders Qry] WHERE [ShipPostalCode]=?
}
nvarchar(10)
# SELECT for Orders_QryBase.ShipCountry
[SELECT_Orders_QryBase_ShipCountry]
{
	SELECT * FROM [Orders Qry] WHERE [ShipCountry]=?
}
nvarchar(15)
# SELECT for Orders_QryBase.CompanyName
[SELECT_Orders_QryBase_CompanyName]
{
	SELECT * FROM [Orders Qry] WHERE [CompanyName]=?
}
nvarchar(40)
# SELECT for Orders_QryBase.Address
[SELECT_Orders_QryBase_Address]
{
	SELECT * FROM [Orders Qry] WHERE [Address]=?
}
nvarchar(60)
# SELECT for Orders_QryBase.City
[SELECT_Orders_QryBase_City]
{
	SELECT * FROM [Orders Qry] WHERE [City]=?
}
nvarchar(15)
# SELECT for Orders_QryBase.Region
[SELECT_Orders_QryBase_Region]
{
	SELECT * FROM [Orders Qry] WHERE [Region]=?
}
nvarchar(15)
# SELECT for Orders_QryBase.PostalCode
[SELECT_Orders_QryBase_PostalCode]
{
	SELECT * FROM [Orders Qry] WHERE [PostalCode]=?
}
nvarchar(10)
# SELECT for Orders_QryBase.Country
[SELECT_Orders_QryBase_Country]
{
	SELECT * FROM [Orders Qry] WHERE [Country]=?
}
nvarchar(15)

# ========================================================================
# Product Sales for 1997: Queries.
# SELECT , INSERT and UPDATE Queries for Product Sales for 1997
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Product_Sales_for_1997Base]
{
SELECT * FROM [Product Sales for 1997] 
}



[INSERT_Product_Sales_for_1997Base]
{

INSERT INTO [Product Sales for 1997]
([CategoryName]
,[ProductName]
,[ProductSales]
) 
	VALUES(?,?,?)


}
nvarchar(15)
nvarchar(40)
money

[UPDATE_Product_Sales_for_1997Base]
{
UPDATE [Product Sales for 1997] 
SET [CategoryName]=?,[ProductName]=?,[ProductSales]=?
}
nvarchar(15)
nvarchar(40)
money

# SELECT for Product_Sales_for_1997Base.CategoryName
[SELECT_Product_Sales_for_1997Base_CategoryName]
{
	SELECT * FROM [Product Sales for 1997] WHERE [CategoryName]=?
}
nvarchar(15)
# SELECT for Product_Sales_for_1997Base.ProductName
[SELECT_Product_Sales_for_1997Base_ProductName]
{
	SELECT * FROM [Product Sales for 1997] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for Product_Sales_for_1997Base.ProductSales
[SELECT_Product_Sales_for_1997Base_ProductSales]
{
	SELECT * FROM [Product Sales for 1997] WHERE [ProductSales]=?
}
money

# ========================================================================
# Products Above Average Price: Queries.
# SELECT , INSERT and UPDATE Queries for Products Above Average Price
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Products_Above_Average_PriceBase]
{
SELECT * FROM [Products Above Average Price] 
}



[INSERT_Products_Above_Average_PriceBase]
{

INSERT INTO [Products Above Average Price]
([ProductName]
,[UnitPrice]
) 
	VALUES(?,?)


}
nvarchar(40)
money

[UPDATE_Products_Above_Average_PriceBase]
{
UPDATE [Products Above Average Price] 
SET [ProductName]=?,[UnitPrice]=?
}
nvarchar(40)
money

# SELECT for Products_Above_Average_PriceBase.ProductName
[SELECT_Products_Above_Average_PriceBase_ProductName]
{
	SELECT * FROM [Products Above Average Price] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for Products_Above_Average_PriceBase.UnitPrice
[SELECT_Products_Above_Average_PriceBase_UnitPrice]
{
	SELECT * FROM [Products Above Average Price] WHERE [UnitPrice]=?
}
money

# ========================================================================
# Products by Category: Queries.
# SELECT , INSERT and UPDATE Queries for Products by Category
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Products_by_CategoryBase]
{
SELECT * FROM [Products by Category] 
}



[INSERT_Products_by_CategoryBase]
{

INSERT INTO [Products by Category]
([CategoryName]
,[ProductName]
,[QuantityPerUnit]
,[UnitsInStock]
,[Discontinued]
) 
	VALUES(?,?,?,?,?)


}
nvarchar(15)
nvarchar(40)
nvarchar(20)
smallint
bit

[UPDATE_Products_by_CategoryBase]
{
UPDATE [Products by Category] 
SET [CategoryName]=?,[ProductName]=?,[QuantityPerUnit]=?,[UnitsInStock]=?,[Discontinued]=?
}
nvarchar(15)
nvarchar(40)
nvarchar(20)
smallint
bit

# SELECT for Products_by_CategoryBase.CategoryName
[SELECT_Products_by_CategoryBase_CategoryName]
{
	SELECT * FROM [Products by Category] WHERE [CategoryName]=?
}
nvarchar(15)
# SELECT for Products_by_CategoryBase.ProductName
[SELECT_Products_by_CategoryBase_ProductName]
{
	SELECT * FROM [Products by Category] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for Products_by_CategoryBase.QuantityPerUnit
[SELECT_Products_by_CategoryBase_QuantityPerUnit]
{
	SELECT * FROM [Products by Category] WHERE [QuantityPerUnit]=?
}
nvarchar(20)
# SELECT for Products_by_CategoryBase.UnitsInStock
[SELECT_Products_by_CategoryBase_UnitsInStock]
{
	SELECT * FROM [Products by Category] WHERE [UnitsInStock]=?
}
smallint
# SELECT for Products_by_CategoryBase.Discontinued
[SELECT_Products_by_CategoryBase_Discontinued]
{
	SELECT * FROM [Products by Category] WHERE [Discontinued]=?
}
bit

# ========================================================================
# Quarterly Orders: Queries.
# SELECT , INSERT and UPDATE Queries for Quarterly Orders
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Quarterly_OrdersBase]
{
SELECT * FROM [Quarterly Orders] 
}



[INSERT_Quarterly_OrdersBase]
{

INSERT INTO [Quarterly Orders]
([CustomerID]
,[CompanyName]
,[City]
,[Country]
) 
	VALUES(?,?,?,?)


}
nchar(5)
nvarchar(40)
nvarchar(15)
nvarchar(15)

[UPDATE_Quarterly_OrdersBase]
{
UPDATE [Quarterly Orders] 
SET [CustomerID]=?,[CompanyName]=?,[City]=?,[Country]=?
}
nchar(5)
nvarchar(40)
nvarchar(15)
nvarchar(15)

# SELECT for Quarterly_OrdersBase.CustomerID
[SELECT_Quarterly_OrdersBase_CustomerID]
{
	SELECT * FROM [Quarterly Orders] WHERE [CustomerID]=?
}
nchar(5)
# SELECT for Quarterly_OrdersBase.CompanyName
[SELECT_Quarterly_OrdersBase_CompanyName]
{
	SELECT * FROM [Quarterly Orders] WHERE [CompanyName]=?
}
nvarchar(40)
# SELECT for Quarterly_OrdersBase.City
[SELECT_Quarterly_OrdersBase_City]
{
	SELECT * FROM [Quarterly Orders] WHERE [City]=?
}
nvarchar(15)
# SELECT for Quarterly_OrdersBase.Country
[SELECT_Quarterly_OrdersBase_Country]
{
	SELECT * FROM [Quarterly Orders] WHERE [Country]=?
}
nvarchar(15)

# ========================================================================
# Sales Totals by Amount: Queries.
# SELECT , INSERT and UPDATE Queries for Sales Totals by Amount
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Sales_Totals_by_AmountBase]
{
SELECT * FROM [Sales Totals by Amount] 
}



[INSERT_Sales_Totals_by_AmountBase]
{

INSERT INTO [Sales Totals by Amount]
([SaleAmount]
,[OrderID]
,[CompanyName]
,[ShippedDate]
) 
	VALUES(?,?,?,?)


}
money
int
nvarchar(40)
datetime

[UPDATE_Sales_Totals_by_AmountBase]
{
UPDATE [Sales Totals by Amount] 
SET [SaleAmount]=?,[OrderID]=?,[CompanyName]=?,[ShippedDate]=?
}
money
int
nvarchar(40)
datetime

# SELECT for Sales_Totals_by_AmountBase.SaleAmount
[SELECT_Sales_Totals_by_AmountBase_SaleAmount]
{
	SELECT * FROM [Sales Totals by Amount] WHERE [SaleAmount]=?
}
money
# SELECT for Sales_Totals_by_AmountBase.OrderID
[SELECT_Sales_Totals_by_AmountBase_OrderID]
{
	SELECT * FROM [Sales Totals by Amount] WHERE [OrderID]=?
}
int
# SELECT for Sales_Totals_by_AmountBase.CompanyName
[SELECT_Sales_Totals_by_AmountBase_CompanyName]
{
	SELECT * FROM [Sales Totals by Amount] WHERE [CompanyName]=?
}
nvarchar(40)
# SELECT for Sales_Totals_by_AmountBase.ShippedDate
[SELECT_Sales_Totals_by_AmountBase_ShippedDate]
{
	SELECT * FROM [Sales Totals by Amount] WHERE [ShippedDate]=?
}
datetime

# ========================================================================
# Sales by Category: Queries.
# SELECT , INSERT and UPDATE Queries for Sales by Category
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Sales_by_CategoryBase]
{
SELECT * FROM [Sales by Category] 
}



[INSERT_Sales_by_CategoryBase]
{

INSERT INTO [Sales by Category]
([CategoryID]
,[CategoryName]
,[ProductName]
,[ProductSales]
) 
	VALUES(?,?,?,?)


}
int
nvarchar(15)
nvarchar(40)
money

[UPDATE_Sales_by_CategoryBase]
{
UPDATE [Sales by Category] 
SET [CategoryID]=?,[CategoryName]=?,[ProductName]=?,[ProductSales]=?
}
int
nvarchar(15)
nvarchar(40)
money

# SELECT for Sales_by_CategoryBase.CategoryID
[SELECT_Sales_by_CategoryBase_CategoryID]
{
	SELECT * FROM [Sales by Category] WHERE [CategoryID]=?
}
int
# SELECT for Sales_by_CategoryBase.CategoryName
[SELECT_Sales_by_CategoryBase_CategoryName]
{
	SELECT * FROM [Sales by Category] WHERE [CategoryName]=?
}
nvarchar(15)
# SELECT for Sales_by_CategoryBase.ProductName
[SELECT_Sales_by_CategoryBase_ProductName]
{
	SELECT * FROM [Sales by Category] WHERE [ProductName]=?
}
nvarchar(40)
# SELECT for Sales_by_CategoryBase.ProductSales
[SELECT_Sales_by_CategoryBase_ProductSales]
{
	SELECT * FROM [Sales by Category] WHERE [ProductSales]=?
}
money

# ========================================================================
# Summary of Sales by Quarter: Queries.
# SELECT , INSERT and UPDATE Queries for Summary of Sales by Quarter
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Summary_of_Sales_by_QuarterBase]
{
SELECT * FROM [Summary of Sales by Quarter] 
}



[INSERT_Summary_of_Sales_by_QuarterBase]
{

INSERT INTO [Summary of Sales by Quarter]
([ShippedDate]
,[OrderID]
,[Subtotal]
) 
	VALUES(?,?,?)


}
datetime
int
money

[UPDATE_Summary_of_Sales_by_QuarterBase]
{
UPDATE [Summary of Sales by Quarter] 
SET [ShippedDate]=?,[OrderID]=?,[Subtotal]=?
}
datetime
int
money

# SELECT for Summary_of_Sales_by_QuarterBase.ShippedDate
[SELECT_Summary_of_Sales_by_QuarterBase_ShippedDate]
{
	SELECT * FROM [Summary of Sales by Quarter] WHERE [ShippedDate]=?
}
datetime
# SELECT for Summary_of_Sales_by_QuarterBase.OrderID
[SELECT_Summary_of_Sales_by_QuarterBase_OrderID]
{
	SELECT * FROM [Summary of Sales by Quarter] WHERE [OrderID]=?
}
int
# SELECT for Summary_of_Sales_by_QuarterBase.Subtotal
[SELECT_Summary_of_Sales_by_QuarterBase_Subtotal]
{
	SELECT * FROM [Summary of Sales by Quarter] WHERE [Subtotal]=?
}
money

# ========================================================================
# Summary of Sales by Year: Queries.
# SELECT , INSERT and UPDATE Queries for Summary of Sales by Year
# GENERATED BY OODBFramWork, don't modify this file.
# ========================================================================


[SELECT_Summary_of_Sales_by_YearBase]
{
SELECT * FROM [Summary of Sales by Year] 
}



[INSERT_Summary_of_Sales_by_YearBase]
{

INSERT INTO [Summary of Sales by Year]
([ShippedDate]
,[OrderID]
,[Subtotal]
) 
	VALUES(?,?,?)


}
datetime
int
money

[UPDATE_Summary_of_Sales_by_YearBase]
{
UPDATE [Summary of Sales by Year] 
SET [ShippedDate]=?,[OrderID]=?,[Subtotal]=?
}
datetime
int
money

# SELECT for Summary_of_Sales_by_YearBase.ShippedDate
[SELECT_Summary_of_Sales_by_YearBase_ShippedDate]
{
	SELECT * FROM [Summary of Sales by Year] WHERE [ShippedDate]=?
}
datetime
# SELECT for Summary_of_Sales_by_YearBase.OrderID
[SELECT_Summary_of_Sales_by_YearBase_OrderID]
{
	SELECT * FROM [Summary of Sales by Year] WHERE [OrderID]=?
}
int
# SELECT for Summary_of_Sales_by_YearBase.Subtotal
[SELECT_Summary_of_Sales_by_YearBase_Subtotal]
{
	SELECT * FROM [Summary of Sales by Year] WHERE [Subtotal]=?
}
money