package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Territories <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class TerritoriesCached extends TerritoriesBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public TerritoriesCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected TerritoriesCached(CS cs, String TerritoryID)
        throws SQLException {
        super(cs, TerritoryID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public TerritoriesCached(CS cs, ResultSet rs) throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Sets this row of Territories to reference the ref row of Region
     */
    public void setRegionIDRef(RegionCached ref) {
        setRegionID(ref.getRegionID());
    }

    /**
     * Gets this row of Territories from referenced row of Region
     */
    public RegionCached getRegionIDRef()
        throws SQLException, CloneNotSupportedException {
        return getRegionIDRef(cs);
    }

    /**
     * Gets this row of Territories from referenced row of Region
     */
    public RegionCached getRegionIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        return RegionCached.instance(cs, getRegionID());
    }

    /**
     * Gets a LinkedList of TerritoriesCached's by querying table field TerritoryID
     * for equality with the same TerritoryID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTerritoryID(int maxResults)
        throws SQLException {
        return getLinkedListWithTerritoryIDValueOf(cs, getTerritoryID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of TerritoriesCached's by querying table field TerritoryID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTerritoryIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTerritoryIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new TerritoriesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of TerritoriesCached's by querying table field TerritoryID
     * for equality with the same TerritoryID as this instance.
     */
    public Iterator getIteratorWithSameValueOfTerritoryID(int maxResults)
        throws SQLException {
        return getIteratorWithTerritoryIDValueOf(cs, getTerritoryID(),
            maxResults);
    }

    /**
     * Gets an Iterator of TerritoriesCached's by querying table field TerritoryID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTerritoryIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithTerritoryIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of TerritoriesCached's by querying table field TerritoryDescription
     * for equality with the same TerritoryDescription as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTerritoryDescription(
        int maxResults) throws SQLException {
        return getLinkedListWithTerritoryDescriptionValueOf(cs,
            getTerritoryDescription(), maxResults);
    }

    /**
     * Gets a LinkedList of TerritoriesCached's by querying table field TerritoryDescription
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTerritoryDescriptionValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTerritoryDescriptionValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new TerritoriesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of TerritoriesCached's by querying table field TerritoryDescription
     * for equality with the same TerritoryDescription as this instance.
     */
    public Iterator getIteratorWithSameValueOfTerritoryDescription(
        int maxResults) throws SQLException {
        return getIteratorWithTerritoryDescriptionValueOf(cs,
            getTerritoryDescription(), maxResults);
    }

    /**
     * Gets an Iterator of TerritoriesCached's by querying table field TerritoryDescription
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTerritoryDescriptionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithTerritoryDescriptionValueOf(cs, value,
            maxResults).iterator();
    }

    /**
     * Gets a LinkedList of TerritoriesCached's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets a LinkedList of TerritoriesCached's by querying table field RegionID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new TerritoriesCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of TerritoriesCached's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getIteratorWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets an Iterator of TerritoriesCached's by querying table field RegionID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, value, maxResults).iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return TerritoriesCached.delete(cs, TerritoryID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, String TerritoryID)
        throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                TerritoriesCached.class, TerritoryID
            });

        return TerritoriesBase.delete(cs, TerritoryID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            Cache.getCache().removeSynchronized(new Object[] {
                    TerritoriesCached.class,
                    
                old_TerritoryID
                });

            int res = super.updateAll();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { TerritoriesCached.class, TerritoryID };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached TerritoriesCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] { TerritoriesCached.class });
    }

    /**
     * Flush a cached TerritoriesCached item.
     */
    public static void flushCache(String TerritoryID) {
        Cache.getCache().removeSynchronized(new Object[] {
                TerritoriesCached.class, TerritoryID
            });
    }

    private static TerritoriesCached cacheLookup(String TerritoryID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (TerritoriesCached.class) {
            TerritoriesCached t = (TerritoriesCached) c.get(new Object[] {
                        TerritoriesCached.class, TerritoryID
                    });

            if (t != null) {
                return (TerritoriesCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static TerritoriesCached instance(CS cs, String TerritoryID)
        throws SQLException, CloneNotSupportedException {
        TerritoriesCached t = cacheLookup(TerritoryID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new TerritoriesCached(cs, TerritoryID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth)
        throws SQLException, CloneNotSupportedException {
        Element root = new Element("TerritoriesCached");

        root.addContent(new Element("TerritoryID").setText(getTerritoryID()));

        root.addContent(new Element("TerritoryDescription").setText(
                getTerritoryDescription()));

        root.setAttribute("RegionID", String.valueOf(getRegionID()));

        if (depth > 0) {
            RegionCached temp1 = getRegionIDRef(cs);

            if (temp1 != null) {
                root.addContent(temp1.toXML(depth - 1));
            }
        }

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() throws SQLException, CloneNotSupportedException {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
