package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Territories<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class TerritoriesBase implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected String TerritoryID;
    protected String old_TerritoryID; // Old value of the key is kept too
    protected String TerritoryDescription;
    protected int RegionID;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected TerritoriesBase() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public TerritoriesBase(CS cs) {
        this.cs = cs;
    }

    /**
     * Get from primary key(s), queries the database
     */
    public TerritoriesBase(CS cs, String TerritoryID) throws SQLException {
        this.cs = cs;

        CallableStatement cc = null;
        ResultSet rs = null;

        try {
            cc = cs.allocCS("SELECT_TerritoriesBase");

            cc.setString(1, TerritoryID);

            rs = cc.executeQuery();
            rs.next();
            setFromRs(rs);
        } finally {
            if (rs != null) {
                rs.close();
            }

            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public TerritoriesBase(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        TerritoryID = old_TerritoryID = rs.getString("TerritoryID");
        TerritoryDescription = rs.getString("TerritoryDescription");
        RegionID = rs.getInt("RegionID");
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for TerritoryID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getTerritoryID() {
        return TerritoryID;
    }

    /**
     * Setter for TerritoryID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setTerritoryID(String value) {
        this.TerritoryID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of TerritoriesBase's by querying table field TerritoryID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfTerritoryID(
        int maxResults) throws SQLException {
        return getResultSetWithTerritoryIDValueOf(cs, getTerritoryID(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of TerritoriesBase's by querying table field TerritoryID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithTerritoryIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_TerritoriesBase_TerritoryID");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of TerritoriesBase's by querying table field TerritoryID
     * for equality with the same TerritoryID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTerritoryID(int maxResults)
        throws SQLException {
        return getLinkedListWithTerritoryIDValueOf(cs, getTerritoryID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of TerritoriesBase's by querying table field TerritoryID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTerritoryIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTerritoryIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new TerritoriesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of TerritoriesBase's by querying table field TerritoryID
     * for equality with the same TerritoryID as this instance.
     */
    public Iterator getIteratorWithSameValueOfTerritoryID(int maxResults)
        throws SQLException {
        return getIteratorWithTerritoryIDValueOf(cs, getTerritoryID(),
            maxResults);
    }

    /**
     * Gets an Iterator of TerritoriesBase's by querying table field TerritoryID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTerritoryIDValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithTerritoryIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for TerritoryDescription.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getTerritoryDescription() {
        return TerritoryDescription;
    }

    /**
     * Setter for TerritoryDescription.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setTerritoryDescription(String value) {
        this.TerritoryDescription = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of TerritoriesBase's by querying table field TerritoryDescription
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfTerritoryDescription(
        int maxResults) throws SQLException {
        return getResultSetWithTerritoryDescriptionValueOf(cs,
            getTerritoryDescription(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of TerritoriesBase's by querying table field TerritoryDescription
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithTerritoryDescriptionValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_TerritoriesBase_TerritoryDescription");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of TerritoriesBase's by querying table field TerritoryDescription
     * for equality with the same TerritoryDescription as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfTerritoryDescription(
        int maxResults) throws SQLException {
        return getLinkedListWithTerritoryDescriptionValueOf(cs,
            getTerritoryDescription(), maxResults);
    }

    /**
     * Gets a LinkedList of TerritoriesBase's by querying table field TerritoryDescription
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithTerritoryDescriptionValueOf(
        CS cs, String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithTerritoryDescriptionValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new TerritoriesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of TerritoriesBase's by querying table field TerritoryDescription
     * for equality with the same TerritoryDescription as this instance.
     */
    public Iterator getIteratorWithSameValueOfTerritoryDescription(
        int maxResults) throws SQLException {
        return getIteratorWithTerritoryDescriptionValueOf(cs,
            getTerritoryDescription(), maxResults);
    }

    /**
     * Gets an Iterator of TerritoriesBase's by querying table field TerritoryDescription
     * for equality with the "value".
     */
    public static Iterator getIteratorWithTerritoryDescriptionValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithTerritoryDescriptionValueOf(cs, value,
            maxResults).iterator();
    }

    /**
     * Getter for RegionID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public int getRegionID() {
        return RegionID;
    }

    /**
     * Setter for RegionID.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setRegionID(int value) {
        this.RegionID = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of TerritoriesBase's by querying table field RegionID
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getResultSetWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of TerritoriesBase's by querying table field RegionID
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithRegionIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS("SELECT_TerritoriesBase_RegionID");
        cc.setMaxRows(maxResults);

        try {
            cc.setInt(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of TerritoriesBase's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets a LinkedList of TerritoriesBase's by querying table field RegionID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithRegionIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new TerritoriesBase(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of TerritoriesBase's by querying table field RegionID
     * for equality with the same RegionID as this instance.
     */
    public Iterator getIteratorWithSameValueOfRegionID(int maxResults)
        throws SQLException {
        return getIteratorWithRegionIDValueOf(cs, getRegionID(), maxResults);
    }

    /**
     * Gets an Iterator of TerritoriesBase's by querying table field RegionID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithRegionIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithRegionIDValueOf(cs, value, maxResults).iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return TerritoriesBase.delete(cs, TerritoryID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, String TerritoryID)
        throws SQLException {
        CallableStatement cc = null;
        int res = 0;

        try {
            cc = cs.allocCS("DELETE_TerritoriesBase");

            cc.setString(1, TerritoryID);

            res = cc.executeUpdate();
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
        return res;
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATE_TerritoriesBase");

                cc.setString(1, getTerritoryDescription());

                cc.setInt(2, getRegionID());

                cc.setString(3, getTerritoryID());

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            return res;
        }

        return -1;
    }

    private void updateOldKeys() {
        // update the old_x old key values
        old_TerritoryID = TerritoryID;
    }

    /**
     * Updates the object to the database, even the primary keys are updated (but not the autoincrements or autoincr PK's)
     */
    public int updateAll() throws SQLException {
        if (isDirty) {
            CallableStatement cc = null;
            int res = 0;

            try {
                cc = cs.allocCS("UPDATEALL_TerritoriesBase");

                cc.setString(1, getTerritoryID());

                cc.setString(2, getTerritoryDescription());

                cc.setInt(3, getRegionID());

                cc.setString(4, old_TerritoryID);

                res = cc.executeUpdate();
                isDirty = false;
            } finally {
                cs.freeCS(cc);
            }

            // template/debug was set to >0 during conversion
            updateOldKeys();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_TerritoriesBase");

            cc.setString(1, getTerritoryID());

            cc.setString(2, getTerritoryDescription());

            cc.setInt(3, getRegionID());

            cc.executeUpdate();

            updateOldKeys();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "TerritoryID:" + getTerritoryID());

        System.out.println(prefix + "TerritoryDescription:" +
            getTerritoryDescription());

        System.out.println(prefix + "RegionID:" + getRegionID());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(TerritoryID);
        sb.append(",");
        sb.append(TerritoryDescription);
        sb.append(",");
        sb.append(RegionID);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
