package test.db;


// A package "globals" should exist, with a class "Cache" which holds the
// pointer to the UniversalCache.
import globals.Cache;

import org.aris.cache.universalcache.UniversalCache;

import org.aris.hldb.CS;

import org.jdom.Element;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Products <P>
 *
 * hldbCached template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework,
 * or by extend-ing the class.<P>
 *
 * Caching notes: cascade on relationships is not supported by this cache. Corrupted data will exist
 * in the case after a delete or update which cascaded to other tables.<P>
 *
 * Use this class to perform any update or delete commands. If you have to do updates or deletes manually
 * in this table, you'll have to manually flush the cache too.<P>
 *
 * Use static member instance() instead of a constructor to get an object if you know the
 * primary key values.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
public class ProductsCached extends ProductsBase implements Cloneable {
    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * Use this constructor to create a new row by calling the setters and then insert().
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     */
    public ProductsCached(CS cs) {
        super(cs);
    }

    /**
     * Get from primary key(s), also stores the row in the cache. This doesn't lookup
     * the cache, and is used internally. Use instance() to get the object.
     *
     * @param cs The hldb CS
     */
    protected ProductsCached(CS cs, int ProductID) throws SQLException {
        super(cs, ProductID);
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *). The row in rs is
     * fetched, and the object is created from this row. A clone of the object is cached too.
     * All modifications done to the object are not reflected to the cache, until an
     * update() or insert() is called.<P>
     *
     * Use static member instance() instead of a constructor to get an object if you know the
     * primary key values.<P>
     *
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public ProductsCached(CS cs, ResultSet rs) throws java.sql.SQLException {
        super(cs, rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this. Fetches the next row and
     * creates the object from the resultset. Also caches the object.<P>
     *
     * Use static member instance() instead of this, to get an object if you know the
     * primary key values.<P>
     *
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        super.setFromRs(rs);
        storeInCache();
    }

    /**
     * Sets this row of Products to reference the ref row of Categories
     */
    public void setCategoryIDRef(CategoriesCached ref) {
        setCategoryID(new Integer(ref.getCategoryID()));
    }

    /**
     * Gets this row of Products from referenced row of Categories
     */
    public CategoriesCached getCategoryIDRef()
        throws SQLException, CloneNotSupportedException {
        return getCategoryIDRef(cs);
    }

    /**
     * Gets this row of Products from referenced row of Categories
     */
    public CategoriesCached getCategoryIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        if (getCategoryID() == null) {
            return null;
        }

        return CategoriesCached.instance(cs, getCategoryID().intValue());
    }

    /**
     * Sets this row of Products to reference the ref row of Suppliers
     */
    public void setSupplierIDRef(SuppliersCached ref) {
        setSupplierID(new Integer(ref.getSupplierID()));
    }

    /**
     * Gets this row of Products from referenced row of Suppliers
     */
    public SuppliersCached getSupplierIDRef()
        throws SQLException, CloneNotSupportedException {
        return getSupplierIDRef(cs);
    }

    /**
     * Gets this row of Products from referenced row of Suppliers
     */
    public SuppliersCached getSupplierIDRef(CS cs)
        throws SQLException, CloneNotSupportedException {
        if (getSupplierID() == null) {
            return null;
        }

        return SuppliersCached.instance(cs, getSupplierID().intValue());
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field ProductID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductIDValueOf(CS cs,
        int value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field ProductID
     * for equality with the same ProductID as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductID(int maxResults)
        throws SQLException {
        return getIteratorWithProductIDValueOf(cs, getProductID(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field ProductID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductIDValueOf(CS cs, int value,
        int maxResults) throws SQLException {
        return getLinkedListWithProductIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field ProductName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getIteratorWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field ProductName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, getSupplierID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field SupplierID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithSupplierIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithSupplierIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field SupplierID
     * for equality with the same SupplierID as this instance.
     */
    public Iterator getIteratorWithSameValueOfSupplierID(int maxResults)
        throws SQLException {
        return getIteratorWithSupplierIDValueOf(cs, getSupplierID(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field SupplierID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithSupplierIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithSupplierIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, getCategoryID(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field CategoryID
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryIDValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field CategoryID
     * for equality with the same CategoryID as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryID(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryIDValueOf(cs, getCategoryID(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field CategoryID
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryIDValueOf(CS cs,
        Integer value, int maxResults) throws SQLException {
        return getLinkedListWithCategoryIDValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field QuantityPerUnit
     * for equality with the same QuantityPerUnit as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfQuantityPerUnit(
        int maxResults) throws SQLException {
        return getLinkedListWithQuantityPerUnitValueOf(cs,
            getQuantityPerUnit(), maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field QuantityPerUnit
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithQuantityPerUnitValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithQuantityPerUnitValueOf(cs,
                value, maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field QuantityPerUnit
     * for equality with the same QuantityPerUnit as this instance.
     */
    public Iterator getIteratorWithSameValueOfQuantityPerUnit(int maxResults)
        throws SQLException {
        return getIteratorWithQuantityPerUnitValueOf(cs, getQuantityPerUnit(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field QuantityPerUnit
     * for equality with the "value".
     */
    public static Iterator getIteratorWithQuantityPerUnitValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithQuantityPerUnitValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitPriceValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitPriceValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field UnitPrice
     * for equality with the same UnitPrice as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitPrice(int maxResults)
        throws SQLException {
        return getIteratorWithUnitPriceValueOf(cs, getUnitPrice(), maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field UnitPrice
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitPriceValueOf(CS cs, Double value,
        int maxResults) throws SQLException {
        return getLinkedListWithUnitPriceValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field UnitsInStock
     * for equality with the same UnitsInStock as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitsInStock(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field UnitsInStock
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitsInStockValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field UnitsInStock
     * for equality with the same UnitsInStock as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitsInStock(int maxResults)
        throws SQLException {
        return getIteratorWithUnitsInStockValueOf(cs, getUnitsInStock(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field UnitsInStock
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitsInStockValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        return getLinkedListWithUnitsInStockValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field UnitsOnOrder
     * for equality with the same UnitsOnOrder as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfUnitsOnOrder(int maxResults)
        throws SQLException {
        return getLinkedListWithUnitsOnOrderValueOf(cs, getUnitsOnOrder(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field UnitsOnOrder
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithUnitsOnOrderValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithUnitsOnOrderValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field UnitsOnOrder
     * for equality with the same UnitsOnOrder as this instance.
     */
    public Iterator getIteratorWithSameValueOfUnitsOnOrder(int maxResults)
        throws SQLException {
        return getIteratorWithUnitsOnOrderValueOf(cs, getUnitsOnOrder(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field UnitsOnOrder
     * for equality with the "value".
     */
    public static Iterator getIteratorWithUnitsOnOrderValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        return getLinkedListWithUnitsOnOrderValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field ReorderLevel
     * for equality with the same ReorderLevel as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfReorderLevel(int maxResults)
        throws SQLException {
        return getLinkedListWithReorderLevelValueOf(cs, getReorderLevel(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field ReorderLevel
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithReorderLevelValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithReorderLevelValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field ReorderLevel
     * for equality with the same ReorderLevel as this instance.
     */
    public Iterator getIteratorWithSameValueOfReorderLevel(int maxResults)
        throws SQLException {
        return getIteratorWithReorderLevelValueOf(cs, getReorderLevel(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field ReorderLevel
     * for equality with the "value".
     */
    public static Iterator getIteratorWithReorderLevelValueOf(CS cs,
        Short value, int maxResults) throws SQLException {
        return getLinkedListWithReorderLevelValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field Discontinued
     * for equality with the same Discontinued as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfDiscontinued(int maxResults)
        throws SQLException {
        return getLinkedListWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets a LinkedList of ProductsCached's by querying table field Discontinued
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithDiscontinuedValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new ProductsCached(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field Discontinued
     * for equality with the same Discontinued as this instance.
     */
    public Iterator getIteratorWithSameValueOfDiscontinued(int maxResults)
        throws SQLException {
        return getIteratorWithDiscontinuedValueOf(cs, getDiscontinued(),
            maxResults);
    }

    /**
     * Gets an Iterator of ProductsCached's by querying table field Discontinued
     * for equality with the "value".
     */
    public static Iterator getIteratorWithDiscontinuedValueOf(CS cs,
        boolean value, int maxResults) throws SQLException {
        return getLinkedListWithDiscontinuedValueOf(cs, value, maxResults)
                   .iterator();
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Delete the current object from database
     */
    public int delete() throws SQLException {
        return ProductsCached.delete(cs, ProductID);
    }

    /**
     * Delete an row from database
     */
    public static int delete(CS cs, int ProductID) throws SQLException {
        Cache.getCache().removeSynchronized(new Object[] {
                ProductsCached.class,
                
            new Integer(ProductID)
            });

        return ProductsBase.delete(cs, ProductID);
    }

    /**
     * Update the current object to the database (primary keys/autoincrements are not updated)
     */
    public int update() throws SQLException {
        if (isDirty) {
            int res = super.update();
            storeInCache();

            return res;
        }

        return -1;
    }

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        super.insert();
        storeInCache();

        // template/debug was set to >0 during conversion
    }

    private final Object[] keysObj() {
        return new Object[] { ProductsCached.class, new Integer(ProductID) };
    }

    private void storeInCache() {
        try {
            Cache.getCache().putSynchronized(keysObj(), this.clone());
        } catch (CloneNotSupportedException e) {
            // This should not occur.
            e.printStackTrace();
        }
    }

    /**
     * Flush all cached ProductsCached items.
     */
    public static void flushCache() {
        Cache.getCache().flushSynchronized(new Object[] { ProductsCached.class });
    }

    /**
     * Flush a cached ProductsCached item.
     */
    public static void flushCache(int ProductID) {
        Cache.getCache().removeSynchronized(new Object[] {
                ProductsCached.class,
                
            new Integer(ProductID)
            });
    }

    private static ProductsCached cacheLookup(int ProductID)
        throws CloneNotSupportedException {
        // try to find the record in the cache
        UniversalCache c = Cache.getCache();

        synchronized (ProductsCached.class) {
            ProductsCached t = (ProductsCached) c.get(new Object[] {
                        ProductsCached.class,
                        
                    new Integer(ProductID)
                    });

            if (t != null) {
                return (ProductsCached) t.clone();
            }
        }

        return null;
    }

    /**
     * Returns an instance of this class, either by getting it from the memory cache (clone), or by querying the database. This
     * is the function that should be used, when the primary keys are known.<P>
     *
     * Any changes in this object are not reflected in the cache until update(), updateAll() or insert() is called.
     */
    public static ProductsCached instance(CS cs, int ProductID)
        throws SQLException, CloneNotSupportedException {
        ProductsCached t = cacheLookup(ProductID);

        if (t != null) {
            return t;
        }

        // not in cache, search the database
        t = new ProductsCached(cs, ProductID);

        return t;
    }

    /**
     * returns the XML form of this object and depth childs
     */
    public Element toXML(int depth)
        throws SQLException, CloneNotSupportedException {
        Element root = new Element("ProductsCached");

        root.setAttribute("ProductID", String.valueOf(getProductID()));

        root.addContent(new Element("ProductName").setText(getProductName()));

        root.setAttribute("SupplierID", String.valueOf(getSupplierID()));

        root.setAttribute("CategoryID", String.valueOf(getCategoryID()));

        root.addContent(new Element("QuantityPerUnit").setText(
                getQuantityPerUnit()));

        root.setAttribute("UnitPrice", String.valueOf(getUnitPrice()));

        root.setAttribute("UnitsInStock", String.valueOf(getUnitsInStock()));

        root.setAttribute("UnitsOnOrder", String.valueOf(getUnitsOnOrder()));

        root.setAttribute("ReorderLevel", String.valueOf(getReorderLevel()));

        root.setAttribute("Discontinued", String.valueOf(getDiscontinued()));

        if (depth > 0) {
            CategoriesCached temp1 = getCategoryIDRef(cs);

            if (temp1 != null) {
                root.addContent(temp1.toXML(depth - 1));
            }

            SuppliersCached temp2 = getSupplierIDRef(cs);

            if (temp2 != null) {
                root.addContent(temp2.toXML(depth - 1));
            }
        }

        return root;
    }

    /**
     * returns the XML form of this object only
     */
    public Element toXML() throws SQLException, CloneNotSupportedException {
        return toXML(0);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
