package test.db;

import org.aris.hldb.CS;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import java.util.Iterator;
import java.util.LinkedList;


// --- a holder for custom imports ---

/**
 * TABLE: Product Sales for 1997<P>
 *
 * hldbBase template. Please don't modify, inherit instead with the inherit mechanisms of OODBFramework.<P>
 *
 * This class template creates classes which query the database using the hldb package. This package
 * uses stored procedures to perform any database operations. See the examples of OODB in order
 * to create a valid configuration file and generate database classes.<P>
 *
 * This class was generated with the OODBFramework © 2004 Konstantine Kougios.<P>
 */
class Product_Sales_for_1997Base implements Cloneable {
    // dirty bit
    protected boolean isDirty = false;

    // Connection
    protected CS cs;

    // ============================================================================
    // =       Variable declaration, according to table columns.                  =
    // ============================================================================
    protected String CategoryName;
    protected String ProductName;
    protected Double ProductSales;

    // ============================================================================
    // =                  Constructors                                            =
    // ============================================================================

    /**
     * default constructor, protected.
     */
    protected Product_Sales_for_1997Base() {
    }

    /**
     * use this to create a new row by calling the setters and then insert().
     */
    public Product_Sales_for_1997Base(CS cs) {
        this.cs = cs;
    }

    /**
     * Constructor by ResultSet (which must contain all columns = SELECT *)
     * @param cs  A cache of callable statements
     * @param rs  the ResultSet
     */
    public Product_Sales_for_1997Base(CS cs, java.sql.ResultSet rs)
        throws java.sql.SQLException {
        this.cs = cs;
        setFromRs(rs);
    }

    /**
     * This is usefull for reusing of this class. Also, the constructors use this
     */
    public void setFromRs(ResultSet rs) throws SQLException {
        CategoryName = rs.getString("CategoryName");
        ProductName = rs.getString("ProductName");
        ProductSales = new Double(rs.getDouble("ProductSales"));

        if (rs.wasNull()) {
            ProductSales = null;
        }

        ;
    }

    // ============================================================================
    // =                  Setters and getters                                     =
    // ============================================================================

    /**
     * Getter for CategoryName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getCategoryName() {
        return CategoryName;
    }

    /**
     * Setter for CategoryName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setCategoryName(String value) {
        this.CategoryName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Product_Sales_for_1997Base's by querying table field CategoryName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfCategoryName(
        int maxResults) throws SQLException {
        return getResultSetWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Product_Sales_for_1997Base's by querying table field CategoryName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Product_Sales_for_1997Base_CategoryName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Product_Sales_for_1997Base's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Product_Sales_for_1997Base's by querying table field CategoryName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithCategoryNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Product_Sales_for_1997Base(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Product_Sales_for_1997Base's by querying table field CategoryName
     * for equality with the same CategoryName as this instance.
     */
    public Iterator getIteratorWithSameValueOfCategoryName(int maxResults)
        throws SQLException {
        return getIteratorWithCategoryNameValueOf(cs, getCategoryName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Product_Sales_for_1997Base's by querying table field CategoryName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithCategoryNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithCategoryNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public String getProductName() {
        return ProductName;
    }

    /**
     * Setter for ProductName.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setProductName(String value) {
        this.ProductName = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Product_Sales_for_1997Base's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductName(
        int maxResults) throws SQLException {
        return getResultSetWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Product_Sales_for_1997Base's by querying table field ProductName
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Product_Sales_for_1997Base_ProductName");
        cc.setMaxRows(maxResults);

        try {
            cc.setString(1, value);

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Product_Sales_for_1997Base's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Product_Sales_for_1997Base's by querying table field ProductName
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductNameValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Product_Sales_for_1997Base(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Product_Sales_for_1997Base's by querying table field ProductName
     * for equality with the same ProductName as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductName(int maxResults)
        throws SQLException {
        return getIteratorWithProductNameValueOf(cs, getProductName(),
            maxResults);
    }

    /**
     * Gets an Iterator of Product_Sales_for_1997Base's by querying table field ProductName
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductNameValueOf(CS cs,
        String value, int maxResults) throws SQLException {
        return getLinkedListWithProductNameValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Getter for ProductSales.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public Double getProductSales() {
        return ProductSales;
    }

    /**
     * Setter for ProductSales.
     * No remarks for this field in the database (or the database driver doesn't return column remarks).
     */
    public void setProductSales(Double value) {
        this.ProductSales = value;
        isDirty = true;
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Product_Sales_for_1997Base's by querying table field ProductSales
     * for equality with the "value". The CallableStatement must be deallocated by calling the freeCS() method.
     */
    public CallableStatement getResultSetWithSameValueOfProductSales(
        int maxResults) throws SQLException {
        return getResultSetWithProductSalesValueOf(cs, getProductSales(),
            maxResults);
    }

    /**
     * Gets a ResultSet (by CallableStatement.getResultSet()) of Product_Sales_for_1997Base's by querying table field ProductSales
     * for equality with the "value". The CallableStatement must be returned to the CS that this object was created.
     */
    public static CallableStatement getResultSetWithProductSalesValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = cs.allocCS(
                "SELECT_Product_Sales_for_1997Base_ProductSales");
        cc.setMaxRows(maxResults);

        try {
            if (value == null) {
                cc.setNull(1, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(1, value.doubleValue());
            }

            //ResultSet rs=
            cc.executeQuery();
        } catch (SQLException e) {
            cs.freeCS(cc);
            throw e;
        } finally {
            cc.setMaxRows(Integer.MAX_VALUE);
        }

        return cc;
    }

    /**
     * Gets a LinkedList of Product_Sales_for_1997Base's by querying table field ProductSales
     * for equality with the same ProductSales as this instance.
     */
    public LinkedList getLinkedListWithSameValueOfProductSales(int maxResults)
        throws SQLException {
        return getLinkedListWithProductSalesValueOf(cs, getProductSales(),
            maxResults);
    }

    /**
     * Gets a LinkedList of Product_Sales_for_1997Base's by querying table field ProductSales
     * for equality with the "value".
     */
    public static LinkedList getLinkedListWithProductSalesValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        CallableStatement cc = getResultSetWithProductSalesValueOf(cs, value,
                maxResults);
        LinkedList ll = new LinkedList();

        try {
            ResultSet rs = cc.getResultSet();

            while (rs.next()) {
                ll.addLast(new Product_Sales_for_1997Base(cs, rs));
            }
        } finally {
            cs.freeCS(cc);
        }

        return ll;
    }

    /**
     * Gets an Iterator of Product_Sales_for_1997Base's by querying table field ProductSales
     * for equality with the same ProductSales as this instance.
     */
    public Iterator getIteratorWithSameValueOfProductSales(int maxResults)
        throws SQLException {
        return getIteratorWithProductSalesValueOf(cs, getProductSales(),
            maxResults);
    }

    /**
     * Gets an Iterator of Product_Sales_for_1997Base's by querying table field ProductSales
     * for equality with the "value".
     */
    public static Iterator getIteratorWithProductSalesValueOf(CS cs,
        Double value, int maxResults) throws SQLException {
        return getLinkedListWithProductSalesValueOf(cs, value, maxResults)
                   .iterator();
    }

    /**
     * Free a callable statement that was returned by any of the class's members
     */
    public void freeCS(CallableStatement callableStatement) {
        cs.freeCS(callableStatement);
    }

    // ============================================================================
    // =                  Delete and Update methods                               =
    // ============================================================================

    /**
     * Inserts this new object to a new row (all columns are inserted, except the identities)
     * Warning: This also sets any class member which reflects an autoincrement value in the DB, to the new value
     * as set by the insert into () sql.
     * For SQLServer this takes an additional query, since st.getGeneratedKeys() isn't implemented in mssql.jar.
     * Thus, some synchronization maybe necessary for this call to complete atomically.
     */
    public synchronized void insert() throws SQLException {
        CallableStatement cc = null;

        try {
            cc = cs.allocCS("INSERT_Product_Sales_for_1997Base");

            cc.setString(1, getCategoryName());

            cc.setString(2, getProductName());

            if (ProductSales == null) {
                cc.setNull(3, java.sql.Types.NUMERIC);
            } else {
                cc.setDouble(3, getProductSales().doubleValue());
            }

            cc.executeUpdate();

            isDirty = false;
        } finally {
            cs.freeCS(cc);
        }

        // template/debug was set to >0 during conversion
    }

    public void dump(String prefix) {
        System.out.println(prefix + "CategoryName:" + getCategoryName());

        System.out.println(prefix + "ProductName:" + getProductName());

        System.out.println(prefix + "ProductSales:" + getProductSales());
    }

    public void dump() {
        dump("");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append(CategoryName);
        sb.append(",");
        sb.append(ProductName);
        sb.append(",");
        sb.append(ProductSales);

        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}
