/*
 * Created on 21 Σεπ 2004
 *
 * By Konstantine Kougios
 */
package def;

import globals.Cache;

import java.sql.SQLException;
import java.util.Iterator;

import org.aris.hldb.CS;

import test.db.CategoriesCached;
import test.db.CustomersCached;
import test.db.EmployeesCached;
import test.db.Order_DetailsCached;
import test.db.OrdersCached;
import test.db.ProductsCached;
import test.db.RegionCached;
import test.db.SuppliersCached;
import test.db.TerritoriesCached;

/**
 * @author Konstantine Kougios, 21 Σεπ 2004, 11:41:46 πμ, for OODBFrameworkTest
 *         project
 * @version 1.0
 */
public class NavigateNorthwind
{

	public NavigateNorthwind(CS csNorthwind, boolean dump) throws SQLException, CloneNotSupportedException
	{
		// do an insert in the Territories
		//TerritoriesCached terr=new TerritoriesCached(csNorthwind);
		//terr.setRegionID(2);
		//terr.setTerritoryDescription("A test territory");
		//terr.setTerritoryID("5555");
		//terr.insert();
		// if the table contained autoincrement values, the terr
		// would automatically be updated with those.
		
		// if we know the primary key(s), we can just get the object by it.
		// This will get the territory with id 02903. It will first lookup the
		// cache and if not found,
		// it will query the table. Since this is the first time we lookup this
		// territory, the
		// lookup will be done to the database.
		TerritoriesCached ter = TerritoriesCached.instance(csNorthwind, "02903");

		// now we'll do an update to the Region table. First we'll get the
		// region
		// that this territory points to and save it so that we can restore the
		// database state later. Then , we'll point this territory to regionId
		// 4.
		// We'll update the database and do some debugging dump of the cache.
		// Finally, we'll restore the territory.regionId to it's previous value.

		// get the old regiod id
		int oldId = ter.getRegionID();

		// get the region of this territory and dump it just to see
		// what is stored. Note: all classes implement the toString()
		// method, and you can see what they contain during debugging.
		RegionCached reg = ter.getRegionIDRef();
		if (dump)
			reg.dump("regionCached==>");

		// now we'll change the region of this territory. We could do it in
		// 2 ways, by providing the ID of the new region, or by providing an
		// RegionCached object. We'll just provide the ID here.
		ter.setRegionID(4);
		ter.update();

		// .. and the same by providing the RegionCached object:
		// ter.setRegionIDRef(RegionCached.instance(csNorthwind,4));
		// ter.update();

		// for debugging we'll dump all contents of the cache to the console
		if (dump)
			Cache.getCache().dump(true);

		// restore the database to it's previous state.
		ter.setRegionID(oldId);
		ter.update();

		// dump the cache again to see if it is updated
		if (dump)
			Cache.getCache().dump(true);

		if (dump)
			System.out.println("\n\n\n\n");

		// find up to 100 employees who live in London
		// Note: getResultSetWith... should be used if the result count could be
		// high.
		Iterator it = EmployeesCached.getIteratorWithCityValueOf(csNorthwind, "London", 100);
		while (it.hasNext()) // iterate through all employees living in London
		{
			if (StretchTest.exit)
				return; // exit if running in stretch mode
			// get the employee
			EmployeesCached emp = (EmployeesCached) it.next();
			// get some info about him
			String emp_firstName = emp.getFirstName();
			System.out.println(emp_firstName);
			java.sql.Date emp_HireDate = emp.getHireDate();
			System.out.println(emp_HireDate);

			// and go on ...

			// find to whom does this employee report to
			EmployeesCached reports = emp.getReportsToRef();
			//get some info about the "boss"
			String boss_city = reports.getCity();
			String boss_firstName = reports.getFirstName();
			System.out.println(boss_city+","+boss_firstName);
			// and do smthing with them ...

			// ...

			// on to the next tables.

			// get all the Orders for this employee
			Iterator oit = OrdersCached.getIteratorWithEmployeeIDValueOf(csNorthwind, new Integer(emp.getEmployeeID()), Integer.MAX_VALUE);
			while (oit.hasNext())
			{
				if (StretchTest.exit)
					return; // exit if running in stretch mode
				OrdersCached ord = (OrdersCached) oit.next();
				// now get the customer who placed this order.
				CustomersCached cust = ord.getCustomerIDRef();

				// play with some fields.
				String city = cust.getCity();
				String address = cust.getAddress();
				System.out.println(city+", "+address);
				// and we don't do anything with them here ... it is just an
				// example

				// Do an update (commented out in order not to alter the
				// Northwind database)
				//cust.setCity("---C:Modified by OODB ---");
				//cust.setAddress("---A:Modified by OODB ---");
				//cust.update(); //this updates only fields. If the primary
				// keys need to be updated too, call updateAll()

				// now find the order details
				Iterator odit = Order_DetailsCached.getIteratorWithOrderIDValueOf(csNorthwind, ord.getOrderID(), Integer.MAX_VALUE);
				while (odit.hasNext())
				{
					if (StretchTest.exit)
						return; // exit if running in stretch mode
					Order_DetailsCached od = (Order_DetailsCached) odit.next();
					// get the products for this order_details
					ProductsCached prod = od.getProductIDRef();
					// and get the suppliers of this products
					SuppliersCached sup = prod.getSupplierIDRef();
					String sup_city = sup.getCity(); // the city of the supplier
					String sup_addr = sup.getAddress(); // the address
					String sup_Company = sup.getCompanyName(); // and the name
															   // of the
															   // supplier's
															   // company
					System.out.println(sup_city+", "+sup_addr+", "+sup_Company);

					// ... do smthing with these values...

					// ... go on with the product's categories.
					CategoriesCached categ = prod.getCategoryIDRef();
					String categ_name = categ.getCategoryName();
					System.out.println(categ_name);
					// note: you can't get images (and the rest of the
					// BLOBS/CLOBS). You have to provide your own
					// code to access those. But when inserting with insert(),
					// or updating a table with images,
					// the handle to the image must be provided.
					// i.e. categ.setPicture(stream,length);
					// A better way is to have blobs in seperate tables and
					// access those with custom code.
				}
			}
		}

		// if you manually update/delete records from tables of the database,
		// you'll have to flush the
		// affected table's caches :
		//SuppliersCached.flushCache();
		//ProductsCached.flushCache();
		//Order_DetailsCached.flushCache();

		// dump the cache to console (for debugging)
		if (dump)
			Cache.getCache().dump(true);

	}
}