/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.sqlBuilder;

import java.util.Enumeration;
import java.util.Vector;
import javak.bo.BOAssert;
import javak.bo.ModelTable;
import javak.bo.sqlBuilder.BOSqlBuilderConstants;
import javak.bo.sqlBuilder.ViewTableFrame;
import javak.bo.sqlBuilder.ViewTableFrameManager;
import javak.bo.sqlBuilder.boAttrAttrRelation;
import javak.bo.sqlBuilder.boAttrModificationManager;
import javak.bo.sqlBuilder.boRelationManager;
import javak.bo.sqlBuilder.boSQLRenderer;
import javak.bo.sqlBuilder.sqlBuilderController;
import javak.bo.sqlBuilder.sqlBuilderStringManipulater;
import javak.exception.BOjavakException;
import javak.iface.bo.I_SQLRenderer;
import javak.iface.bo.I_VisualActionListener;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class boMultiAttrBox
extends JScrollPane {
    private boAttrModificationManager modManager = null;
    private boRelationManager relManager = null;
    private ViewTableFrameManager contManager = null;
    private sqlBuilderController m_controller = null;
    private String insertIntoSelectTable = null;

    public boMultiAttrBox(boAttrModificationManager boAttrModificationManager2, sqlBuilderController sqlBuilderController2) {
        this.modManager = boAttrModificationManager2;
        this.m_controller = sqlBuilderController2;
        this.relManager = new boRelationManager(sqlBuilderController2);
        this.contManager = new ViewTableFrameManager(this.relManager, sqlBuilderController2);
        this.relManager.setContainerManager(this.contManager);
        this.setHorizontalScrollBarPolicy(30);
        this.setVerticalScrollBarPolicy(20);
        JViewport jViewport = this.createViewport();
        jViewport.setView(this.contManager);
        this.setViewport(jViewport);
    }

    public void revalidateTableView() {
        this.contManager.revalidateTableView();
    }

    public String getNameLastActiveFrame() {
        return this.contManager.getNameLastActiveFrame();
    }

    public void removeTable(String string) {
        this.contManager.removeTable(string);
    }

    public I_SQLRenderer buildQuery(String string) throws BOjavakException {
        BOAssert.assert(this.getNrOfShownTables() != 0, "No table has been chosen.");
        String string2 = null;
        if (string.equals("Select") || string.equals("Count results")) {
            string2 = this.buildQuery_Select(string);
        } else if (string.equals("Select (grouped by...)")) {
            string2 = this.buildQuery_SelectGroupBy();
        } else if (string.equals("Insert by values")) {
            string2 = this.buildQuery_InsertByValue();
        } else if (string.equals("Insert by select")) {
            string2 = this.buildQuery_InsertBySelect();
        } else if (string.equals("Update")) {
            string2 = this.buildQuery_Update();
        } else if (string.equals("Delete")) {
            string2 = this.buildQuery_Delete();
        } else {
            throw new BOjavakException("Querytype " + string + " not supported");
        }
        return new boSQLRenderer(string2.trim() + BOSqlBuilderConstants.CONST_LINEFEED);
    }

    private String buildQuery_Select(String string) throws BOjavakException {
        String string2 = "";
        String string3 = "";
        String string4 = this.getSQLAttributes(string) + BOSqlBuilderConstants.CONST_LINEFEED;
        String string5 = this.getSQLAttributesConstraints(0, string);
        String string6 = "";
        boolean bl = this.relManager.relationsOnlyEqui();
        boolean bl2 = this.relManager.hasRelations();
        if (bl) {
            string3 = this.getSQLTables() + " " + BOSqlBuilderConstants.CONST_LINEFEED;
        }
        if (bl2) {
            string6 = this.getSQLRelations(bl);
        }
        if (!string5.equals("") && !bl && string6.equals("")) {
            string6 = string6 + string5;
        } else if (!(string5.equals("") || bl || string6.equals(""))) {
            string6 = string6 + " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string5;
        } else {
            if (!string6.equals("") && bl) {
                string6 = " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string6;
            }
            if (!string5.equals("") && string6.equals("")) {
                string6 = " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string5;
            } else if (!string5.equals("") && !string6.equals("")) {
                string6 = string6 + " AND" + BOSqlBuilderConstants.CONST_LINEFEED + string5;
            }
        }
        string6 = " " + string6.trim();
        string2 = "SELECT " + string4 + " FROM " + string3 + string6 + this.modManager.getSQLOrderString();
        return string2;
    }

    private String buildQuery_SelectGroupBy() throws BOjavakException {
        String string = "";
        String string2 = "";
        String string3 = this.getSQLAttributes("Select (grouped by...)") + BOSqlBuilderConstants.CONST_LINEFEED;
        String string4 = this.getSQLAttributesConstraints(2, "Select (grouped by...)");
        String string5 = "";
        String string6 = this.getSQLAttributesConstraints(1, "Select (grouped by...)");
        boolean bl = false;
        boolean bl2 = this.relManager.relationsOnlyEqui();
        boolean bl3 = this.relManager.hasRelations();
        if (bl2) {
            string2 = this.getSQLTables() + " " + BOSqlBuilderConstants.CONST_LINEFEED;
        }
        if (bl3) {
            string5 = this.getSQLRelations(bl2);
        }
        if (bl3 && !string6.equals("")) {
            string5 = string5 + " AND " + string6;
        } else if (!bl3 && !string6.equals("")) {
            string5 = string5 + " " + string6;
        }
        if (!string4.equals("") && !bl2 && string5.equals("")) {
            string5 = string5 + this.modManager.getGroupedBy("Select (grouped by...)") + string4;
            bl = true;
        } else if (!(string4.equals("") || bl2 || string5.equals(""))) {
            string5 = string5 + this.modManager.getGroupedBy("Select (grouped by...)") + " HAVING" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
            bl = true;
        } else {
            if (bl2 && !string5.equals("")) {
                string5 = " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string5;
            }
            if (!string4.equals("")) {
                string5 = string5 + this.modManager.getGroupedBy("Select (grouped by...)") + " HAVING" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
                bl = true;
            }
        }
        string5 = " " + string5.trim();
        string = "SELECT " + string3 + " FROM " + string2 + string5 + (bl ? "" : this.modManager.getGroupedBy("Select (grouped by...)")) + this.modManager.getSQLOrderString();
        return string;
    }

    private String buildQuery_InsertByValue() throws BOjavakException {
        String string = "";
        String string2 = this.getSQLTables();
        String string3 = this.modManager.buildAttributesInsertStatementPart();
        String string4 = this.modManager.buildValuesInsertStatementPart();
        if (this.getNrOfShownTables() > 1) {
            throw new BOjavakException("INSERT INTO ... VALUES() may only have one table.");
        }
        if (string4.length() > 0) {
            string4 = BOSqlBuilderConstants.CONST_LINEFEED + "VALUES" + string4;
        }
        string = "INSERT INTO " + string2 + string3 + string4;
        return string;
    }

    private String buildQuery_InsertBySelect() throws BOjavakException {
        String string = "";
        String string2 = this.modManager.buildAttrInsertMap();
        String string3 = this.buildQuery_Select("Select");
        string = "INSERT INTO " + this.m_controller.getStringManipulater().quoteString(this.insertIntoSelectTable) + string2 + BOSqlBuilderConstants.CONST_LINEFEED + string3;
        return string;
    }

    private String buildQuery_Delete() throws BOjavakException {
        String string = "";
        String string2 = "";
        String string3 = this.getSQLAttributes("Delete") + BOSqlBuilderConstants.CONST_LINEFEED;
        String string4 = this.getSQLAttributesConstraints(0, "Delete");
        String string5 = "";
        boolean bl = this.relManager.relationsOnlyEqui();
        boolean bl2 = this.relManager.hasRelations();
        if (bl) {
            string2 = this.getSQLTables() + " " + BOSqlBuilderConstants.CONST_LINEFEED;
        }
        if (bl2) {
            string5 = this.getSQLRelations(bl);
        }
        if (!string4.equals("") && !bl && string5.equals("")) {
            string5 = string5 + string4;
        } else if (!(string4.equals("") || bl || string5.equals(""))) {
            string5 = string5 + " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
        } else {
            if (!string5.equals("") && bl) {
                string5 = " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string5;
            }
            if (!string4.equals("") && string5.equals("")) {
                string5 = " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
            } else if (!string4.equals("") && !string5.equals("")) {
                string5 = string5 + " AND" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
            }
        }
        string5 = " " + string5.trim();
        string = "DELETE " + string3 + " FROM " + string2 + string5;
        return string;
    }

    private String buildQuery_Update() throws BOjavakException {
        String string = "";
        String string2 = "";
        String string3 = this.getSQLAttributes("Update") + BOSqlBuilderConstants.CONST_LINEFEED;
        String string4 = this.getSQLAttributesConstraints(0, "Update");
        String string5 = "";
        boolean bl = this.relManager.relationsOnlyEqui();
        boolean bl2 = this.relManager.hasRelations();
        if (bl) {
            string2 = this.getSQLTables() + " " + BOSqlBuilderConstants.CONST_LINEFEED;
        }
        if (bl2) {
            string5 = this.getSQLRelations(bl);
        }
        if (!string4.equals("") && !bl && string5.equals("")) {
            string5 = string5 + string4;
        } else if (!(string4.equals("") || bl || string5.equals(""))) {
            string5 = string5 + " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
        } else {
            if (bl && !string5.equals("")) {
                string5 = " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string5;
            }
            if (string5.equals("") && !string4.equals("")) {
                string5 = " WHERE" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
            } else if (!string5.equals("") && !string4.equals("")) {
                string5 = string5 + " AND" + BOSqlBuilderConstants.CONST_LINEFEED + string4;
            }
        }
        string5 = " " + string5.trim();
        try {
            string = "UPDATE " + string2 + " SET " + this.modManager.buildSetStatements("Update") + string5;
        }
        catch (BOjavakException bOjavakException) {
            string = "";
        }
        return string;
    }

    private Vector sortByRelationType(Vector vector) {
        Vector<boAttrAttrRelation> vector2 = new Vector<boAttrAttrRelation>(10, 10);
        Vector<boAttrAttrRelation> vector3 = new Vector<boAttrAttrRelation>(5, 5);
        Vector<boAttrAttrRelation> vector4 = new Vector<boAttrAttrRelation>(5, 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            boAttrAttrRelation boAttrAttrRelation2 = (boAttrAttrRelation)enumeration.nextElement();
            String string = boAttrAttrRelation2.getJoinType();
            if (string.equals("INNER JOIN")) {
                vector2.addElement(boAttrAttrRelation2);
                continue;
            }
            if (string.equals("LEFT JOIN")) {
                vector3.addElement(boAttrAttrRelation2);
                continue;
            }
            vector4.addElement(boAttrAttrRelation2);
        }
        vector2.addAll(vector3);
        vector2.addAll(vector4);
        return vector2;
    }

    public String getSQLRelations(boolean bl) throws BOjavakException {
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        Vector vector = this.sortByRelationType(this.relManager.getRelationVectorCopy());
        Vector<ViewTableFrame> vector2 = new Vector<ViewTableFrame>(this.getNrOfShownTables());
        Vector vector3 = new Vector(this.getNrOfShownTables());
        boolean bl2 = true;
        boolean bl3 = false;
        sqlBuilderStringManipulater sqlBuilderStringManipulater2 = this.m_controller.getStringManipulater();
        if (!vector.isEmpty()) {
            boAttrAttrRelation boAttrAttrRelation2 = (boAttrAttrRelation)vector.firstElement();
            ViewTableFrame viewTableFrame = boAttrAttrRelation2.getTitleAttrAllJoin();
            if (viewTableFrame == null) {
                viewTableFrame = boAttrAttrRelation2.getTitleAttrCont1();
            }
            Vector vector4 = boRelationManager.getRelationsByPattern(boAttrAttrRelation2, vector, true);
            if (!bl) {
                stringBuffer.append(sqlBuilderStringManipulater2.quoteString(viewTableFrame.getModelTable().getName()));
            }
            boRelationManager.buildSQLFromRelations(vector4, stringBuffer, viewTableFrame, bl);
            vector2.addElement(viewTableFrame);
            vector2.addElement(boAttrAttrRelation2.getTitleAttrOtherEnd(viewTableFrame));
            while (!vector.isEmpty()) {
                boAttrAttrRelation2 = boRelationManager.getRelationFromCont(vector, vector2, false);
                if (boAttrAttrRelation2 == null) {
                    if (bl3 && !bl) {
                        stringBuffer.append(")");
                    }
                    bl3 = true;
                    this.addMissing(vector3, vector2);
                    vector2 = new Vector(this.getNrOfShownTables());
                    boAttrAttrRelation2 = (boAttrAttrRelation)vector.firstElement();
                    viewTableFrame = boAttrAttrRelation2.getTitleAttrCont1();
                    if (!bl) {
                        stringBuffer2.append(stringBuffer + "," + BOSqlBuilderConstants.CONST_LINEFEED);
                        stringBuffer = new StringBuffer("(" + sqlBuilderStringManipulater2.quoteString(boAttrAttrRelation2.getTitleAttrOtherEnd(viewTableFrame).getModelTable().getName()));
                    }
                } else {
                    viewTableFrame = boRelationManager.getContNotInVec(boAttrAttrRelation2, vector2);
                }
                vector4 = boRelationManager.getRelationsByPattern(boAttrAttrRelation2, vector, true);
                boRelationManager.buildSQLFromRelations(vector4, stringBuffer, boAttrAttrRelation2.getTitleAttrOtherEnd(viewTableFrame), bl);
                vector2.addElement(viewTableFrame);
                vector2.addElement(boAttrAttrRelation2.getTitleAttrOtherEnd(viewTableFrame));
            }
        }
        if (bl3 && !bl) {
            stringBuffer.append(")");
        }
        stringBuffer2.append((Object)stringBuffer);
        this.addMissing(vector3, vector2);
        stringBuffer2 = this.contManager.buildRestTables(bl, stringBuffer2, vector3, bl3);
        return stringBuffer2.toString();
    }

    private void addMissing(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (vector.contains(e)) continue;
            vector.addElement(e);
        }
    }

    public void setInsertTable(ModelTable modelTable) throws BOjavakException {
        if (this.insertIntoSelectTable != null && this.insertIntoSelectTable.equals(modelTable.getName())) {
            return;
        }
        this.insertIntoSelectTable = modelTable.getName();
        this.modManager.setAttrForInsertMapping(modelTable);
    }

    private String getSQLAttributesConstraints(int n, String string) throws BOjavakException {
        return this.modManager.getSQLAttributesConstraints(n, string);
    }

    private String getSQLAttributes(String string) throws BOjavakException {
        return this.modManager.buildAttrQuery(string);
    }

    private String getSQLTables() {
        return this.contManager.getSQLTables();
    }

    public Object createNewBox(ModelTable modelTable) {
        return this.contManager.createNewBox(modelTable);
    }

    public void addVisualActionListener(I_VisualActionListener i_VisualActionListener) {
        this.contManager.addVisualActionListener(i_VisualActionListener);
    }

    public void removeVisualActionListener(I_VisualActionListener i_VisualActionListener) {
        this.contManager.removeVisualActionListener(i_VisualActionListener);
    }

    public void removeAllTables() {
        this.contManager.removeAllTables();
    }

    public int getNrOfShownTables() {
        return this.contManager.getNrOfElements();
    }

    public void createRelation(String string, String string2, String string3, String string4, int n) throws BOjavakException {
        ViewTableFrame viewTableFrame = this.contManager.getObjectByName(string);
        ViewTableFrame viewTableFrame2 = this.contManager.getObjectByName(string3);
        BOAssert.assert(viewTableFrame != null, "Tablename " + string + " not found!");
        BOAssert.assert(viewTableFrame2 != null, "Tablename " + string3 + " not found!");
        int n2 = viewTableFrame.getAttrIndex(string2);
        int n3 = viewTableFrame2.getAttrIndex(string4);
        BOAssert.assert(n2 > -1, string2 + " not found in table " + string);
        BOAssert.assert(n3 > -1, string4 + " not found in table " + string3);
        boAttrAttrRelation boAttrAttrRelation2 = this.relManager.addRelation(viewTableFrame, n2, viewTableFrame2, n3);
        if (n == 0) {
            boAttrAttrRelation2.setJoinSome(null);
        } else if (n == 1) {
            boAttrAttrRelation2.setJoinSome(viewTableFrame);
        } else if (n == 2) {
            boAttrAttrRelation2.setJoinSome(viewTableFrame2);
        }
    }
}

