/*
 * Decompiled with CFR 0.152.
 */
package javak.bo.dbInfos;

import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;
import javak.bo.BOAssert;
import javak.bo.ConfigData;
import javak.exception.BOjavakException;
import javak.iface.bo.I_BODBInfos;
import javak.iface.bo.I_BOResultFetcher;
import javak.iface.bo.I_dbInfoListener;
import javak.iface.zs.I_DBZS;
import javak.iface.zs.I_DBZSInfo;
import javak.zs.DBjavakFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class dbInfoMain
extends JPanel
implements I_BODBInfos {
    private final String LABEL_PROFILE = "Use profile: ";
    private final String LABEL_DBNAME = "DB-Name: ";
    private final String LABEL_LOGIN = "Login: ";
    private final String LABEL_PASSWORD = "Password: ";
    private final String LABEL_HOSTRMI = "Computer RMI-Registry: ";
    private final String LABEL_JDBCPROT = "Protocol: ";
    private final String LABEL_DRIVERCLASS = "Driverclass: ";
    private final String LABEL_READATONCE = "Datasets to read at once: ";
    private final String STRING_READATONCE = "100";
    private JComboBox cbProfile = null;
    private JComboBox cbDBName = null;
    private JTextField tfLogin = null;
    private JTextField tfPassword = null;
    private JTextField tfHostRMIRegistry = null;
    private JComboBox cbJDBCProtocol = null;
    private JComboBox cbDriverClass = null;
    private JTextField tfNrDatasetsReadAtOnce = null;
    private Vector listeners = new Vector(5, 3);
    private I_BOResultFetcher resultFetcher = null;
    ConfigData configdata = null;

    public dbInfoMain() {
        super(new GridLayout(9, 2));
        this.cbProfile = new JComboBox();
        this.cbDBName = new JComboBox();
        this.cbDBName.setEditable(true);
        this.cbDriverClass = new JComboBox();
        this.cbDriverClass.setEditable(true);
        this.cbJDBCProtocol = new JComboBox();
        this.cbJDBCProtocol.setEditable(true);
        this.tfLogin = new JTextField();
        this.tfPassword = new JTextField();
        this.tfHostRMIRegistry = new JTextField();
        this.tfNrDatasetsReadAtOnce = new JTextField("100");
        this.add(new JLabel("Use profile: ", 4));
        this.add(this.cbProfile);
        this.add(new JLabel("Login: ", 4));
        this.add(this.tfLogin);
        this.add(new JLabel("Password: ", 4));
        this.add(this.tfPassword);
        this.add(new JLabel("DB-Name: ", 4));
        this.add(this.cbDBName);
        this.add(new JLabel("Computer RMI-Registry: ", 4));
        this.add(this.tfHostRMIRegistry);
        this.add(new JLabel("Protocol: ", 4));
        this.add(this.cbJDBCProtocol);
        this.add(new JLabel("Driverclass: ", 4));
        this.add(this.cbDriverClass);
        this.add(new JLabel("Datasets to read at once: ", 4));
        this.add(this.tfNrDatasetsReadAtOnce);
        this.tfHostRMIRegistry.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent keyEvent) {
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    dbInfoMain.this.fireEventRMIAddressChanged();
                }
            }
        });
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 2) {
                    return;
                }
                dbInfoMain.this.setProfileData((String)dbInfoMain.this.cbProfile.getSelectedItem());
            }
        };
        this.cbProfile.addItemListener(itemListener);
    }

    public void setConfigData(ConfigData configData) {
        this.configdata = configData;
        try {
            this.setDriverClass(this.configdata.getDriverClasses());
            this.setJDBCProtocol(this.configdata.getProtocols());
            this.setLogin(this.configdata.getDefaultLogin());
            this.setProfileNames(this.configdata.getPreconfiguredProfileNames());
            Vector vector = this.configdata.getDatabases();
            Vector vector2 = this.getDSNList(this.configdata.getPathIniWindows());
            if (vector2 != null) {
                vector.addAll(vector2);
            }
            this.setDBName(vector);
        }
        catch (BOjavakException bOjavakException) {
            System.err.println("Error at retrieving configdata! Proceeding.");
        }
    }

    private void setProfileData(String string) {
        try {
            this.setDriverClass(this.configdata.getDriverClass(string));
            this.setJDBCProtocol(this.configdata.getProtocol(string));
            this.setLogin(this.configdata.getLogin(string));
            this.setDBName(this.configdata.getDatabase(string));
            this.setHostRMIRegistry(this.configdata.getRMI(string));
        }
        catch (BOjavakException bOjavakException) {
            System.err.println("Error at retrieving profile configdata for '" + string + "'! Proceeding.");
        }
    }

    private void fireEventRMIAddressChanged() {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((I_dbInfoListener)enumeration.nextElement()).rmiAddressChanged();
        }
    }

    public void addListener(I_dbInfoListener i_dbInfoListener) {
        this.listeners.add(i_dbInfoListener);
    }

    public void removeListener(I_dbInfoListener i_dbInfoListener) {
        this.listeners.remove(i_dbInfoListener);
    }

    public String getLogin() throws BOjavakException {
        return this.tfLogin.getText();
    }

    public String getPassword() throws BOjavakException {
        return this.tfPassword.getText();
    }

    public String getDBName() throws BOjavakException {
        return (String)this.cbDBName.getSelectedItem();
    }

    public String getHostRMIRegistry() throws BOjavakException {
        return this.tfHostRMIRegistry.getText();
    }

    public String getJDBCProtocol() throws BOjavakException {
        return (String)this.cbJDBCProtocol.getSelectedItem();
    }

    public String getDriverClass() throws BOjavakException {
        return (String)this.cbDriverClass.getSelectedItem();
    }

    public int getNrDatasetsReadAtOnce() throws BOjavakException {
        return new Integer(this.tfNrDatasetsReadAtOnce.getText());
    }

    private void setDBName(String string) {
        this.setComboBoxValue(this.cbDBName, string);
    }

    private void setJDBCProtocol(String string) {
        this.setComboBoxValue(this.cbJDBCProtocol, string);
    }

    private void setDriverClass(String string) {
        this.setComboBoxValue(this.cbDriverClass, string);
    }

    private void setProfileNames(Vector vector) {
        this.addComboBoxValues(this.cbProfile, vector);
    }

    private void setDBName(Vector vector) {
        this.addComboBoxValues(this.cbDBName, vector);
    }

    private void setJDBCProtocol(Vector vector) {
        this.addComboBoxValues(this.cbJDBCProtocol, vector);
    }

    private void setDriverClass(Vector vector) {
        this.addComboBoxValues(this.cbDriverClass, vector);
    }

    public void setHostRMIRegistry(String string) {
        this.tfHostRMIRegistry.setText(string);
    }

    private void setLogin(String string) {
        this.tfLogin.setText(string);
    }

    public JPanel getPanel() {
        return this;
    }

    public void enableLogin(boolean bl) {
        this.tfLogin.setEnabled(bl);
    }

    public void enablePassword(boolean bl) {
        this.tfPassword.setEnabled(bl);
    }

    public void enableDBName(boolean bl) {
        this.cbDBName.setEnabled(bl);
    }

    public void enableHostRMIRegistry(boolean bl) {
        this.tfHostRMIRegistry.setEnabled(bl);
    }

    public void enableJDBCProtocol(boolean bl) {
        this.cbJDBCProtocol.setEnabled(bl);
    }

    public void enableDriverClass(boolean bl) {
        this.cbDriverClass.setEnabled(bl);
    }

    private void setNrDatasetsReadAtOnce(int n) throws BOjavakException {
        BOAssert.assert(n > 0, "Number of Sets to read at once is invalid (<1)");
        this.tfNrDatasetsReadAtOnce.setText("" + n);
    }

    private void setComboBoxValue(JComboBox jComboBox, String string) {
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        int n = comboBoxModel.getSize();
        int n2 = 0;
        while (n2 < n) {
            if (((String)comboBoxModel.getElementAt(n2)).equals(string)) {
                jComboBox.setSelectedIndex(n2);
                return;
            }
            ++n2;
        }
        jComboBox.addItem(string);
        jComboBox.setSelectedItem(string);
    }

    private void addComboBoxValues(JComboBox jComboBox, Vector vector) {
        Enumeration enumeration = vector.elements();
        jComboBox.removeAllItems();
        while (enumeration.hasMoreElements()) {
            jComboBox.addItem(enumeration.nextElement());
        }
    }

    private Vector getDSNList(String string) throws BOjavakException {
        Vector vector = null;
        try {
            I_DBZS i_DBZS = new DBjavakFactory(this.getHostRMIRegistry()).i_dbzs();
            I_DBZSInfo i_DBZSInfo = i_DBZS.getDBZSInfo();
            vector = i_DBZSInfo.getInstalledDSNSources(string);
            Stack stack = new Stack();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                stack.push(enumeration.nextElement());
            }
            vector = new Vector(10, 10);
            while (!stack.empty()) {
                vector.addElement(stack.pop());
            }
        }
        catch (Exception exception) {
            throw new BOjavakException(exception, "Couldn't create DSNlist!");
        }
        return vector;
    }
}

