[NOTE:  I've made only a couple of changes to this solution, which was
written with Curses Release 12 in mind.  There are no new puzzles in the
current Release 16, but the ambiguities from my original solution have been
addressed.  This solution does not give you step-by-step commands, so it
should help novices learn how to translate their desired actions into 
"Textadventurese."  Before you start reading, PLEASE go back to the puzzle
you're having trouble with and give it another shot.  This is an extremely
difficult game, and if you can solve it without once reading below this
sentence, you'll feel great because of it.]


I begin with a disclaimer:

	Curses may be one of the best text adventures ever written, and for
that reason it deserves the effort which is required to solve it.  It
is one of the few text adventures I have played where the puzzles
become a part of the story, rather than a series of obstructions.  This
walkthrough is not meant to be used as an instant gratification method
of getting through the story, and I hope that it will not be used as
such.  More than anything, this walkthrough is intended to cut down on
the exceptional amount of traffic on r.g.i-f., which for months has
been almost exclusively Curses-oriented.  If you are looking for hints
which will help you get through certain parts of the game which yor are
stuck on, my suggestion is that you use a word search to skip to
exactly where you are stuck.  This will help you avoid ruining what can
be a very rewarding experience.

	I also suggest that new players immediately use the 'help' command
to get all of the background information on the game.  Graham Nelson,
the author, has provided an excellent set of instructions for your use.

Also, a couple of notes:

	1) When saying a single word to other characters, the format is: "say
<word>" (no punctuation).
	2) When making a request or saying a word to a particular object, the
format is: "<object/person>, <word/request>."  I'll cover these instances 
in detail later, but if "guess the verb" is holding you down, then this 
is the way to do it: "painting, lagach" or "evans, give me the <word>."
	3) Often you'll have to take items out of the rucksack before you can
use them, so if it suggests that you're not holding something that
you're fairly certain you have, "get" it before you decide the game's
gone nuts.
	4) At times, the dumbwaiter will not be where you want it to be. 
Just get to the nearest wheel and turn it for the dumbwaiter to show
up.  If the wheel won't turn, then "turn off wheel" will free it up for
you.
	5) The game doesn't take kindly to swearing.  If you should swear
(and the game is pretty strict -- 'bugger' is as bad as any four letter
word), a cake of carbolic soap will appear in your inventory.  Wash
your mouth out with soap, and you'll be able to continue.
	6) Make a map.  I'll only go so far in guiding you by the hand --
if you have to get from one end of the house to the other, and I've
shown you the way before, you'll have to figure it out yourself the
second time.
	7) Many of the solutions actually change the state of other rooms
without notifying you.  That's another reason to explore a bit on your
own before using this indiscriminately.  In fact, explore a lot, or the
intricacy of the game will be lost to you.

And now, the walkthrough --


Curses -- Version 12
The Walkthrough


	You should begin the game by collecting all of the objects which are
immediately available to you.  In order to do this efficiently,
however, you should begin by taking care of the flashlight situation
and by finding something to help you carry the many items which will be
available to you.  [If you find yourself wondering "What flashlight
situation?" then it's way too early for you to be using this walkthrough.]
Head north to the old winery, and -- well, there's another problem that
should be taken care of, as the attic key just slipped between the floor-
boards.  Let's not get sidetracked, though -- go west and south to the
airing cupboard.  Look under the sheets and you'll find an old, heavy
wireless radio.  Push that north to Aunt Jemima's lair and turn it on before
going west to the potting room.  Aunt Jemima is busy pouting right now, so
she won't be very friendly -- in fact, if you try to take those ever-useful
gardening gloves right now, you'll see just how unfriendly she can be.
Wait ('Z' works well) a few turns until the radio fades in, and then you can
take the gloves.
	Head east twice, wear the gloves, and open the demijohn.  You don't
need these items yet, so head south twice and then go southeast to the
east wing.  Head east from here and you'll be in the east annexe, where
your flashlight's battery will begin to bite the dust.  That's no
problem, though, because if you're wearing the gloves you can search
the insulation rolls to find a brand new battery waiting for you.  Open
the flashlight, empty it, put the new battery in and then close it up
and you'll have a lightsource for the rest of the game.  You also want
to head south now, where your ancestor Ebeneezer's rucksack is waiting
for you.  Grab that, because it can hold a miraculous amount of stuff.
	OK, now that we've got the rucksack we can pick up a few items.  Head
north and open the cupboard before heading north again.  Grab the
painting of Mad Isaac and the gas mask and go back to the old winery. 
Now head east, grab the wrench, and enter the dumbwaiter (you might as
well grab the chicken bone which is lying here, as well).  Pull the
rope and you'll drop down into the basement.  Get out of the dumbwaiter
(just 'out' will do nicely) and grab the robot mouse before going
south.  Drop the mouse, and tell it to go east.  Understand that
conversation is the only limit in this game, and must be done
correctly, so type 'mouse, go west.'  Now the mouse is out of earshot,
so you can't talk to it directly.  Talk to the hole instead: 'hole, go west.'
There we go -- now have the mouse go west twice more, then north once, west
once, and north again.  Ah!  Something happened!  Send the mouse back the way
it came, and out will come that missing attic key.  Grab it, head to the
dumbwaiter and pull the rope again.

[NOTE: If you haven't done so already, before you go up in the
dumbwaiter head west and south to the demon.  This guy can be pretty
helpful.  Just "ask demon about <object>" or "show <object> to demon"
and you might get a hint.  Just remember that he IS a demon, so
whatever he tells you is likely the opposite of the truth.]

	Now you should be somewhere between the attic and the basement.  Get
out of the dumbwaiter and put on the gas mask before heading north. 
Unlock and open the door, and if you want you can head north and take a
look around, although we're not going to do anything here quite yet. 
Incidentally, at some time far in the future we'll go through this door
a second time and pick up ten points for it -- I really have no idea
why we don't get them now.  Anyway, head back to the dumbwaiter and
pull the rope again to get back to the attic.  Let's do some more
garbage collection.  Head west and get everything from the demijohn,
then head south and look at the teachest.  This book, the History of
the Meldrews, contains a wealth of information which is necessary to
complete the game.  If you haven't taken a good look at this history,
you should look up every name you come across in your travels (a list
of these names appears at the end of the walkthrough).
	Head east from here, lie down on the bed, and sleep.  Yes, you are
quite the vivid dreamer.  Go east and north and take the mascot that's
there -- read this description carefully, because an important magic
word will appear.  Now, drop the mascot, because it's cursed and you
won't live long if you insist on carrying it around (plus you'll lose
fifty points for taking it out of the dream).  Head south, west,
southwest and east to escape the dream.  Stand up and grab the
dictionary and scarf before going west and south where you'll take
everything from the cupboard (did I mention that you'll be carrying
around a lot of stuff?).  Open up that mysterious little parcel. 
Hmm... I wonder if Jemima likes chocolate?  Just to make sure, why
don't you head back to the potting room and offer the box to her.  Now,
quick explanation for why you're going to choose one particular color. 
If you flip through the calendar east of the potting room, you'll
notice many different daisies pictured.  There is only one that should
be of any particular interest, however --  the Merlyn's Hat daisy,
which is yellow.  If you looked up Isaac in the History of the
Meldrews, you must have noticed that Isaac had a particular interest in
Merlin, so when Jemima asks you what color you're looking for, I
suggest "say yellow."
	While Jemima works on this, head back to the east wing and go west.
 Pull the cord to turn on the darkroom light and take a look at the
postcard to read its invisible ink, and while you're at it, grab the
flash.  Look at the photograph, as well -- ah, another Meldrew!  Look
Roger up in the history of the Meldrews, because there's a clue there
that will be important later on.  Now, go east twice and north back
into the cabinet.  Turn the crank here to open the window, go up to the
roof and then head northwest.  Ah, a key!  Unfortunately, when you try
to pick it up you'll get a ghastly little surprise, but it's easily
remedied.  If we wanted to take the time, we could look up Joshua in
the history and discover how to foil him, but since we're in a
walkthrough just give him the chicken bone.  Elusive key, isn't it? 
Head back into the cabinet and put the torch and the brass key into the
fireplace.  This will be a tight squeeze, so drop everything else
before going west into the dark.  Go down and you'll be in a
not-entirely-pleasant little priest's hole.  Grab everything and then
open the hatch with the brass key so you can drop down.
	I'll bet you think you've done a lot by now, but no such luck.  Head
west into familiar territory.  Now, if you turn the wheel here the
dumbwaiter SHOULD come down to us, but if you look at the wheel you'll
see the problem.  Just "turn off wheel" (yes, it's odd, but a lot of
the grammar here is unusual) and then turn the wheel to bring the
dumbwaiter back downstairs.  This would probably be a good time to head
back to Jemima and claim your daisy chain.  WARNING: Do not drop the
daisy chain.  You can probably get another one, but it's really not
worth the trouble.
	Head back to the cabinet and collect all of your stuff and then
prepare for a little time travelling.  Go south out of the cabinet,
then west and south to the observatory.  While we're here, clean that
glass ball -- it'll come in handy later.  Go west into the library
storage room and tighten that loose joint with the wrench.  Grab both
of the books and check out the romance novel first.  Who the hell is
Marie Swelldon?  Worry about it later -- for now, read the book of
poetry and ...
	Yep, it's France at the turn of the century.  What did you expect? 
Head north and up to Madame Sosostris's reading room and push the bell
there.  I've never seen much of a difference between choosing odd or
even here, but just as a disclaimer I'll admit that I've never tried
anything but 'even,' myself.  She'll do a quick and somewhat
frightening reading and then hustle you back onto the street.  Don't
accept such a rebuke!  Go right back upstairs and grab the Tarot cards
(although only one of these cards will actually be useful, the others
can be fun).  Go downstairs and west and take a look at the mural
(another name -- look it up!  Remember, look up EVERY name that you
see!) before going outside again.  Back on the street, head west and
get the silk handkerchief.  Wave it and board the boat.  Now if you
take long enough, this guy will literally hand you the solution: say
time.
	So here we are, back at the garden stream.  Now let's see what we've
got here.  Head northwest and climb the family tree, then look at the
maze.  Notice that strange open space in the southeast corner?  Good,
now head back down and drop the medicine bottle right here.  Head west
twice, get everything, board the garden roller, and turn it on.  Go
east twice (Ouch!  What was that?) and then east once more to plow over
one of those garden statues.  Head west again, and then drive north
into the maze (if you want to know why we're driving here, try walking
in).  The directions through the maze are: north, west, west, north,
north, north, north, west, west, west (it's a simple maze, thank God). 
Get off the roller ('out' works fine), get the miniature, then board
the roller again and go back where you came.  Turn off the roller (this
is probably just anality on my part, but it's better to be safe than
out of gas) and get off it again.  Grab the tablet (Childproof lock? 
Hah!  Piece of cake!) and you're ready to do some more time travelling.
	Go back up to the observatory (by now I'm assuming that you can find
your way around) and head south.  Turn on the slide projector and turn
the knob.  Remember that Ace of Cups which appeared when you left
Paris?  Put that card into the projector's slot now, and then head
south, right through the wall.  This is where the game really starts to
get interesting.  You may want to listen in to the conversation
upstairs, but when you're ready, search the crates and you'll find a
model ship.  Pick up the mounted bottle and pull the anchor on the
ship.  Put what's left of the ship into the mounted bottle, and you've
got a beautiful little ship in the bottle (I've always wondered how
they do that!).  Now just look at the ship, and we're seasick.
	A little acrobatics are now in order.  Climb the mast and get the
flag which is flying from it.  Once you've got a firm grasp, go port
and the whole business will crash down around you.  Pick up everything
that came down with you and go fore, where you'll find a green branch
which should also be taken.  Head aft twice, turn the wheel and then go
down the anchor chain to end up back in the attic again.
	Now, put the Fool into the projector (you might want to remove the
Ace of Cups first) and go north.  See how handy that ball can be once
it's clean (if nothing happened, turn the knob on the slide projector
and try again)?  To find out what just happened, go back to the "dead
end" where you found the rucksack.  Head east down the fire escape and
then northeast towards town.  Go north, and look at the cross.  Another
name -- why don't you look up Gerard in the history of the Meldrews? 
Marie Swelldon -- isn't that the name of the romance novel?  If you're
good at putting two and two together, then you should now know that
Marie Swelldon is the pseudonum used by Roger Meldrew's wife.  At this
point figuring out the real name is fairly simple.  Take the letters
"MELDREW" out and we're left with "AISLON," which when unscrambled
becomes "Alison."  So, look up Alison Meldrew in the history and voila!
If you head back to the dead end and push the south wall, Alison's
private writing room will be revealed.
	In the writing room, you should continue your trend of sleeping on
everything which seems even remotely designed for that purpose.  You
should put the ship's flag on the bed first, though, to provide a
comfortable blanket.  Once you're asleep, you'll have another of those
vivid dreams.  Wait once, and watch what the weird guy does with that
rod.  I wonder where you can pick up one of those?  When he's gone,
head east twice and turn the wheel.  Now, this is one of the few
semi-arbitrary puzzles, but the thinking as expressed by those who
claim to have solved it is that, if you look up at the status bar,
you'll see the word "dreaming?"  The traditional way to see if you're
dreaming is to "pinch me," so go ahead and do that.
	Get out of bed now and look in the mirror.  Actually, take that sooty
old stick from the fireplace out of your rucksack first and THEN look
in the mirror.  You'll notice that the sooty old stick doesn't show up
in the mirror for some reason.  If you haven't looked up Isaac in
thehistory yet, do so now.  Using his date of death as a reference,
look up 1792 in the prayer book.  Merlyn's hat, eh?  Hidden items, eh? 
Why not wave that sooty old stick while we're wearing that yellow daisy
chain, just to see what happens.
	This is a major theme in the game -- there are a total of ten rods
disguised throughout, and you have two of them.  The old timber spar is
the other one, so wave that.  Now the question is: how do we tell one
rod from the other?  Before we answer that question, break the windows
so you can gain access south to the balcony.  Look under the window
sill and then pick up the gold key which you reveal.  What do you
suppose this key belongs to?  Well, go back to the "attic" room where
the game began and close the attic door.  Get the box that is revealed
and then open the door again on the off chance that you get separated
from your light source in the future.  Unlock the box with the gold key
and open it to reveal a four leaf clover.  I'd suggest you give this a
wave, as well.
	Next you'll want to head down to the coal bunker, where you'll see
that your little dream actually opened up that sandstone passage you've
been so curious about.  Head east twice and you'll be in a large
octagonal room with lots of strange Egyptian stuff.  Before we go about
the serious business, get everything and break the frame on the
charcoal sketch.  You'll reveal a dog-eared old letter by doing so, and
you'll want to pick that up, as well.  Now open the coffin and read the
inscription inside.  The dog-eared old letter will supply you with the
necessary tools to decipher this, so now put one of your featureless
rods into the coffin.  Close the coffin (I hope you were wearing your
gloves!) and open it again, and your rod is named.  Do the same with
the other two rods (you can actually put all of them in at once, but
only one will be named at a time), and then head southeast.  Hang the
picture of Isaac Meldrew on the hook here and then get the sceptre
which is hidden in the umbrella stand.

[NOTE: About that magic word, 'lagach.'  If you want to travel around
to many of the places you've been, one way of doing so is by
approaching an artwork and typing (for example) 'mural, lagach' or
'painting, lagach.'  This will cycle you through the artworks which you
have seen, however I must point out that this can be very tiresome, and
there are really very few times when it's necessary.  A complete list of
places you can 'lagach' to appears at the end of this walkthrough.]

	Ready to travel some more?  Head up the staircase here and then go
up again and you'll be back in the servant's room.  This will supply
you with a nice short cut between the two most distant areas of Meldrew
hall.  Let's go to Hamburg this time -- remembering the postcard, look
up 1420 on the map of Hamburg and you'll end up at the museum of
Arcana.  Just for the heck of it, head south and marvel at the wonders
of modern security.  To get through it, we'll have to be a bit
innovative.  Turn the revolving door once and then go northeast.  Of
course!  Where else would a beach ball be?  Push it southwest, and then
push it south and the security problem will be behind us.  Grab the
tarot box and open it up so you can reach its contents more easily
later on.  Head east and break the cabinet (yes, occasionally violence
IS the answer).  Get everything from the cabinet, and immediately make
sure that you are HOLDING the medicine tablet (i.e. take it out of the
rucksack) and the Rod of Returning (this is not arbitrary -- we are
simply doing the puzzle a little out of order).  If we wanted to, we
could just lagach through the still life in the other room (which, if
we were doing things in order, is exactly what we would do), but this
is more useful and interesting.  Wait around for a while and the druids
will grab you, drug you, and throw you in jail.  Before doing anything
else, eat the tablet to neutralize Doktor Stein's poison.  Now grab the
Shepherd's crook and show that Alison's dream taught you something --
strike the Rod of Returning and point it at yourself ("me").  If you
didn't prepare well enough beforehand, Doktor Stein has got some nasty
plans for you.
	Believe me, that was a close one.  Now you should be somewhere in the
attic, and hopefully ready for more time travelling.  This time,
replace the Fool in the projector with the miniature and go south
again.  This time, you've gone way back to the building of the hedge
maze.  My first advice to you is to leave the bean pole alone for now. 
Head east as far as you can go, and then head south as far as possible.
You should now be in a whitewashed area which, coincidentally,
corresponds perfectly with the inaccessible section of the garden maze.
Head west, and squeeze the weed killer bottle which you picked up from
the garage.  Having killed off all of those seeds, you can now go all
the way back to the northwest corner of the maze.  Now be ready with
the Rod of Returning.  Get the bean pole, strike the rod, and get out
of there in a hurry before Capability Meldrew ships you off to
Australia.
	Shall we see what we've accomplished?  First, go to the library
storage room and pick up the book of twenties poetry which you left
there.  Go back to the maze, jump in the roller and go north twice and
east three times.  Get off the roller, get the marble rose, and then go
down.  This mural should set off a few bells in your mind.  A star?  A
maiden?  A bundle of wands?  Look in the Tarot box from the museum and
you'll see something familiar.  Maybe Madame Sosostris holds a key to
what this means.  Read the poetry book again and go back to the reading
room.  This time, though, we're going to stack the deck.  In order for
them to be pulled in the correct order, you should put the eight of
wands on the deck, followed by the maiden, and finally the star.  Push
the bell, and Madame Sosostris will go a little nuts and give you an
oak quarterstaff (three guesses as to what THIS is).  After you've been
hustled into the street once again, go back and retrieve your cards
before going to our friend on the river boat for a return trip to
Meldrew Hall.
	You may not realize it, but you've collected a number of rods.  Use
the coal bunker to get into the octagon room again and wave the bean
pole, the shepherd's crook, the quarterstaff, and the Eight of Wands. 
Now use the coffin to name them all, and you'll have a total of seven
wands to play with.  Go southeast and 'lagach, painting,' hopping from
artwork to artwork until you're back at the bronze mural.  Activate the
Rod of Bronze by striking it and pointing it at the bronze mural to
reveal a passage going down (be sure to grab the book of poetry
beforehand).

[NOTE: If you think you've had enough of being led by the hand, you now
have access to another hint machine.  If you go south from the clearing
outside of the garage, you'll find a runner bean plant.  Use the Rod of
Stalking on that plant and, naturally, a beanstalk will appear.  Up the
beanstalk you'll find an angel who works similarly to the demon, but who
will always tell you the truth.]

	When you head down into the passage, get the key which you're
standing on first.  Then head east twice and read the gravestone
beneath your feet.  Another name -- look it up.  Now head back to the
jagged passage and go south.  Although the smell is REALLY bad here, take
a deep whiff, anyway -- no, really, just type 'smell.'  Strange, eh?  Do
it again, and you'll discover a new passage heading down.  Follow it, and
you'll come to the universe maintenance room.  If you want to die, turn
the dial.  If you want to win, turn off the electrician's switch so
that determinism becomes a thing of the past.  Now head back upstairs
and go west to the contraption room.  If you look at the panel, you'll
notice that this is rather complicated.  However, what's with that
giant bronze wall?  Use the Rod of Bronze on the wall and, although
nothing special will SEEM to happen, try going north.  Now the puzzle
is simple.  Look at the panel again, and you should see that the
solution is HENRI BLACK POST (you DID look Henri up in the history,
didn't you?).  If you're careful, you should be able to slide the
letters into place without backtracking at all.  If you hadn't gone
through the wall, it would have been unsolvable.
	When you're done, go back to the garden roller and exit the maze. 
If you go east, you'll see why we plowed over that lawn ornament way
back at the beginning of the game.  Grab the golden orb, but don't do
anything with it yet.  I think it's time to head off to ancient Greece,
so take a shortcut with the Rod of Returning and return to the slide
projector.  This time, put the Maiden into the slot and stroll through
the wall.  Don't bother with Andromeda, she's kinda prudish and takes
herself too serously.  Instead, go up the cliff face, then east and
south.  This wall of thorns seems rather solid, but if you use the Rod
of Fire on it you won't have much trouble.  Head south again, coming 
face-to-face with a rather unhappy Zeus, and use the Rod of Luck on
yourself.  You see, Zeus really would rather not have you strolling
around on sacred ground, and if Determinism were still in effect, he
would have no trouble frying you with a lightning bolt.  Thanks to your
messing around with the laws of the universe, though, you can now take
advantage of Chance and go south into the temple of Zeus.
	All right (just so you know, I'm getting exhausted from typing all
of this, and an E-mail of thanks would be greatly appreciated if you
find that I've helped you out), first off grab the copper coin and go
southeast.  Pick up this stone and look at it, because this is your
Rosetta Stone for learning the nifty ancient language which Graham has
created.  Combined with the dog-eared letter, this object will help you
translate any of the ancient languages which you come across in the
course of the game.  You'll notice that all of the Greek/Alexandrian
sentences BEGIN with periods; that's your clue that they are actually
written backwards, which is important to understand, but not until
later.  For now, continue southwest to where Homer is sleeping.  You
want those pan-pipes of his, so wake him up and answer his three
questions.  The answers can be found from a combination of the
dictionary from the Servant's room and information from Alexandria
(which we haven't visited yet), but since this is a walkthrough: 1)
Menelaus's brother is Agamemnon, 2) Ptolemy was Alexander's successor,
and 3) your favorite color is yellow, the color of the chain which you
chose.  Now the way is clear for you to go down.
	The dictionary of Mythology helps out down here, as well.  Head
southwest, and you'll notice find a statue of Poseidon.  Grape vines
and barrels don't seem his style, don't you agree?  Go ahead and push
that statue northeast and then head northwest to see what else you can
track down.  Dionysus?  Well, that's more like it.  Let's push him
southeast and then southwest with those wine-casks.  Now, go northeast
twice and we'll find Demeter, goddess of the harvest.  It seems like
she's misplaced amongst fish and waves.  Let's push her southwest and
northwest into all of that wheat, and let's push Poseidon up into that
northeast corner.  Did you hear something?  You'll find an opening
going down back at the cross centre.  Drop down there and, if your
interpreter accepts the 'undo' command, take the amber gem.  If your
interpreter doesn't let you undo, save the game if you want to
experiment with death.  Now use that knowledge and try this again. 
Before dropping down the opening, put the rosetta stone into the
opening, making it safe for you to drop down and get that amber gem.
	That's it for the Temple of Zeus.  Go back across the sacred ground
(Zeus is pretty persistent, isn't he?) and up to the clifftop walk. 
Those goats are kind of a pain, but you can dispose of them simply
enough with the Rod of Husbandry.  Once the path is clear, go east and
grab a fig before you going into the tavern, where you'll give the coin
to the bartender in exchange for that tasty-looking dessert.  Head back
down to Andromeda and offer her this tasty treat and she'll give you
her hairband in return.  OK, a quick trip to see the priestess Apollo
and we'll be done with Greece.  Head back up the cliff and go
southwest.  As you might have learned from the scroll in the Octagon
room, Apollo loves music, so play the pan-pipes and the priestess of
Apollo will appear.  Now put the fig in the urn as an offering and ask
the priestess any question -- the format is "Priestess, tell me about
<word>."  It doesn't matter what you ask, because she always gives the
same basic answers.  The first one tells you of a place with six arches
-- we haven't seen that yet, but jot down the "X paces and Y paces"
which she mentions.  Now, if you want to you can go back to the inn and
get another fig, but I find it easier just to drop that useless
chocolate biscuit into the urn (if it's edible, it'll work).  Have the
priestess tell you about something else (I find that 'orgasm' provides
an amusing response), and you'll hear something about escaping the
destruction of a castle with the power of a veil of the neck.  Check
your inventory and see if you can figure out what that might be.
	The priestess has a third response, but that's just to tell you
(cryptically, of course) that the medicine tablet is the antidote to
Doktor Stein's drugs (if you really want to see what she says, you can
fig it again).  There's not much left to do here, so use the Rod of
Returning to head back home. THE FOLLOWING PUZZLE is actually optional,
but it's also a lot of fun.  If you're not in the mood to have fun,
skip down a couple of paragraphs to the one that starts "And now,
Alexandria."
	Head for the slide projector and replace the Maiden with the Castle
before doing your Casper routine.  I really wish you could hang out in
this scene for a while, because it looks like a pretty decent party,
but if you look under the table, you'll notice that things aren't as
much fun as they seem.  Harken back to the priestess's clue and take a
look at that scarf.  Using the order of the colors as a guide, pull the
blue wire, the green wire, the black wire, and finally the red wire,
and wait a little while with your fingers crossed (don't miss that
Reagan quote -- it's a classic, like War of the Worlds).  Once you've
safely got the timer in hand, the Rod of Returning will get you home
safely.
	Next, we put the star into the projector and we're back in Greece,
but later in the day than before (a neat gimmick, as you'll see). 
First, go down and take a look at the frieze (no, we're not just
sightseeing).  Now head back upstairs, open the photographer's flash,
and put the red battery inside.  Then set the timer and put the timer
inside before closing the flash.  Finally, put the flash into the
device and wait for the fireworks.  Pretty cool -- 50 points, and the
puzzle is optional, something I really don't understand.  Now check
your inventory, and you'll notice a slight discrepancy.  This is not a
problem.  Go east twice to the mosaic and do your lagach trick until
you're back at the frieze.  Head upstairs, and there's all of your
stuff, safe and sound.
	And now, Alexandria.  This is, IMHO, the endgame, but only because
the actual endgame is so much easier than this part.  If you've been
just cruising through the walkthrough so far, put it away now and try
out Alexandria yourself a bit; only when approaching breakdown do you
want to pick up this walkthrough again.  To get to Alexandria, you'll
want to put the charcoal sketch into the projector.  You were going to
figure this out on your own, but head north anyway and notice that the
beam of light is striking Leo.  Also, Austin should probably be
standing here tripping out on the pretty light show.  Now call me
crazy, but do you see some kind of connection here?  Before I actually
pass on this solution, I feel obligated to show you how I reach it --
push Austin into the potting room with Jemima.  'Kay?  Good, now push
Austin into the slide projector room and do as Jemima did -- jump, and
then follow your poor traumatized cat into Alexandria.
	This place is bustling with activity, but luckily Austin has suddenly
decided to be affectionate (you just had to show him who was boss) and
will follow you around for a while.  The first thing you want to do is
to head north and drop the smooth round stone into the grating.  You
can wait around to see what happens if you like, but then head south,
southeast, and southwest to the necropolis.  Now go south and look at
the writings (making Alexandria lagachable) and head north again.  Blow
the bird whistle and the birds of prey will direct you to a certain
tombstone.  Take the cloak of many colors from the tombstone, wear it,
and then head northeast twice, into the parade -- you'll find that you
can only enter the parade while wearing this garish thing.  Now you can
safely head southeast into the royal museum while the guards outside
kneel and bow and scrape and grovel in front of your cat.
	Once inside the museum, start by going south and anointing yourself
with oil ('anoint me'), a ritual which you might have seen mentioned
with the inscription in the necropolis.  Go back north and southeast,
where you'll want to take the spindle from the rickety globe that's
there.  Back at the birdcage, wait a couple of turns until a messenger
drops two tubes into the pingeonhole.  Get these tubes and prepare a
little practical joke.  To the northeast you'll find Callimachus and
Apollonius, two competitive poets with extremely different writing
styles (you can find out about this by looking them up in the
dictionary).  Before going there, though, switch the scrolls in the
tubes -- i.e. put the short poem in the Alpha tube and epic poem in the
Kappa tube.  Now head northeast and give the Kappa tube to Callimachus.
Follow Callimachus south and give the Alpha tube to Apollonius, and
then pick up the spoils of this little war before heading out of the
museum.
	With the museum out of the way, you should go north and then west,
where you'll find the smooth stone and rusty key.  Pick these up and
then, if you wish, play dice with the old sailor.  The object is to
figure out how to count from one to six in this language, and if you
play long enough you'll figure it out ('throw die' or 'drop die' -- 'roll
die' might not work).  However, if you were in the mood to figure things
out you wouldn't be reading this walkthrough.  The numbers, from one to six,
are: thu, zal, si, ca, mach, and huth.  Once you're through playing around,
go back to the grating, unlock it with the rusty key, go down and enter the
skiff.  Pick up the adamantine heart which you find there, and then set sail. 
Don't worry, we'll be back soon.
	Now for some mundane stuff.  To start off, head back to the octagon
room and identify the rods you've picked up.  Wave the spindle and the
amber hairband and put them in the coffin to find out what they are. 
You should have a total of nine rods now, leaving only one to collect. 
Head up the servant's staircase and go through the fire exit and
northeast.  Head down and wave the green branch, driving off the corn
crake.  Get the nuts, go northwest, get the wooden ball, and take your
favorite route to Mad Isaac's painting.  Now head northeast to an area
of Meldrew Hall we really haven't dealt with yet.  Go east and then
north and get the croquet mallet, then go south and east again to the
croquet lawn, where we find six arches, just as the priestess
mentioned.  I hope you jotted down those numbers from earlier, because
you need them now.  The syntax here is "walk X paces <direction>."  In
general, the first number which the priestess gave you refers to east
or west directions, the second number north or south, so there are four
different places where you might have to dig (incidentally, if you
haven't looked at the gardening implement from the garage, do so now). 
My experience has shown that the treasure is usually located east and
north, but I can't guarantee it.  Once you've dug up the strongbox with
the spade, unlock it with the gothic iron key and open it to reveal an
astrolabe, which you want to take.
	Now to finish with the truly mundane (only so because this paragraph
is related to an optional puzzle), drop the hard wooden ball and hit it
with the croquet mallet.  Oops -- maybe you had better fill that hole
first.  Follow the squirrel northwest and put the nuts into the hole in
the wall of the summer house.  Once the squirrel has chased after the
nuts, go south and blow the bird whistle.  This should shake loose the
gold watch for you to take.  With that taken care of, head to the
painting and 'lagach' yourself back to Alexandria.
	Head north into the necropolis and put the amber gem into the socket
on the tombstone.  Go down and do exactly what I feel like doing right
now -- lie down on the couch and go to sleep.  Now do it again.  And
again.  And one more time.  Now wait around, and watch the guards do
their thing.  Once they're finished, go to the west and die.  Now die
again.  And again.  Continue until you're back in the "present," and
tweak the sphinx's nose.  Head west and pick up the statue if you like
before going further west to "Quite an Undertaking."  At this point,
you might try to go down that tunnel [northeast?].  Care to try again?
You could keep trying, but when you give up and head east and west again
a green oak quarterstaff will drop from the rafters (grab it).  Next, put
the sceptre into the first socket and turn it until it comes up "si." 
Move the sceptre to the second socket and turn it until it comes up
"huth."  Finally, turn it in the third socket until you get "thu," and
the sarcophagous should spring open.  Incidentally, you'll notice that
this corresponds to the "III IIIIII I" writings we examined earlier. 
Now, enter the coffin and close the lid, and when the computer asks if
you are crazy, just close the lid again, because you are.  Just when
all seems lost, go up, and you will see why we took the precaution of
annointing ourselves with oil.
	OK, we still have one more trip to Alexandria left, so head out to
the bronze mural and lagach yourself there.  From the crossroads, go
southeast, remove the cloak of many colors and turn it inside-out.  If
you happened to glance at the painting in the Undertaking room, you
might have noticed that the priest of Sosostris wore a gray cloak. 
Wear this cloak, open the door to the tower, and enter.  Put the green
oak quarterstaff on Sosostris's table, and she'll give you a keepsake. 
Next head northwest, turn the cloak inside-out again, and go northeast
into the parade.  Go north twice and you'll be standing outside of the
palace of Alexandria.  If you want a laugh (and have 'undo' or 'save'
capability), immediately go north again.  If you want to live, then
remove the cloak of many colors before going north.
	Once inside the palace, wear the purple sash, which will allow you
to walk around.  Are you familiar with those wonderful mazes where you
have to drop items in order to identify rooms?  Well, try it now and
you'll see that that won't fly.  The papyrus fragment from the museum
in Hamburg actually has the solution, but remember that it's written
backwards.  If you think of the smooth round stone as a compass, then
you'll see that you should go northeast, east, and then south before
typing 'anoppe.'  You will be immediately hustled over to the palace
balustrade.  Put the astrolabe on the mounting and then look through
the eyepiece...
	...And here you are, at the old church, ready for the last few
obstacles.  Before going on, I just want you to remind yourself that
you're going to all of this trouble just to obtain a street map of
Paris -- I thought you should try to keep your goal in perspective. 
Pick up the adamantine hand from the spire and then drop down twice to
the parish.  Go west, and you'll find an adamantine knight lying there.
Put the hand on the statue, and then screw it on tightly.  Do the same
with the head, and finally the heart will be the finishing touch.  Use
the Rod of Fire to do your Doctor Frankenstein bit, and be kind, this
guy's a little bit on the stupid side.  Point east, and follow, then
point east again and follow.  Give the marble rose to the knight and
then show him the keepsake which Sosostris gave you ('show keepsake to
knight').  Once that's taken care of, point west and follow.
	This is another 'guess the verb' problem.  What you need to do is
type 'knight, open stone.'  The knight will be confused.  Now just type
'open stone' to show the knight what you mean, and if that doesn't
work, try 'knight, open stone' a second time.  Once the stone is out of
the way, point down, and your good friend the knight will go bye-bye. 
Now you've got three High Rods, and honestly I don't think it matters
which one you choose; I usually choose Love because I'm sappy. 
Careful, though, those things are hot!  Use the Rod of Ice to cool down
the one you want and then feel free to take it -- you can't stop the
others from falling away.
	Using this route, dealing with Old Evans is essentially optional. 
Since I made you go to the trouble of getting the watch, though, we
might as well take care of this.  Evans has a mascot, which is actually
a "moon" card which we could have used a while ago to get into the
church.  If you want to grab it anyway, then go south out of the church
and hypnotise Evans with the watch.   Once he's under, 'Evans, give me
the mascot' will score you a few more points and the moon card (which,
as I've already pointed out, is useless now that you've finished with
the church).  If you feel guilty about stealing from the poor old guy,
then head back up to Alison's room and, while HOLDING the statue of the
extremely ugly animal, look in the mirror.  Evans will gain a pet, and
you'll gain an eased conscience.
	Now, before we do the endgame, there's one more little puzzle we want
to take care of.  Pick up that golden orb from earlier and clean it. 
This part is a little strange, so I'll lead you through the reasoning. 
If you wait around a while, you will discover that you are basically
inside of a chess game.  If you looked up Helene in the history
earlier, you should have noticed that she had a husband named Anton. 
If you look up Anton in the history, you'll find that he was a
chessplayer with a flair for sacrifices.  So there you have it -- use
the Rod of Sacrifice on white and the orb will be sparkling and golden
and ready for the last step.  Head back to the dumbwaiter, go down to
the cellar, and go west, where you'll find that the long wrought iron
key will unlock this last door to the northwest.
	It's time to find a home for all of these rods you've collected. 
Fill the nine sockets with nine of the ten rods, holding onto the Rod
of Infinity.  For your benefit, the ones that should go in sockets are:
Bronze, Fire, Ice, Husbandry, Luck, Returning, Sacrifice, Stalking, and
the High Rod which you chose.  Then put the orb into the spherical
opening, strike the Rod of Infinity, and point it at the lemniscus.
	Hence, the master game -- your last chance to solve a complete
portion of the game on your own.  Take advantage of it, because once
you've gotten this far the rest is a piece of cake.
	You are now wonderfully empty-handed.  Get the torch, head west, and
go down the rope.  You can't quite reach the yellow daisy yet, so swing
the rope and then grab it.  Wear the daisy (these things are just so
damn useful!) before going back up and east.  Head northeast, then
east, and then south.  Get the horn, continue south, and then east. 
Get the sandals and wear them -- the die, for all intents and purposes,
is useless.  Next, go west twice, open the the cover, and put the torch
into the well -- this is important, because otherwise you wouldn't be
able to guage the distance.  Go down into the well, and then east,
putting you underneath the hypocaust.  From this convenient hiding
place, blow the horn, and then -- surprise! -- wave the horn.  Use the
Rod of Language on yourself in the usual manner, and then kick back and
listen as the real reasons for this exhausting quest are revealed. 
When the druids are done talking, go west and up into the waiting hands
of the enemy.
	For now, there's not a heck of a lot you can do, so wait a few turns
until the saxon spy is thrown into the tent with you.  Now you want to
get the pole, thus collapsing the tent, before you head east over the
hot coals (good thing you're wearing those sandals!).  Now, get the
blue stone and wave the tent pole.  I'm sure you know what to do next.
	Once you're safely back at Meldrew Hall, get the book of poetry and
read it.  This time go east and down.  Now, the coup de grace -- wave
the blue stone, and give the fifty-franc note to the map man.  His
question is "What do you want?"  Although I have a feeling he knows
perfectly well what "map" means, you want to "say carte."  Your old
friend at the river will help you get back to Meldrew Hall, and just
for the sake of closure, go back to the attic where the game began and
go down.

	And that's it!  I strongly suggest that you take a look at the
"amusing" things to do section, because it covers a lot which this
walk-through does not, including some of the other optional puzzles
which aren't as much fun.  If you have any questions or comments,
please feel free -- oh hell, feel obligated -- to e-mail me:
rbryan@netcom.com

	After using this walkthrough, you should have 554 out of 550 possible
points.  I have heard tell, however, that some have earned even more. 
If you know of any point-scoring puzzles which I have not found, please
let me know.

-- Russ Bryan, 11/11/94

Appendix:

Things to look up in the dictionary of Mythology:

Aeschylus, Agamemnon, Alexander, Alexandria, Andromeda, Aphrodite,
Apollo, Apollonius, Ares, Arthur, Athene, Callimachus, Chlamys,
Demeter, Diana, Dionysus, Eraina, Eumenides, Galita, Hades, Helicon,
Hephaetus, Hera, Homer, Iliad, Kraken, Leda, Loxias, Menelaus, Odyssey,
Odysseus, Pan, Perseus, Pharos, Pluto, Poseidon, Ptolemy, Pythian,
Selenae, Sosostris, Syrinx, Ulysses, Zeus

People to look up in the History of the Meldrews:

Peter, Joshua, Ebeneezer, Isaac, Roger, Alison, Helene, Henri, Anton,
Capability, Gerard, and Graham (sort of)

Objects you can 'lagach':

the mosaic, the mural at the crypt, the impressionist mural painting in
Paris, the still life in Hamburg, the painting of Mad Isaac when
mounted, the Greek frieze, and the writings in Alexandria

