#include <adv3.h>
#include <en_us.h>
versionInfo: GameID
  name = 'Split Game Demo'
  version = '0.3'
  byline = 'by Chris Odhner'
  htmlByline = 'by <a href="mailto:trask@tinaa.com">Chris Odhner</a>'
  authorEmail = 'Chris Odhner <trask@tinaa.com>'
  desc = 'A small demonstration of two separate games driven by a single command line.'
  htmlDesc = 'A small demonstration of two separate games driven by a single command line.'
  licenseType = 'Public Domain'
  copyingRules = 'No Restrictions; Compilations Allowed'
  presentationProfile = 'Multimedia'
  showAbout()
  {
    "<i>SplitGame</i><.p>
    This is actually two games in one; every command you type is
    executed by two different characters in two different worlds.
    It might be challenging to find commands that cause good
    effects in one world without causing trouble in the other.\n
    <.p>
    Type Xyzzy to win the game.\n";
  }
  showCredit()
  {
    libMessages.showCredit(name, htmlByline);
    "\b";
  }
;
gameMain: GameMainDef
  initialPlayerChar = god
  showIntro()
  {
    leftWindow.captureOutput({: leftIntro()});
    rightWindow.captureOutput({: rightIntro()});
  }
  leftIntro()
  {
    me1.lookAround(true);
  }
  rightIntro()
  {
    me2.lookAround(true);
  }
;
modify ModuleID
  showCredit()
  {
    libMessages.showCredit(name, htmlByline);
    "\b";
  }
;
god: ActorInstanceDriver;
me1: ActorInstance
  location = me1FirstRoom
;
me2: ActorInstance
  location = me2FirstRoom
;


/* Every Game needs an XYZZY command. */

DefineIAction (Xyzzy)
  execAction()
  {
    /* We don't actually do anything here; instead
       it's best to re-direct this action to a method
       specific to each Actor. That way it's easy to
       have different Actors react in different ways
       to the "xyzzy" command.  */
    gActor.xyzzyNow();
  }
;

/* here's where we define the syntax for the command. */

VerbRule(Xyzzy)
  'xyzzy' | 'plugh'
  : XyzzyAction
  verbPhrase = 'XYZZY/XYZZYing'
;

/* and here is where we specify the default behaviour when an
   Actor is given orders to XYZZY. */

modify Actor
  xyzzyNow 
  { 
    rightWindow.captureOutput({: libMessages.showFinishMsg('You Have Won')});
    finishGameMsg('You Have Won', [finishOptionUndo]);
  }
;

me1FirstRoom: Room
  'Starting Room'
  "This is the boring starting room. A passage slopes downward to the south.\n"
  north = me1SecondRoom
  down asExit(north)
;
+ me1Sword: Thing 'sword' 'sword' "This is a dreadfully sharp broadsword.\n";
+ me1Potato: Thing 'potato' 'potato' "Just a potato.\n";
+ me1greenFrog: Thing 'green frog' 'small green frog' "This is a small green
frog.\n";

me1SecondRoom: Room
  'Second Room'
  "This room is boring too. A passage slopes upward to the north.\n"
  south = me1FirstRoom
  up asExit(south)
;

me2FirstRoom: Room
  'Starting Room'
  "This room is slightly more exciting than the one me1 has to deal with.
   A level passage leads to the south, where certain doom awaits. A boring
   passage leads to the east.\n"
  north = me2death
  east = me2SecondRoom
;
+ me2sword: Thing 'sword' 'sword' "This is a flimsy plastic toy sword.\n";
+ me2redFrog: Thing 'red frog' 'small red frog' "This is a small red frog.\n";
+ me2blueFrog: Thing 'blue frog' 'small blue frog' "This is a small blue frog.\n";

me2SecondRoom: Room
  'Second Room'
  "This is a relatively boring room, but certainly much safer than going north from the Starting Room (which lies to the west).\n"
  west = me2FirstRoom
;

me2death: Room
  'You have died.'
  "I was going to make you die when you came here, but I am bugfixing and
   a simple message is easier for me to work with right now. Just pretend
   that you are dead.\n"
   south = me2FirstRoom
;
