#charset "us-ascii"

/*
 *   Copyright (c) 1999, 2002 by Michael J. Roberts.  Permission is
 *   granted to allone to copy and use this file for any purpose.  
 *   
 *   This is a starter T3 source file.  This is designed for a project
 *   that doesn't require any of the standard TADS 3 adventure game
 *   libraries.
 *   
 *   To compile this game in TADS Workbench, open the "Build" menu and
 *   select "Compile for Debugging."  To run the game, after compiling it,
 *   open the "Debug" menu and select "Go."
 *   
 *   This starter file is intended for people who want to use T3 to create
 *   projects that don't fall into the usual TADS 3 adventure game
 *   patterns, so it doesn't include any of the standard libraries.  If
 *   you want to create a more typical Interactive Fiction project, you
 *   might want to create a new project, and select the "introductory" or
 *   "advanced" option when the New Project Wizard asks you what kind of
 *   starter game you'd like to create.  
 */

#include <tads.h>
#include "relation.h"

/*
 *   The main entrypoint - the T3 virtual machine calls this function to
 *   start the program running.  'args' is a list of strings giving the
 *   command-line arguments that the user specified, if any. 
 */
main(args)
{
    local ret1, ret;
    local set1, set2, set3;

    ret = Woman.subset({x: x.parms.car() == joan});
    ret = MakeSet('A', 1,2,3);
    ret = ret.subset({x: x > 2});
    ret = ret.powerset().toList();
    ret = MakeSet('g');
    MakeElem(ret, 1);
    MakeElem(ret, 2);
    MakeElem(ret, 3);
    MakeElem(ret, 4, 5, 6);
    ret     = MakeRelSet('g');
    MakeElem(ret, 1, 2);
    MakeElem(ret, 2, 2);
    ret     = MakeSet('Gamma', B,C,D);
    ret     = ret.powerset();   
    set1    = MakeSet('s1', A);
    MakeElem(set1, B,C);
    set2    = MakeSet('s2', B,C,D);
    set3    = set1.xor(set2);
    ret = Woman.powerset();
    ret = RelationObject.getMembershipList(jean);
    ret1 = Woman.hasElement(jean);
    ret1 = Search(Woman, jean);
    ret = ret1.equals(Woman);
    ret = ret1.isSubsetOf(Woman);
    ret = Woman.isSubsetOf(ret1);
    ret = Woman.isSupersetOf(ret1);

    /*
     *  An example of a compound statement
     */
    ret = Or(
        And(Search(Woman, any), Search(Healthy, any)),
        And(Search(Woman, any), Search(Wealthy, any)),
        And(Search(Woman, any), Search(Wise, any)));
}

A: object;
B: object;
C: object;
D: object;
E: object;
F: object;

Set(Alpha);
+ Element(A);
+ Element(B);
+ Element(C);

Set(Beta);
+ Element(D,E,F);

RelSet(Woman);
+ Element(jean);
+ Element(jane);
+ Element(joan);
+ Element(pat);

RelSet(Healthy);
+ Element(jim);
+ Element(jean);
+ Element(jane);

RelSet(Wealthy);
+ Element(jim);
+ Element(jean);
+ Element(jane);

RelSet(Wise);
+ Element(jean);

RelSet(f);
+ Element(1, 1);
+ Element(1, 2);
+ Element(1, 3);
+ Element(2, 1);
+ Element(2, 2);
+ Element(1, 1, 1);

RelSet(a);
+ Element(1);
+ Element(2);
+ Element(3);

RelSet(b);
+ Element(1);
+ Element(3);

jean: object;
jane: object;
joan: object;
pat: object;
jim: object;
bob: object;
vicki: object;