#include <adv.t>
#include <std.t>

startroom : room
  sdesc = "Cave"
  ldesc = "You are standing in a cave. "
;

screamVerb: deepverb
  verb = 'scream'
  sdesc = "scream"
  action( actor ) =
  {
     "Aaaaaiiiiieeeee!!!\n";
     "(You feel much better now.) ";
  }
;

screamatVerb: deepverb
  verb = 'scream at'
  sdesc = "scream at"
  doAction = 'Screamat'
;

waveVerb: deepverb
  verb = 'wave'
  sdesc = "wave"
  action( actor ) =
  {
    "You wave your hand at no one in particular. ";
  }
  doAction = 'Wave'
  ioAction( atPrep ) = 'WaveAt'
;

frog : item
  location = startroom
  noun = 'frog'
  adjective = 'ugly'
  sdesc = "ugly frog"
  adesc = "an ugly frog"
  ldesc = "You've never seen such an ugly frog in your entire life. "
  
  verDoScreamat(actor) = {}
  doScreamat(actor) = 
  {
    if (actor.isCarrying(frog))
    {
      "Startled, the frog tries to squirm out of your grip, but it can't
      seem to break free. ";
    }
    else
    {
      "Startled, the frog jumps several feet into the air.  
      When it lands, it glares at you, blinking its 
      protruding eyes.";
    }
  }
  
  verIoWaveAt(actor) = {}
  ioWaveAt(actor, dobj) = 
  {
    if (dobj == wand)
    {
      "You wave the wand at the frog, and much to your surprise, it
      turns into a beautiful princess! ";
      frog.moveInto(nil);
      princess.moveInto(actor.location);
    }
    else
    {
      "Nothing happens. ";
    }
  }
;

wand : item
  location = startroom
  noun = 'wand'
  adjective = 'magic'
  sdesc = "magic wand"
  ldesc = "The black wand has a silver tip which sparkles. "
  
  verDoWave(actor) = 
  {
    if (not actor.isCarrying(self))
    {
      "You're not holding the wand! ";
    }
    else
    {
      "You wave the wand around in the air.  The air seems to shimmer a
      bit, but nothing happens. ";
    }
  }
  verDoWaveAt(actor, iobj) = 
  {
    if (not actor.isCarrying(self))
    {
      "You're not holding the wand! ";
    }
    else if (iobj != frog)
    {
      "The air around <<iobj.thedesc>> seems to shimmer a bit, but
      nothing happens. ";
    }
  }
;

princess : Actor
  noun = 'princess'
  adjective = 'beautiful'
  sdesc = "beautiful princess"
  ldesc = "Wow!  She's stunningly beautiful.  When she smiles, your
  heart skips a beat. "
;

modify openVerb
  ioAction( withPrep ) = 'OpenWith'  
;

modify thing
  verDoScreamat(actor) = 
  {
    "You scream at <<self.thedesc>>, but it just sits there, unmoved. ";
  }
;
