////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: sibling() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _SIBLING_T_
#define _SIBLING_T_

#include <parent.t>

#pragma C+

/*
 *  sibling: function(o)
 *
 */
sibling: function(o) {
    local f, list, p;
    
    if (o == nil) return nil;
    p = parent(o);
    if (p == nil) return nil;
    list = p.contents;
    f = find(list, o);
    if (f == 1) return nil;
    return list[f-1];
}

#pragma C-

#endif /* _SIBLING_T_ */
