////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: commandPrompt() 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _COMMAND_PROMPT_T_
#define _COMMAND_PROMPT_T_

#pragma C+

#ifdef USE_HTML_PROMPT
/*
 *   commandPrompt - this displays the command prompt.  For HTML games, we
 *   switch to the special TADS-Input font, which lets the player choose
 *   the font for command input through the preferences dialog.
 */
commandPrompt: function(code) {
    /* display the normal prompt */
    "\b&gt;";

    /* 
     *   switch the font to TADS-Input - the standard text-only
     *   interpreter will simply ignore this, so we don't have to worry
     *   about whether we're using an HTML-enabled interpreter or not 
     */
    "<font face='TADS-Input'>";
}
#endif /* USE_HTML_PROMPT */

#pragma C-

#endif /* _COMMAND_PROMPT_T_ */
