////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: NestedRoom 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _NESTED_ROOM_H_
#define _NESTED_ROOM_H_

#include <nestedroomable.h>
#include <surface.h>

#pragma C+

/*
 *  NestedRoom: NestedRoomable, Surface
 *
 *  A special kind of Room that is inside another Room; Chairs and
 *  some types of Vehicles, such as inflatable rafts, fall into this
 *  category.  Note that a Room can be within another Room without
 *  being a NestedRoom, simply by setting its location property
 *  to another Room.  The NestedRoom is different from an ordinary
 *  Room, though, in that it's an "open" Room; that is, when inside it,
 *  the actor is still really inside the enclosing Room for purposes of
 *  descriptions.  Hence, the player sees "Laboratory, in the chair."
 *  In addition, a NestedRoom is an object in its own right,
 *  visible to the player; for example, a chair is an object in a
 *  Room in addition to being a Room itself.  The boardingPrep
 *  property displays the preposition in the status description; by
 *  default, it will be "in," but some subclasses and instances
 *  will want to change this to a more appropriate preposition.
 *  unboardingPrep is used to report what happens when the player
 *  gets out of the object:  it should be "out of" or "off of" as
 *  appropriate to this object.
 */
class NestedRoom: NestedRoomable, Surface
;

#pragma C-

#endif /* _NESTED_ROOM_H_ */
