////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: Lockable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _LOCKABLE_H_
#define _LOCKABLE_H_

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  Lockable: object
 *
 *  A class that can be locked and unlocked.  
 */
class Lockable: object
    isLockable  = true
    isLocked    = true
    myKey       = nil
    setIsLocked(setting) = {
        /* update my status */
        self.isLocked = setting;

        /* if there's another side, update it as well */
        if (self.otherSide != nil && self.otherSide.isLocked != setting)
            self.otherSide.setIsLocked(setting);
    }
    verDoLock(actor) = {
        if (self.isLocked) {
            "\^<<self.itIsDesc>> already locked! ";
        }
    }
    doLock(actor) = {
        if (self.isOpenable && self.isOpen) {
            "%You%'ll have to close <<self.theDesc>> first. ";
        } else {
            "Locked. ";
            self.setIsLocked(true);
        }
    }
    verDoLockWith(actor, io) = {
        if (self.isLocked)
            "\^<<self.itIsDesc>> already locked. ";
        else if (self.myKey == nil)
            "%You% %do%n't need anything to lock <<self.itObjDesc>>.";
    }
    doLockWith(actor, io) = {
        if (io == self.myKey) {
            "Locked. ";
            self.setIsLocked(true);
        }
        else
            "\^<<io.itNomDesc>> <<self.doesDesc>>n't fit the lock. ";
    }
    verDoUnlock(actor) = {
        if (!self.isLocked)
            "\^<<self.itIsDesc>> not locked! ";
    }
    doUnlock(actor) = {
        "Unlocked. ";
        self.setIsLocked(nil);
    }
    verDoUnlockWith(actor, io) = {
        if (!self.isLocked)
            "\^<<self.itIsDesc>> not locked! ";
        else if (self.myKey == nil)
            "%You% %do%n't need anything to unlock << self.itObjDesc >>.";
    }
    doUnlockWith(actor, io) = {
        if (io == self.myKey) {
            "Unlocked. ";
            self.setIsLocked(nil);
        }
        else
            "\^<<io.itNomDesc>> <<self.doesDesc>>n't fit the lock. ";
    }
;

#pragma C-

#endif /* _LOCKABLE_H_ */
