////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: EnterableActionable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _ENTERABLE_ACTIONABLE_H_
#define _ENTERABLE_ACTIONABLE_H_

#include <nestedroomactionable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  EnterableActionable: NestedRoomActionable
 *
 *  Rules for room actions in an Enterable-style room.
 */
class EnterableActionable: NestedRoomActionable
    roomCheck(v) = {   
    	if (v == getOutVerb)
    		return true;
    	else pass roomCheck;
    }
    roomAction(a, v, d, p, i) = {
        if (!(v == getOutVerb && d == self))
            pass roomAction;
    }
    
    roomDrop(obj) = {
        if (!self.canSenseLocations(touch, nil)) {
            "Dropped. ";
            obj.moveInto(self);
        } else pass roomDrop;
    }

    verDoTake(actor) = {
        if (actor.isIn(self))
            "%You% can't have <<self.theDesc>> while %you're% 
            <<actor.posture.desc>> <<self.boardingPrep>> 
            <<self.itObjDesc>>! ";
        else if (actor.isCarrying(self))
        	"%You% already %have% <<self.theDesc>>! ";
    }
    
    verDoTakeOut(actor, iobj) = {
        self.verDoTake(actor);
    }
    
    verDoDrop(actor) = {
        if (actor.isIn(self))
            "%You% can't drop <<self.theDesc>>. ";
    }
    
    verDoTakeOff(actor, iobj) = {
        self.verDoTake(actor);
    }
    
    verDoPutIn(actor, iobj) = {
        if (actor.isIn(self))
            "%You% can't put <<self.theDesc>> anywhere while %you're% 
            <<actor.posture.desc>> <<self.boardingPrep>> 
            <<self.itObjDesc>>. ";
    }
    
    verDoPutOn(actor, iobj) = {
        if (actor.isIn(self))
            "%You% can't put <<self.theDesc>> anywhere while %you're% 
            <<actor.posture.desc>> <<self.boardingPrep>> 
            <<self.itObjDesc>>. ";
    }
    
    verDoMove(actor) = {
        if (actor.isIn(self))
            "%You% can't move <<self.theDesc>> anywhere while %you're% 
            <<actor.posture.desc>> <<self.boardingPrep>> 
            <<self.itObjDesc>>. ";
    }
    
    verDoThrowAt(actor, iobj) = {
        if (actor.isIn(self))
            "%You% can't throw <<self.theDesc>> anywhere while %you're% 
            <<actor.posture.desc>> <<self.boardingPrep>> 
            <<self.itObjDesc>>. ";
    }
;

#pragma C-

#endif /* _ENTERABLE_ACTIONABLE_H_ */
