////////////////////////////////////////////////////////////////////////
//  
//  ALT Library File: ChairActionable 010123
//
//  Copyright (c) 2000, 2001 Kevin Forchione. All rights reserved.
//  Based on ADV.T (c) and STD.T (c) Michael Roberts.
//
//  This file is part of the ALT replacement library for ADV.T and 
//  STD.T and requires TADS 2.5.1 or later.
//
////////////////////////////////////////////////////////////////////////

#ifndef _CHAIR_ACTIONABLE_H_
#define _CHAIR_ACTIONABLE_H_

#include <nestedroomactionable.h>

#pragma C+

/*----------------------------------------------------------------------
 *  MIX-IN CLASS:   This class must always preced any non-mix-in classes
 *                  in a superclass list - this is required because a
 *                  mix-in can't override default methods in the root of
 *                  the hierarchy.
 *--------------------------------------------------------------------*/

/*
 *  ChairActionable: NestedRoomActionable
 *
 *  Rules for room actions in a Chair-style room.
 */
class ChairActionable: NestedRoomActionable
    reachable = ([] + self) // list of all containers reachable from here;
                            //  normally, you can only reach carried items
                            //  from a chair, but this makes special allowances

    /*
     *   For compatibility with past versions of adv.t, we do not allow
     *   the player to reach objects that are inside objects that are in
     *   the reachable list.  This behavior probably doesn't make a lot of
     *   sense in most cases, and isn't consistent with other types of
     *   nested rooms, so many games will probably want to modify
     *   chairItem and set canReachContents = true.  However, since it
     *   worked this way in the past, the default is still nil, so that
     *   any games that (intentionally or otherwise) depended on this
     *   behavior will continue to work the same way they used to.  
     */
    canReachContents = nil
;

#pragma C-

#endif /* _CHAIR_ACTIONABLE_H_ */
