/* Perdition's Flames - desolate plains, wastelands, cave of fire */
// copyright (c) 1993, 2002 by Michael J. Roberts.

gravelpath: room
    sdesc = "Gravel Path"
    ldesc = "You're on a gravel path that leads east and west.  The
        terrain is growing quite dry and rocky to the west; the air
        is too dusty to see very far west.  A small wooden sign is
        posted here."
    east = suburbWest
    west = desolatePlain
;

cigaretBox: qcontainer
    sdesc = "cigarette box"
    noun = 'box'
    adjective = 'cigaret' 'cigarette' 'trash' 'litter'
    isplaced = nil
;

cigaret: item
    sdesc = "cigarette" 
    noun = 'cigaret' 'cigarette'
    location = cigaretBox
;

gravelpathSign: fixeditem, readable
    sdesc = "sign"
    noun = 'sign'
    adjective = 'small' 'wooden'
    location = gravelpath
    ldesc =
    {
        "\b\t\t\t\tHell Nature Preserve
        \b\b\tYou are now entering the Hell Nature Preserve.  This
        \n\tarea has been set aside to preserve a small part of
        \n\tHell in its original state, as it was before urbanization
        \n\ttransformed Hell into what we know today.  Please don't
        \n\tlitter -- keep Hell beautiful!";

        if (not cigaretBox.isplaced)
        {
            "\bAfter reading the sign, you notice that someone has
            flagrantly violated the plea not to litter -- someone
            has carelessly tossed a cigarette box on the ground here.";

            cigaretBox.isplaced := true;
            cigaretBox.moveInto(self.location);
        }
    }
;

desolateRocks: fixeditem
    sdesc = "rock"
    noun = 'rock' 'rocks' 'pebbles'
    adjective = 'sharp' 'small'
    location = desolatePlain
    ldesc = "They're just rocks."
;

desolateSand: fixeditem
    sdesc = "sand"
    noun = 'sand'
    location = desolatePlain
    ldesc = "The ground is hard-packed sand covered with small, sharp rocks."
;

desolatePlain: room
    sdesc = "Desolate Plain"
    ldesc = "You're on the east edge of a desolate plain.  The
        ground is hard-packed sand covered with small, sharp rocks.
        The plain extends to the west as far as the
        eye can see.  You notice that you can see for a very long
        distance; the ground does not seem to have any curvature
        at all, and there is no distinct horizon.  Only sheer distance
        seems to obscure your view of what may be an infinite plain.
        \n\tYou can see a red glow to the north, and the city
        lies back to the east.  The plain stretches off without
        any distinguishing features in all other directions."
    east = gravelpath
    west =
    {
        "You walk for what seems like a very long time, but every
        time you look back, you realize that you are no further
        from the city.";
        return(nil);
    }
    south = { return(west); }
    ne = { return(west); }
    se = { return(west); }
    nw = { return(west); }
    sw = { return(west); }
    north = wastelands
;

wastelands: room
    sdesc = "Wastelands"
    ldesc = "You are on a vast, desolate plain.  The ground is hot
        here; steam rises from cracks in the dry soil, and the warm,
        damp air smells strongly of sulfur.  The area is littered with
        debris:  decaying bones of strange animals, broken parts from
        ancient machinery, pools of tar and oil.  The plain continues
        off in all directions; it was somewhat more pleasant to the
        south.  A bright red glow comes from the north."
    south = desolatePlain
    west =
    {
        "You walk for what seems like a very long time, but it
        seems as though you walk only in circles.  You keep
        walking past the same strange debris, and it doesn't
        seem to get any cooler.  After a great deal of walking,
        you realize that you're back where you started.";
        return(nil);
    }
    east = { return(west); }
    north = topOfPit
    ne = { return(west); }
    nw = { return(west); }
    se = { return(west); }
    sw = { return(west); }
;

oilpool: decoration
    location = wastelands
    sdesc = "pool of oil"
    adesc = "pools of oil"
    noun = 'oil' 'pool' 'tar' 'pools' 'debris'
    ldesc = "There's nothing special about it."
    verDoBurn(actor) = { askio(withPrep); }
    doSynonym('Burn') = 'Light'
    verDoBurnWith(actor, iobj) =
    {
        "The pool of oil refuses to light.";
    }
    doSynonym('BurnWith') = 'LightWith'
;

desolateBones: decoration
    location = wastelands
    sdesc = "pile of bones"
    adesc = "some bones"
    noun = 'bones' 'skull' 'bone' 'debris' 'pile'
    adjective = 'strange' 'animal'
    ldesc =
    {
        "The bones are of no animals you've ever seen.  Some of
        them look almost human, but not quite. ";
        if (not appointmentCard.isTaken)
            "As you look more closely, you notice a human-looking
            skeleton underneath some of the strange animal bones.";
    }
    verDoLookunder(actor) = {}
    doLookunder(actor) =
    {
        if (not appointmentCard.isTaken)
            "There's a human-looking skeleton underneath some of
            the bones, but you can't make out much with all the
            other bones covering it.";
        else
            "You see nothing underneath.";
    }
    isMoved = nil
    tryMove(actor, obj) =
    {
        if (isMoved) "You've already disturbed them enough.";
        else
        {
            "As << obj <> nil ? obj.thedesc : "your hand" >> approaches the
            pile of bones, bright blue electric arcs jump toward you";
            if (rubberGloves.isIn(actor) and rubberGloves.isworn)
            {
                ", but the rubber gloves provide some protection.
                As you start to move the pile, it collapses,
                and sparks fly throughout the pile.  You jump back from the
                fireworks.  Once the smoke has cleared, you see that a
                human skeleton has been uncovered.";
                isMoved := true;
            }
            else
                ". You jump back in pain as the electricity shoots
                through your body.";
        }
    }
    verDoTake(actor) = {}
    doTake(actor) = { self.tryMove(actor, nil); }
    doSynonym('Take') = 'Move' 'Push' 'Pull'
    verDoPryWith(actor, iobj) = {}
    doPryWith(actor, iobj) = { self.tryMove(actor, iobj); }
    doSynonym('PryWith') = 'TakeWith' 'MoveWith' 'PullWith' 'PushWith'
;

appointmentCard: item
    sdesc = "appointment card"
    adesc = "an appointment card"
    ldesc = "It's an appointment card for a driver's license test.
        It doesn't seem to specify a time or date; it's probably
        good any time."
    noun = 'card'
    adjective = 'appointment'
    doTake(actor) =
    {
        inherited.doTake(actor);
        if (not self.isTaken)
        {
            self.isTaken := true;
            awardPoints(13, self);
        }
    }
;

desolateSkeleton: fixeditem
    location = wastelands
    isqcontainer = true
    sdesc = "human skeleton"
    noun = 'skeleton' 'hand'
    adjective = 'human' 'human-looking' 'bony'
    ldesc =
    {
        if (desolateBones.isMoved)
        {
            "The skeleton has been stripped of flesh; only the bright
            white bones remain. ";
            if (appointmentCard.location = self)
                "The bony hand is clutching a small card.";
            else if (not appointmentCard.isTaken and desolateBones.isMoved)
            {
                appointmentCard.moveInto(self);
                "You notice that the skeleton's bony hand is clutching
                a small card.";
            }
        }
        else
            "You can't see much; it's mostly covered by the strange
            animal bones.";
    }
    dobjGen(a, v, i, p) =
    {
        if (v <> inspectVerb)
        {
            "You can't get to the skeleton; it's covered by
            the strange animal bones.";
            exit;
        }
    }
    iobjGen(a, v, d, p) =
    {
        "You can't get to the skeleton; it's covered by
        the strange animal bones.";
        exit;
    }
;

machineparts: decoration
    location = wastelands
    sdesc = "machine part"
    adesc = "some machine parts"
    noun = 'parts' 'part' 'protrusions' 'debris' 'machinery'
    adjective = 'machine' 'broken' 'ancient'
    ldesc = "Most of the parts are gigantic, some standing several feet
        high.  The parts are all made of dark, rough metals that look
        like wrought iron; they have myriad sharp protrusions and
        appendages.  You can't imagine what these parts are or what
        machines they come from."
;

topOfPit: room
    sdesc = "Top of Crater"
    ldesc = "You're standing at the top of an enormous crater, which
        is at least several hundred feet in diameter and almost as
        deep.  Strangely, the ground around the crater is not lifted
        as you would expect of an impact crater; it is more like the
        result of excavation.  The sides of the crater are very
        steep, but it looks as though you could climb down with some
        effort.  The depths of the crater are obscured by a dense
        fog, but a wavering red glow penetrates the fog from below.
        Overpowering sulfurous fumes fill the air, and waves of heat
        and steam rise from below."
    south = wastelands
    east = wastelands
    west = wastelands
    se = wastelands
    sw = wastelands
    north =
    {
        "You can't go that way; as you may have noticed, there's a
        huge crater in the way.";
        return(nil);
    }
    ne = { return(north); }
    nw = { return(north); }
    down = bottomOfPit
;

bottomOfPit: room
    sdesc = "Bottom of Crater"
    atmosnum = 0
    atmosphere =
    {
        if (Me.location <> self) return;

        "\b\t";
        if (++atmosnum > 5) atmosnum := 1;
        switch(atmosnum)
        {
        case 1:
            "One of the large rocks on the pit floor suddenly
            bursts into flames. You jump back and shield your
            eyes from the blinding fire. After a few moments,
            the fire subsides, and all that's left of the rock
            is a thick black cloud of sulfurous fumes that slowly
            dissipates.";
            break;

        case 2:
            "You hear a rumbling sound under your feet. The rumbling
            increases in intensity until the sound is deafening, and
            the ground is shaking violently.  As you try to maintain
            your balance, several rocks are suddenly blown upward
            as a huge steam geyser blasts through the surface. You
            jump backward away from the jet of pressurized steam.
            Eventually, the geyser weakens, and finally stops.";
            break;

        case 3:
            "You hear a noise overhead, and look up to see a number
            of rocks come sliding down the side of the crater.  You
            jump out of the way just in time.";
            break;

        case 4:
            "A stream of molten lava abruptly starts pouring out
            of the side of the crater.  The glowing stream of
            liquid rock slowly cools into yet more hot rocks at
            the floor of the crater.";
            break;

        case 5:
            "A thick cloud of dust drifts down from the side of
            the crater. You watch the cloud as it slowly meanders
            through the complex air currents driven by the hot
            crater floor.  As the cloud approaches the hot rocks
            at the bottom of the crater, it suddenly catches
            fire; you leap back as the cloud almost instantly
            vanishes in a searing wall of flame.";
            break;
        }
    }
    enterRoom(actor) =
    {
        if (not self.isseen) notify(self, &atmosphere, 0);
        pass enterRoom;
    }
    ldesc =
    {
        "You're at the bottom of the crater.  The floor of
        the crater is littered with huge, sharp rocks, making
        travel very difficult, and the ground is so hot that it
        glows red.  It looks as though you could climb back up
        the crater wall. ";

        if (craterDoor.isopen)
            "To the northeast is a narrow passage
            leading into an underground cave.";
        else
            "To the northeast is a huge stone slab.";
    }
    up = topOfPit
    ne = craterDoor
;

pitRocks: fixeditem
    sdesc = "rock"
    noun = 'rocks'
    adjective = 'huge' 'sharp' 'large'
    ldesc = "They're ordinary rocks."
    location = bottomOfPit
    verDoTake(actor) = { "You don't need any rocks."; }
;

craterDoor: obstacle, fixeditem
    location = bottomOfPit
    destination =
    {
        if (self.isopen)
            return(caveLedge);
        else
        {
            "You'll have to move <<thedesc>> out of the way first.";
            return(nil);
        }
    }
    sdesc = "huge stone slab"
    noun = 'slab' 'rock'
    adjective = 'huge' 'stone'
    isopen = nil
    ldesc =
    {
        if (isopen)
            "It has rotated into the rock wall, revealing
            a narrow passage to the northeast.";
        else
            "It's about ten feet tall and five feet wide.
            In the center of the slab, you notice three small
            holes, arranged in a horizontal line, six
            inches apart.";
    }
    verDoOpen(actor) =
    {
        if (isopen) "It's already open!";
        else "There's no obvious way to do that.";
    }
    verDoClose(actor) =
    {
        if (not isopen) "It's already closed!";
        else "There's no obvious way to do that.";
    }
    verDoMove(actor) = { "It's too big for you to move."; }
    verDoMoveWith(actor, iobj) = { self.verDoMove(actor); }
    doSynonym('Move') = 'Push' 'Pull'
;

craterSlabHoles: fixeditem
    sdesc = "line of holes"
    noun = 'hole' 'holes' 'line'
    location = bottomOfPit
    ldesc = "There are three holes, each about half an inch in
        diameter, arranged in a horizontal line, and spaced about six
        inches apart. You can't tell how deep the holes are."
    verDoLookin(actor) = { "You can't see anything in the holes."; }
    verIoPutIn(actor) =
    {
        if (craterDoor.isopen)
            "You can't fit anything in the holes with the
            slab in this position.";
    }
    ioPutIn(actor, dobj) =
    {
        if (dobj = pitchfork)
        {
            "You slide the pitchfork's prongs into the holes, and
            discover that it's an exact fit!  You hear a deep, loud
            rumbling sound from behind the slab.  You cautiously
            remove the pitchfork from the holes, and stand back.
            The slab slowly starts to rotate.  It turns until a
            narrow passage is revealed to the northeast, then
            the rumbling ceases.";
            craterDoor.isopen := true;
            awardPoints(13, self);
        }
        else
            "That doesn't seem to fit.";
    }
;

caveLedge: room
    sdesc = "Ledge"
    ldesc = "You're on a ledge fifty feet above the floor of a huge cave.
        The cave below is engulfed in flames.  Fire shoots out
        of vents in the rock; pools of oil on the ground burn
        slowly, releasing thick black clouds of smoke; even some
        of the rocks themselves smolder and burn. Across the cave
        on the north side, you can see a wide, dark lake; some distance
        into the lake is a small island.  You can probably climb down
        the gently sloping walls of the cave to the floor below,
        and a narrow passage leads outside to the crater to the
        southwest."
    sw = bottomOfPit
    down = caveFloor
;

caveFloor: room
    sdesc = "Floor of Fire Cave"
    ldesc = "You're on the floor of the huge cave of fire.  It's
        extremely difficult to see where you're going due to all
        of the fire and smoke.  High above on the cave wall, you
        can see a ledge; you think you'll be able to climb
        back up the wall.  The only path you can see through the
        cave is to the north."
    up = caveLedge
    north =
    {
        "You slowly make your way through the dense flames.
        You realize that this cave must be totally devoid of
        oxygen -- certainly it's all being consumed by the
        raging fires.  It's lucky you're already dead, you
        think to yourself.\b";
        return(caveShore);
    }
;

caveShore: room
    sdesc = "Rocky Shore"
    ldesc = "You're at the north end of the fire cave, standing on
        the rocky shore of a huge, still lake.  The water is black --
        so black that it
        barely reflects the brilliant light of the fires.  In the
        middle of the lake, you can see a small island.  The fire
        cave lies to the south, and you could wade into the water
        to the north."
    south = caveFloor
    north = caveLake
;

island1: distantItem
    sdesc = "island"
    location = caveShore
    noun = 'island'
    adjective = 'small'
    ldesc = "The island is some distance into the lake.  You
        can't make out any details from here."
;

class lakewater: fixeditem
    verDoWade(actor) = {}
    doWade(actor) =
    {
        if (actor.location = caveLake)
            "You're already in the water!  If you want to go somewhere,
            just use the direction you want to travel.";
        else
            actor.travelTo(caveLake);
    }
    doSynonym('Wade') = 'Swim' 'Enter'
    sdesc = "lake water"
    noun = 'water' 'blood' 'lake'
    adjective = 'black' 'lake'
    ldesc =
    {
        /* don't use self.isseen - instead, use property in class object */
        if (lakewater.isseen)
            "You hesitate to put your hand in the lake of human
            blood again, or even to look at it that closely.";
        else
            "You dip your hand into the dark water.  The water is hot
            and thick.  As you pull your hand out, and see the dark red
            fluid dripping off, you realize that the lake is
            filled not with water, but with human blood. You jump back
            and shake your hand violently to clean it of the horrifying
            liquid.";
        lakewater.isseen := true;
    }
    verIoFillWith(actor) = {}
    ioFillWith(actor, dobj) = { self.verDoPutIn(actor, dobj); }
    verDoPutIn(actor, iobj) =
    {
        "You try to scoop up some of the horrifying fluid,
        but every time you do, the blood boils away as soon
        as you remove << iobj.thedesc >> from the lake.";
    }
    verIoPutIn(actor) =
    {
        "You don't want to put anything in the horrifying fluid.";
    }
;

lakewater1: lakewater
    location = caveShore
;

lakewater2: lakewater
    location = caveLake
;

caveLake: room
    sdesc = "Lake"
    ldesc =
    {
        "You're wading in the lake.  The shore is to the south.
        An island lies some distance to the north. ";
        if (not lakewater.isseen)
        {
            "\n\tThe water is hot and thick.  You momentarily dip
            your hand into the water.  When you pull it out, you see
            dark red fluid dripping off, and you realize that the lake
            is filled not with water, but with human blood.  You
            shake your hand violently to clean it of the horrifying
            liquid, but then you realize that you're standing
            waist-deep in it.";
            lakewater.isseen := true;
        }
    }
    south = caveShore
    enterRoom(actor) =
    {
        self.state := 1;
        pass enterRoom;
    }
    amuletList = [ braceletAmulet jewelAmulet goldDiskAmulet
                   silverRing ivoryBoat ]
    obstacleList =
    [
        'a terrible shrieking noise rings in your ears, so loud
        that it blurs your vision and makes you tremble in pain'
        'you feel freezing cold, as though you were embedded in
        a block of ice'
        'a terrible burst of searing heat shoots through your body,
        as though your clothes were on fire'
        'a blinding light forces you to cover your eyes'
        'you double over with painful stomach cramps and nausea'
    ]
    madeit = nil
    north =
    {
        if (state = 1 and madeit)
        {
            "You wade toward the island, expecting to be hit once
            again with waves of pain, but the lake seems to have
            lost its power to affect you.  This time, you easily
            make it across the lake and up onto the shore.\b";
            return(caveIsland);
        }
        if (state > length(amuletList))
        {
            "You finally make it up onto the island's shore.\b";
            return(caveIsland);
        }
        if (amuletList[state].isIn(Me) and amuletList[state].isworn)
        {
            ++state;
            if (state <= length(amuletList))
            {
                "You manage to wade a little further toward the island,
                but as you do, "; say(obstacleList[state]);
                ", and you are unable to get any further.";
                return(nil);
            }
            else
            {
                "You finally make it up onto the island's shore.\b";
                madeit := true;
                return(caveIsland);
            }
        }
        else
        {
            "You try to wade further north, but ";
            say(obstacleList[state]); ", and you can go no further.";
            return(nil);
        }
    }
;

lakewater3: lakewater
    location = caveIsland
;

distantPyramid: distantItem
    noun = 'pyramid'
    location = caveIsland
    sdesc = "pyramid"
    ldesc = "It rises high above the island floor to the north.
        You can't make out much detail from here."
;

caveIsland: room
    sdesc = "Island"
    ldesc =
    {
        "You're on the southern shore of an island.  Looking back
        to the south, you realize that the lake is much wider than
        you had originally thought -- you must be miles from the fire
        cave.
        \n\tBefore you, two columns of enormous stone statues form
        a corridor leading to the north.  The statues appear to stand
        hundreds of feet tall, and depict strange creatures with the
        bodies of men and the heads of different animals.  The statues
        face in along the corridor, and are standing so close together
        that you can't pass them to the east and west";

        if (lionStatue.position <> 0)
        {
            ", except that there is a gap in the line of statues to the east";
            if (lionStatue.location = self)
                ". One of the statues -- with a lion's head on a man's
                body -- has moved out of the column, and is standing in
                between the two columns, facing << lionStatue.dirdesc >>";
        }

        ".\n\tTo the north is a thicket of broken timbers, as though
        an explosion had levelled a dense forest";

        if (caveThicket.isbroken)
            "; a path has been cut through the center of the thicket";

        ". Beyond the thicket to the north, you see a pyramid rising up above
        the island floor.";
    }
    south = caveLake
    north =
    {
        if (caveThicket.isbroken)
            return(cavePyrBase);
        else
        {
            "You can't pass the thicket.";
            return(nil);
        }
    }
    east =
    {
        if (lionStatue.position = 0)
        {
            "You can't get by the statues.";
            return(nil);
        }
        else
            return(statueGap);
    }
    west =
    {
        "You can't get by the statues.";
        return(nil);
    }
;

statueGapStatues: fixeditem
    noun = 'statue' 'statues'
    adjective =  'north' 'northern' 'south' 'southern' 'huge'
    location = statueGap
    sdesc = "statue"
    ldesc = "You had a much better view from out in the corridor."
;

statueGapWall: fixeditem
    sdesc = "stone wall"
    noun = 'wall' 'cliff'
    adjective = 'stone'
    location = statueGap
    ldesc = "It's a rough stony wall. It looks climbable."
    verDoClimb(actor) = {}
    doClimb(actor) = { actor.travelTo(caveCliff); }
;

statueGap: room
    sdesc = "Between statues"
    ldesc = "You're in a gap in the eastern column of statues.
        Huge statues are on the north and south.  The corridor
        between the statues is back to the west.  To the east
        is a rough stone wall which looks climbable."
    west = caveIsland
    east = caveCliff
    up = caveCliff
;

caveStatues: fixeditem
    sdesc = "rows of statues"
    adesc = "a row of statues"
    noun = 'statue' 'statues' 'carving' 'carvings' 'row' 'rows'
    adjective = 'rock' 'stone' 'east' 'west' 'eastern' 'western'
    location = caveIsland
    ldesc =
    {
        "The statues tower above, hundreds of feet tall; they're
        lined up in a pair of columns, facing
        inward as though watching you.  They are elaborate
        carvings of strange creatures, with the bodies of men and
        the heads of various animals:   a horse, a lion, an eagle,
        a wolf, a reptilian monster.  They're all dressed in
        ancient armor -- some in chain mail, some in metal armor,
        some in what must be leather armor. ";

        switch(lionStatue.position)
        {
        case 0:
            "One statue in particular has unusual armor: the lion-headed
            statue on the east, which is clad in armor covered with
            regular spikes.";
            if (lionStatue.direction <> 4)
                " Unlike the other statues, though, the lion-headed statue
                is facing << lionStatue.dirdesc >>.";
            break;

        case 1:
            "Unlike the other statues, though, the lion-headed statue
            is out in between the two columns, facing << lionStatue.dirdesc
            >>, leaving a gap in the east column.";
            break;
        }

        if (not lionStatue.isseen)
        {
            lionStatue.moveInto(self.location);
            lionStatue.isseen := true;
        }
    }
;

lionStatue: fixeditem
    noun = 'statue'
    adjective = 'lion' 'lion-headed' 'lion-head' 'headed' 'head' 'eastern'
        'east'
    sdesc = "lion-headed statue"
    position = 0         // in the columns
    direction = 4        // N=1, E=2, S=3, W=4
    dirdesc = { say(['north' 'east' 'south' 'west'][direction]); }
    ldesc =
    {
        switch(position)
        {
        case 0:
            "It's in the eastern column";
            if (direction <> 4)
                ", but unlike the other statues, it is facing east";
            ". ";
            break;

        case 1:
            "It is standing between the rows of statues, facing
            << self.dirdesc >>, leaving a gap in the eastern column. ";
            break;

        case 2:
            "It is standing at the base of the pyramid,
            facing << self.dirdesc >>. ";
            break;
        }

        "It is clad in some sort of armor covered with regular spikes.";
    }
    verDoClimb(actor) = {}
    doClimb(actor) =
    {
        "Using the regularly-spaced spikes, you easily manage
        to climb up the statue. It's a very long way to the top,
        but you eventually find yourself sitting on the statue's
        shoulders.\b";
        actor.travelTo(lionRoom);
    }
;

lionStatue1: fixeditem
    location = lionRoom
    noun = 'statue' 'head'
    adjective = 'lion' 'lion-headed' 'lion-head' 'headed' 'head'
    sdesc = "lion-headed statue"
    verDoClimbdown(actor) = {}
    doClimbdown(actor) =
    {
        "You carefully climb back down the spikes...\b";
        actor.travelTo(caveIsland);
    }
    ldesc =
    {
        "You can see from here just how massive this statue really is,
        looking at the twenty-foot-wide head and sixty-foot-wide shoulders.
        Under the back of the neck, there are two foot-long vertical
        slots, each about an inch wide. ";
        self.slotdesc;
    }
    slotdesc =
    {
        if (lionLeftSlot.contents <> [])
        {
            "The left slot contains << lionLeftSlot.contents[1].adesc >>";
            if (lionRightSlot.contents <> [])
                ", and the right slot contains <<
                lionRightSlot.contents[1].adesc >>";
            ".";
        }
        else if (lionRightSlot.contents <> [])
            "The right slot contains << lionRightSlot.contents[1].adesc >>.";
    }
;

// this is a class for objects that can be used in the statue slots
class rodItem: item
    ldesc =
    {
        if (isclass(self.location, slotitem))
            " It's in << self.location.thedesc >>, and is currently
            positioned << ['at the bottom' 'in the center'
               'at the top'][self.location.slotpos + 2] >> of the slot.";
    }
    verDoMove(actor) =
    {
        "Be more specific:  say whether you want to move it up,
        move it down, or center it.";
    }
    doSynonym('Move') = 'Push' 'Pull'
    verifyMove(newpos) =
    {
        if (not isclass(self.location, slotitem))
            "That doesn't seem to be very useful just now.";
        else if (self.location.slotpos = newpos)
            "It's already <<
            ['all the way down' 'centered' 'all the way up'][newpos + 2]
            >>!";
    }
    moveRod(newpos) =
    {
        "Okay, << self.thedesc >> is now <<
            ['all the way down' 'centered' 'all the way up'][newpos + 2]
            >>. ";
        self.location.moveRod(newpos);
    }
    verDoMoveup(actor) = { self.verifyMove(1); }
    doMoveup(actor) = { self.moveRod(1); }
    verDoMovedown(actor) = { self.verifyMove(-1); }
    doMovedown(actor) = { self.moveRod(-1); }
    verDoCenter(actor) = { self.verifyMove(0); }
    doCenter(actor) = { self.moveRod(0); }
;

class slotitem: fixeditem
    noun = 'slot'
    plural = 'slots'
    location = lionRoom
    isqcontainer = true
    moveRod(newpos) =
    {
        self.slotpos := newpos;

        /* see what kind of motion we have */
        if ((self.slotpos = 1 and self.otherslot.slotpos = -1)
            or (self.slotpos = -1 and self.otherslot.slotpos = 1))
        {
            /* ROTATION */
            local rotdir;
        
            if (lionStatue.position = 1 or lionStatue.position = 2)
            {
                if ((self = lionLeftSlot and newpos = 1)
                    or (self = lionRightSlot and newpos = -1))
                    rotdir := 1;
                else
                    rotdir := -1;

                lionStatue.direction += rotdir;
                if (lionStatue.direction < 1) lionStatue.direction := 4;
                else if (lionStatue.direction > 4) lionStatue.direction := 1;

                "The statue vibrates and shakes as it picks up its
                feet and rotates to the << rotdir = 1 ? "right" : "left"
                >>. It is now facing << lionStatue.dirdesc >>.";
            }
            else
                "The statue vibrates and strains against the other
                statues, but it has no room to maneuver.";
        }
        else if (self.slotpos <> 0 and self.slotpos = self.otherslot.slotpos)
        {
            /* MOVE FORWARD OR BACKWARDS */
            local dir := (newpos = 1 ? 'forward' : 'backwards');

            if (lionStatue.position = 0 and
                ((lionStatue.direction = 4 and newpos = 1)
                 or (lionStatue.direction = 2 and newpos = -1)))
            {
                "The statue starts to vibrate and rumble with a terrible
                noise.  The vibration grows, until you feel the statue
                start to move!  You grab onto the rocky sculpture to
                hold on as the statues takes several paces <<dir>>,
                out into the corridor between the statues.  It finally
                comes to a halt in the center of the corridor.";

                awardPoints(13, lionStatue);
                lionStatue.position := 1;
            }
            else if (lionStatue.position = 0)
            {
                "The statue vibrates and rumbles, but is unable to
                move any further against the cliff wall.";
            }
            else if (lionStatue.position = 1 and
                     ((lionStatue.direction = 2 and newpos = 1)
                      or (lionStatue.direction = 4 and newpos -1)))
            {
                "The statue takes several paces <<dir>>, until it's
                back in its place in the eastern column";
                if (newpos = 1) " (although facing the wrong way)";
                ".";

                lionStatue.position := 0;
            }
            else if (lionStatue.position = 1 and
                     ((lionStatue.direction = 1 and newpos = 1)
                      or (lionStatue.direction = 3 and newpos = -1)))
            {
                if (caveThicket.isbroken)
                    "The statue takes several paces <<dir>>, coming
                    to rest at the base of the pyramid.";
                else
                {
                    "The statue takes several paces <<dir>>, crashing
                    effortlessly through the thicket of timber.  You
                    watch as the timber is snapped into pieces and tossed
                    aside like so many toothpicks.  The statue walks
                    up to the base of the pyramid, and comes to rest.";
                    
                    caveThicket.isbroken := true;
                }
                lionStatue.position := 2;
                lionStatue.moveInto(cavePyrBase);
                lionFootprints.moveInto(nil);
            }
            else if (lionStatue.position = 1)
            {
                if (lionStatue.direction = 2 or lionStatue.direction = 4)
                {
                    "The statue strains against the column of statues,
                    but is unable to move any further.";
                }
                else
                {
                    "The statue seems unwilling to move any further
                    toward the lake of blood.";
                }
            }
            else if (lionStatue.position = 2 and
                     ((lionStatue.direction = 3 and newpos = 1)
                      or (lionStatue.direction = 1 and newpos = -1)))
            {
                "The statue walks <<dir>>, back into the corridor between
                the columns statues.  It comes to rest just west of its
                original place in the column.";
                
                lionStatue.position := 1;
                lionStatue.moveInto(caveIsland);
                lionFootprints.moveInto(cavePyrBase);
            }
            else if (lionStatue.position = 2)
            {
                if (lionStatue.direction = 2 or lionStatue.direction = 4)
                {
                    "The statue strains against the huge boulders,
                    but is unable to move.";
                }
                else
                {
                    "The statue strains against the foot of the
                    pyramid, but can go no further.";
                }
            }
        }

        if (newpos <> 0 and self.otherslot.slotpos <> 0)
        {
            "\b\^<< self.contents[1].thedesc >> and << self.otherslot.
            contents[1].thedesc >> both return to their center positions.";
            self.slotpos := 0;
            self.otherslot.slotpos := 0;
        }
    }
    ldesc =
    {
        "It's a deep vertical slot, about a foot high and a little
        under an inch wide.";
        if (self.contents <> [])
        {
            " There's << self.contents[1].adesc >> stuck into the
            slot, which is moved to << ['the bottom' 'the center'
            'the top'][self.slotpos + 2] >> of the slot.";
        }
    }
    doSynonym('Inspect') = 'Lookin'
    slotpos = 0
    verIoPutIn(actor) =
    {
        if (self.contents <> [])
            "You'll have to remove << self.contents[1].thedesc >> first.";
    }
    ioPutIn(actor, dobj) =
    {
        if (isclass(dobj, rodItem))
        {
            "You insert <<dobj.thedesc>> into the slot.  As it reaches
            the back, it seems to engage a mechanism of some kind.  As
            you let go, you see that it's sitting centered in the slot;
            it can be moved up or down.";
            
            dobj.moveInto(self);
            self.slotpos := 0;  // center it
        }
        else
            "It doesn't seem to fit.";
    }
    verGrab(obj) =
    {
        if (self.slotpos <> 0)
            "You can't seem to remove it in this position.";
        else
            pass verGrab;
    }
;

lionLeftSlot: slotitem
    sdesc = "left slot"
    adjective = 'left'
    otherslot = lionRightSlot
;

lionRightSlot: slotitem
    sdesc = "right slot"
    adjective = 'right'
    otherslot = lionLeftSlot
;

lionRoom: room
    sdesc = "On the lion statue"
    ldesc =
    {
        "You're on the shoulders of the lion-headed statue. ";
        if (lionStatue.position <> 0 or lionStatue.direction <> 4)
            "The statue is currently facing << lionStatue.dirdesc >>. ";

        switch(lionStatue.position)
        {
        case 0:
            "Although the statues are almost touching at their bases,
            the gap between adjacent statues is wide enough up here
            that you don't think you could reach the others.
            \n\tJust under the statue's neck, there are two deep
            vertical slots.  The slots are about a foot high apiece,
            and a little under an inch wide.  They are too deep and
            narrow to reach into. ";
            break;

        case 1:
            "The statue is out in between the two columns of
            statues, leaving a gap in the column directly to
            the east. ";
            break;

        case 2:
            "The statue is at the base of a tall pyramid. ";
        }

        lionStatue1.slotdesc;
    }
    down =
    {
        "You carefully climb back down the spikes...\b";
        return(lionStatue.position = 2 ? cavePyrBase : caveIsland);
    }
;

caveSpikes: fixeditem
    noun = 'spike' 'spikes'
    adjective = 'regular' 'stone' 'rock'
    sdesc = "spike"
    ldesc = "They're arranged very regularly up the statue's legs,
        and they're only about a foot apart.  You might be able to
        use them as handholds for climbing the statue."
    verDoClimb(actor) = {}
    doClimb(actor) = { lionStatue.doClimb(actor); }
    location = lionStatue
;

class caveThicketItem: fixeditem
    sdesc = "thicket"
    noun = 'thicket' 'timber' 'timbers' 'log' 'logs'
    adjective = 'dense' 'broken'
    doSynonym('Burn') = 'Light'
    verDoBurn(actor) = {}
    doBurn(actor) =
    {
        "The timbers are already so charred they won't burn any further.";
    }
    doSynonym('Burn') = 'Light'
    verDoBurnWith(actor, iobj) = {}
    doBurnWith(actor, iobj) =
    {
        "The timbers are already so charred they won't burn any further.";
    }
    doSynonym('BurnWith') = 'LightWith'
;

caveThicket: caveThicketItem
    location = caveIsland
    ldesc =
    {
        "The timbers are blackened, as though they have been
        in a fire. ";
        if (self.isbroken)
            "A path has been cut through the center of the thicket.";
        else
            "The thicket looks unpassable.";
    }
;

cavePyramid: fixeditem
    sdesc = "pyramid"
    noun = 'pyramid'
    adjective = 'huge'
    location = cavePyrBase
    ldesc = "It's a tall pyramid built out of some sort of dark stone.
        It's far too steep to climb."
    verDoClimb(actor) = { "It's too steep."; }
    verDoEnter(actor) = { "You'll have to figure out how to do that."; }
;

caveThicket2: caveThicketItem
    location = cavePyrBase
    ldesc = "The timbers are blackened, as though they have been
        in a fire. A path has been cut through the center of the thicket."
;

// boulders/pyramid when on statue in position 2
lionStatueBoulders: distantItem, floatingItem
    noun = 'boulder' 'boulders' 'pyramid' 'wall'
    sdesc = "boulder"
    locationOK = true
    location = ( lionStatue.position = 2 ? lionRoom : nil )
    ldesc = "You don't have a very good view; you could see better
        if you climbed down."
;

// other statues, cliff when is position 1
lionStatueCliff: distantItem, floatingItem
    noun = 'cliff' 'statue' 'statues' 'wall'
    sdesc = "statue"
    locationOK = true
    location = ( lionStatue.position = 0 or lionStatue.position = 1
                  ? lionRoom : nil )
    ldesc = "You'd be able to see it better if you climbed down."
;

cavePyrBoulders: fixeditem
    sdesc = "boulder"
    noun = 'boulder' 'boulders' 'rock' 'rocks' 'wall' 'walls'
    adjective = 'huge' 'twenty' 'foot' 'feet' 'high'
    location = cavePyrBase
    ldesc = "Twenty-foot walls of boulders have been deposited
        to the east and west, forming an avenue leading up to
        the pyramid.  The boulders look unpassable."
    verDoClimb(actor) = { "The boulders are unclimbable."; }
    verDoPush(actor) = { "The boulders are far too large."; }
    doSynonym('Push') = 'Pull' 'Move'
;

cavePyrBase: room
    sdesc = "Base of Pyramid"
    ldesc =
    {
        "You are on a wide avenue, bounded on the east and west by
        boulders, stacked in walls twenty feet high.  The avenue
        leads up to the base of a tall stone pyramid to the north.
        A path through a thicket leads to the south. ";
        if (lionStatue.position = 2)
            "A huge statue, hundreds of feet tall, is standing
            at the base of the pyramid, facing << lionStatue.dirdesc >>. ";
        else
            "In the footprints left by the huge statue, directly
            in front of the pyramid, there is a small passage
            leading down.";
    }
    south = caveIsland
    down =
    {
        if (lionStatue.position = 2) return(self.noexit);
        else return(cavePyrPassage);
    }
    east = { "The boulders are unpassable."; return(nil); }
    west = (self.east)
    ne = (self.east)
    nw = (self.east)
    se = (self.east)
    sw = (self.east)
    up = { "The pyramid is unclimbable."; return(nil); }
;

cavePyrPassage: room
    sdesc = "Dark Passageway"
    ldesc = "You're in a dark passageway leading north and south.
        It ascends out into the light to the south."
    north = caveChamber
    down = caveChamber
    south = cavePyrBase
    up = cavePyrBase
;

lionFootprints: fixeditem
    sdesc = "statue's footprint"
    noun = 'footprint' 'footprints' 'print' 'prints'
    adjective = 'statue\'s' 'lion' 'lion\'s' 'foot' 'huge'
    ldesc = "There's a passage leading down where the statue was
        standing."
;

caveChamberAltar: distantItem
    sdesc = "altar"
    adesc = "an altar"
    noun = 'altar' 'light' 'shaft'
    location = caveChamber
    ldesc = "Why don't you go up there and have a look?"
;

caveChamber: room
    sdesc = "Pyramid Chamber"
    ldesc = "You're in a large central chamber in the pyramid.
        The ceiling rises high above; from an opening at the
        top of the pyramid, a shaft of light illuminates an
        altar to the north.  A passage leads out to the south."
    south = cavePyrPassage
    north = cavePyrAltar
    up = cavePyrAltar
;

cavePyrShape: distantItem
    noun = 'shape' 'bird' 'pterodactyl'
    adjective = 'large' 'reptilian'
    sdesc = "shape"
    location = cavePyrAltar
    ldesc =
    {
        if (not self.isseen)
            "You can't make out any detail; it looks like some sort
            of large bird.";
        else
            pterodactyl.ldesc;
    }
;

cavePedestal: fixeditem, surface
    noun = 'pedestal'
    location = cavePyrAltar
    sdesc = "pedestal"
;

pterodactyl: fixeditem
    noun = 'pterodactyl' 'bird'
    adjective = 'reptilian' 'huge'
    sdesc = "pterodactyl"
    ldesc = "Its leathery wings span at least ten feet. Its features
        are primitive:  scaly skin, rough, bony protrusions, sharp
        beak."
    actorAction =
    {
        "\b";

        // see if it's been voluntarily returned...
        if (goldskull.location = cavePedestal)
        {
            "Apparently satisfied that you've reconsidered your
            defilement, the pterodactyl flies back up to its
            perch at the apex of the chamber, where it watches
            you uneasily.";
        }
        else
        {
            // follow the player if they're trying to escape
            if (self.location <> Me.location)
                "The reptilian bird flaps furiously after you, unwilling
                to let you escape with the skull. ";

            // put the skull back where it belongs
            "The pterodactyl snatches the gold skull, and flies off. It
            flies over to the pedestal, and deposits the skull back where
            it was. The bird then flaps up back to the opening in the apex,
            where it settles back onto its perch. It watches you uneasily.";
            goldskull.moveInto(cavePedestal);
        }

        self.moveInto(nil);
        cavePyrShape.moveInto(cavePyrAltar);
        cavePyrShape.isseen := true;
    }
    verIoShowTo(actor) = {}
    ioShowTo(actor, dobj) =
    {
        if (dobj = pterodactylEgg)
        {
            "The bird immediately backs off upon seeing its egg.
            It flies around the chamber for a few moments, then
            swoops down on you and snatches the egg.  It flies
            back up to the opening at the top of the pyramid,
            and disappears into the sky.";

            awardPoints(13, self);
            self.moveInto(nil);
            pterodactylEgg.moveInto(nil);
            unnotify(self, &actorAction);
        }
        else
            "The huge reptilian bird doesn't seem interested.";
    }
    ioSynonym('ShowTo') = 'GiveTo' 'ThrowTo' 'ThrowAt'
;

pterodactylEgg: item
    noun = 'egg'
    adjective = 'large' 'leathery'
    sdesc = "leathery egg"
    ldesc = "It's a very large egg, about eight inches long. It
        has a tough, leathery covering -- it's probably from some
        reptilian species."
    location = caveNest
;

caveNest: fixeditem, container
    noun = 'nest' 'twig' 'twigs'
    adjective = 'wooden' 'burned' 'burnt'
    location = caveCliff
    sdesc = "nest"
    ldesc =
    {
        "It's a large nest roughly assembled out of burnt wooden
        twigs. ";
        pass ldesc;
    }
;

caveCliff: room
    sdesc = "Cliff"
    ldesc = "You're standing at the top of a cliff.  The ground
        drops precipitously away on all sides, but it looks like
        you can climb down to the west.  Among the rocks is a
        large nest."
    west = statueGap
    down = statueGap
;

goldskull: item
    noun = 'skull' 'head'
    adjective = 'gold' 'solid'
    sdesc = "solid gold skull"
    location = cavePedestal
    ldesc = "It's a life-sized sculpture of a human skull, made out of
        solid gold. It's extremely heavy."
    moveInto(obj) =
    {
        if (location = cavePedestal and
            cavePyrShape.location = cavePyrAltar)
        {
            "As you lift the skull off the pedestal, the shape above
            swoops down into the chamber. You see now that it's some
            sort of huge reptilian bird -- a pterodactyl!  It squawks
            and spits furiously at you as it dashes back and forth
            just above you.
            \b";
            
            cavePyrShape.moveInto(nil);
            pterodactyl.moveInto(cavePyrAltar);
            notify(pterodactyl, &actorAction, 2);
        }
        pass moveInto;
    }
;

cavePyrAltar: room
    south = caveChamber
    down = caveChamber
    sdesc = "Altar"
    ldesc =
    {
       "You're standing on an altar at the north end of a large chamber.
        Light pours in from an opening at the apex of the pyramid high above.
        In the center of the altar is a pedestal.";

        if (cavePyrShape.location = self)
            "\n\tIn the opening above, you see a shape moving slowly.
            You can't make out what it is.";
    }
;

