#charset "us-ascii"

#include <adv3.h>
#include <en_us.h>


hunter : Person 'bird watcher/birdwatcher/hunter/man'
	location = duckHuntField
	
	isHim = true
	globalParamName = 'hunter'
	
	name {
		if(discovered)
			return 'hunter';
		else
			return 'bird watcher';
	}
	
	desc {
		"A man wearing ugly a red plaid shirt and black denim pants is sitting here staring out into the
		reeds. ";
		
		if(hasGun) {
			"He leisurely holds a rifle close across his chest. ";
		}
	}
	
	specialDesc {
		if(hasGun)
			"A <<name>> is standing here holding a rifle at the ready. ";
		else
			"A <<name>> is standing here. ";
	}
	
	
	hasGun = (!duckHuntSpeechProGun.gunsAreBanned)
	
	
	shootDuck {
		if(canSee(duck) && hasGun) {
			duck.getShot();
		}
	}
	
	dobjFor(Attack) {
		verify() {}
		check() {}
		action() {
			"That wouldn't be nice. He may not be a nice guy, but he hasn't done anything to deserve that. ";
		}
	}
	
	iobjFor(ThrowAt) {
		check() {
			replaceAction(Attack, self);
		}
	}
	
	dobjFor(Watch) {
		verify() {}
		check() {}
		action() {
			"In a cunning attempt to turn the tables you watch the bird watcher for a while.
			However, the bird watcher does not appear to be influenced by your stares. He continues
			staring out over the water at the reeds. ";
		}
	}
	
//	obeyCommand(issuingActor, action) {
//		if(action==Attack) {
//		} else {
//			return nil;
//		}
//	}
;

+ hunterGun : Hidden,Thing 'gun/rifle' 'rifle'
	"It's a typical hunting rifle. "
	
	discovered = hunter.hasGun
;
+ hunterPants : Decoration 'black denim pants' 'black denim pants'
	"The pants looks just fine. It's the shirt that's ugly. "
;
+ hunterShirt : Decoration 'ugly red plaid shirt' 'red plaid shirt'
	"That is one heck of an ugly red plaid shirt. What type of person wears plaid out in the woods?
	In fact, what type of person wears plaid outside of Scotland and thinks it's a good look for them? "
;



+ HelloTopic
	"<q>Don't be so cheerful. You can't be cheerful knowing that there are ducks in this world.</q> "
;


+ AskTellTopic @duck
	topicResponse {
		"<q>I hate ducks. I hate them sooo much.</q> He grimaces as he says this. He clearly feels very passionate about hating ducks. ";
		hunter.shootDuck();
	}
;

+ AskTellTopic @hunter  topicResponse {"<q>There's only one thing that anyone needs to know about me. I hate ducks.</q> ";}  ;
+ AskTellTopic @theReeds  topicResponse {"<q>Ducks like to hide in the reeds.</q> ";}  ;
+ AskTellTopic @hunterShirt  topicResponse {"<q>What's wrong with plaid? Plaid is cool!</q> ";}  ;
+ AskTellTopic @hunterPants  topicResponse {"<q>What's wrong with my pants?</q> ";}  ;
+ AskTellTopic @duckhuntWater  topicResponse {"<q>I wish water wasn't so freaking wet.</q> ";}  ;
+ AskTellTopic @pebbles  topicResponse {"<q>Pebbles are no good. Ducks have slippery oily feathers that are as good as leather armor. If you want to kill a duck then you need a better weapon. However, they are useful for scaring ducks out of their hiding places.</q> ";}  ;
+ AskTellTopic @pebble  topicResponse {"<q>Pebbles are no good. Ducks have slippery oily feathers that are as good as leather armor. If you want to kill a duck then you need a better weapon. However, they are useful for scaring ducks out of their hiding places.</q> ";}  ;

+ AskTellTopic 'gun|rifle'  topicResponse {"<q>I wish I had a gun right now.</q> ";}  matchScore=90 ;
+ AskTellTopic @hunterGun  topicResponse {"<q>It's so beautiful. It's an almost sexual experience holding this gun.</q> ";}  matchScore=100 ;

+ AskTellTopic 'bird|birds'  topicResponse {"<q>I hate birds. And, of all the birds, I hate ducks most of all.</q> ";}  ;
+ AskTellTopic @bogSmell  "<q>This bog smells horrible, but that shouldn't surprise anyone. No duck would live in anyplace that wasn't horrible.</q> ";

+ GiveShowTopic @twentyDollarBill
	"He shakes his head, <q>That won't work. You can't bribe a duck.</q> "
;


//			"<q>There's nothing around here to shoot.</q> ";

+ CommandTopic [ShootAction,ShootItAction,ShootItWithAction]
	handleTopic(fromActor, action) {
		if(!hunter.hasGun)
			"<q>I can't currently shoot anything. Guns are illegal.</q> ";
		else if(action.getDobj()!=duck)
			"<q>I would never harm anything except for ducks.</q> ";
		else
			"<q>I will.</q> ";
	}
;



/*
+ TCommandTopic, ShuffledEventList @ShootWithAction
   [
     '<q>Goodness, no!</q> she declares, <q>What <i>do</i> you take me for?</q>'
   ]
   [
     '<q>You are joking, of course!</q> she laughs. ',
     '<q>Ever the optimist, aren\'t we!</q> she chides you. ',
     '<q>Not bloody likely!</q> she retorts. ',
     '<q>Now, why on earth do you suppose I\'d want to do
      that?</q> she cries. ',
     '<q>Don\'t be silly.</q> she admonishes you. ' 
   ]
   matchDobj = duck
;
*/
