/*
 * Copyright (C) 1998 Jose Luis Cebrian Pague
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include "ss.h"

struct SS_MODULE * _ss_curr_mod ;

void ss_init (struct SS_MODULE *mod)
{
    _ss_curr_mod = mod ;
    (*mod->ss_init)() ;
}

/* --- Attributes and character sets --- */

int ss_attrib = 0x07, ss_attribmask = 0x00 ;

unsigned char ss_udg[SS_NUMUDG][8] ;

unsigned char ss_shades[SS_NUMSHADES][8] ;

unsigned char ss_charset[SS_NUMSET][SS_NUMCHAR][8] =
{
    /* Charset 0 : Spectrum ROM charset */
    {
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00 },
	{ 0x00, 0x24, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x24, 0x7E, 0x24, 0x24, 0x7E, 0x24, 0x00 },
	{ 0x00, 0x08, 0x3E, 0x28, 0x3E, 0x0A, 0x3E, 0x08 },
	{ 0x00, 0x62, 0x64, 0x08, 0x10, 0x26, 0x46, 0x00 },
	{ 0x00, 0x10, 0x28, 0x10, 0x2A, 0x44, 0x3A, 0x00 },
	{ 0x00, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x00, 0x04, 0x08, 0x08, 0x08, 0x08, 0x04, 0x00 },
	{ 0x00, 0x20, 0x10, 0x10, 0x10, 0x10, 0x20, 0x00 },
	{ 0x00, 0x00, 0x14, 0x08, 0x3E, 0x08, 0x14, 0x00 },
	{ 0x00, 0x00, 0x08, 0x08, 0x3E, 0x08, 0x08, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x10 },
	{ 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x00, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00 },
	{ 0x00, 0x00, 0x02, 0x04, 0x08, 0x10, 0x20, 0x00 },
	{ 0x00, 0x3C, 0x46, 0x4A, 0x52, 0x62, 0x3C, 0x00 },
	{ 0x00, 0x18, 0x28, 0x08, 0x08, 0x08, 0x3E, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x02, 0x3C, 0x40, 0x7E, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x0C, 0x02, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x08, 0x18, 0x28, 0x48, 0x7E, 0x08, 0x00 },
	{ 0x00, 0x7E, 0x40, 0x7C, 0x02, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x3C, 0x40, 0x7C, 0x42, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x7E, 0x02, 0x04, 0x08, 0x10, 0x10, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x3C, 0x42, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x42, 0x3E, 0x02, 0x3C, 0x00 },
	{ 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x00 },
	{ 0x00, 0x00, 0x10, 0x00, 0x00, 0x10, 0x10, 0x20 },
	{ 0x00, 0x00, 0x04, 0x08, 0x10, 0x08, 0x04, 0x00 },
	{ 0x00, 0x00, 0x00, 0x3E, 0x00, 0x3E, 0x00, 0x00 },
	{ 0x00, 0x00, 0x10, 0x08, 0x04, 0x08, 0x10, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x04, 0x08, 0x00, 0x08, 0x00 },
	{ 0x00, 0x3C, 0x4A, 0x56, 0x5E, 0x40, 0x3C, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x42, 0x7E, 0x42, 0x42, 0x00 },
	{ 0x00, 0x7C, 0x42, 0x7C, 0x42, 0x42, 0x7C, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x40, 0x40, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x78, 0x44, 0x42, 0x42, 0x44, 0x78, 0x00 },
	{ 0x00, 0x7E, 0x40, 0x7C, 0x40, 0x40, 0x7E, 0x00 },
	{ 0x00, 0x7E, 0x40, 0x7C, 0x40, 0x40, 0x40, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x40, 0x4E, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x42, 0x42, 0x7E, 0x42, 0x42, 0x42, 0x00 },
	{ 0x00, 0x3E, 0x08, 0x08, 0x08, 0x08, 0x3E, 0x00 },
	{ 0x00, 0x02, 0x02, 0x02, 0x42, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x44, 0x48, 0x70, 0x48, 0x44, 0x42, 0x00 },
	{ 0x00, 0x40, 0x40, 0x40, 0x40, 0x40, 0x7E, 0x00 },
	{ 0x00, 0x42, 0x66, 0x5A, 0x42, 0x42, 0x42, 0x00 },
	{ 0x00, 0x42, 0x62, 0x52, 0x4A, 0x46, 0x42, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x42, 0x42, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x7C, 0x42, 0x42, 0x7C, 0x40, 0x40, 0x00 },
	{ 0x00, 0x3C, 0x42, 0x42, 0x52, 0x4A, 0x3C, 0x00 },
	{ 0x00, 0x7C, 0x42, 0x42, 0x7C, 0x44, 0x42, 0x00 },
	{ 0x00, 0x3C, 0x40, 0x3C, 0x02, 0x42, 0x3C, 0x00 },
	{ 0x00, 0xFE, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00 },
	{ 0x00, 0x42, 0x42, 0x42, 0x42, 0x42, 0x3C, 0x00 },
	{ 0x00, 0x42, 0x42, 0x42, 0x42, 0x24, 0x18, 0x00 },
	{ 0x00, 0x42, 0x42, 0x42, 0x42, 0x5A, 0x24, 0x00 },
	{ 0x00, 0x42, 0x24, 0x18, 0x18, 0x24, 0x42, 0x00 },
	{ 0x00, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x00 },
	{ 0x00, 0x7E, 0x04, 0x08, 0x10, 0x20, 0x7E, 0x00 },
	{ 0x00, 0x0E, 0x08, 0x08, 0x08, 0x08, 0x0E, 0x00 },
	{ 0x00, 0x00, 0x40, 0x20, 0x10, 0x08, 0x04, 0x00 },
	{ 0x00, 0x70, 0x10, 0x10, 0x10, 0x10, 0x70, 0x00 },
	{ 0x00, 0x10, 0x38, 0x54, 0x10, 0x10, 0x10, 0x00 },
	{ 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF },
	{ 0x00, 0x1C, 0x22, 0x78, 0x20, 0x20, 0x7E, 0x00 },
	{ 0x00, 0x00, 0x38, 0x04, 0x3C, 0x44, 0x3C, 0x00 },
	{ 0x00, 0x20, 0x20, 0x3C, 0x22, 0x22, 0x3C, 0x00 },
	{ 0x00, 0x00, 0x1C, 0x20, 0x20, 0x20, 0x1C, 0x00 },
	{ 0x00, 0x04, 0x04, 0x3C, 0x44, 0x44, 0x3C, 0x00 },
	{ 0x00, 0x00, 0x38, 0x44, 0x78, 0x40, 0x3C, 0x00 },
	{ 0x00, 0x0C, 0x10, 0x18, 0x10, 0x10, 0x10, 0x00 },
	{ 0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04, 0x38 },
	{ 0x00, 0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x00 },
	{ 0x00, 0x10, 0x00, 0x30, 0x10, 0x10, 0x38, 0x00 },
	{ 0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x24, 0x18 },
	{ 0x00, 0x20, 0x28, 0x30, 0x30, 0x28, 0x24, 0x00 },
	{ 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x0C, 0x00 },
	{ 0x00, 0x00, 0x68, 0x54, 0x54, 0x54, 0x54, 0x00 },
	{ 0x00, 0x00, 0x78, 0x44, 0x44, 0x44, 0x44, 0x00 },
	{ 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00 },
	{ 0x00, 0x00, 0x78, 0x44, 0x44, 0x78, 0x40, 0x40 },
	{ 0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04, 0x06 },
	{ 0x00, 0x00, 0x1C, 0x20, 0x20, 0x20, 0x20, 0x00 },
	{ 0x00, 0x00, 0x38, 0x40, 0x38, 0x04, 0x78, 0x00 },
	{ 0x00, 0x10, 0x38, 0x10, 0x10, 0x10, 0x0C, 0x00 },
	{ 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x38, 0x00 },
	{ 0x00, 0x00, 0x44, 0x44, 0x28, 0x28, 0x10, 0x00 },
	{ 0x00, 0x00, 0x44, 0x54, 0x54, 0x54, 0x28, 0x00 },
	{ 0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00 },
	{ 0x00, 0x00, 0x44, 0x44, 0x44, 0x3C, 0x04, 0x38 },
	{ 0x00, 0x00, 0x7C, 0x08, 0x10, 0x20, 0x7C, 0x00 },
	{ 0x00, 0x0E, 0x08, 0x30, 0x08, 0x08, 0x0E, 0x00 },
	{ 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00 },
	{ 0x00, 0x70, 0x10, 0x0C, 0x10, 0x10, 0x70, 0x00 },
	{ 0x00, 0x14, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00 },
	{ 0x3C, 0x42, 0x99, 0xA1, 0xA1, 0x99, 0x42, 0x3C }
    }
} ;

unsigned char ss_sys_udg[SS_NUMSYSUDG][8] =
{
    /* Spectrum ROM UDG */
    { 0x0F, 0x0F, 0x0F, 0x0F, 0x00, 0x00, 0x00, 0x00 },
    { 0xF0, 0xF0, 0xF0, 0xF0, 0x00, 0x00, 0x00, 0x00 },
    { 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0x00, 0x00, 0x0F, 0x0F, 0x0F, 0x0F },
    { 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F, 0x0F },
    { 0xF0, 0xF0, 0xF0, 0xF0, 0x0F, 0x0F, 0x0F, 0x0F },
    { 0xFF, 0xFF, 0xFF, 0xFF, 0x0F, 0x0F, 0x0F, 0x0F },
    { 0x00, 0x00, 0x00, 0x00, 0xF0, 0xF0, 0xF0, 0xF0 },
    { 0x0F, 0x0F, 0x0F, 0x0F, 0xF0, 0xF0, 0xF0, 0xF0 },
    { 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0, 0xF0 },
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xF0, 0xF0, 0xF0, 0xF0 },
    { 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0xFF },
    { 0x0F, 0x0F, 0x0F, 0x0F, 0xFF, 0xFF, 0xFF, 0xFF },
    { 0xF0, 0xF0, 0xF0, 0xF0, 0xFF, 0xFF, 0xFF, 0xFF },
    { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF }
} ;

/* --- Rendering --- */

int ss_render_mode = SS_RENDER_8BPP ;

/* Spectrum palette */
struct SS_RGB ss_render_palette[256] =
{
    { 0x00, 0x00, 0x00 }, 	/* RGB */
    { 0x00, 0x00, 0xC0 },
    { 0xC0, 0x00, 0x00 },
    { 0xC0, 0x00, 0xC0 },
    { 0x00, 0xC0, 0x00 },
    { 0x00, 0xC0, 0xC0 },
    { 0xC0, 0xC0, 0x00 },
    { 0xC0, 0xC0, 0xC0 },
    { 0x00, 0x00, 0x00 },
    { 0x00, 0x00, 0xFF },
    { 0xFF, 0x00, 0x00 },
    { 0xFF, 0x00, 0xFF },
    { 0x00, 0xFF, 0x00 },
    { 0x00, 0xFF, 0xFF },
    { 0xFF, 0xFF, 0x00 },
    { 0xFF, 0xFF, 0xFF }
} ;

unsigned char *ss_render_buffer = 0 ;

unsigned int ss_render_buffer_size = 0, 
             ss_render_buffer_width,
	     ss_render_buffer_height ;

