/* -------------------------- */
/*   Spectrum Screen module   */
/* -------------------------- */

/*
 * Copyright (C) 1998 Jose Luis Cebrian Pague
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

#include "ss.h"

void ss_clear    () 
{
    (*(_ss_curr_mod->ss_clear)) () ;
}

void ss_move	(int x, int y) 
{
    (*(_ss_curr_mod->ss_move)) (x, y) ;
}

void ss_plot	(int mode) 
{
    (*(_ss_curr_mod->ss_plot)) (mode) ;
}

void ss_rmove    (int incx, int incy) 
{
    (*(_ss_curr_mod->ss_rmove)) (incx, incy) ;
}

void ss_line	(int incx, int incy, int mode) 
{
    (*(_ss_curr_mod->ss_line)) (incx, incy, mode) ;
}

void ss_fill	(int incx, int incy, char pattern[8]) 
{
    (*(_ss_curr_mod->ss_fill)) (incx, incy, pattern) ;
}

void ss_attbl    (int col, int row, int w, int h) 
{
    (*(_ss_curr_mod->ss_attbl)) (col, row, w, h) ;
}

void ss_putch    (int col, int row, int set, unsigned char c, int m) 
{
    (*(_ss_curr_mod->ss_putch)) (col, row, set, c, m) ;
}

void ss_scroll   (int row) 
{
    (*(_ss_curr_mod->ss_scroll)) (row) ;
}

void ss_render   () 
{
    (*(_ss_curr_mod->ss_render)) ();
}


/* Call the color functions with color=8 for "transparent color" setting.
 * Bright and flash can only be 0 or 1. Ink and paper color can be:
 *
 * 0    Black           00 00 00
 * 1    Blue            00 00 C0
 * 2    Red             C0 00 00
 * 3    Magenta         C0 00 C0
 * 4    Green           00 C0 00
 * 5    Yellow          00 C0 C0
 * 6                    C0 00 C0
 * 7    White           C0 C0 C0
 */

void ss_ink      (int ink)
{
    ss_attrib = (ss_attrib & ~0x07) | (ink & 0x07) ;
    ss_attribmask = (ss_attribmask & ~0x07) | (ink == 8 ? 0x07 : 0x00) ;
}

void ss_paper    (int paper)
{
    ss_attrib = (ss_attrib & ~0x70) | ((paper << 4) & 0x70) ;
    ss_attribmask = (ss_attribmask & ~0x70) | (paper == 8 ? 0x70 : 0x00) ;
}

void ss_bright   (int bright)
{
    ss_attrib = bright == 1 ? (ss_attrib | 0x08) : (ss_attrib & ~0x08) ;
    ss_attribmask = bright == 8 ? (ss_attribmask | 0x08) : (ss_attribmask & 0x08) ;
}

void ss_flash (int flash)
{
    ss_attrib = flash == 1 ? (ss_attrib | 0x80) : (ss_attrib & ~0x80) ;
    ss_attribmask = flash == 8 ? (ss_attribmask | 0x80) : (ss_attribmask & 0x80) ;
}

