!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.07.27 ORTransition
! Transition() is best used as a special effect for dividing story parts.  It conveys 
! to the player, a transition between logical breaks in the game (for instance, 
! chapters). It can be called after printing the final lines of a section, and before 
! the first lines of the next. 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! The general use of the routine is as follows:
!	1) Text of Section A is printed.
!	2) Transition() prints a small text seperation then prompts for the player to 
!		press space.
!	3) The screen is cleared and the text of Section B is then printed.
! Note:
! Transition can take a single parameter for text to be used in the tranition.
! If no text is supplied the three dashes will be used.  
!--------------------------------------------------------------------------------------
! AutoDep:	ORStyleHint
!			ORStyleRvrsMonospace
!	both :	ORCenter
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_ORTransition; #include "ORTransition"; #endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORTransition; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.05.12	Initial Creation
! 2002.05.13	Adjusted closing line feeds.
! 2002.05.18	Addressed bug in GLULX mode.
! 2002.07.27	Added code to optionally skip the erase screen section of code.
!--------------------------------------------------------------------------------------
#ifdef USE_ORTransition;message "          Processing library extension ORTransition...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------
	#ifndef USE_ORCenter; Constant USE_ORCenter; message "          ****Forcing inclusion of ORCenter****"; #include "ORCenter"; #endif; 
	#ifndef USE_ORStyleHint; Constant USE_ORStyleHint; message "          ****Forcing inclusion of ORStyleHint****"; #include "ORStyleHint"; #endif; 
	#ifndef USE_ORStyleRvrsMonospace; Constant USE_ORStyleRvrsMonospace; message "          ****Forcing inclusion of ORStyleRvrsMonospace****"; #include "ORStyleRvrsMonospace"; #endif; 
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORTransition_DONEREPLACE; constant ORTransition_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORTransition_DONEMESSAGE; constant ORTransition_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORTransition requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORTransition_DONECODE;constant ORTransition_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------
	[Transition text skiperase ch;
		if(text==0) text="---";
		new_line;
		Center(text);
		new_line;
		Center("Press SPACE to continue",0,1);
		while(ch~=' ') {
	#ifdef TARGET_GLULX; 
			ch=false;
			while(ch==false){
				glk_request_char_event(gg_mainwin);
				glk_select(gg_event); ! select
				if(gg_event-->0==evtype_CharInput) ch=gg_event-->2;
				HandleGlkEvent(gg_event, 1);
			}
	#ifnot;
			@read_char 1 -> ch;
	#endif;
		}
		if(skiperase==false){
		#ifndef TARGET_GLULX; 
			@erase_window -1; 
			@set_cursor 1 1; 
		#ifnot; 
			glk_window_clear(gg_mainwin); 
			glk_window_move_cursor(gg_mainwin,0,0); 
		#endif;
		}
		new_line;
	];
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORTransition_DONEGRAMMAR; constant ORTransition_DONEGRAMMAR; #ifdef ORTransition_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;