!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2002.02.26 ORStyleHint [GLULX]
! An object wrapper to easily establish user-defined styles.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! AutoDep (Glulx-only) :	ObjectInitialise
!							ORInfGlk
!--------------------------------------------------------------------------------------
! Without this module, in order to produce a style, for example [reverse, italic, centered, bold], 
! that would appear in both the status window and main window, you had to declare the 
! InitGlkWindow() routine and define it as follows:
!
!	[ InitGlkWindow winrock;
!		switch(winrock){
!			GG_MAINWIN_ROCK:
!				glk_stylehint_set(wintype_TextBuffer,Style_User1, stylehint_ReverseColor, 1);
!				glk_stylehint_set(wintype_TextBuffer,Style_User1, stylehint_Weight, 1);
!				glk_stylehint_set(wintype_TextBuffer,Style_User1, stylehint_Justification, stylehint_just_Centered);
!				glk_stylehint_set(wintype_TextBuffer,Style_User1, stylehint_Oblique, 1);
!			GG_STATUSWIN_ROCK:
!				glk_stylehint_set(wintype_TextGrid,Style_User1, stylehint_ReverseColor, 1);
!				glk_stylehint_set(wintype_TextGrid,Style_User1, stylehint_Weight, 1);
!				glk_stylehint_set(wintype_TextGrid,Style_User1, stylehint_Justification, stylehint_just_Centered);
!				glk_stylehint_set(wintype_TextGrid,Style_User1, stylehint_Oblique, 1);
!		}
!		rfalse;
!	];
!
! Note that this is just 1 style in two windows; double this for an additional style.  
! With the ORStyleHint module, the following will do the same and it can be defined 
! anywhere in your source code:
!
!	ORStyleHint	with windows wintype_TextGrid wintype_TextBuffer
!		,	hints stylehint_ReverseColor stylehint_Weight stylehint_Justification stylehint_Oblique
!		,	values 1 1 stylehint_just_Centered 1;
! 
! Also, the InitGlkWindow() routine need not be defined.
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#include "ORStyleHint";					!Constant USE_ORStyleHint; 
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_ORStyleHint; to the game file;
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.02.11	Initial Creation
! 2002.02.26	Fit to new template.
!--------------------------------------------------------------------------------------
#ifdef USE_ORStyleHint;
	#ifndef TARGET_GLULX;
		message "          Processing library extension ORStyleHint...Ignoring (GLULX specific)";
	#ifnot;
		message "          Processing library extension ORStyleHint...";
	#endif;
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- Uncomment for GLULX--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--------------------------------------------------------------------------------------
	#ifdef TARGET_GLULX;
		#ifndef USE_ORObjectInitialise; Constant USE_ORObjectInitialise; message "          ****Forcing inclusion of ORObjectInitialise****"; #include "ORObjectInitialise"; #endif; 
		#ifndef USE_ORInfGlk; Constant USE_ORInfGlk; message "          ****Forcing inclusion of ORInfGlk****"; #include "ORInfGlk"; #endif; 
	#endif;
!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef ORStyleHint_DONEREPLACE; constant ORStyleHint_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef ORStyleHint_DONEMESSAGE; constant ORStyleHint_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! ORStyleHint requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	#ifdef TARGET_GLULX;
		class ORStyleHint
				with object_initialise[o i; 
					if(self hasnt general){ !--if called from main, then setup for next call and exit
						give self general;
						return;
					}
					for(o=0:o<self.#windows/WORDSIZE:o++){
						for(i=0:i<self.#hints/WORDSIZE:i++){
							glk_stylehint_set(self.&windows-->o,self.user_num,self.&hints-->i,self.&values-->i);
						}
					}
				]
			,	user_num style_User1 !--can be changed
			,	windows  wintype_TextBuffer
			,	hints	stylehint_Weight
			,	values	0
		;
	#endif;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef ORStyleHint_DONECODE;constant ORStyleHint_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef ORStyleHint_DONEGRAMMAR; constant ORStyleHint_DONEGRAMMAR; #ifdef ORStyleHint_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;
