!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! 2003.02.06 OROptionList [Z, GLULX]
! A class which maintains a list of value pairs.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!--------------------------------------------------------------------------------------
! Created by Jim Fisher
! A more detailed description of this file, what it does, and how to use it goes here.
!
!--------------------------------------------------------------------------------------
! AutoDep:	
!--------------------------------------------------------------------------------------
! To register this module with your library, add the line:
!
!		#ifdef USE_OROptionList; #include "OROptionList";	#endif;
!	
!	to the library header file (OR_Library_Include).  To use in a game, add the line:
!
!		Constant USE_OROptionList; 
!
!	to the game file;
!--------------------------------------------------------------------------------------
! Revision History
! 2002.04.03	Initial Creation
! 2002.05.01	Modified comments.
! 2002.07.15	Moved class definition to the messages section. Additionally created 
!				an field to hold an addition association and methods to set the various 
!				componants too.
! 2003.02.06	Eliminated the default number of blank entries of the properties 
!				OptionList, AssociationList, and AssociationList2.  This can (and should)
!				be set to better values in derived classes or instances of this class, 
!				but is being eleminated from the base class to keep from allocating 
!				readable memory needlessly.
!--------------------------------------------------------------------------------------
#ifdef USE_OROptionList;message "          Processing library extension OROptionList...";
!--------------------------------------------------------------------------------------
! D E P E N D A N C I E S   section   (for bringing in dependant modules)
!--- sample forced include---   #ifndef USE_<REPLACEWITHINCLUDENAME>; Constant USE_<REPLACEWITHINCLUDENAME>; message "          ****Forcing inclusion of <REPLACEWITHINCLUDENAME>****"; #include "<REPLACEWITHINCLUDENAME>"; #endif; 
!--- #ifndef TARGET_GLULX; default WORDSIZE 2; #ifnot;default WORDSIZE 4; #endif; !--for GLULX compatability
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#ifdef REPLACEPOINT; #ifndef OROptionList_DONEREPLACE; constant OROptionList_DONEREPLACE; 
!--------------------------------------------------------------------------------------
! R E P L A C E   section (for code that preceeds the inclusion of PARSER)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif;#endif;#ifdef MESSAGEPOINT; #ifndef OROptionList_DONEMESSAGE; constant OROptionList_DONEMESSAGE; 
!--------------------------------------------------------------------------------------
! M E S S A G E   section (for code that falls between PARSER and VERBLIB )
!--- Uncomment to check for OREnglish--- #ifndef OREnglish; message "ERROR!!!! OROptionList requires the OREnglish file.";#endif; 
!--------------------------------------------------------------------------------------
	class OROptionList
		with OptionList			0
		,	AssociationList		0
		,	AssociationList2	0
		,	GetOption[n;
				if(n>=self.count()) "Error (OROptionList): index out of range (GetOption)";
				return self.&OptionList-->n;
			]
		,	GetAssociation[n;
				if(n>=self.count()) "Error (OROptionList): index out of range (GetAssociation)";
				if(((self.#AssociationList)/WORDSIZE)>n) return self.&AssociationList-->n;
				return 0;
			]
		,	GetAssociation2[n;
				if(n>=self.count()) "Error (OROptionList): index out of range (GetAssociation2)";
				if(n>=self.count()) return -1;
				if(((self.#AssociationList2)/WORDSIZE)>n) return self.&AssociationList2-->n;
				return 0;
			]
		,	SetOption[n val;
				if(n>=self.count()) "Error (OROptionList): index out of range (SetOption)";
				self.&OptionList-->n=val;
			]
		,	SetAssociation[n val;
				if(n>=self.count()) "Error (OROptionList): index out of range (SetAssociation)";
				self.&AssociationList-->n=val;
			]
		,	SetAssociation2[n val;
				if(n>=self.count()) "Error (OROptionList): index out of range (GetAssociation2)";
				self.&AssociationList2-->n=val;
			]
		,	Count[t;
				for(t=0:t<(self.#OptionList/WORDSIZE):t++){
					if(self.&OptionList-->t==0) return t;
				}
				return (self.#OptionList/WORDSIZE);
			]
		,	ClearOptionList[t; !--remove everything from the list
				for(t=0:t<self.#OptionList/WORDSIZE:t++){
					self.&OptionList-->t=0;
					if(((self.#AssociationList)/WORDSIZE)>t)self.&AssociationList-->t=0;
					if(((self.#AssociationList2)/WORDSIZE)>t)self.&AssociationList2-->t=0;
				}
			]	
		,	RemoveOptionByNumber[number t pos; !--eliminate a position and shift everything forward
				pos=((self.#OptionList)/WORDSIZE)-1;
				for(t=number:t<pos:t++){
					self.&OptionList-->t=self.&OptionList-->(t+1);
					if(((self.#AssociationList)/WORDSIZE)>t+1) self.&AssociationList-->t=self.&AssociationList-->(t+1); 
					if(((self.#AssociationList2)/WORDSIZE)>t+1)self.&AssociationList2-->t=self.&AssociationList2-->(t+1); 
				}
				self.&OptionList-->pos=0;
				if(((self.#AssociationList)/WORDSIZE)>pos) self.&AssociationList-->pos=0;
				if(((self.#AssociationList2)/WORDSIZE)>pos) self.&AssociationList2-->pos=0;
			]
		,	RemoveOption[Option n; !--Locate an option and remove it
				n=self.LocateOption(Option);
				if(n~=-1) self.RemoveOptionByNumber(n);
			]
		,	LocateOption[Option t;
				for(t=0:t<self.#OptionList/WORDSIZE:t++){
					if(self.&OptionList-->t==Option){
						return t;
					}
				}
				return -1;
			]
		,	PushOption[newOption AltValue AltValue2 t; !--add an option and associated value to the first unused position
				if(self.LocateOption(newOption)>=0) rtrue; !--already is considering that Option
				for(t=0:t<self.#OptionList/WORDSIZE:t++){
					if(self.&OptionList-->t==0){
						self.&OptionList-->t=newOption;
						if(self.#AssociationList/WORDSIZE>t)self.&AssociationList-->t=AltValue;
						if(self.#AssociationList2/WORDSIZE>t)self.&AssociationList2-->t=AltValue2;
						rtrue;
					}
				}
				rfalse; !--not enough room to record new option
			]
	;
!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef CODEPOINT; #ifndef OROptionList_DONECODE;constant OROptionList_DONECODE; 
!--------------------------------------------------------------------------------------
! C O D E   section (for code that falls between VERBLIB and GRAMMAR)
!--------------------------------------------------------------------------------------

!--------------------------------------------------------------------------------------
#endif; #endif; #ifdef GRAMMARPOINT; #ifndef OROptionList_DONEGRAMMAR; constant OROptionList_DONEGRAMMAR; #ifdef OROptionList_DONEGRAMMAR; #endif; !--just to supress warning
!--------------------------------------------------------------------------------------
! G R A M M A R   section (for code that follows the inclusion of GRAMMAR)
!--------------------------------------------------------------------------------------


!--------------------------------------------------------------------------------------
#endif; #endif; #endif;