! This include file is for the purpose of containing objects prefixed by 'ROOM_', i.e. rooms.

! A class to handle AGT rooms. Based on BarringerRoom by C.E.Forman and Gareth Rees.
class AGTRoom
 with
  n_to
  [;
   print "You can't go n from here!^";
   return self;
  ],
  s_to
  [;
   print "You can't go s from here!^";
   return self;
  ],
  e_to
  [;
   print "You can't go e from here!^";
   return self;
  ],
  w_to
  [;
   print "You can't go w from here!^";
   return self;
  ],
  u_to
  [;
   print "You can't go u from here!^";
   return self;
  ],
  d_to
  [;
   print "You can't go d from here!^";
   return self;
  ],
  ne_to
  [;
   print "You can't go ne from here!^";
   return self;
  ],
  nw_to
  [;
   print "You can't go nw from here!^";
   return self;
  ],
  se_to
  [;
   print "You can't go se from here!^";
   return self;
  ],
  sw_to
  [;
   print "You can't go sw from here!^";
   return self;
  ],
  in_to
  [;
   print "You can't enter anything here.^";
   return self;
  ],
  out_to
  [;
   print "You're not inside anything that you can exit.^";
   return self;
  ],
  short_name
  [;
   print_ret "<< ", (object)self, " >>";
  ]
 has
;

! Limbo - a special room.
object ROOM_Limbo "Limbo"
 with
  description "Limbo is a special room, not intended to be visited.",
  name "limbo"
 has
  enterable
  light
;

! Deck Nine. The sole purpose of this room is to be as a response to a "magic" word.
object ROOM_Deck9 "Deck Nine"
 with
  description
  [;
   print "This is a featureless corridor similar to every other corridor on the ship. It curves away to starboard, and a gangway leads up. To port is the entrance to one of the ship's primary escape pods. The pod bulkhead is closed.", (NewLine)2;
   print "You have beamed yourself into Planetfall, and escaped from the Satellite of Love. Unfortunately, you did so before Mike Nelson arrived to take your place. With no man in space to experiment on, Dr. Forrester ekes out the rest of his career playing B-movie heavies, TV's Frank returns to his job at Arby's, and Mystery Science Theater is cancelled.", (NewLine)2;
   Quip (-1, 0, Tom, "Good one, Joel!", 1);
   Quip (-1, 0, Crow, "Hey Joel, wanna play Hucka-Bucka Beanstalk?", 2);
   deadflag=4;	! The game ends here.
   rtrue;
  ],
 has
  light
;

! Foggy street a
AGTRoom ROOM_StreetA "the foggy street"
 with
  description
  [;
   print "The is fog everywhere, ";
   Quip (0, 1, Tom, "Uh, oh. Typo in the first sentence. I've gotta bad feeling about this.", 2);
   print "obscuring the entire landscape. Max feels suddenly like a huge cloud has lifted him up and taken him away. ";
   Quip (0, 1, Crow, "[falsetto voice] ~When I bite into a York Peppermint Patty...~", 2);
   print "He wonders where he has gone.^";
   Quip (0, 1, Tom, "Never mind about Max, what about us?", 1);
   Quip (0, 0, Joel, "Uh, Tom. This game seems to be written in third person. So that would mean that we're Max.", 1);
   Quip (0, 0, Tom, "Third person? In a text game? Joel, isn't that kinda fruity?", 1);
   Quip (0, 0, Joel, "Oh, I don't know. I never thought about it.", 1);
   Quip (0, 0, Crow, "Joel. It is.", 1);
   rtrue;
  ],
  e_to ROOM_Bedroom,	! The bedroom
  n_to ROOM_Theatre,	! The theatre
  w_to ROOM_Cobble	! The cobble street
 has
  light
;

! The theatre.
AGTRoom ROOM_Theatre "the theatre"
 with
  description
  [;
   print "Max is onstage. He is dressed in kahki fatigues. His head is shaved. ";
   Quip (0, 1, Joel, "I hate Hell Week.", 2);
   Quip (1, 1, Tom, "Well, duh! Where else would he go?", 1);
   Quip (1, 0, Crow, "I'd like to help set him free.", 2);
   print "He is playing the part of man trapped inside his own skin. Three other people, his ~family~ try to tell he is alright. But he is not alright. ";
   Quip (0, 1, Tom, "Tell me about it.", 2);
   print "He is misunderstood. He cannot even begin to articulate how he feels. ";
   Quip (0, 1, Tom, "[In Max voice] I am so high!", 2);
   print "But there is a panic inside him, growing more desparate by the moment. He begins to scoop water out of a large metal pot and watch it trickle back. ";
   Quip (0, 1, Crow, "Bad game? Relax, you're soaking in it.", 2);
   print "he does this for some time. the movement comforts him. then the panic strikes again. He spies something shiny in the water. He reaches in and grasps the object and hurls it into the air. ";
   Quip (1, 1, Joel, "That's a switch: the actors are throwing junk at the crowd.", 2);
   print "A huge fish flies across the stage ";
   if (CONTAINER_Fish notin location)	! But it can't...
   {
    Quip (0, 1, Crow, "Hey! But we picked...", 1);
    Quip (0, 0, Joel, "Yup.", 2);
   }
   print "and lands wetly a few feet away. Everyone is suddenly very quiet.^";
   Quip (0, 0, Tom, "What the Sam Scratch is goin' on?", 1);
   Quip (1, 0, Crow, "Oh wow! This is just sooo profound! Lunch, anyone?", 1);
   rtrue;
  ],
  e_to ROOM_StreetC,	! Foggy street C
  n_to
  [;
   Quip (0, 1, Crow, "Here we go...", 1);
   Quip (1, 1, Tom, "...round the...", 1);
   Quip (2, 1, Joel, "...mulberry bush...", 1);
   return self;	! The theatre
  ],
  s_to ROOM_StreetA,	! Foggy street A
  w_to ROOM_Forest	! The forest
 has
  light
;

! The hospital.
AGTRoom ROOM_Hospital "the hospital"
 with
  description
  [;
   print "Max is in the operating room of a hospital. His wife is on the operating table, breathing quite heavily. There are several doctors and nurses in the room. ";
   Quip (0, 1, Tom, "Cool! Are we going to get to see the machine that goes ~Ping~?", 2);
   print "He tries to touch one of them but his hand passes right through. His wife is breathing heavier now. He goes to her, tries to talk to her. ";
   Quip (1, 1, Tom, "[Max voice] Hi honey, I'm back from my 12-month cruise. Whatcha been up to?", 2);
   print "She does not hear. A nurse comes up to Max and tells him if he is cannot calm down he will have to leave. He watches quietly as they cut open his wife's stomach. He watches the birth of his son. The nurse comes up to him, handing him the baby. ";
   Quip (0, 1, Joel, "...which falls through his immaterial fingers with a loud ~klunk.~", 2);
   print "The doctors have begun to sew up his wife. ";
   Quip (1, 1, Crow, "[Doctor voice] Uh Max, could you put your finger right there? Thanks.", 2);
   "~You will have to leave now,~ the nurse says. He looks down at his baby son, but the child is gone.";
   ! CODE GOES HERE TO PLAY ANOTBORE ("Another boring scene...")
  ],
  e_to ROOM_Parlor,	! The parlor
  n_to ROOM_StreetB,	! Foggy street B
  s_to ROOM_StreetC,	! Foggy street C
  w_to ROOM_Forest	! The forest
 has
  light
;

! The bedroom
AGTRoom ROOM_Bedroom "the bedroom"
 with
  description
  [;
   print "Max is in bed with his grandfather Willie. ";
   Quip (0, 1, Tom, "Shut up, Crow.", 1);
   Quip (0, 0, Crow, "Whaaat? I didn't say anything!", 1);
   Quip (0, 0, Joel, "Well, just don't.", 2);
   print "Willie is snoring quite loudly. Max turns over to tell his grandfather to be quiet when he is assailed by the smell of grandfather's breath. Willie is fond of cigars and they give his breath the aroma of used dragon smoke. ";
   Quip (1, 1, Crow, "Yeah, I thought it was kinda Smaugie in here. Hee, hee, hee.", 2);
   print "Max starts to get out of bed, but finds he is surrounded by an impenetrable darkness. The bed seems to be floating. ";
   Quip (0, 1, Tom, "[In Max voice] I knew I should have gone before I came to bed.", 2);
   Quip (1, 1, Joel, "So what is this, ~Bedknobs and Broomsticks~ all of a sudden?", 2);
   print "Willie begins talking in his sleep. ";
   Quip (0, 1, Crow, "[In sleepy Willie voice] No, mom! Not the clown suit!", 2);
   print "~What's the matter with you,~ he says. ~You never listen to anything I tell you. You think you're so smart. You're a bum just like your father. Never listen to me.~ Willie begins to swing his hands in his sleep. Max ducks and dodges. Finally he lifts his pillow in self defense. Under the pillow is a wet cigar.^";
   Quip (1, 1, Tom, "Smoking in bed, huh? Good thing I forgot to go to the...", 1);
   Quip (1, 0, Joel, "Tom!", 1);
   if (OBJECT_Cigar notin location)
   {
    ! Comment on the cigar's duplicity.
    Quip (0, 1, Tom, "Hmmm... the cigar's magically-replicating.", 1);
    Quip (0, 0, Joel, "Hey, it could be worse. What about that dazed guy in ~Detective~?", 1);
    Quip (0, 0, All, "[Shudder]", 1);
   }
   rtrue;
  ],
  e_to ROOM_StreetB,	! Foggy street B
  n_to ROOM_StreetA,	! Foggy street A
  s_to
  [;
   return self;		! Loops back on itself.
  ],
  w_to
  [;
   return self;		! Loops back on itself.
  ],
 has
  light
  scored
;

! The study.
AGTRoom ROOM_Study "the study"
 with
  description
  [;
   print "Max is in cantor Diamond's study. The cantor is a tall man with an open face and kind eyes. Max is listening to him sing a passage from the haftorah. ";
   Quip (0, 1, Crow, "Well, haftorah, will travel.", 1);
   Quip (0, 0, Joel, "The Half Torah? Couldn't he find the whole thing?", 2);
   Quip (1, 1, Tom, "[Singing in Morris' voice] Boom, boom, boom, boom. Ahh told the Witch Doctor I was in love with you...", 2);
   print "Morris Diamond has the most beautiful voice in the world. Long before Max has ever heard opera, he has heard enough of Morris Diamond to change his life forever. When he hears the cantor sing he is swept up in the peculair feeling of tremendous joy and unspeakable sorrow. The cantor's voice touches him in a way that Max can never forget. ";
   Quip (1, 1, Joel, "As it has touched the hearts of millions. Just dial this toll-free number. Operators are standing by.", 2);
   print "Morris asks Max to repeat the passage. Although he does not have a bad singing voice, his chanting cannot compare with the cantor's. Max begins to weep, ";
   Quip (0, 1, Tom, "What a Grade-A Fem!", 2);
   print "not for his lack of talent, but for his lack of feeling. How could he follow such a voice. Morris Diamond goes to his desk and opens a drawer. ";
   Quip (0, 1, Crow, "He's got a gun!", 2);
   print "He takes out a small book ";
   Quip (0, 1, Crow, "Oh.", 2);
   print "and places it on the table before Max.^";
   if (CONTAINER_Book notin location)	! But he can't.
   {
    Quip (0, 1, Tom, "[Sigh]", 1);
   }
   ! CODE GOES HERE TO PLAY WEEP ("I weep for...")
   rtrue;
  ],
  e_to ROOM_StreetA,	! Foggy street A
  n_to ROOM_Lake,	! The frozen lake
  s_to ROOM_Parlor,	! The parlor
  w_to ROOM_StreetA	! Foggy street A
 has
  light
  scored
;

! The forest
AGTRoom ROOM_Forest "the forest"
 with
  description
  [;
   print "Max is in the woods near his house. It is a crisp autumn day. His nostrils flare as he picks up the scent of burning leaves. Every autumn old man Whittaker sets the woods on fire. ";
   Quip (0, 1, Tom, "What the... huh?", 2);
   print "All the kids in the neighborhood tell their parents, but they are not believed. ";
   Quip (1, 1, Tom, "So how come all the kids see this guy setting fires, but none of the grownups ever do?", 1);
   Quip (1, 0, Joel, "It's just a game, okay?", 2);
   print "So each autumn, the woods behind their rowhouse burns. the firemen come out with their trucks. Several hours later the fire will be out for another year. But now is the time of greatest danger. ";
   Quip (0, 1, Crow, "I don't get it Joel. Why does the old man burn down the forest every year?", 1);
   Quip (0, 0, Joel, "Well, it's kind of like the hunter's equivalent of dynamiting the stream.", 2);
   print "The forest is blazing all around Max. He feels the heat of the flames on his face. If he doesn't move soon he will become part of the blaze. Max hopes he does not step in any poison ivy.^";
   Quip (1, 1, Crow, "Talk about looking for trouble. He's already in the middle of a fire, for crying out loud!", 1);
   ! CODE GOES HERE TO PLAY LARCH ("Number 3... the Larch.")
   rtrue;
  ],
  e_to ROOM_Fire,	! The raging fire
  n_to ROOM_Fire,	! The raging fire
  s_to ROOM_Patch,	! The patch
  w_to ROOM_Fire	! The raging fire
 has
  light
;

! The cobble street
AGTRoom ROOM_Cobble "the cobble street"
 with
  description
  [;
   print "Max is walking down a cobble street when a small boy, perhaps a year old, falls to the pavement from a second story window. ";
   Quip (0, 1, Crow, "[Michael Palin voice] Here is an unsuccessful encyclopedia salesman.", 2);
   Quip (1, 1, Joel, "Again? The City Council should put a ~Falling Child Zone~ sign here.", 2);
   print "The baby gasps and then does not move. For a moment, Max is paralyzed with horror. Before he can recover, a woman comes running out of the house screaming, ~my baby, my baby.~ She lifts the child up high into the air above her, sobbing hysterically. She runs back inside the house and closes the door behind her.^";
   Quip (0, 1, Joel, "I guess this wouldn't be a good time to try to sell these Girl Scout Cookies.", 1);
   ! CODE GOES HERE TO PLAY RELEVANT ("I question the relevance of this scene.")
   rtrue;
  ],
  e_to ROOM_StreetB,	! The foggy street B
  n_to ROOM_Alley,	! The alley
  s_to ROOM_Hospital,	! The hospital
  w_to ROOM_StreetC	! The foggy street C
 has
  light
;

! The frozen lake
AGTRoom ROOM_Lake "the frozen lake"
 with
  description
  [;
   print "It is after the first snowfall of winter. The lake has frozen solid. Max stands on the newly formed ice and listens to the quietness. ";
   if (self hasnt general)	! First time round, give score.
   {
    score=score+20;		! 20+5=25.
    give self general;		! Once only.
   }
   Quip (0, 1, Crow, "[In Max voice] Hmm, what's this sign say? ~Danger, thin... Ahhhhhh!~", 2);
   print "He can hear the tinkle of icecicles banging against each other in the wind as they hang off the evergreen brahcnes. ";
   Quip (1, 1, Crow, "Brahcnes?", 1);
   Quip (1, 0, Tom, "Gesundheit. Joel, can they say ~tinkle~ in a family game?", 1);
   Quip (1, 0, Joel, "Only if it has artistic merit.", 2);
   print "Max feels he is at he center of the universe ";
   Quip (0, 1, Joel, "The chewy nougat center.", 2);
   print "and that center is calm. He thinks of Morris Diamond. Max can hear the faint sound of a dog barking two miles away.^";
   Quip (1, 1, Crow, "[Max voice] I am so BORED!", 1);
   Quip (0, 1, Crow, "[As dog] BARK! BARK!", 1);
   rtrue;
  ],
  e_to ROOM_Alley,	! The alley
  n_to ROOM_StreetA,	! Foggy street A
  s_to ROOM_Forest,	! The forest
  w_to ROOM_Door,	! The front door
 has
  light
  NoInt			! No intermission is played here.
  scored
;

! The front door
AGTRoom ROOM_Door "the front door"
 with
  description
  [;
   print "Quite unexpectedly, Max finds himself at his front door. How long has he been walking, he wonders. And what was he doing out on a night like this?^";
   Quip (-1, 0, Joel, "And why does he have this splitting headache? And where did he get that policeman's badge? And the traffic cone?", 2);
   print "He can't remember. The fog has obliterated the street behind him. He fumbles for his house keys, opens his door and climbs the steps.^";
   Quip (-1, 0, Crow, "Honey, put down that rolling pin!", 2);
   print "~A fine thing,~ he mumbles,~ to be walking around on such a night. A person could get lost.~^";
   Quip (-1, 0, Crow, "So, was this fable by Aesop?", 1);
   Quip (-1, 0, Tom, "No, I think it was by ~A sap~!", 1);
   Quip (-1, 0, Crow, "Dooh!", 2);
   print (Center)"~~~~~~~~~~~~~~~~~~~~", (NewLine)1;
   print (Center)"T H E      E N D", (NewLine)1;
   print (Center)"~~~~~~~~~~~~~~~~~~~~", (NewLine)1;
   Quip (-1, 1, Joel, "...does not justify the means.", 2);
   WaitForKey ("[Press any key...]");
   End ();	! The game ends here!
   rtrue;
  ],
 has
  light
;

! The raging fire
AGTRoom ROOM_Fire "the raging fire"
 with
  description
  [;
   print "Max is surrounded by flames. The whole forest is burning! If Max does not do something soon, he will be burned alive.^";
   Quip (0, 1, Joel, "[Wicked Witch voice] How about a little fire, scarecrow?", 1);
   Quip (0, 0, Crow, "[Lloyd Bridges voice] By this time my lungs were aching for air!", 1);
   Quip (0, 0, Tom, "Must you guys do that EVERY time?", 1);
   Quip (1, 1, Tom, "Oh, sure he will.", 1);
   ! CODE GOES HERE TO PLAY LUNGS ("By this time my lungs were aching for air.")
   rtrue;
  ],
  e_to ROOM_Patch,	! The patch
  n_to
  [;
   return self;
  ],
  s_to
  [;
   return self;
  ],
  w_to
  [;
   return self;
  ],
 has
  light
;

! The patch
AGTRoom ROOM_Patch "the patch"
 with
  description
  [;
   print "Max find himself in the only part of the forest not in flames, a patch of poison ivy. He walks through it gingerly trying not to touch anthing, ";
   Quip (0, 1, Tom, "We're in the middle of a forest fire and we're walking gingerly?", 2);
   print "but he is already beginning to feel itchy all over his body.^";
   Quip (1, 1, Crow, "[Peter Parker voice] My spider sense is tingling, Aunt Mae. Dr. Doom must be near.", 1);
   Quip (0, 1, Joel, "He's in love!", 1);
   rtrue;
  ],
  e_to ROOM_Study,	! The study
  n_to ROOM_Fire,	! The raging fire
  s_to ROOM_StreetA,	! Foggy street A
  w_to ROOM_StreetB	! Foggy street B
 has
  light
;

! Foggy street B
AGTRoom ROOM_StreetB "the foggy street"
 with
  description
  [;
   print "The is fog everywhere, ";
   Quip (0, 1, Tom, "Oh, that was me. Sorry.", 2);
   print "obscuring the entire landscape. Max feels suddenly like a huge cloud has lifted him up and taken him away. ";
   Quip (0, 1, Joel, "They're coming to take me away, ha ha.", 2);
   ! CODE HERE TO PLAY FOG ("Even The Fog didn't have this much fog.")
   "He wonders where he has gone.";
  ],
  e_to ROOM_StreetA,	! Foggy street A
  n_to ROOM_Cobble,	! The cobble street
  s_to
  [;
   return self;		! Foggy street B
  ],
  w_to ROOM_Bedroom	! The bedroom
 has
  light
;

! Foggy street C
AGTRoom ROOM_StreetC "the foggy street"
 with
  description
  [;
   print "The is fog everywhere, ";
   Quip (0, 1, Crow, "[Scottish accent] Stay off the moors!", 2);
   print "obscuring the entire landscape. Max feels suddenly like a huge cloud has lifted him up and taken him away. ";
   Quip (0, 1, Tom, "Hey guys, this game takes place in the fog, and it's a MiSTing! Get it?", 1);
   Quip (0, 0, Joel, "Shh, we're not supposed to know about that.", 2);
   print "He wonders where he has gone.^";
   Quip (0, 1, Crow, "London? [Embarrassed silence] You know, heh, heh, because it's... so... foggy there...", 1);
   rtrue;
  ],
  e_to ROOM_Study,	! The study
  n_to ROOM_Forest,	! The Forest
  s_to ROOM_StreetB,	! Foggy street B
  w_to ROOM_StreetA	! Foggy street A
 has
  light
;

! The alley
AGTRoom ROOM_Alley "the alley"
 with
  description
  [;
   print "Max watches four young girls jump rope in a red bricked alley not far from his home. ";
   Quip (1, 1, Joel, "Max's probation officer warns him not to, but Max doesn't listen...", 2);
   print "They play with an intensity that precludes any awareness that they are watched. The rope skips across the concrete as the girls chant with great seriousness,", (NewLine)2, "~Cinderella^Dressed in yell-a^Went upstairs to see her fella^How many kisses did she get:^One...^two...^three...~^";
   Quip (0, 1, Crow, "[singing] Hail, hail, fire and snow. Call the angel, we must go...", 1);
   Quip (0, 0, Tom, "Yeah, that's what this game reminds me of too.", 2);
   print "Suddenly the eldest girl spins around and stares at Max. The other girls all fall in behind her. ";
   Quip (0, 1, Joel, "What? Is my fly open?", 2);
   print "The jump rope lies on the ground, lifeless.^";
   Quip (1, 1, Crow, "[grumpily] What, what? Leave me alone, you dumb kids. Ahh!", 1);
   Quip (0, 1, Joel, "Like this script.", 1);
   ! CODE GOES HERE TO PLAY POINT ("What was the point...")
   rtrue;
  ],
  e_to ROOM_Hospital,	! The hospital
  n_to ROOM_StreetC,	! Foggy street C
  s_to ROOM_Parlor,	! The parlor
  w_to ROOM_Forest	! The forest
 has
  light
;

! The parlor
AGTRoom ROOM_Parlor "the parlor"
 with
  description
  [;
   print "Max is sitting next to Cora on a large green couch. ";
   Quip (1, 1, Joel, "So how's the date going?", 1);
   Quip (1, 0, Crow, "Sofa so good!", 1);
   Quip (1, 0, Tom, "Dooh!", 2);
   print "It is the hottest day of the summer. ";
   Quip (1, 0, Crow, "[Groucho Marx voice] ...if you know what I mean.", 2);
   print "They are content to sip lemonade, chat softly ";
   Quip (1, 1, Tom, "So, how do you like the Dodgers this year?", 2);
   print "and wait for Cora's roommate to leave the stuffy apartment. ";
   Quip (1, 1, Joel, "...and wait for Cora's stuffy roommate to leave the apartment.", 2);
   print "Max's desire for Cora is finally answered as she slips into his arms. He unbottons her blouse ";
   Quip (0, 1, Crow, "Ah, let the game begin!", 2);
   print "and beholds a vision that will mark him for the rest of his life. ";
   Quip (0, 1, Joel, "Body Piercing Mishaps. Next on Geraldo.", 2);
   print "Cora's breasts are beautiful ";
   Quip (1, 1, Tom, "Joel, do you think this scene is providing characterization and establishing narrative?", 1);
   Quip (1, 0, Joel, "Well no, but who cares?", 2);
   print "She wears a small silver cross around her neck which falls with erotic precision in the tuck of her cleavage. A drop of sweat has beaded up on Cora's collar bone and falls slowly down to meet the cross. For Max, the drop of sweat is pure magic, the most remarkable thing he has ever witnessed in his entire life. ";
   Quip (1, 1, Tom, "That I believe.", 2);
   print "Cora looks at him warmly and smiles.^";
   Quip (0, 1, Crow, "Oh yes, oh yes! Let's read the cleavage part again!", 1);
   Quip (0, 0, Joel, "Uh, Crow. Before you get too excited, remember that this is a GAGS game. The verbs you want to use aren't going to be there.", 1);
   Quip (0, 0, Crow, "What? Noooooooooo!", 1);
   ! CODE HERE TO PLAY BOOBS ("Oh, man, what a boob!")
   rtrue;
  ],
  e_to ROOM_Hospital,	! The hospital
  n_to ROOM_StreetA,	! Foggy street A
  s_to ROOM_Forest,	! The forest
  w_to ROOM_Bedroom	! The bedroom
 has
  light
;