/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <stdlib.h>

#include "glk.h"
#include "win.h"

void glk_stylehint_set(glui32 wintype, glui32 styl, glui32 hint,
    				   glsi32 val) {
	/*  We don't support style hints for now  */    				   
}
    				   
void glk_stylehint_clear(glui32 wintype, glui32 styl, glui32 hint) {
	/*  We don't support style hints for now  */
}

glui32 glk_style_distinguish(winid_t id, glui32 styl1, glui32 styl2) {
	win *w;

	w = lglk_get_window(id);
	if(w == NULL)
		return 0;	
	if(styl1 < 0 || styl1 >= style_NUMSTYLES || styl2 < 0 || styl2 >= style_NUMSTYLES)
		return 0;
	
	if(w->stylecolor[styl1] != w->stylecolor[styl2])
		return 1;
	else
		return 0;
}

glui32 lglk_console_to_rgba(unsigned char color) {
	int val[16];
	int at;
	
	for(at = 0; at < 8; at++) {
		val[at] = (at >= 8) ? 0xFF : 0x80;
	}
	
	return (val[color & (8 | 4)] << 16)	|
		   (val[color & (8 | 2)] << 8) |
		   (val[color & (8 | 1)] << 0);
}

glui32 glk_style_measure(winid_t id, glui32 styl, glui32 hint, 
    					 glui32 *result) {	    					
	win *w;
	
	w = lglk_get_window(id);
	if(w == NULL)
		return 0;	
	if(styl < 0 || styl >= style_NUMSTYLES)
		return 0;
	if(result == NULL)
		return 1;

	w = lglk_get_window(id);
	
	if(hint == stylehint_Size)
		*result = 1;
	else if(hint == stylehint_Justification) 
		*result = stylehint_just_LeftFlush;
	else if(hint == stylehint_TextColor) {
		*result = lglk_console_to_rgba((unsigned char)(w->stylecolor[styl] & 0x0f));
	} else if(hint == stylehint_BackColor) {
		*result = lglk_console_to_rgba((unsigned char)((w->stylecolor[styl] & 0x70) >> 4));
	} else
		*result = 0;
		
	return 1;
}
