/* Streams.c - buffered file i/o routines */
/*
	Copyright (c) 1993, by David Michael Betz
	All rights reserved
*/

#include "Streams.h"

/* prototypes */
static int FillBuffer(StreamHandle fh);
static void FlushBuffer(StreamHandle fh);

StreamHandle OpenStream(ConstStr255Param fName,short vRefNum)
{
    StreamHandle fh = nil;
    short fRefNum;
    if (FSOpen(fName,vRefNum,&fRefNum) == noErr) {
	if ((fh = (StreamHandle)NewHandle(sizeof(Stream))) == nil)
	    FSClose(fRefNum);
	else {
	    (*fh)->mode = StreamRead;
	    (*fh)->fRefNum = fRefNum;
	    (*fh)->cnt = 0;
	}
    }
    return fh;
}

StreamHandle CreateStream(ConstStr255Param fName,short vRefNum,long creator,long type)
{
    StreamHandle fh = nil;
    short fRefNum;
    FSDelete(fName,vRefNum);
    if (Create(fName,vRefNum,creator,type) == noErr) {
	if (FSOpen(fName,vRefNum,&fRefNum) == noErr) {
	    if ((fh = (StreamHandle)NewHandle(sizeof(Stream))) == nil)
		FSClose(fRefNum);
	    else {
		(*fh)->mode = StreamWrite;
		(*fh)->fRefNum = fRefNum;
		(*fh)->ptr = 0;
		(*fh)->cnt = 0;
	    }
	}
    }
    return fh;
}

void CloseStream(StreamHandle fh)
{
    HLock((Handle)fh);
    if ((*fh)->mode == StreamWrite)
	FlushBuffer(fh);
    FSClose((*fh)->fRefNum);
    HUnlock((Handle)fh);
    DisposHandle((Handle)fh);
}

int StreamGetC(StreamHandle fh)
{
    return --(*fh)->cnt >= 0 ? (*fh)->buf[(*fh)->ptr++] : FillBuffer(fh);
}

int StreamGetLine(StreamHandle fh,Str255 str)
{
    int cnt=0,ch;
    while ((ch = StreamGetC(fh)) != -1 && ch != '\r')
	if (cnt < 255) str[++cnt] = ch;
    str[0] = cnt;
    return cnt != 0 || ch != -1;
}

int StreamPutC(StreamHandle fh,int ch)
{
    (*fh)->buf[(*fh)->ptr++] = ch;
    if (++(*fh)->cnt == BSIZE)
	FlushBuffer(fh);
    return 0;
}

void StreamPutString(StreamHandle fh,ConstStr255Param str)
{
    int cnt = *str++;
    while (--cnt >= 0)
	StreamPutC(fh,*str++);
}

static int FillBuffer(StreamHandle fh)
{
    HLock((Handle)fh);
    (*fh)->cnt = BSIZE;
    FSRead((*fh)->fRefNum,&(*fh)->cnt,(*fh)->buf);
    (*fh)->ptr = 0;
    HUnlock((Handle)fh);
    return --(*fh)->cnt >= 0 ? (*fh)->buf[(*fh)->ptr++] : ((*fh)->cnt = 0, -1);
}

static void FlushBuffer(StreamHandle fh)
{
    if ((*fh)->cnt > 0) {
	HLock((Handle)fh);
	FSWrite((*fh)->fRefNum,&(*fh)->cnt,(*fh)->buf);
	(*fh)->ptr = 0;
	(*fh)->cnt = 0;
	HUnlock((Handle)fh);
    }
}
