/* ldef.c - a list definition proc */

#include <Quickdraw.h>
#include <Lists.h>
#include <SetUpA4.h>
#include "ldef.h"

typedef struct {
  ListDataProcPtr *procPtr;
} **ListDataHandle;

/* prototypes */
pascal long main(int lMessage,
		 Boolean lSelect,
		 Rect *lRect,
		 Cell lCell,
		 int lDataOffset,
		 int lDataLen,
		 ListHandle lHandle);
void MyInitialize(void);
void MyDraw(Boolean lSelect,
	    Rect *lRect,
	    Cell lCell,
	    int lDataOffset,
	    int lDataLen,
	    ListHandle lHandle);
void MyHighlight(Boolean lSelect,
		 Rect *lRect,
		 Cell lCell,
		 int lDataOffset,
		 int lDataLen,
		 ListHandle lHandle);
void MyClose(void);

pascal long main(int lMessage,
		 Boolean lSelect,
		 Rect *lRect,
		 Cell lCell,
		 int lDataOffset,
		 int lDataLen,
		 ListHandle lHandle)
{
    RememberA0();
    SetUpA4();

    switch (lMessage) {
    case lInitMsg:
	MyInitialize();
	break;
    case lDrawMsg:
	MyDraw(lSelect,lRect,lCell,lDataOffset,lDataLen,lHandle);
	break;
    case lHiliteMsg:
	MyHighlight(lSelect,lRect,lCell,lDataOffset,lDataLen,lHandle);
	break;
    case lCloseMsg:
	MyClose();
	break;
    }
	
    RestoreA4();
}

void MyInitialize(void)
{
}

void MyDraw(Boolean lSelect,
	    Rect *lRect,
	    Cell lCell,
	    int lDataOffset,
	    int lDataLen,
	    ListHandle lHandle)
{
    ListDataHandle dataHandle;
    DataHandle cells;
    Str255 buf;
    void *data;
    EraseRect(lRect);
    cells = (*lHandle)->cells;
    HLock(cells);
    data = (long *)((char *)*cells + lDataOffset);
    if ((dataHandle = (ListDataHandle)(*lHandle)->refCon) == nil)
	NumToString((long)data,buf);
    else
	(*(*dataHandle)->procPtr)(lHandle,data,lDataLen,buf);
    MoveTo(lRect->left+2,lRect->bottom-4);
    DrawString(buf);
    HUnlock(cells);
    if (lSelect)
	InvertRect(lRect);
}

void MyHighlight(Boolean lSelect,
		 Rect *lRect,
		 Cell lCell,
		 int lDataOffset,
		 int lDataLen,
		 ListHandle lHandle)
{
    MyDraw(lSelect,lRect,lCell,lDataOffset,lDataLen,lHandle);
}

void MyClose(void)
{
}

