/*----------------------------------------------------------------------*\

	smScan.c

	ScannerMaker generated scanner

\*----------------------------------------------------------------------*/

/* %%IMPORT */


#include "sysdep.h"

#include "types.h"

#include "alan.h"
#include "lmList.h"
#include "encode.h"

/* For open, read & close */
#ifdef __sun__
#include <unistd.h>
#include <fcntl.h>
#endif
#ifdef __vms__
#include <unixio.h>
#endif
#ifdef __dos__
#include <io.h>
#endif
#ifdef __mac__
#include <fcntl.h>
#endif


/* END %%IMPORT */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "smScan.h"

/* Local imports */
extern int smScReader( smScContext smThis, unsigned char *smBuffer, unsigned int smLength );
extern int smScAction( smScContext smThis, int smInternalCode, Token *smToken );
extern int smScPostHook( smScContext smThis, Token *smToken );

/* System dependencies */

/* These datatypes should be defined to be unsigned integers of length 1, 2
 * and 4 bytes respectively.
 */
typedef unsigned char UByte1;
typedef unsigned short UByte2;
typedef unsigned int UByte4;


/* START of scanning tables */


/*
 * MAP
 *
 * [character] -> character
 *
 */

static UByte1 smMap[256]={
0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47
,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63
,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79
,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95
,96,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79
,80,81,82,83,84,85,86,87,88,89,90,91,92,93,126,127
,128,129,130,131,132,133,134,220,203,215,128,204,129,130,131,197
,183,201,178,179,195,196,132,222,221,189,133,205,210,211,223,134
,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175
,176,177,178,179,180,181,198,183,184,185,186,187,188,189,174,175
,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,206
,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223
,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239
,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255
}
;


/*
 * SCANNER
 *
 * [scanner] -> state
 */

static UByte1 smScanner[2]={
0,1
}
;

/*
 * ACCEPT (internal token code)
 *
 * [state] -> icode
 */

static UByte1 smAccept[343]={
0,0,107,8,5,6,7,9,1,10,2,11,101,4,13,3
,12,102,113,104,103,108,27,24,25,18,26,23,19,20,17,16
,22,21,14,15,110,30,32,28,37,33,31,39,29,34,35,38
,36,41,45,42,54,51,52,53,47,55,43,44,49,48,40,50
,46,56,63,59,62,66,61,57,65,58,64,60,80,76,77,72
,71,75,79,67,78,69,70,68,74,73,87,88,83,86,82,81
,84,85,109,95,94,91,93,89,92,90,96,98,97,99,100,0
,102,103,0,102,0,102,0,102,0,102,0,102,0,102,0,102
,0,102,0,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102,102
,102,102,102,102,102,102,102
}
;

/*
 * EXTERNAL TOKEN CODE
 *
 * [icode] -> ecode
 */

static UByte1 smTokenCode[113]={
4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19
,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35
,36,37,38,39,40,41,42,43,44,45,47,48,49,50,51,52
,53,54,55,56,57,58,59,60,61,62,63,65,66,67,68,69
,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85
,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101
,102,103,104,105,64,3,3,46,1,2,0,0,0,3,1,2
,0
}
;

/*
 * EOT and Unknown
 *
 * [scanner] -> icode
 *
 */

static UByte1 smEOTCode[2]={
105,111
}
;
static UByte1 smUnknownCode[2]={
104,110
}
;

/*
 * DFA
 */

  
static UByte1 smDFAdetRow[343]={
1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1
,0,1,0,0,0,0,0,0,0,0,0,1,0,0,1,1
,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1
,1,0,0,1,1,1,1,1,0,1,0,1,0,1,0,1
,0,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1
}
;
static UByte1 smDFAdetCol[256]={
1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1
}
;
  
static UByte2 smDFArowVal[343]={
135,180,2,343,343,343,343,343,343,21,343,343,12,343,212,180
,26,268,18,111,343,21,343,343,343,343,343,349,304,304,403,180
,304,212,304,304,118,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,241,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,343,304,304,304,304,304,304,304,304,304,304,304,304,0
,295,116,120,322,45,376,90,430,122,457,124,484,126,511,128,538
,130,565,98,592,619,646,673,700,727,754,781,808,835,862,889,916
,943,970,997,1024,1051,1078,1105,1132,1159,1186,1213,1240,1267,1294,1321,1348
,1375,1402,1429,1456,1483,1510,1537,1564,1591,1618,1645,1672,1699,1726,1753,1780
,1807,1834,1861,1888,1915,1942,1969,1996,2023,2050,2077,2104,2131,2158,2185,2212
,2239,2266,2293,2320,2347,2374,2401,2428,2455,2482,2509,2536,2563,2590,2617,2644
,2671,2698,2725,2752,2779,2806,2833,2860,2887,2914,2941,2968,2995,3022,3049,3076
,3103,3130,3157,3184,3211,3238,3265,3292,3319,3346,3373,3400,3427,3454,3481,3508
,3535,3562,3589,3616,3643,3670,3697,3724,3751,3778,3805,3832,3859,3886,3913,3940
,3967,3994,4021,4048,4075,4102,4129,4156,4183,4210,4237,4264,4291,4318,4345,4372
,4399,4426,4453,4480,4507,4534,4561,4588,4615,4642,4669,4696,4723,4750,4777,4804
,4831,4858,4885,4912,4939,4966,4993,5020,5047,5074,5101,5128,5155,5182,5209,5236
,304,5263,5290,5317,5344,5371,5398,5425,5452,5479,5506,5533,5560,5587,5614,5641
,5668,5695,5722,5749,5776,5803,5830,5857,5884,5911,5938,5965,5992,6019,6046,6073
,6100,6127,6154,6181,6208,6235,6262
}
;
static UByte1 smDFAcolVal[256]={
0,0,0,0,0,0,0,0,0,29,31,0,0,29,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,29,40,41,0,42,0,0,30,43,44,32,33,34,35,38,39
,0,0,0,0,0,0,0,0,0,0,36,0,37,27,28,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,26,26,26,0,0
,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
,16,17,18,19,20,21,22,23,24,25,26,26,26,26,0,0
,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26
,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,26
,0,0,26,26,0,0,26,26,26,0,0,0,0,26,26,26
,0,0,0,26,26,26,26,0,0,26,0,26,26,26,26,26
,0,0,26,26,0,0,0,26,0,0,0,0,26,26,26,26
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
}
;
static UByte1 smDFAerr[(21*20+7)/8]={
0x80,0x00,0x19,0xDF,0xFF,0x8F,0xFF,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xF7,0xFF,0xFF,
0x9F,0xFF,0xFB,0xFF,0xFF,0x60,0x09,0xFF,0xFF,0xFB,0xFF,0xF2,0x00,0x00,0xFD,0xFF,
0xF0,0x00,0x00,0xFF,0xFE,0xFF,0xFF,0xFB,0xFF,0xF7,0xFF,0xFF,0xF7,0xFF,0xFF,0xDF,
0xFF,0xBF,0xFF,0xFD,0xF0
};
  
static UByte1 smDFAerrRow[343]={
0,1,2,3,3,3,3,3,3,4,3,3,5,3,6,6
,7,8,9,10,3,11,3,3,3,3,3,8,8,8,8,8
,8,8,8,8,12,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,3,8,8,8,8,8,8,8,8,8,8,8,8,13
,8,12,14,8,13,8,13,8,15,8,16,8,17,8,18,8
,19,8,20,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
,8,8,8,8,8,8,8
}
;
static UByte1 smDFAerrCol[256]={
0,0,0,0,0,0,0,0,0,1,2,0,0,3,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,1,4,5,0,4,0,0,6,4,4,4,4,4,7,4,4
,8,8,8,8,8,8,8,8,8,8,4,0,4,9,10,0
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,11,11,11,0,19
,0,11,11,12,13,14,11,11,11,15,11,11,16,11,17,11
,11,11,11,11,11,18,11,11,11,11,11,11,11,11,0,0
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,11
,0,0,11,11,0,0,11,11,11,0,0,0,0,11,11,11
,0,0,0,11,11,11,11,0,0,11,0,11,11,11,11,11
,0,0,11,11,0,0,0,11,0,0,0,0,11,11,11,11
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
}
;
  
static UByte2 smDFAval[6289]={
111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111
,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111,111
,111,111,111,111,111,111,111,111,111,19,111,111,111,116,116,116
,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116,116
,116,116,116,116,116,116,116,116,116,116,116,113,20,116,116,116
,116,116,116,116,116,116,116,116,116,116,118,118,118,118,118,118
,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118,118
,118,118,118,118,118,118,118,118,36,118,118,118,118,118,118,118
,118,118,118,118,118,118,118,12,17,112,115,261,199,200,304,201
,117,304,304,262,202,203,119,304,263,329,204,121,205,264,265,304
,304,304,15,16,2,116,2,6,7,8,9,13,14,10,11,3
,111,114,4,5,304,42,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,24
,25,18,118,18,304,304,304,304,304,304,304,304,304,304,304,304
,146,304,304,304,304,304,304,304,304,304,304,304,304,304,304,22
,23,304,304,304,304,304,304,304,304,304,257,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,266
,304,304,267,304,304,304,304,304,304,304,123,304,304,304,125,304
,27,304,304,304,304,304,304,304,304,304,304,304,305,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,28,304,304,306,304,304,304,304,304,304,268,304,304,304,304,304
,304,269,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,342,304,304,304,304,304,304,304,304,304,304,304,304,29,304
,304,304,304,304,304,304,30,304,304,304,304,31,304,304,304,304
,304,304,304,304,304,304,336,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,316,304,304,304,304,304,304,304,304
,309,304,304,304,32,304,304,304,304,304,304,304,33,304,331,304
,34,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,215,304,304,304,304,304,304,35,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,37,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,38,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,313,304,304,304,304,304,304,304,304,304,304,39,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,40,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,41,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,144,304,304,304,304,304,304,304,304,304
,304,304,304,43,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,44,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,148,304,304,45,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,46,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,47,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,48,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,49,304,304,304,304,304,304,304,304,304,304,304,304,50,304,304
,304,158,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,51,304,304,304,304,304,304,304,304
,304,304,304,52,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,53,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,54
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,55,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,56
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,57,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,58,304,304,304,304,304,304,304,304,304,304,304
,59,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,60,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,61
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,62,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,63,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,64,304,304,304,164,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,65
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,66,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,67,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,68,304,304,304,304,304,304,304,304,304,304,304,304,69
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,70,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,71,304,304,304,304,304,304,304,304,304,304,304,72
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,73,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,74,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,75,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,76,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,77,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,78,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,79,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,80,304,304,304,304,304,304,304,304,304,304
,304,304,81,304,304,304,254,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,82,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,83,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,84,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,85,304,304
,304,304,304,304,304,304,304,304,304,304,304,86,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,87,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,88,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,89,304,304,304,304,304,304,304
,304,304,304,304,304,90,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,91,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,92,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,93,304,304,304,304,304,304,304,304,304,304,304,304
,304,94,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,95,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,96,304,304,304,304,304,304,304,304,304
,304,304,97,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,194,304,304
,304,304,304,304,304,304,304,304,304,304,304,99,304,304,304,304
,304,304,304,304,304,304,304,304,100,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,101,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,102,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,103,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,104,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,105,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,106,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,107,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,108
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,109,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,110
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,207,270,127,304,304,304,304,304
,304,304,271,304,208,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,129,304,304,304,304,304,304,304,304,304
,304,304,304,131,304,304,304,209,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,132,304
,304,304,330,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,212,304,304,304,308,304,304
,304,304,304,304,304,304,304,133,304,304,304,304,304,304,304,304
,304,304,304,304,134,304,272,304,135,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,214,136,304,304,304,311,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,273,304,304,304
,304,137,304,304,304,304,304,304,304,304,304,304,304,304,138,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,139,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,140,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,277,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,141,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,278,304,304,304,304,304,142,304,304,304,304,304,304,304
,304,304,304,279,304,304,304,304,304,304,304,304,304,304,304,143
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,145,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,147
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,226,304,304,304,149,304,304,304,304,304,304,304,304,304
,304,304,304,284,304,304,304,304,304,304,304,304,304,304,304,304
,304,150,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,151,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,152,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,153,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,154,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,155,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,156,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,157,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,159,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,160,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,161,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,162,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,163,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,165,304,304
,304,304,304,304,304,304,304,304,304,304,304,166,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,167
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,168,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,169,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,170,304,304,304,304,304,304,304,304,171
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,172,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,173,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,174,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,175,304,304,304,304,304,304,304,304
,304,304,304,304,304,176,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,177,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,178,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,179,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,180,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,181,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,182,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,183,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,184,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,185,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,186,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,187,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,188,304,304,304,304
,304,304,304,304,304,189,304,304,304,304,304,304,304,304,304,304
,304,304,304,328,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,190,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,191,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,192,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,193,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,195,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,196,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,197,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,198,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,307,304,304,304,304
,304,304,304,304,304,206,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,210,304,304,304,304,304
,211,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,213,304,304,304,304,304,304,304,304,304,304,216,304,304,304
,312,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,217,304,304,304,304,304,304,218,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,219,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,220,304,304,304
,304,304,304,304,304,304,304,304,221,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,333,304,304,304
,304,304,304,222,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,223,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,224,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,337,304,304,304,304,304,304,225,304
,304,283,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,227,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,228,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,229,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,230,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,231,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,232,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,233,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,234,304,304,304,304,304,304
,304,304,304,304,304,304,304,235,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,236,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,237,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,238,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,325,304,304
,304,304,239,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,240,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,241,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,242,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,243
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,244,304,304,304,304,304
,304,304,304,304,304,304,304,245,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,246,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,247,304,304,304,304,304,304,304,304,304,304
,304,304,248,304,304,304,304,304,304,304,304,304,304,304,304,304
,249,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,250,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,251,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,252,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,253,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,255,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,256,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,258,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,259,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,260,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,274,304,304,304,304,304,304,304,304,304,304
,304,304,304,314,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,275,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,334,304,304,315,304,304,304,304
,304,304,304,304,304,276,304,304,335,304,304,304,304,304,304,304
,304,280,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,281,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,282,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,285
,304,304,304,304,286,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,287
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,288,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,289,304,304,304,304,290,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,291,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,292,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,293,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,294,304,304
,304,304,304,304,304,295,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,296,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,297,304,304,304
,304,304,304,304,304,304,304,304,304,304,298,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,299,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,300,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,301,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,302,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,303,304,304,304,304,304,304,304,310,304,304,304,332,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,340,304,304,304,304,317,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,318,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,319,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,320,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,321,304,304,304,304,304,304,304,304,304,304,304,322,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,323,304,304,304,304,304,304,304,304,304
,304,304,304,304,324,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,326,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,327,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,338,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,339,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304,304
,304,304,304,304,304,304,304,304,341,304,304,304,304,304,304,304
,304
}
;
  


/* END of scanning tables */






/*
 * Source position calculation 
 */

static void smSourcePosition(
     smScContext smThis,
     unsigned char *smAt,
     unsigned char *smEnd)
{
  if(smThis->smPosContinue<smEnd) {
    if(smThis->smPosContinue>smAt) smAt=smThis->smPosContinue;
    smThis->smNextPosition+=smEnd-smAt;
    for(;smAt<smEnd;smAt++) 
      if(*smAt==10) {
	smThis->smPosLine=smAt;
	smThis->smNextLine++;
      } else if ((*smAt==13) && (*(smAt+1)==10)) {
	smThis->smPosLine=smAt++;
	smThis->smNextLine++;
      }

    smThis->smNextColumn=smEnd-smThis->smPosLine;
    smThis->smPosContinue=smEnd;
  }
}

static void smRewindSourcePosition(
     smScContext smThis,
     unsigned char *smAt,
     unsigned char *smEnd)
{
  if(smThis->smPosContinue>smEnd) return;
  smThis->smNextPosition-=smEnd-smAt;
  while(smAt<smEnd--) if(*smEnd==10) smThis->smNextLine--;
  while(smThis->smBegining<smEnd) 
    if(*smEnd==10) {
      smThis->smPosLine=smEnd;
      break; 
    }
    else smEnd--;
  if(smAt<smThis->smPosLine) smThis->smPosLine=smThis->smPosPrevLine;
  smThis->smNextColumn=smAt-smThis->smPosLine;
  smThis->smPosContinue=smAt;
}


/*
 * int smReadBuffer(SMContext smThis)
 *
 * SmThis function reads charcters using the reader into the buffer in a
 * context. The buffer is enlarged if the current buffer is full
 * (smEnd-smText==smSize) or reduced if current buffer is larger than
 * the standard buffer size and the token may fit the standard buffer
 * (smEnd-smText<smTokenSize AND smSize>smTokenSize). The function
 * returns the number of characters read into the buffer.
 *
 */

static int smReadBuffer(smScContext smThis)
{
  long length;
  int size;
  long mod;

  if(smThis->smBegining!=smThis->smText) {
    /* Move data to beginning of buffer */
    length=smThis->smEnd-smThis->smText;
    memcpy((void *)smThis->smBegining,(void *)smThis->smText,(size_t)length);
    if(length<1024 && smThis->smSize>1024) {
      /* Reduce buffer size */
      smThis->smSize=1024;
      smThis->smBegining=(unsigned char *)realloc(smThis->smBegining,(size_t)1024+1);
    }
  }
  else if(smThis->smBegining+smThis->smSize==smThis->smEnd) {
    /* Try to enlarge buffer */
    if(smThis->smSize==524288) {
      /* Cut Buffer */
      smSourcePosition(smThis,smThis->smText,smThis->smEnd-1024);
      memcpy((void *)smThis->smBegining,(void *)(smThis->smEnd-1024),(size_t)1024);
      mod=smThis->smEnd-smThis->smBegining-1024;
      smThis->smContinue-=mod;
      smThis->smEnd-=mod;
      smThis->smPosPrevLine-=mod;
      smThis->smPosLine-=mod;
      smThis->smPosContinue-=mod;
      smThis->smBufferOverflow+=mod;
    }
    else {
      unsigned char *begining = smThis->smBegining;
      size=smThis->smSize*1.5;
      if(size>524288) size=524288;
      /* Enlarge buffer */
      smThis->smBegining=(unsigned char *)realloc(smThis->smBegining,(size_t)size+1);
      if(smThis->smBegining==NULL) {
	/* Cut Buffer */
	smThis->smBegining = begining;	/* Restore to original buffer */
	smSourcePosition(smThis,smThis->smText,smThis->smEnd-1024);
	memcpy((void *)smThis->smBegining, (void *)(smThis->smEnd-1024), (size_t)1024);
	mod=smThis->smEnd-smThis->smBegining-1024;
	smThis->smContinue-=mod;
	smThis->smEnd-=mod;
	smThis->smPosPrevLine-=mod;
	smThis->smPosLine-=mod;
	smThis->smPosContinue-=mod;
        smThis->smBufferOverflow+=mod;
      }
      else
	smThis->smSize=size;
    }
  }
  if(smThis->smBegining!=smThis->smText) {
    mod=smThis->smText-smThis->smBegining;
    smThis->smContinue-=mod;
    smThis->smEnd-=mod;
    smThis->smPosPrevLine-=mod;
    smThis->smPosLine-=mod;
    smThis->smPosContinue-=mod;
    smThis->smText-=mod;
  }
  length=smThis->smSize-(smThis->smEnd-smThis->smBegining);
  length=smScReader(smThis,smThis->smEnd,(unsigned int)length);
  if(length<0) return length;
  smThis->smEnd+=length;
  return length;
}

/*
 * SMContext SMNew( smScScanner scanner )
 *
 * Create a new context.
 *
 */

smScContext smScNew(smScScanner smScanner)
{
  smScContext smThis;

  smThis=(smScContext)malloc((size_t)sizeof(smScContextItem));
  if(smThis==NULL) {
    return NULL;
  }
  smThis->smBegining=(unsigned char *)malloc((size_t)1024+1);
  if(smThis->smBegining==NULL) {
    free((char *)smThis);
    return NULL;
  }
  smThis->smSize=1024;
  smThis->smContinue=smThis->smBegining;
  smThis->smEnd=smThis->smBegining;
  smThis->smPosPrevLine=smThis->smBegining-1;
  smThis->smPosLine=smThis->smBegining-1;
  smThis->smPosContinue=smThis->smBegining;
  smThis->smText=smThis->smBegining;
  
  smThis->smLength=0;
  smThis->smNextLine=1;
  smThis->smNextColumn=1;
  smThis->smNextPosition=0;
  smThis->smLine=1;
  smThis->smColumn=1;
  smThis->smPosition=0;
  smThis->smScanner=smScanner;
  smThis->smBegining[0]=0;
  return smThis;
}

/*
 * void SMDelete( SMContext smThis )
 *
 * Destroy a context and associated buffer.
 *
 */

void smScDelete(smScContext smThis)
{
  free((char *)smThis->smBegining);
  free((char *)smThis);
}

/*
 * int SMSkip( SMContext smThis, int smLength )
 *
 * Enlarge/reduce the current token in a context with length characters.
 * If length is less than zero reduce the token, if length is greater
 * than zero enlarge the token.
 *
 */

int smScSkip(
     smScContext smThis,
     int smLength)
{
  int empty;

  if(smLength>0) {
    empty=smThis->smEnd-smThis->smContinue;
    if(empty<smLength) {
      empty=smReadBuffer(smThis);
      if(empty<0) return empty;
      empty=smThis->smEnd-smThis->smContinue;
      if(empty<smLength) smLength=empty;
    }
    smSourcePosition(smThis,smThis->smContinue,smThis->smContinue+smLength);
    smThis->smContinue+=smLength;
    smThis->smLength+=smLength;
  }
  else if(smLength<0) {
    smLength= -smLength;
    if(smLength>smThis->smLength) smLength=smThis->smLength;
    smRewindSourcePosition(smThis,smThis->smContinue-smLength,smThis->smContinue);
    smThis->smContinue-=smLength;
    smThis->smLength-=smLength;
    }
  return smLength;
}

int smScModify(
     smScContext smThis,
     unsigned char *smBuffer,
     int smLength)
{
  if(smLength<0) {
/* This code is identical to smSkip but no source position is rewinded */
    smLength= -smLength;
    if(smLength>smThis->smLength) smLength=smThis->smLength;
    smThis->smContinue-=smLength;
    smThis->smLength-=smLength;
/***********************************************************************/
    memcpy((void *)smThis->smContinue,(void *)smBuffer,(size_t)smLength);
    return smLength;
  }
  else if(smLength>0) {
    int length1;
    int length2;
    
    for(length2=smLength;(length1=smScSkip(smThis,length2));length2-=length1) {
      if(length1<0) return length1;
      memcpy((void *)(smThis->smContinue-length1),(void *)smBuffer,(size_t)length1);
      smBuffer+=length1;
    }
    return smLength-length2;
  }
  return smLength;
}

int smScCopy(
     smScContext smThis,
     unsigned char *smBuffer,
     unsigned int smFrom,
     unsigned int smTo)
{
  if(smFrom>smThis->smLength) smFrom=smThis->smLength;
  if(smTo>smThis->smLength) smTo=smThis->smLength;
  memcpy((void *)smBuffer,(void *)(smThis->smText+smFrom),(size_t)smTo-smFrom);
  return smTo-smFrom;
}

int smScMapCopy(
     smScContext smThis,
     unsigned char *smBuffer,
     unsigned int smFrom,
     unsigned int smTo)
{
  int n;
  int len;
  unsigned char *at;

  if(smFrom>smThis->smLength) smFrom=smThis->smLength;
  if(smTo>smThis->smLength) smTo=smThis->smLength;
  len=0;
  for(n=smFrom,at=smThis->smText+smFrom;n<smTo;n++) {
*smBuffer++=smMap[*at++];
    len++;
  }
  return len;
}

void smScScrScanner(
     smScScanner smScanner,
     int smOnOff)
{
}

void smScScrToken(
     smScScanner smScanner,
     int smCode,
     int smOnOff)
{
}

void smScScrRule(
     smScScanner smScanner,
     int smCode,
     int smOnOff)
{
}

int smScan(
     smScContext smThis,
     Token *smToken)
{
  unsigned char *at;
  unsigned char *end;
  unsigned char *rew_at;
  unsigned char ch;
  int state;
  int rew_state;
  int code;

  do {				/* Skip loop */
    smThis->smLine=smThis->smNextLine;
    smThis->smColumn=smThis->smNextColumn;
    smThis->smPosition=smThis->smNextPosition;
    end=(smThis->smEnd);
    smThis->smText=smThis->smContinue;
    smThis->smBufferOverflow=0;
    smToken->srcp.line=smThis->smNextLine;
    smToken->srcp.col=smThis->smNextColumn;
    smThis->smPosPrevLine=smThis->smPosLine;
    rew_at=smThis->smText;
    do {			/* Continue loop */
      rew_state=343;
      rew_at++;
      at=(smThis->smContinue);
      state=smScanner[smThis->smScanner];
      for (;;) {
	if(at==end) {
	  int mod;
	  
	  if(state>=343) state-=343+1;
	  smThis->smContinue=end;
	  mod=smReadBuffer(smThis);
	  if(mod<0) return mod;
	  rew_at-=end-smThis->smContinue;
	  at=smThis->smContinue;
	  end=smThis->smEnd;
          if(at==end) 
	    break;
        }
	  ch = *at++;
{
  int smERRindex;

  
  
  
  smERRindex=smDFAerrRow[state]*20+smDFAerrCol[ch];
  
  if(smDFAerr[smERRindex>>3] & (0x80>>(smERRindex&0x7))) 
    state=343;
  else {
  
    if(smDFAdetRow[state]<smDFAdetCol[ch])
   state=smDFArowVal[state];
    else if(smDFAdetRow[state]>smDFAdetCol[ch])
    state=smDFAcolVal[ch];
    else
  
  
      state=smDFAval[smDFArowVal[state]+smDFAcolVal[ch]];
  
  }
}
	  if(state>=343) break;
	  if(smAccept[state]>0) {
	    rew_state=state;
	    rew_at=at;
	  }
      }
      if(rew_state==343) {
        if(rew_at>end) {
  	  code=smEOTCode[smThis->smScanner];
	  rew_at=end;
        }
        else
	  code=smUnknownCode[smThis->smScanner];
      }	
      else
	code=smAccept[rew_state]-1;	
      smThis->smContinue=rew_at;
      smThis->smLength=smThis->smContinue-smThis->smText;
      smSourcePosition(smThis,smThis->smText,smThis->smContinue);
      smToken->code=smTokenCode[code]-1;
      code=smScAction(smThis,code,smToken);
    } while(code<-1);
    smToken->code=code;
    code=smScPostHook(smThis,smToken);
  } while(code<0);
  return smToken->code=code;
}
