// WinAceView.cpp : implementation of the CWinAceView class
//
/*################################################################################
#
#  winace - Adventure Creation Environment
#
#
#  Copyright:
#    1997 - 2010 Andy Clark
#
#  License:
#    LGPL: http://www.gnu.org/licenses/lgpl.html
#    See the COPYING.LESSER file in the project's top-level directory for details.
#
#  Authors:
#    * Andy Clark
#
################################################################################*/

#include "stdafx.h"
#include "WinAce.h"

#include "afx.h"
#include "ListCtrlCombo.h"
#include "ObjectDialog.h"
#include "WinAceDoc.h"
#include "WinAceView.h"


#include <mshtml.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinAceView

IMPLEMENT_DYNCREATE(CWinAceView, CFormView)

BEGIN_MESSAGE_MAP(CWinAceView, CFormView)
	//{{AFX_MSG_MAP(CWinAceView)
	ON_BN_CLICKED(IDC_BUTTON1, OnButtonClicked)
	ON_WM_SIZE()
	ON_WM_KEYDOWN()
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	ON_EN_KILLFOCUS(IDC_EDIT1, OnKillfocusEdit1)
	ON_WM_TIMER()
	ON_COMMAND(ID_DEBUG_FLAGS, OnDebugFlags)
	ON_COMMAND(ID_DEBUG_PARSER, OnDebugParser)
	ON_COMMAND(ID_DEBUG_SINGLESTEP, OnDebugSinglestep)
	ON_COMMAND(ID_OPTIONS, OnOptions)
	ON_COMMAND(ID_DEBUG_OBJECTS, OnDebugObjects)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CFormView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CFormView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinAceView construction/destruction

CWinAceView::CWinAceView()
	: CFormView(CWinAceView::IDD)
{
	//{{AFX_DATA_INIT(CWinAceView)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// TODO: add construction code here

OutputStream = new COutputStream();

OutputStream->SetView(this );
wantKeyPress=false;
debugging = false;
is_quitting=false;



}

CWinAceView::~CWinAceView()
{
	delete OutputStream;
}

void CWinAceView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWinAceView)
	DDX_Control(pDX, IDC_BUTTON1, m_Button);
	DDX_Control(pDX, IDC_EDIT2, m_prompt);
	DDX_Control(pDX, IDC_EDIT1, m_commandControl);
	DDX_Control(pDX, IDC_EXPLORER1, m_browser2);
	//}}AFX_DATA_MAP
}

BOOL CWinAceView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CWinAceView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();

	m_commandControl.
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	b_initalUpdate=false;
	m_browser2.Navigate(_T("about:blank"),NULL, NULL, NULL,NULL );
	m_browser2.GetDocument();
	m_prompt.SetWindowText(_T("What Next?"));

	GetDocument()->SetMainView(this);
	p_flagsDialog = NULL;
	p_objDlg = NULL;

}

/////////////////////////////////////////////////////////////////////////////
// CWinAceView printing

BOOL CWinAceView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CWinAceView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CWinAceView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CWinAceView::OnPrint(CDC* pDC, CPrintInfo* /*pInfo*/)
{
	// TODO: add customized printing code here
	
}

/////////////////////////////////////////////////////////////////////////////
// CWinAceView diagnostics

#ifdef _DEBUG
void CWinAceView::AssertValid() const
{
	CFormView::AssertValid();
}

void CWinAceView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CWinAceDoc* CWinAceView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWinAceDoc)));
	return (CWinAceDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinAceView message handlers

void CWinAceView::OnButtonClicked() 
{
	try {
	if (!is_quitting)
	{
	CString Command;

	m_commandControl.GetWindowText( Command );
	m_Button.EnableWindow( false );

	m_commandControl.EnableWindow( false );;
	GetDocument()->NewCommand( Command );
	if ( !is_quitting )
	{
		m_commandControl.SetWindowText(_T(""));
		m_commandControl.SetFocus();
	}
	}
	}
	catch ( ... )
	{}
}

void CWinAceView::OnSize(UINT nType, int cx, int cy) 
{
	if ( b_initalUpdate == false )
	{

		CRect editSz, promptSz;
		m_commandControl.GetWindowRect( editSz );
		m_prompt.GetWindowRect( promptSz );


		m_browser2.MoveWindow(10,10 ,cx-20,cy-editSz.Height()-30  );

		m_commandControl.MoveWindow(promptSz.Width()+15,cy-editSz.Height()-10,cx-(promptSz.Width()+10+20),editSz.Height());
		m_prompt.MoveWindow( 10, cy-promptSz.Height()-10, promptSz.Width(), promptSz.Height() );
	}

		CFormView::OnSize(nType, cx, cy);
	
}

void CWinAceView::AddHTML(CString html)
{
	IHTMLDocument2* pHTMLDocument2;
	IHTMLWindow2* pHTMLWindow2;
	LPDISPATCH lpDispatch;

	html.Replace( _T("file:"), _T("file://")+CString(GetDocument()->getFileName())+_T("/"));

	// 1.
	// We get a dispatch pointer to the Document
	lpDispatch = m_browser2.GetDocument();

	if (lpDispatch)
	{
		HRESULT hr;
		hr = lpDispatch->QueryInterface(IID_IHTMLDocument2,
			                            (LPVOID*)
								&pHTMLDocument2);
		lpDispatch->Release();
		ASSERT(SUCCEEDED(hr));


		IHTMLElement*  pBody;

		/// 2
		/// We get a pointer to the body
		HRESULT nhr = pHTMLDocument2 -> get_body(&pBody);

		

		if (FAILED(hr)) return;

		
		pHTMLDocument2->get_parentWindow( &pHTMLWindow2 );

		
		BSTR BstrTexTToBeAdded;    // for some reason 2 piece
		                            // creation of BSTR s is preferable.
		BstrTexTToBeAdded = 	CString(html).AllocSysString();
	
		/// 3.
		/// We insert a string of HTML to the end of the document
	      pBody->insertAdjacentHTML(L"BeforeEnd",
         	                 BstrTexTToBeAdded);
	
	   SysFreeString(BstrTexTToBeAdded);

	   //Scroll the HTML Window

	   if ( !b_initalUpdate )
	   {
				   pHTMLWindow2->scrollTo(0,100000);
	   }


	   /// 4. Release the pointer to the body
	   pBody->Release();
	}

	/// 5. Release the pointer to the document
	pHTMLDocument2->Release();	
}

void CWinAceView::ClearHTML()
{
		IHTMLDocument2* pHTMLDocument2;
	IHTMLWindow2* pHTMLWindow2;
	LPDISPATCH lpDispatch;

	// 1.
	// We get a dispatch pointer to the Document
	lpDispatch = m_browser2.GetDocument();

	if (lpDispatch)
	{
		HRESULT hr;
		hr = lpDispatch->QueryInterface(IID_IHTMLDocument2,
			                            (LPVOID*)
								&pHTMLDocument2);
		lpDispatch->Release();
		ASSERT(SUCCEEDED(hr));


		IHTMLElement*  pBody;

		/// 2
		/// We get a pointer to the body
		HRESULT nhr = pHTMLDocument2 -> get_body(&pBody);

		//pHTMLDocument2->put_designMode(L"true");

		if (FAILED(hr)) return;

		
		pHTMLDocument2->get_parentWindow( &pHTMLWindow2 );

		
		BSTR BstrTexTToBeAdded;    // for some reason 2 piece
		                            // creation of BSTR s is preferable.
		CString baseTag = CString("<base href='file://")+CString(GetDocument()->getFileName())+CString("/' />");

		CString text(CString("<html><head>")+baseTag+CString("</head><body><link type='text/css' rel='stylesheet' href='style.css' />"));
      
		//::AfxMessageBox(text );

		BstrTexTToBeAdded = 	(text).AllocSysString();
	
		/// 3.
		/// We insert a string of HTML to the end of the document

		pBody->put_innerHTML( BstrTexTToBeAdded );
	      
	
	   SysFreeString(BstrTexTToBeAdded);

	   //Scroll the HTML Window

	   if ( !b_initalUpdate )
	   {
				   pHTMLWindow2->scrollTo(0,100000);
	   }


	   /// 4. Release the pointer to the body
	   pBody->Release();
	}

	/// 5. Release the pointer to the document
	pHTMLDocument2->Release();
}

void CWinAceView::OnUpdate(CView* pSender, LPARAM lHint, CObject* pHint) 
{
	// TODO: Add your specialized code here and/or call the base class
//::AfxMessageBox("UPDATE");
	if (!b_initalUpdate)
	{
		
		CMenu *menu = GetParentFrame()->GetMenu();

		if ( GetDocument()->isDebugable() )
		{
		
			menu->GetSubMenu( 1 )->EnableMenuItem(1,MF_BYPOSITION|MF_ENABLED);
		}
		else
		{
			menu->GetSubMenu( 1 )->EnableMenuItem(1,MF_BYPOSITION|MF_DISABLED|MF_GRAYED);
		}

	while ( !OutputStream->empty() )	
	{
	

		CEvent evt = OutputStream->getNextEvent();
		switch ( evt.GetType() )
		{
			
		case EVT_CLS:
			this->ClearHTML();
			this->AddHTML( evt.getStringData() );
		//	::AfxMessageBox( evt.getStringData() );
			break;
		case EVT_TEXT:
		//	::AfxMessageBox( evt.getStringData() );
			this->AddHTML( evt.getStringData() );
			break;
		case EVT_ANYKEY:
		//	::AfxMessageBox("ANYKEY");
			m_commandControl.EnableWindow( );
			m_commandControl.SetFocus();
			wantKeyPress = true;
			return;
		case EVT_FINISHED:
		//	::AfxMessageBox("FINISHED");
			if ( debugging )
			{
				updateFlags();
			}
			m_commandControl.EnableWindow( );
			m_commandControl.SetFocus();
			m_Button.EnableWindow();
			break;
		case EVT_PAUSE:
		//	::AfxMessageBox("PAUSE");
			this->SetTimer( 1, evt.GetIntData()*1000,NULL);
			return;
		case EVT_QUIT:
			if (AfxMessageBox( evt.getStringData(), MB_YESNO ) !=IDYES )
			{
				OutputStream->flush();
				m_commandControl.EnableWindow( );
				m_commandControl.SetFocus();
				m_Button.EnableWindow();
			}
			break;
		case EVT_END:
			OutputStream->flush();
			if (AfxMessageBox( evt.getStringData(), MB_YESNO ) !=IDYES )
			{
				is_quitting = true;
				AfxGetApp()->CloseAllDocuments( true );
				AfxGetApp()->ExitInstance();
				return;
                				
			}
			else
			{
			  OutputStream->clearEvents();

			 GetDocument()->restart();
			 m_commandControl.EnableWindow( );
			 m_commandControl.SetFocus();
			}
			break;

		}
	}
	}
	
	
	
}

void CWinAceView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	CFormView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CWinAceView::OnChangeEdit1() 
{
	// TODO: If this is a RICHEDIT control, the control will not
	// send this notification unless you override the CFormView::OnInitDialog()
	// function and call CRichEditCtrl().SetEventMask()
	// with the ENM_CHANGE flag ORed into the mask.
	
	// TODO: Add your control notification handler code here

	CString newString;
	m_commandControl.GetWindowText( newString );

	if ( newString.IsEmpty() ) return;

	if ( wantKeyPress )
	{
		wantKeyPress = false;
		m_commandControl.SetWindowText(_T(""));
		m_commandControl.EnableWindow( false );
		GetDocument()->UpdateAllViews( NULL );
	}
	
}

void CWinAceView::OnKillfocusEdit1() 
{
//	m_commandControl.SetFocus();
}

void CWinAceView::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent ==  1 )
	{
		KillTimer(  nIDEvent );
		GetDocument()->UpdateAllViews( NULL );
	}
	else
	{
		CFormView::OnTimer(nIDEvent);
	}
}



void CWinAceView::OnDebugFlags() 
{
	// TODO: Add your command handler code here
	if ( p_flagsDialog == NULL )
	{
		p_flagsDialog = new CFlagsDialog( );
	    p_flagsDialog->setFlagTable( GetDocument()->getFlags() );
		p_flagsDialog->Create( IDD_DIALOG1 );


	}

	p_flagsDialog->updateFlags();
	p_flagsDialog->ShowWindow( SW_SHOWNORMAL );
	debugging = true;
	

}

void CWinAceView::OnDebugParser() 
{
	// TODO: Add your command handler code here
	
}

void CWinAceView::OnDebugSinglestep() 
{
	// TODO: Add your command handler code here
	
}

void CWinAceView::OnOptions() 
{
	// TODO: Add your command handler code here
	COutputStream o; 


	CFont font;

	VERIFY(font.CreatePointFont( o.getFontSze(), o.getFontName() ));
	LOGFONT lfont; font.GetLogFont( &lfont );

	CFontDialog fontDialog( &lfont );

	if ( fontDialog.DoModal() != IDOK )
	{ 
		return;
	}

	
	CString face = fontDialog.GetFaceName();
	int pointSz = fontDialog.GetSize();

    
	o.SetFont( face, pointSz);
	
}

void CWinAceView::updateFlags()
{
	if ( p_flagsDialog != NULL )
	{
		p_flagsDialog->updateFlags();
	}

	if (p_objDlg != NULL )
	{
		p_objDlg->UpdateWindow();
	}
}


void CWinAceView::OnDebugObjects() 
{
if (p_objDlg== NULL )
{
	p_objDlg = new CObjectDialog();
	p_objDlg->setData( GetDocument()->getObjects(), GetDocument()->getLocationCount() );
	p_objDlg->Create( IDD_OBJECTDLG );
	debugging=true;
}

p_objDlg->ShowWindow( SW_SHOWNORMAL );
}
