/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
// FlagTable.cpp: implementation of the CFlagTable class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "FlagTable.h"

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

IMPLEMENT_SERIAL( CFlagTable, CObject, 1)

CFlagTable::CFlagTable()
{
  FlagList.SetSize(65534);
  WeightCarried=0;
  ObjectsCarried=0;
  for ( int count=0; count< 65533; count++, FlagList[count]=0 );
  for ( int count=0; count<100; count ++ )
  {
	  AutoDecFlags[count] = 0;//reset AutoDec's
  }

  SetFlag(52,10); //maximum weight of object carried/worn
  SetFlag(37,4);	//maximum no of objects carried/worn
}

void CFlagTable::Reset( void )
{
  FlagList.SetSize(65534);
  WeightCarried=0;
  ObjectsCarried=0;
  for ( int count=0; count< 65533; count++, FlagList[count]=0 );
  for (  int count=0; count<100; count ++ )
  {
	  AutoDecFlags[count] = 0;//reset AutoDec's
  }

  SetFlag(52,10); //maximum weight of object carried/worn
  SetFlag(37,4);	//maximum no of objects carried/worn
}

CFlagTable::~CFlagTable()
{

}

int CFlagTable::GetFlag(int Flag)
{
	return FlagList[Flag];
}

void CFlagTable::SetFlag(int Flag, int Value)
{
	FlagList[Flag]=Value;
}

void CFlagTable::DecFlag(int FlagNo)
{

	if (FlagList[FlagNo] > 0)
		FlagList[FlagNo]--;
}

void CFlagTable::IncFlag(int FlagNo)
{
 FlagList[FlagNo]++;
}

void CFlagTable::AddAutoDec(int FlagNo)
{
  for ( int count=0; count<100; count++ )
  {
	  if  (AutoDecFlags[count] == 0 )
	  {
		  AutoDecFlags[count] = FlagNo;
		  return;
	  }
  }
	  return;
}

void CFlagTable::DelAutoDec(int FlagNo)
{
	for ( int count=0; count<100; count++ )
	{
		if ( AutoDecFlags[count] == FlagNo )
		{
			AutoDecFlags[count]=0;
			return;
		}
	}
}


void CFlagTable::DoAutoDecs()
{

	for ( int count =0; count<100; count++ )
	{
		if ( AutoDecFlags[count] != 0 )
		{
			if ( GetFlag( AutoDecFlags[count] ) != 0)
				DecFlag( AutoDecFlags[count] ); // only dec until == 0
			
		}
	}

}

void CFlagTable::Serialize( CArchive &ar )
{
	int count;
	int temp;

	if ( ar.IsStoring() )
	{
		for ( count=0; count<1000; count++ )
		{
			ar<<GetFlag(count);
		}
		
		for ( count=0; count<100; count++ )
		{
			ar<<AutoDecFlags[count];
		}
	}
	else
	{
		for ( count=0; count<1000; count++ )
		{

			ar>>temp;
			SetFlag(count,temp);
		}
		
		for ( count=0; count<100; count++ )
		{
			ar>>temp;
			AutoDecFlags[count]=temp;
		}
	}
}
