/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
#ifndef CONDACTS
#define CONDACTS

#define AT		0
#define NOTAT	1
#define ATGT	2
#define ATLT	3
#define PRESENT	4
#define ABSENT	5
#define WORN	6
#define NOTWORN	7
#define CARRIED	8
#define NOTCARR	9
#define CHANCE	10	
#define ZERO	11
#define NOTZERO	12	
#define EQ		13
#define GT		14
#define LT		15
#define ADJECT1	16
#define ADVERB	17
#define INVEN	18	
#define DESC	19
#define QUIT	20	
#define END		21
#define DONE	22
#define OK		23
#define ANYKEY	24	
#define SAVE	25
#define LOAD	26
#define TURNS	27
#define SCORE	28
#define CLS		29
#define DROPALL	30
#define AUTOG	31	
#define AUTOD	32
#define AUTOW	33
#define AUTOR	34
#define PAUSE	35
#define TIMEOUT	36
#define GOTO	37
#define MESSAGE	38
#define REMOVE	39
#define GET		40
#define DROP	41
#define WEAR	42
#define DESTROY	43
#define CREATE	44
#define SWAP	45
#define PLACE	46
#define SET		47
#define CLEAR	48
#define PLUS	49
#define MINUS	50
#define LET		51
#define NEWLINE	52
#define PRINT	53
#define SYSMESS	54
#define ISAT	55
#define COPYOF	56
#define COPYOO  57
#define COPYFO	58
#define COPYFF	59
#define LISTOBJ	60
#define EXTERN	61 //NO LONGER USED
#define RAMSAVE	62 //NOT USED
#define RAMLOAD	63 //NOT USED
#define BELL	64
#define PREP	65
#define NOUN2	66
#define ADJECT2	67
#define ADD		68
#define SUB		69
#define PARSE	70 //NOT IMPLEMENTED
#define LISTAT	71
#define PROCESS	72
#define SAME	73
#define MES		74
#define NOTEQ	75
#define NOTSAME	76
#define MODE	77
#define TIME	78
#define DOALL	79
#define PROMPT	80
#define ISNOTAT	81
#define WEIGH	82
#define PUTIN	83
#define TAKEOUT	84
#define NEWTEXT	85
#define ABILITY	86
#define WEIGHT	87
#define RANDOM	88
#define WHATO	89
#define RESET	90
#define PUTO	91
#define NOTDONE	92
#define AUTOP	93
#define AUTOT	94
#define MOVE	95
#define AUTODEC 96 //Sets a flag to autodecrement
#define GRPCLR  97 //clears a group of flags
#define UNDO	98 //undo command
#define GRPSET  99 //sets a group of flags
#define UNDOCLR 100//clears the undo stack
#define AGAIN   101//repeats the last command


#endif
