/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/
#ifndef __CONDACT_ARRAY__
#define __CONDACT_ARRAY
#define NONE		0
#define OBJECT		1
#define LOCATION	2
#define SYSTEMMESS	3
#define USRMESS		4
#define FLAG		5
#define VALUE		6


typedef struct { char *Name; int type1; int type2; } CondActDef;

CondActDef CondactActArray[110] = 
{	
	{"AT",		VALUE, NONE},
	{"NOTAT",	VALUE, NONE},
	{"ATGT",	VALUE, NONE},
	{"ATLT",	VALUE, NONE},
	{"PRESENT", OBJECT, NONE},
	{"ABSENT",  OBJECT, NONE},
	{"WORN",	OBJECT, NONE},
	{"NOTWORN", OBJECT, NONE},
	{"CARRIED", OBJECT, NONE},
	{"NOTCARR", OBJECT, NONE},
	{"CHANCE",	VALUE, NONE},
	{"ZERO",	FLAG, NONE},
	{"NOTZERO",	FLAG, NONE},
	{"EQ",		FLAG, VALUE},
	{"GT",		FLAG, VALUE},
	{"LT",		FLAG, VALUE},
	{"ADJECT1", VALUE, NONE},
	{"ADVERB",	VALUE, NONE},
	{"INVEN",	NONE, NONE},
	{"DESC",	NONE, NONE},
	{"QUIT",	NONE, NONE},
	{"END",		NONE, NONE},
	{"DONE",	NONE, NONE},
	{"OK",		NONE, NONE},
	{"ANYKEY",	NONE, NONE},
	{"SAVE",	NONE, NONE},
	{"LOAD",	NONE, NONE},
	{"TURNS",	NONE, NONE},
	{"SCORE",	NONE, NONE},
	{"CLS",		NONE, NONE},
	{"DROPALL", NONE, NONE},
	{"AUTOG",	NONE, NONE},
	{"AUTOD",	NONE, NONE},
	{"AUTOW",	NONE, NONE},
	{"AUTOR",	NONE, NONE},
	{"PAUSE",	VALUE, NONE},
	{"TIMEOUT",	VALUE, NONE},
	{"GOTO",	LOCATION, NONE},
	{"MESSAGE", USRMESS, NONE},
	{"REMOVE",	OBJECT, NONE},
	{"GET",		OBJECT, NONE},
	{"DROP",	OBJECT, NONE},
	{"WEAR",	OBJECT, NONE},
	{"DESTROY",	OBJECT, NONE},
	{"CREATE",	OBJECT, NONE},
	{"SWAP",	OBJECT, OBJECT},
	{"PLACE",	OBJECT,	VALUE},
	{"SET",		FLAG, NONE},
	{"CLEAR",	FLAG, NONE},
	{"PLUS",	FLAG, VALUE},
	{"MINUS",	FLAG, VALUE},
	{"LET",		FLAG, VALUE},
	{"NEWLINE", NONE, NONE},
	{"PRINT",	FLAG, NONE},
	{"SYSMESS", SYSTEMMESS, NONE},
	{"ISAT",OBJECT,LOCATION},
	{"COPYOF",OBJECT,FLAG},
	{"COPYOO",OBJECT,OBJECT},
	{"COPYFO",FLAG,OBJECT},
	{"COPYFF",FLAG,FLAG},
	{"LISTOBJ",NONE,NONE},
	{"EXTERN",NONE,NONE},
	{"RAMSAVE",NONE,NONE},
	{"RAMLOAD",NONE,NONE},
	{"BELL",VALUE,NONE},
	{"PREP",NONE,NONE},
	{"NOUN2",NONE,NONE},
	{"ADJECT2",NONE,NONE},
	{"ADD",FLAG,FLAG},
	{"SUB",FLAG,FLAG},
	{"PARSE",NONE,NONE},
	{"LISTAT",LOCATION,NONE},
	{"PROCESS",VALUE,NONE},
	{"SAME",FLAG,FLAG},
	{"MES",USRMESS,NONE},
	{"NOTEQ",FLAG,VALUE},
	{"NOTSAME",FLAG,FLAG},
	{"MODE",VALUE,NONE},
	{"TIME",VALUE,VALUE},
	{"DOALL",NONE,NONE},
	{"PROMPT",SYSTEMMESS,VALUE},
	{"ISNOTAT",OBJECT,LOCATION},
	{"WEIGH",VALUE,NONE},
	{"PUTIN",OBJECT,LOCATION},
	{"TAKEOUT",OBJECT,LOCATION},
	{"NEWTEXT",NONE,NONE},
	{"ABILITY",VALUE,NONE},
	{"WEIGHT",VALUE,NONE},
	{"RANDOM",VALUE,NONE},
	{"WHATO",NONE,NONE},
	{"RESET",LOCATION,NONE},
	{"PUTO",LOCATION,NONE},
	{"NOTDONE",NONE,NONE},
	{"AUTOP",LOCATION,NONE},
	{"AUTOT",LOCATION,NONE},
	{"MOVE",FLAG,NONE},
	{"AUTODEC",FLAG,VALUE},
	{"GRPCLR",FLAG,FLAG},
	{"UNDO",NONE,NONE},
	{"GRPSET",FLAG,FLAG},
	{"UNDOCLR",NONE,NONE},
	{"AGAIN",NONE,NONE},
	{"*",NONE,NONE} };

#endif

