package zpplet.header;


public class ZHeader4
		extends ZHeader3
	{
	protected final static int INTERP_NUMBER = 0x1E;
	protected final static int INTERP_VERSION = 0x1F;
	protected final static int SCREEN_HEIGHT_LINES = 0x20;
	protected final static int SCREEN_WIDTH_CHARACTERS = 0x21;
	
	public ZHeader4(byte[] mem)
		{
		super(mem);
		}

	public void setInterpreterInfo(int number, int version)
		{
		m[INTERP_NUMBER] = (byte)number;
		m[INTERP_VERSION] = (byte)version;
		}

	public void setScreenDimensions(int lines, int chars)
		{
		m[SCREEN_HEIGHT_LINES] = (byte)lines;
		m[SCREEN_WIDTH_CHARACTERS] = (byte)chars;
		}

	public void setBoldAvailable(boolean value)
		{
		if (value)
			m[FLAGS1] |= 0x04;
		else
			m[FLAGS1] &= 0xFB;
		}

	public void setItalicAvailable(boolean value)
		{
		if (value)
			m[FLAGS1] |= 0x08;
		else
			m[FLAGS1] &= 0xF7;
		}

	public void setFixedFontAvailable(boolean value)
		{
		if (value)
			m[FLAGS1] |= 0x10;
		else
			m[FLAGS1] &= 0xEF;
		}

	public void setTimedInputAvailable(boolean value)
		{
		if (value)
			m[FLAGS1] |= 0x80;
		else
			m[FLAGS1] &= 0x7F;
		}

	public int getFileLength()
		{
		return getWord(FILE_LENGTH) * 4;
		}
	}