UNIT ZIP_Ext;

INTERFACE

 TYPE
  
  Byte=0..255;
  ShortInteger=SWORD;
  aMaxString=String[255];
  
  aPage=PACKED ARRAY [0..255] OF Byte;
  aPageFile=FILE OF aPage;
  PtrPage=^aPage;

 VAR ScreenWidth:Integer;
     ScreenHeight:Integer;

 PROCEDURE ClearScreen;
 PROCEDURE ClearToEOL;
 PROCEDURE GotoXY(x,y:Integer);
 PROCEDURE WriteRawChOnScreen(Ch:Char);
 PROCEDURE WriteChOnScreen(Ch:Char);
 FUNCTION  Random:Integer;
 PROCEDURE Randomize;
 FUNCTION  KeyPressed:Boolean;
 PROCEDURE EnableTimer;
 PROCEDURE DisableTimer;
 FUNCTION  ReadKeyWithNoEcho(TimeOut:Integer):Char;
 FUNCTION  Backspace:Char;
 FUNCTION  EOL:Char;
 FUNCTION  ESC:Char;
 FUNCTION  Ctrl_S:Char;
 FUNCTION  DeleteChar:Char;
 FUNCTION  KeyToDeleteLine:Char;
 PROCEDURE ScrollLinesUp(FirstLine:Integer);
 FUNCTION  FileExists(VAR FileName:aMaxString):Boolean;
 FUNCTION  IsDirectory(VAR Name:aMaxString):Boolean;
 FUNCTION  StateDirectory:String;
 PROCEDURE CloseText(VAR TextToClose:Text);
 PROCEDURE ClosePageFile(VAR theFile:aPageFile);
 PROCEDURE RingBell;
 PROCEDURE CursorOn;
 PROCEDURE CursorOff;
 PROCEDURE SaveTextAttributes;
 PROCEDURE RestoreTextAttributes;
 PROCEDURE NormalOn;
 PROCEDURE InverseOn;
 PROCEDURE BoldOn;
 PROCEDURE ItalicOn;
 PROCEDURE ExtraOn;
 FUNCTION ExpandByte(theByte:Integer):Integer;
 PROCEDURE SplitWord(theWord:Integer; VAR LowByte,HighByte:Integer);
 FUNCTION JoinBytes(LowByte,HighByte:Integer):Integer;
 PROCEDURE WrapAddress(VAR PageNo,PageIndex:Integer);
 PROCEDURE ShiftLeft(VAR HighWord,LowWord:Integer);
 PROCEDURE ShiftRight(VAR HighWord,LowWord:Integer);
 FUNCTION Nibble(theByte:Integer; NibbleNo:Integer):Integer;
 FUNCTION Bittle(theByte:Integer; BittleNo:Integer):Integer;
 FUNCTION TstBit(theWord:Integer; BitNo:Integer):Boolean;
 PROCEDURE SetBit(VAR theWord:Integer; BitNo:Integer);
 PROCEDURE ClrBit(VAR theWord:Integer; BitNo:Integer);
 FUNCTION cOp4(Code:Integer):Integer;
 FUNCTION cMode(Code:Integer):Integer;
 FUNCTION cCmd2(Code:Integer):Integer;
 FUNCTION cOp5(Code:Integer):Integer;
 FUNCTION cMode3(Code:Integer):Integer;
 FUNCTION cDistance(Code:Integer):Integer;
 FUNCTION cShort(Code:Integer):Boolean;
 FUNCTION cTrueJump(Code:Integer):Boolean;
 FUNCTION land(i1,i2:Integer):Integer;
 FUNCTION lor(i1,i2:Integer):Integer;
 FUNCTION lnot(i:Integer):Integer;
 FUNCTION lsr(i,c:Integer):Integer;
 FUNCTION lsl(i,c:Integer):Integer;
 PROCEDURE InitSystem;
 PROCEDURE SetupTerminal(VAR Width,Height:Integer);
 PROCEDURE ResetTerminal;
 FUNCTION UpArrow:Char;
 FUNCTION DownArrow:Char;
 FUNCTION LeftArrow:Char;
 FUNCTION RightArrow:Char;
 FUNCTION IsFuncKey(Key:Char):Boolean;
 FUNCTION FuncKeyNo(Key:Char):Integer;
 FUNCTION NumericSW:Char;
 FUNCTION NumericS:Char;
 FUNCTION NumericSE:Char;
 FUNCTION NumericW:Char;
 FUNCTION NumericCentre:Char;
 FUNCTION NumericE:Char;
 FUNCTION NumericNW:Char;
 FUNCTION NumericN:Char;
 FUNCTION NumericNE:Char;
 FUNCTION SwitchToFont(FontNo:Integer):Boolean;
 PROCEDURE SysSetColours(Foreground,Background:Integer);

IMPLEMENTATION

 PROCEDURE ClearScreen; EXTERNAL;
 PROCEDURE ClearToEOL; EXTERNAL;
 PROCEDURE GotoXY(x,y:Integer); EXTERNAL;
 PROCEDURE WriteRawChOnScreen(Ch:Char); EXTERNAL;
 PROCEDURE WriteChOnScreen(Ch:Char); EXTERNAL;
 FUNCTION  Random:Integer; EXTERNAL;
 PROCEDURE Randomize; EXTERNAL;
 FUNCTION  KeyPressed:Boolean; EXTERNAL;
 PROCEDURE EnableTimer; EXTERNAL;
 PROCEDURE DisableTimer; EXTERNAL;
 FUNCTION  ReadKeyWithNoEcho(TimeOut:Integer):Char; EXTERNAL;
 FUNCTION  Backspace:Char; EXTERNAL;
 FUNCTION  EOL:Char; EXTERNAL;
 FUNCTION  ESC:Char; EXTERNAL;
 FUNCTION  Ctrl_S:Char; EXTERNAL;
 FUNCTION  DeleteChar:Char; EXTERNAL;
 FUNCTION  KeyToDeleteLine:Char; EXTERNAL;
 PROCEDURE ScrollLinesUp(FirstLine:Integer); EXTERNAL;
 FUNCTION  FileExists(VAR FileName:aMaxString):Boolean; EXTERNAL;
 FUNCTION  IsDirectory(VAR Name:aMaxString):Boolean; EXTERNAL;
 FUNCTION  StateDirectory:String; EXTERNAL;
 PROCEDURE CloseText(VAR TextToClose:Text); EXTERNAL;
 PROCEDURE ClosePageFile(VAR theFile:aPageFile); EXTERNAL;
 PROCEDURE RingBell; EXTERNAL;
 PROCEDURE CursorOn; EXTERNAL;
 PROCEDURE CursorOff; EXTERNAL;
 PROCEDURE SaveTextAttributes; EXTERNAL;
 PROCEDURE RestoreTextAttributes; EXTERNAL;
 PROCEDURE NormalOn; EXTERNAL;
 PROCEDURE InverseOn; EXTERNAL;
 PROCEDURE BoldOn; EXTERNAL;
 PROCEDURE ItalicOn; EXTERNAL;
 PROCEDURE ExtraOn; EXTERNAL;
 FUNCTION ExpandByte(theByte:Integer):Integer; EXTERNAL;
 PROCEDURE SplitWord(theWord:Integer; VAR LowByte,HighByte:Integer); EXTERNAL;
 FUNCTION JoinBytes(LowByte,HighByte:Integer):Integer; EXTERNAL;
 PROCEDURE WrapAddress(VAR PageNo,PageIndex:Integer); EXTERNAL;
 PROCEDURE ShiftLeft(VAR HighWord,LowWord:Integer); EXTERNAL;
 PROCEDURE ShiftRight(VAR HighWord,LowWord:Integer); EXTERNAL;
 FUNCTION Nibble(theByte:Integer; NibbleNo:Integer):Integer; EXTERNAL;
 FUNCTION Bittle(theByte:Integer; BittleNo:Integer):Integer; EXTERNAL;
 FUNCTION TstBit(theWord:Integer; BitNo:Integer):Boolean; EXTERNAL;
 PROCEDURE SetBit(VAR theWord:Integer; BitNo:Integer); EXTERNAL;
 PROCEDURE ClrBit(VAR theWord:Integer; BitNo:Integer); EXTERNAL;
 FUNCTION cOp4(Code:Integer):Integer; EXTERNAL;
 FUNCTION cMode(Code:Integer):Integer; EXTERNAL;
 FUNCTION cCmd2(Code:Integer):Integer; EXTERNAL;
 FUNCTION cOp5(Code:Integer):Integer; EXTERNAL;
 FUNCTION cMode3(Code:Integer):Integer; EXTERNAL;
 FUNCTION cDistance(Code:Integer):Integer; EXTERNAL;
 FUNCTION cShort(Code:Integer):Boolean; EXTERNAL;
 FUNCTION cTrueJump(Code:Integer):Boolean; EXTERNAL;
 FUNCTION land(i1,i2:Integer):Integer; EXTERNAL;
 FUNCTION lor(i1,i2:Integer):Integer; EXTERNAL;
 FUNCTION lnot(i:Integer):Integer; EXTERNAL;
 FUNCTION lsr(i,c:Integer):Integer; EXTERNAL;
 FUNCTION lsl(i,c:Integer):Integer; EXTERNAL;
 PROCEDURE InitSystem; EXTERNAL;
 PROCEDURE SetupTerminal(VAR Width,Height:Integer); EXTERNAL;
 PROCEDURE ResetTerminal; EXTERNAL;
 FUNCTION UpArrow:Char; EXTERNAL;
 FUNCTION DownArrow:Char; EXTERNAL;
 FUNCTION LeftArrow:Char; EXTERNAL;
 FUNCTION RightArrow:Char; EXTERNAL;
 FUNCTION IsFuncKey(Key:Char):Boolean; EXTERNAL;
 FUNCTION FuncKeyNo(Key:Char):Integer; EXTERNAL;
 FUNCTION NumericSW:Char; EXTERNAL;
 FUNCTION NumericS:Char; EXTERNAL;
 FUNCTION NumericSE:Char; EXTERNAL;
 FUNCTION NumericW:Char; EXTERNAL;
 FUNCTION NumericCentre:Char; EXTERNAL;
 FUNCTION NumericE:Char; EXTERNAL;
 FUNCTION NumericNW:Char; EXTERNAL;
 FUNCTION NumericN:Char; EXTERNAL;
 FUNCTION NumericNE:Char; EXTERNAL;
 FUNCTION SwitchToFont(FontNo:Integer):Boolean; EXTERNAL;
 PROCEDURE SysSetColours(Foreground,Background:Integer); EXTERNAL;

END.
