function stables()
	clearText()
	if triedtograssHobs then

		text [[As Hobson sets down his lute, cheerfully nodding to you, he tilts his head in the other direction.]]

		text [["Is anything the matter? You seem a little troubled. I hope it's not something I did."]]

		jump "stables_hub"
	end

	if not metHobson then
		metHobson = true

		text [[The wooden doors swing open on well-maintained hinges. Behind them is a stables, the floor covered in fresh straw and cobbles. Seated at a table, dressed in a style of clothing you faintly remember seeing on your great-grandfather, is an animated skeleton, plucking away at his lute with a thumb-bone that clicks against its neck whenever he moves it.]]

		image "hobson"

		text [[He sees you react with surprise, and holds the lute up towards you.]]

		text [["Ah, yes! It's a vintage Riccio "Superiora" in blond sunburst. From after they stopped sizing the fretboard with horse glue, but before they started making the tuning pegs out of catoblepas. Listen to that signature tone!"]]

		text [[He is not playing it.]]

		choice([["Excuse me, sir, but I can't help noticing your physical condition."]], "stables_condition")
	else
		image "hobson"

		text [[Hobson sets down his lute and greets you with what you assume is a smile.]]

		text [["Back for another chin-wag? Good."]]

		jump "stables_hub"
	end
end

function stables_condition()
	text [[The grin of the skull somehow appears to brighten.]]

	text [["Ah, yes! Still as lean as the day I came to this citadel, however many decades it's been. How long has it been?"]]

	text [[He pauses, then appears to shift in position in his seat, as if returning to his senses after a daydream.]]

	text [["It's so difficult to think about the time anything takes here. Things haven't been the same since the relocation.]]

	text [["I forgot to introduce myself," he says, just as you are about to speak.]]

	text [[He slaps himself across the forehead – *clonk*. Then doffs his elaborate riding hat. "My name is Edmund Hobson – stablemaster of the mighty citadel of Gallos."]]

	jump "stables_hub"
end

function stables_hub()
	choiceOnce([["About your lute playing…"]], "stables_lute")
	choice([["You said 'things haven't been the same since the relocation'. What did you mean by that?"]], "stables_relocation")
	if hobsonExplainedUndermarch then
		choice([["So if getting into the Undermarch is like reading a closed book, how did I get in?"]], "stables_closedBook")
		choice([["Are there other people who came to Gallos besides me?"]], "stables_others")
		choice([["What was your life like before you came to Gallos?"]], "stables_lifeBefore")
	end
	choice([["You're a stablemaster? I want to borrow a horse."]], "stables_horse")
	choice([["About this citadel…"]], "stables_gallos")

	if hobsonFearsMilpreve and hobsonBadAtLute and metMilpreve and (heardAboutTrueCitizens_Hobson or heardAboutTrueCitizens_Milpreve) then
		choiceOnce([[*WAIT!* There is a contradiction in Hobson's tales about Milpreve...]], "stables_contradiction")
	end

	if stablesAccusedHobson and not visited "stables_meanIt" then
		choice([["Hobson, now I *know for certain* why you fear Milpreve…"]], "stables_accuseAgain")
	end
	choice([["I need to get back to exploring the citadel now."]], "stables_leave")
end

function stables_lute()
	text [[Hobson looks up. "What about it?"]]

	choice([[Be kind.]], "stables_luteKind")
	choice([[Be constructive.]], "stables_luteConstructive")
	choice([[Be merciless.]], "stables_luteMerciless")
end

function stables_luteKind()
	text [["Keep practicing!" you say. "With your dedication, you'll be a maestro in no time!"]]

	text [["Thank you," he says. "There are times that I doubt that I can get any better - learning new skills has become challenging now that I no longer have a brain.]]

	text [["But your words of encouragement have ignited me! Not even Milpreve will get me to set down my lute!"]]

	luteCritKind = true
	hobsonBadAtLute = true

	jump "stables_hub"
end

function stables_luteConstructive()
	text [["Have you thought about playing any other notes than those ones?"]]

	text [["Well, I suppose I have stayed within my comfortable boundaries," he muses. "In truth, learning new skills has become rather difficult now that I no longer have a brain. But you are right - a true virtuoso must evolve his style as he matures."]]

	text [[He takes a sip of his drink, which you hear pouring onto his stool beneath him.]]

	text [["As with the difference between the charming warmth of early de-Théo, and his less accessible late works after he took to drink and divorced his wife.]]

	text [["Or the cathartic fury of early Mercerius, and his more accessible late works after he swore off the drink and made up with his wife.]]

	text [["Actually, both of these are bad." He scratches his cheekbone. "Perhaps a true virtuoso should just play the same song over and over again, forever. Perhaps that is what I shall tell Milpreve next time he orders me to set down my lute."]]

	luteCritConstructive = true
	hobsonBadAtLute = true

	jump "stables_hub"
end

function stables_luteMerciless()
	text [["You play like you've never touched that instrument before."]]

	text [["Marvellous! Spontaneity is the essence of musicianship!"]]

	text [[He gives a delighted chuckle. "See, this is what Milpreve never understands. He only likes music if it is played exactly as scored in his partbooks." He grips his hands around the neck of the lute in second-hand embarrassment. "He has no need for music that speaks to the animus, because he does not have one.]]

	text [["Milpreve cares nothing about the future of art, or euphoria of purpose. It's people like us who must bring it into being. Us youngsters. Am I right?"]]

	luteCritMerciless = true
	hobsonBadAtLute = true

	jump "stables_hub"
end

function stables_relocation()
	text [["The relocation to the Undermarch!" Hobson says.]]

	text [[He taps a phalange against the seam above his nasal cavity, thinking.]]

	text [["It's all very political and a little over my head, but Queen Gwenhaela moved Gallos for its safety. Lots of problems in the older place - competing interests, linear time…"]]

	choice([["She moved the city? How can one even do such a thing?"]], "stables_movedCity")
end

function stables_movedCity()
	text [["Cities can move. Like in antiquity, where the Millers of Intinnuum carried a stone each from the walls of the Temple before they fled to the Eponian Hills."]]
	millersofintinnuum = true

	choice([["So that was how it happened?"]], "stables_movedCity2")
end

function stables_movedCity2()
	text [[Hobson tilts his head. "Not at all!]]

	text [["The Undermarch isn't a place that you can travel to on foot from overward. It's more of - of a different perspective, in the same way as a drinking-straw bends when you put it into a glass."]]

	text [[You consider what this curious allegory could mean, or even if it means anything at all.]]

	choice([["So it's like the afterlife?"]], "stables_afterlife")
	choice([["So it's like the Faerylands?"]], "stables_faerylands")
	choice([["So it's like a bent mirror?"]], "stables_mirror")
end

function stables_afterlife()
	text [["Not at all," says Hobson. "All the beings in the Undermarch are alive. Even if they are dead."]]
	jump "stables_speech"
end

function stables_faerylands()
	text [["Oh, certainly not," says Hobson. "The Faerylands are a far better organised place than this."]]
	jump "stables_speech"
end

function stables_mirror()
	text [["A philosopher's answer," says Hobson, excitedly. "Yes, the object is reflected in it, but it no longer can be seen."]]
	jump "stables_speech"
end

function stables_speech()
	text [["I remember Queen Gwenhaela once explaining it - she gave a speech. It was a great speech, or so Milpreve assures me. He sometimes likes to reenact her speeches when he doesn't think anyone can hear. Perhaps it is his performance I remember, and not the Queen's? I seem to recall I was sleepy that day…]]

	text [["Anyhow.]]

	text [["The Queen said the Undermarch is as if written in the pages of a book. Overward is the blank cover. A book may be closed, but the knowledge inside its pages is still present - waiting to be read, to be learned, to be conquered!" He raises a finger. "And so all that must be done - " he clenches a fist - "is to unfold the pages." He opens his fingers, with a flourish.]]

	text [["I definitely recall her doing that with her hand," he says, and brightens. "I must have been awake!"]]

	hobsonExplainedUndermarch = true
	jump "stables_hub"
end

function stables_closedBook()
	text [[Hobson clicks his jaw from side to side. "Ah, a technical question. You'll have to ask a physicist, or librarian."]]

	text [[Clearly, not Hobson.]]

	jump "stables_hub"
end

function stables_others()
	text [[Hobson shakes his head. "Since the relocation, not many. It's Scowles's job to escort visitors when they arrive, but it's rare to get bright young people such as you. He brought back a cat once. It clawed Milpreve.]]

	text [["But before the relocation, it was busy," Hobson continues. He shifts on his stool, picking a piece of straw out from his knuckle joint. "Strays, travellers, even true believers. A lot of young people fleeing unkindly parents or Churches that preached against them. Deserting soldiers, starving bohemians, rogues on the lam…"]]

	jump "stables_hub"
end

function stables_lifeBefore()
	text [["Unremarkable. I wasted eight years mucking out stables for a branch of the Rescorla Postal Service until I told the stablemaster what I thought of him, hopped on his prize charger and rode like the wind!]]

	text [["You're Rescorlian too, aren't you? I recognise your accent."]]

	choice([["Yes – I'm from Ruan-le-pentrith. I wouldn't expect you've heard of it."]], "stables_pentrith")
end

function stables_pentrith()
	text [["Oh, no, I know Ruan-le-pentrith well! Lovely market, I would come down there for cheese pasties. And fish - caught right out of the river."]]

	text [[The idea of eating fish from the river turns your stomach. You've never known it to be anything other than an acrid shade of pink.]]

	jump "stables_pentrithHub"
end

function stables_pentrithHub()
	choiceOnce([["So you last knew the town before the dyers' workshop had their wastewater channel built. That's more than a hundred years ago!"]], "stables_100years")
	choiceOnce([["I could murder a cheese pasty right now…"]], "stables_pasty")
	choice("I want to ask about something else.", "stables_pentrithReturn")
end

function stables_100years()
	text [["How extraordinary," Hobson says, pressing a finger to his chin. "I have no idea of the significance of anything you just said. But I trust it was clever."]]
	jump "stables_pentrithHub"
end

function stables_pasty()
	text [["I sympathise. Unfortunately, there's little good food in Gallos these days. So few of its residents require it."]]

	text [[He takes a sip of his drink, then looks solemnly at it trickling into the pool around his feet.]]

	text[["But the constructs and empsychons tending the farms still do the jobs laid out for them, and it is law that every resident of Gallos be provided for. If you are hungry, you should ask Milpreve."]]

	cheesePasty = true

	jump "stables_pentrithHub"
end

function stables_pentrithReturn()
	text [["Understood!"]]
	jump "stables_hub"
end

function stables_horse()
	text [[Hobson shakes his head.]]

	text [["I'm afraid that won't be possible. All my horses are gone, save for my custom model."]]

	jump "stables_horseHub"
end

function stables_horseHub()
	choice([["How can a horse be custom?"]], "stables_customHorse")
	choice([["I promise I would return the horse."]], "stables_horsePromise")
	choiceOnce([[He's a dratted skeleton, he can't have feelings! Importune Hobson into surrendering the horse.]], "stables_importune")
	choice([["Let's talk about something else…"]], "stables_hub")
end

function stables_customHorse()
	text [[Hobson jerks up in sudden interest.]]

	text [["My Ragwort's kitted out with an enhanced respirator, pressurised airways and a cooling system. He's also got a custom fragrance. Haven't you, Raggie?"]]

	text [[At Hobson's call, a slender, pale head rises over a stable partition towards the back of the room, nodding side to side to look at you with orange-coloured eyes that glow with their own light source. As he does so, you catch a delicate scent mingling with the familiar smell of the stable - lime peel and woodruff.]]

	jump "stables_customHorseHub"
end

function stables_customHorseHub()
	choice([["Did you do this to the horse?"]], "stables_ragwortHow")
	choice([["Is it kind to… change a living being like this?"]], "stables_ragwortKind")
	choice([["Why do you need such a powerful horse?"]], "stables_ragwortPowerful")
	choice([["I feel I know everything I want to about horse customisation."]], "stables_ragwortDone")
end

function stables_ragwortHow()
	text [["No, I had Ragwort done back before the relocation, when there were horsewrights all over. I am reaching the point of my life where I have to accept that I am never going to read my therianology textbooks, and it's a relief!]]

	text [["I know enough maintainence to keep Raggie on the move. Specialised waxes, custom fuel… A daily exercise on the trail whether he wants to or not. Performance like that takes dedication."]]

	jump "stables_customHorseHub"
end

function stables_ragwortKind()
	text [["If I were a horse, I would sooner be made into a stronger and faster horse, than be uplifted into a functionary, farmhand or bureaucrat with just enough selfhood to be unhappy with my lot," Hobson sniffs. "Besides, Raggie consented."]]
	jump "stables_customHorseHub"
end

function stables_ragwortPowerful()
	text [[Hobson looks away from you. You sense he knows he has to lie, but also knows he is a bad liar.]]

	text [["I can't tell you," he says. "There are… some plans I have for my life that I can't tell anybody about, even if those plans themselves are impossible."]]

	jump "stables_customHorseHub"
end

function stables_ragwortDone()
	text [[Hobson nods in approval.]]
	jump "stables_horseHub"
end

function stables_horsePromise()
	text [["Of course you would! And I'm certain you're perfectly trustworthy." He nods vigorously and dislodges some dust. "But there remains a legal complication."]]

	text [["By law, certain privileges are reserved only for True Citizens, such as use of the stables, playing the lute… So, in order to borrow a horse – or play the lute – you would first have to acquire your freedom, and then petition the city authority for a licence."]]

	heardAboutTrueCitizens_Hobson = true
	jump "stables_horseHub"
end

function stables_importune()
	text [["Hobson, you have a horse you could only have dreamed of before you came to Gallos, and all you do is take it for walks on the trail? All you do is sit around, picking at your lute, and keeping him around as an affectation of when your life had meaning! It is a waste for Ragwort to be with you!"]]

	text [[Hobson doesn't know how to react. For a heartbeat, he stops moving. Motionless, he seems no different from one of the skeletons the travelling-doctor would exhibit on the green to amuse the local children.]]

	text [["But I know it is a waste," he eventually says, his voice a faint whine. "All I do here is waste - the lute, the horse, this drink I have no tongue to taste, it's all a sort of game.]]

	text [["But the thing is, the game is what keeps me from going potty! Even when I was a little heavier, I would play games when I was stuck in the same place for too long. Remember how I used to talk to you in the Postmaster's stable, Raggie? About running away and having my own stable?"]]

	text [[Ragwort snorts and flicks back his angular ears, and disappears back behind his partition. He seems to have caught onto his master's distress.]]

	text [[After a long, uncomfortable moment, Hobson straightens himself up.]]

	text [["Right!" he announces, voice pitched back down. "As a stablemaster, I must be in good spirits for my horses! And while what you said hurt my feelings, I understand that you are in a difficult situation and probably just trying every possibility you can think of in the hope you'll uncover something. So let's put it all behind us!"]]

	bulliedHobson = true

	choice([["Agreed. Let's talk about something else."]], "stables_hub")
end

function stables_gallos()
	choice([["You said this place is called 'Gallos'. I've never heard of it."]], "stables_heardOfGallos")
	choice([["Who's in charge here?"]], "stables_gwenhaela")
	if (heardAboutTrueCitizens_Hobson or heardAboutTrueCitizens_Milpreve) then
		choice([["Are you a True Citizen?"]], "stables_citizen")
	end
	choice([["Is everyone here so… curious?"]], "stables_curious")


	if not guardedExit then
		choice([["Do you know of a way out?"]], "stables_cityExit")
	end

	if shrineRoofBroken and guardedExit then
		choice([["Do you think there could be another way out of the city? If someone got onto the roof of the shrine, perhaps?"]], "stables_anotherExit")
	end

	if metGargoyle then
		choice([["That $(gargoyleName) said I needed a pass to visit the shrine. Do you know how I can get one?"]], "stables_shrinePass")
	end

	choice([["Let me ask about something else…"]], "stables_hub")
	choice([["I need to get back to exploring the citadel now."]], "stables_leave")
end

function stables_heardOfGallos()
	text [["But Gallos is world famous!" exclaims Hobson, "just like Archaegia, and the New Crowndom, and the Archiveship of Atta-lee!"]]

	text [[You have never heard of any of these places either.]]

	jump "stables_gallos"
end

function stables_gwenhaela()
	text [["Queen Gwenhaela," says Hobson. "The founder of Gallos! Currently absent. The Remembrancer Milpreve handles things in her stead."]]
	heardAboutGwenhaela = true
	jump "stables_queenHub"
end

function stables_queenHub()
	choice([["What kind of person is the Queen?"]], "stables_queenType")
	choice([["Where is the Queen now?"]], "stables_queenLocation")
	choice([["So is Milpreve her heir, or…?"]], "stables_queenHeir")
	choice([["I have other things to ask…"]], "stables_queenReturn")
end

function stables_queenType()
	text [["Ah, she is *intense!*" Hobson says. "She is a skilled philosopher, thaumaturge and artist. Everybody remarks on her beautiful, focused eyes, though it is rare for her to make eye contact with anyone. That's not to say she is rude - she just has a different intelligence to most people.]]

	text [["I think that was why she wanted to build Gallos," he continues, rubbing a bony finger like a rasp over his teeth. "It's a place where people look at things the way she does. All of that vision, but the cities and kings around her just couldn't see it."]]

	jump "stables_queenHub"
end

function stables_queenLocation()
	text [["Somewhere else in the Undermarch," Hobson says. "Presumably she is trying to uncover its mysteries - map the topography, taxonomise the local abominations, work out how to make the time go in a straight line again…"]]

	jump "stables_queenHub"
end

function stables_queenHeir()
	text [["Oh no, not at all. He's a functionary, he carries out the work of the state. And, besides, the Queen doesn't like primogeniture. When it comes time to name a new monarch, there will be a ballot."]]
	jump "stables_queenHub"
end

function stables_queenReturn()
	text [[Hobson nods gently.]]
	jump "stables_gallos"
end

function stables_citizen()
	text [["Yes," Hobson nods. "Certified by the Queen herself."]]
	choice([["How did you get to become a True Citizen?"]], "stables_becomeCitizen")
end

function stables_becomeCitizen()
	text [["I went to the courtroom on my hearing-day and spoke to the Queen about who I was, and what kind of knowledge and practice I could share with the city," Hobson said. "And she said, 'I do approve of horses…'"]]

	text [[He laughs. "It turned out to be nothing to fret about at all! She values fairness."]]

	choice([["Why are there True Citizens?"]], "stables_whyAreCitizens")
end

function stables_whyAreCitizens()
	text [[Hobson puts his hand on top of his hat, then rotates his head from side to side under it.]]

	text [["The idea at first was that constructs and empsychons would handle all of the un-fun work. But in practice, as soon as you give constructs and empsychons enough intelligence to do jobs, they have enough intelligence to get bored.]]

	text [["The Queen was working on ways around that limitation - lessening the imagination of constructs like Milpreve. But hard work still needed to get done! And so the Citizenship system was established. As a temporary measure. Just so as we had a pool of thinking labourers. It was always a few years out of reach before everything would be taken care of…"]]

	text [[Hobson looks over towards the stable partitions.]]

	text [["But even horses get bored, and a horse can't plant crops, bake pasties or do mathematics. I don't think it's a problem that can be solved."]]

	jump "stables_gallos"
end

function stables_curious()
	text [["No," says Hobson, "Milpreve in particular is very unimaginative."]]

	text [[You decide not to correct him on what you had actually meant.]]

	text [["Scowles is quite exploratative, though it's difficult to tell. Leofwine and Leofric ruthlessly consume legal documents but have limited interests beyond that and squabbling. I like to think that I still dream of a bigger world."]]

	jump "stables_denizens"
end

function stables_denizens()
	choice([["Who is Scowles?"]], "stables_scowles")
	choice([["How do Leofwine and Leofric…work?"]], "stables_vultures")
	choice([["You seem slightly concerned about Milpreve."]], "stables_milpreve")
	if askedAboutShrine then
		choice([["Do you know about that strange $(gargoyleName)? Why won't it let me visit the shrine? I haven't seen anywhere else that's guarded like that."]], "stables_gargoyle")
	end
	choice([["Actually, I'm interested in the city itself."]], "stables_gallos")
end

function stables_scowles()
	text [["*Why* is Scowles? *Who* is Scowles? *What* is Scowles? *When* is Scowles? *Where* is Scowles? *How* is Scowles?" ]]

	text [[Hobson interlaces his hands together at his waist, and glares at you intensely with his eye sockets.]]

	text [[You sense he is waiting for you to speak.]]

	jump "stables_scowlesHub"
end

function stables_scowlesHub()
	choice([["Why *is* Scowles?"]], "stables_whyScowles")
	choice([["Who *is* Scowles?"]], "stables_whoScowles")
	choice([["What *is* Scowles?"]], "stables_whatScowles")
	choice([["When *is* Scowles?"]], "stables_whenScowles")
	choice([["Where *is* Scowles?"]], "stables_whereScowles")
	choice([["How *is* Scowles?"]], "stables_howScowles")
	choice([["I can't take it. I don't think I am meant to comprehend Scowles."]], "stables_scowlesReturn")
end

function stables_whyScowles()
	text [["I think Gallos's post-relocation foundation was Scowles's home. He seems eager to help out and be included. That's why he's exploited and excluded."]]

	jump "stables_scowlesHub"
end

function stables_whoScowles()
	text [["A good question. Scowles is the help. He lumbers around the citadel and, occasionally, the Undermarch.]]

	text [["He isn't popular around here, but he and I get along. I taught him the concept of money so the two of us could play dice. There is no currency in Gallos, so we substituted paper with numbers written on." Hobson hangs his head. "The blighter cleaned me out!"]]

	jump "stables_scowlesHub"
end

function stables_whatScowles()
	text [["Scowles is some sort of arboriform, though details beyond that are obscure. He does not know what he is. And why should he? I don't know what I am, you don't know what you are…"]]

	text [[Hobson pauses to consider. "Well, maybe we know those things, but… He is from the Undermarch, and I'm not sure he has had as many points of reference as us. Assuming he is a 'he'. We call him a 'he', and he doesn't seem to mind."]]

	jump "stables_scowlesHub"
end

function stables_whenScowles()
	text [["Scowles is eternal. Scowles was here before Gallos was moved to the Undermarch and he will be here after it has crumbled to dust." Hobson grinds his teeth from side to side. "At least, that's what he says."]]

	jump "stables_scowlesHub"
end

function stables_whereScowles()
	text [["Scowles goes anywhere. I think he is able to even travel beyond the Gatefold. But somehow, he is able to always hear when his name is called."]]

	jump "stables_scowlesHub"
end

function stables_howScowles()
	text [["In good health! How kind of you to ask."]]

	jump "stables_scowlesHub"
end

function stables_scowlesReturn()
	text [[Hobson nods in identification. "I would tear my hair out if I still had any."]]

	jump "stables_denizens"
end

function stables_vultures()
	text [["Contentiously!"]]

	text [[Hobson mimes a pair of snapping heads with his hands, touching his elbow joints together. You smile.]]

	text [["In the days of the Empire, the two-headed vulture represented the Law. The Imperials saw the vulture as incorruptible, alone among flesh-eating beasts in its refusal to kill for food. One head has the eyes of justice, looking forward, and the other has the eyes of precedence, looking back.]]

	text [["In practice, they both share a stomach. Sometimes they get a digestive upset from their diet of rotting flesh, and mistake it for the grumblings of pedantry." He sighs. "And such is the risk of letting aesthetics triumph over function."]]

	jump "stables_denizens"
end

function stables_milpreve()
	text [[Hobson's jaw drops with an audible click. "What? Me, terrified of Milpreve? My word, madame, if a stablemaster ever feared anything, it would bother the horses!]]

	text [["You have completely the wrong impression," he continues, rolling the round of his skull back and forth in his hand, with a grinding noise. "However, Milpreve is the Queen's Remembrancer. His records have the force of law, and besides, there's something I really don't like about the way he doesn't blink."]]

	text [[He looks across at you with sockets that have not blinked for a century.]]

	text [["Please don't draw attention to yourself in such a way that he has to come here."]]

	hobsonFearsMilpreve = true

	jump "stables_denizens"
end

function stables_gargoyle()
	text [["The shrine?" Hobson glances upward for a moment. "Yes, there was something odd there. What was it?"]]

	text [[You allow him to consider.]]

	text [["The roof!" He jabs a bony finger in the air triumphantly. "Yes, the roof caved in. Totally collapsed! Someone was supposed to see to it, but it's been so hard to get the labour."]]

	choice([["The whole roof is gone? So it's open to the sky?"]], "stables_shrineRoof")
end

function stables_shrineRoof()
	text [["Or whatever it is that stands above it, yes! Good thing it never rains any more! Ahahaha."]]

	shrineRoofBroken = true

	jump "stables_gallos"
end

function stables_cityExit()
	text [[Hobson jolts. "Ah!? You mean, out of the citadel?!" He glances over at the stable partitions. "Well, there's the riding route I take Raggie on, but it's patrolled by mounted empsychons now, ever since an *individual in high office* thought that *some Citizens* were using that route to *explore*. And I will confess to nothing!]]

	text [["There used to be a route for boats through the waterway, but since the relocation, that canal pours out into a bottomless void… Isn't Undermarch geography lovely?"]]

	guardedExit = true

	jump "stables_gallos"
end

function stables_anotherExit()
	text [[He stops and stares. "Well! I've simply never thought about it." He clacks his teeth back and forth for a moment. "I suppose you could check for yourself, if you could reach the shrine."]]

	jump "stables_gallos"
end

function stables_shrinePass()
	text [["A pass?" Hobson taps his teeth. "I'm not sure I've had reason to go to the Shrine of late, but I can't remember any business with passes. It sounds like something you'd have to ask Milpreve about, sadly."]]

	jump "stables_gallos"
end

function stables_contradiction()
	text [[You tilt your head sweetly.]]

	text [["Dear Hobson!" you exclaim, "you *are* afraid of Milpreve! And I know exactly why."]]

	text [[Hobson wraps an arm over the top of his head, forcing down the brim of his floppy hat.]]

	text [["Oh," he says, unconvincingly. "I mean - don't be ridiculous! Prove it!"]]

	jump "stables_accuse"
end

function stables_accuse()
	choice([["You have a terror of being stared at."]], "stables_accuseStaring")
	choice([["You have a mortal fear of snakes."]], "stables_accuseSnakes")
	choice([["May I see your lute-player's licence?"]], "stables_luteLicense")
end

function stables_accuseStaring()
	text [[Hobson's body loosens with relief.]]

	text [["Oh, of course. Nobody likes being stared at, especially not with awful bronze eyes, like he's got. In the old days I'd be able to stare back, but now I can't do that!"]]

	text [[He rubs his brow bone.]]

	text [["Even though I can still see and, no, I have no idea how it works either!"]]

	text [[Judging by his reaction, this wasn't right…]]

	stablesAccusedHobson = true

	jump "stables_hub"
end

function stables_accuseSnakes()
	text [[Hobson exhales a breath he has no lungs to hold.]]

	text [["Well, I can't say I like snakes," he admits. "Especially not adders. Their bite can sicken a horse!]]

	text [["Of course, Milpreve has never bitten my horse," continues Hobson. "We have our differences, but I respect that about the fellow."]]

	text [[It seems you managed to get Hobson to extend Milpreve a compliment. Clearly, this isn't the reason…]]

	stablesAccusedHobson = true

	jump "stables_hub"
end

function stables_luteLicense()
	text [[Hobson freezes for a second; then, ever so slowly, his lower jaw opens out in a silent cringe.]]

	text [["Well, you know, the - the funny thing about that is, I…" He trails off. "Excuse me, I've forgotten! No brain, empty head, just bones, ha ha! Who are you?"]]

	choice([["I mean it, Hobson!"]], "stables_meanIt")
end

function stables_meanIt()
	text [["Did Milpreve put you up to this?" Hobson says.]]

	text [[While it would be impossible for him to cry, you can tell from the tone of his voice that he is holding back tears.]]

	text [["I mean, think of all the great rebels of music, like the Rosewater Players Band and Pedro Antonetti and Vera Vincent -]]

	text [["- none of *them* ever had to ask permission from an uplifted serpent due to archaic noise ordinance rulings, and I mean, it's a dratted *lute!* What's it going to do to anyone?…"]]

	text [[His sockets swell up at you from under the brim of his ridiculous hat.]]

	text [["Are you going to tell Milpreve I was playing without a license?"]]

	choice([["I won't do."]], "stables_wontGrass")
	choice([["I may do."]], "stables_mightGrass")
end

function stables_wontGrass()
	text [[Hobson slumps with relief.]]

	text [["If only I had that license," he mumbles. "Then nobody could bother me."]]

	wontGrassHobson = true

	jump "stables_hub"
end

function stables_mightGrass()
	text [["I beg of you, don't," Hobson says, hardly not panicking, "this is the only vintage Riccio in Gallos and if he destroyed it, it would be a terrible shame for posterity."]]

	text [[He gives a nervous giggle. "Ah! You're trying to tease me, aren't you? Well, you had me fooled!]]

	text [["Seriously, though, I can't stop you, but please don't tell him anything. I can't afford to get into trouble again!"]]

	mightGrassHobson = true

	jump "stables_hub"
end

function stables_accuseAgain()
	text [[Hobson looks nervous. "Really?"]]
	jump "stables_accuse"
end

function stables_leave()
	text [[Hobson seems a little disappointed, but is polite enough not to make a show of it.]]

	text [["And I need to get back to exploring my lute!"]]

	jump "archway"
end
