import "story/vulture_intro"

function cell()
	image("cell", "cover")

	text [[You wake up.]]
	text [[You don't remember falling asleep, exactly; you were in the forest beyond the lake again, gathering herbs – did you stop to sit down? Why would you be indoors now?]]

	text [[Blanched shafts of light pierce through narrow windows, etching out a floor strewn with sweet flag and walls of stone. The room is cold, and smells unusual. You are recumbent on a straw pallet.]]

	choice("Check your things.", "cell_pockets")
end

function cell_pockets()
	text [[The pockets of your dress are still full of Faery-elecampane pods. Your pouch, big enough for three days' travel, contains only a smattering of dried fruit and a broken rusk. Had you turned to go back home? Your canteen is empty of water, and you faintly recall the frustration of emptying it.]]

	choice("Stand up.", "cell_stand")
end

function cell_stand()
	text [[The walls are lined with heavy iron rings, perhaps for tying up animals. In one corner is a bucket.]]
	jump "cell_menu"
end

function countFlags(flags)
	local c = 0
	for _,f in ipairs(flags) do
		if getVar(f) then
			c = c+1
		end
	end
	return c
end

function cell_menu()
	image("cell", "cover")

	if countFlags{"cellPulledRings", "cellSeenScowles", "cellCalledOut", "cellTriedDoor"} >= 3 then
		jump "cell_vultures"
	end

	if not cellSeenScowles then
		choice("Look out the window.", "cell_window")
	end
	if not cellPulledRings then
		choice("Look at the iron rings.", "cell_rings")
	end
	choiceOnce("Examine the bucket.", "cell_bucket")
	if cellSeenScowles then
		choiceOnce("Check if the tree creature is gone.", "cell_window2")
    end
	choiceOnce("Call for help.", "cell_call")
    choiceOnce("Try the door.", "cell_tryDoor")
end

function cell_window()
	cellSeenScowles = true

	text "Outside, you see a great bare overgrown tree, woody tendrils stretching in all directions."
	image("scowles", "cover")
	text "Just as you are about to turn away, the tendrils begin to draw themselves up, delicately, like the paws of a cat. The top of the trunk bends to look towards you, with dark, empty eyes."
	text "You shrink back away from the window."

	jump "cell_menu"
end

function cell_rings()
	text "These are heavy and ancient, set into the wall at regular intervals and secured with enormous spikes. They are bruised with spots of rust."
	choiceOnce("Pull on the iron rings.", "cell_pullRings")
	choice("Look around the room again.", "cell_menu")
end

function cell_pullRings()
	cellPulledRings = true

    text "The rings grind a little against the rust, but remain firmly embedded in the wall. "
	jump "cell_menu"
end

function cell_bucket()
	text "Best not."
	jump "cell_menu"
end

function cell_call()
	cellCalledOut = true

	if cellSeenScowles then
		text [[You scream in terror.]]
		text [[Nobody answers.]]
	else
		text [["Hello? Is anyone there?" You shout as loud as you can, but nobody answers.]]
	end
	jump "cell_menu"
end

function cell_tryDoor()
	cellTriedDoor = true

	text "It's locked."
	jump "cell_menu"
end

function cell_window2()
	text [[With your face pressed against the wall, you get close enough to see a sliver of the outside world from an angle that you hope will not expose you.]]

	text [[All that remains where the creature once stood is a stone wall beneath a hazy sky.]]

	jump "cell_menu"
end

function cell_vultures()
	text [[After a while you hear a curious flapping sound outside the door, and a pair of voices arguing.]]
	text [[*"Confound it, what are you doing? Turn it counter-clockwise!"*]]
	text [[*"If you try to force it you'll jam the lock! Remember what happened last time!"*]]

	text [[The door bangs and shakes on its hinges. There's a scuffling sound, and a clank.]]

	text [[*"Don't try to speak! You'll drop it!"*]]
	text [[*"I was not, in point of fact, attempting to speak! Now stop talking!"*]]

	text [[The door opens a sliver, groaning. Through the narrow gap pushes some sort of enormous bird, maybe taller than your waist, with dense, scruffy feathers in an unreflective shade of black. Once inside, it throws the weight of its body against the door again, and you hear the lock snap shut.]]

	image "vultures"

	jump "vultures_appear"
end
